/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Resource;
import com.wb.common.ScriptBuffer;
import com.wb.tool.Flow;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Route {
    public JSONObject flow;
    private JSONArray allNodes;
    private JSONArray connections;
    private JSONObject data;

    public Route(JSONObject jo, JSONObject tpl) {
        this.flow = tpl;
        this.allNodes = this.getNodes(tpl);
        this.connections = tpl.getJSONArray("conn");
        jo.put("FLOW_XTPL", (Object)tpl.toString());
        this.data = jo;
    }

    public JSONArray getCurrentNodes() {
        return (JSONArray)this.data.opt("CURRENT_NODES");
    }

    public void move(String src, String dst) throws Exception {
        JSONArray currentNodes = this.getCurrentNodes();
        int fromIndex = JsonUtil.indexOf((JSONArray)currentNodes, (String)src);
        if (fromIndex == -1) {
            throw new Exception("Node \"" + src + "\" is not active.");
        }
        JSONObject dstObj = JsonUtil.findObject((JSONArray)this.allNodes, (String)"label", (String)dst);
        if (dstObj == null) {
            throw new Exception("Node \"" + dst + "\" does not exist.");
        }
        currentNodes.put(fromIndex, (Object)dst);
    }

    public void to(String name) throws Exception {
        String[] names = new String[]{name};
        this.deactivateAll();
        this.activate(names);
    }

    public void activate(String[] names) throws Exception {
        JSONArray currentNodes = this.getCurrentNodes();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            JSONObject obj = JsonUtil.findObject((JSONArray)this.allNodes, (String)"label", (String)n3);
            if (obj == null) {
                throw new Exception("Node \"" + n3 + "\" does not exist.");
            }
            if (JsonUtil.indexOf((JSONArray)currentNodes, (String)n3) == -1) {
                currentNodes.put((Object)n3);
            }
            ++n2;
        }
    }

    public void deactivate(String[] names) {
        JSONArray currentNodes = this.getCurrentNodes();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            int i = JsonUtil.indexOf((JSONArray)currentNodes, (String)n3);
            if (i != -1) {
                currentNodes.remove(i);
            }
            ++n2;
        }
    }

    public void deactivateAll() {
        JSONArray currentNodes = this.getCurrentNodes();
        int j = currentNodes.length();
        int i = j - 1;
        while (i >= 0) {
            currentNodes.remove(i);
            --i;
        }
    }

    public void pause() {
        this.data.put("paused", true);
    }

    public void resume() {
        this.data.put("paused", false);
    }

    public void remove() throws Exception {
        Flow.remove((String)((String)this.get("ROUTE_ID")));
    }

    public boolean isPaused() {
        return this.data.optBoolean("paused", false);
    }

    public void commit() throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        Date date = new Date();
        String routeId = this.data.optString("ROUTE_ID");
        String userId = this.data.optString("sys.user", "-");
        String activeNode = this.getCurrentNodes().optString(0);
        try {
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            st = conn.prepareStatement("delete from WB_ROUTE where ROUTE_ID=?");
            st.setString(1, routeId);
            st.executeUpdate();
            DbUtil.close((Object)st);
            st = conn.prepareStatement("insert into WB_ROUTE values(?,?,?,?,?,?,?,?)");
            st.setString(1, routeId);
            st.setString(2, this.data.optString("FLOW_ID"));
            st.setTimestamp(3, new Timestamp(date.getTime()));
            st.setString(4, userId);
            st.setString(5, activeNode);
            st.setString(6, this.data.optString("TITLE", "-"));
            st.setString(7, this.data.optString("STATUS", "-"));
            DbUtil.setText((PreparedStatement)st, (int)8, (String)this.data.toString());
            st.executeUpdate();
            conn.commit();
            this.set("MODIFY_DATE", (Object)date);
            this.set("USER_ID", (Object)userId);
            this.set("ACTIVE_NODE", (Object)activeNode);
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            DbUtil.close((Object)conn);
            throw throwable;
        }
        DbUtil.close((Object)st);
        DbUtil.close((Object)conn);
    }

    public void set(String name, Object value) throws Exception {
        if (value instanceof Date) {
            value = DateUtil.dateToStr((Date)((Date)value));
        } else if (value instanceof InputStream) {
            String id = SysUtil.getId();
            Resource.set((String)id, (byte[])this.getBytes((InputStream)value));
            value = "@@blob." + id;
        } else if (value instanceof byte[]) {
            String id = SysUtil.getId();
            Resource.set((String)id, (byte[])((byte[])value));
            value = "@@byte." + id;
        } else if (value instanceof Object[]) {
            value = new JSONArray((Object)((Object[])value)).toString();
        }
        this.data.put(name, value);
    }

    public void set(HttpServletRequest request) throws Exception {
        JSONObject items = WebUtil.fetch((HttpServletRequest)request);
        Set es = items.entrySet();
        for (Map.Entry e : es) {
            this.set((String)e.getKey(), e.getValue());
        }
    }

    public Object get(String name) {
        Object value = this.data.opt(name);
        if (value instanceof String) {
            String prefix = (String)value;
            if (prefix.startsWith("@@blob.")) {
                value = new ByteArrayInputStream(Resource.getBytes((String)prefix.substring(7), null));
            } else if (prefix.startsWith("@@byte.")) {
                value = Resource.getBytes((String)prefix.substring(7), null);
            }
        }
        return value;
    }

    public JSONObject get() {
        return this.data;
    }

    private byte[] getBytes(InputStream is) throws Exception {
        ByteArrayOutputStream bos;
        try {
            bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
        }
        finally {
            is.close();
        }
        return bos.toByteArray();
    }

    public boolean forward(HttpServletRequest request) throws Exception {
        int j = this.connections.length();
        String activeNode = this.getCurrentNodes().optString(0);
        String[] nodes = new String[]{""};
        this.set("xLastNode", (Object)activeNode);
        int i = 0;
        while (i < j) {
            JSONObject xprop;
            String condi;
            JSONObject jo = this.connections.getJSONObject(i);
            if (jo.optString("src").equals(activeNode) && (StringUtil.isEmpty((String)(condi = (xprop = jo.optJSONObject("xprop")).optString("\u6761\u4ef6"))) || Boolean.parseBoolean(ScriptBuffer.run((String)WebUtil.replaceParams((HttpServletRequest)request, (String)("return " + condi))).toString()))) {
                nodes[0] = jo.optString("dst");
                this.deactivateAll();
                this.activate(nodes);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean backward(HttpServletRequest request) throws Exception {
        return false;
    }

    private JSONArray getNodes(JSONObject template) {
        JSONArray nodes = new JSONArray();
        JSONArray list = template.getJSONArray("list");
        int j = list.length();
        int i = 0;
        while (i < j) {
            JSONObject obj = list.getJSONObject(i);
            if (obj.getBoolean("isObj")) {
                obj.remove("box");
                nodes.put((Object)obj);
            }
            ++i;
        }
        return nodes;
    }
}

