/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.DataPermissionBuffer;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.tool.Console;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger logger = LoggerFactory.getLogger(Query.class);
    public HttpServletRequest request;
    public String sql;
    public String jndi;
    public String arrayName;
    public JSONArray arrayData;
    public boolean batchUpdate;
    public String type;
    public String transaction;
    public String isolation;
    public boolean uniqueUpdate;
    public String errorText;
    private String debugSql;
    private String formattedSql;
    private ArrayList<Object[]> paramList;
    private ArrayList<String> paramValList;
    private int paramCount;
    private PreparedStatement statement;
    private Map<String, Object> paramValMap;

    public Object run() throws Exception {
        String functionId = "";
        String xwl = this.request.getParameter("xwl");
        String title = "";
        Object result = null;
        try {
            boolean isCall;
            String guid = SysUtil.getId();
            if (StringUtils.isNotEmpty((String)xwl)) {
                title = XwlBuffer.get((String)(String.valueOf(xwl) + ".xwl"), (boolean)true).optString("title");
                if (StringUtils.indexOf((String)xwl, (String)"/") > -1 && StringUtils.countMatches((String)xwl, (String)"/") >= 2) {
                    String[] su = StringUtils.split((String)xwl, (String)"/");
                    functionId = su[su.length - 2];
                    xwl = StringUtils.substringBeforeLast((String)xwl, (String)"/");
                } else {
                    functionId = xwl;
                }
            }
            this.checkProperties();
            boolean hasArray = this.arrayData != null || !StringUtil.isEmpty((String)this.arrayName);
            this.sql = this.sql.trim();
            this.replaceMacros();
            Connection connection = DbUtil.getConnection((HttpServletRequest)this.request, (String)this.jndi);
            boolean isCommit = "commit".equals(this.transaction);
            if (isCommit) {
                if (connection.getAutoCommit()) {
                    this.transaction = "start";
                }
            } else if (StringUtil.isEmpty((String)this.transaction) && (this.uniqueUpdate || hasArray) && connection.getAutoCommit()) {
                this.transaction = "start";
            }
            if ("start".equals(this.transaction)) {
                DbUtil.startTransaction((Connection)connection, (String)this.isolation);
            }
            if (StringUtil.isEmpty((String)this.type)) {
                this.type = this.sql.startsWith("{") ? "call" : "execute";
            }
            this.statement = (isCall = "call".equals(this.type)) ? connection.prepareCall(this.formattedSql) : connection.prepareStatement(this.formattedSql);
            if (Var.fetchSize != -1) {
                this.statement.setFetchSize(Var.fetchSize);
            }
            WebUtil.setObject((HttpServletRequest)this.request, (String)SysUtil.getId(), (Object)this.statement);
            this.regParameters();
            long beginTime = System.currentTimeMillis();
            if (hasArray) {
                this.executeBatch();
            } else {
                if (Var.debug) {
                    this.printSql();
                }
                if ("query".equals(this.type)) {
                    result = this.statement.executeQuery();
                    WebUtil.setObject((HttpServletRequest)this.request, (String)SysUtil.getId(), (Object)result);
                } else if ("update".equals(this.type)) {
                    int affectedRows = this.statement.executeUpdate();
                    result = affectedRows;
                    if (this.uniqueUpdate && affectedRows != 1) {
                        this.notUnique();
                    }
                } else {
                    HashMap map;
                    if (this.statement.execute()) {
                        result = this.statement.getResultSet();
                        WebUtil.setObject((HttpServletRequest)this.request, (String)SysUtil.getId(), (Object)result);
                    } else {
                        int affectedRows = this.statement.getUpdateCount();
                        result = affectedRows;
                        if (this.uniqueUpdate && affectedRows != 1) {
                            this.notUnique();
                        }
                    }
                    if (isCall && this.paramCount > 0 && (map = this.getOutParameter()).size() > 0) {
                        if (map.containsKey("return")) {
                            throw new IllegalArgumentException("Invalid output parameter name \"return\"");
                        }
                        map.put("return", result);
                        result = map;
                    }
                }
            }
            if (isCommit) {
                connection.commit();
                connection.setAutoCommit(true);
            }
            long endTime = System.currentTimeMillis();
            if (StringUtils.isNotEmpty((String)functionId)) {
                LogUtil.recordForSp((String)this.type, (String)functionId, (String)guid, (String)WebUtil.fetch((HttpServletRequest)this.request, (String)"sys.username"), (String)this.sql, (String)title, (String)xwl, (Map)this.paramValMap, (String)"0", (String)"\u6267\u884c\u6210\u529f\uff01", (long)(endTime - beginTime));
            }
            this.checkError(result);
        }
        catch (SQLException e) {
            logger.error("SQL\u3010" + StringUtil.toLine((String)this.formattedSql) + "\u3011<br>" + e.getMessage());
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            logger.error("SQL\u3010" + StringUtil.toLine((String)this.formattedSql) + "\u3011<br>" + e.getMessage());
            throw e;
        }
        return result;
    }

    private void checkProperties() {
        String[] isolations;
        String[] types;
        String[] trans;
        if (!StringUtil.isEmpty((String)this.transaction) && StringUtil.indexOf((String[])(trans = new String[]{"start", "commit", "none"}), (String)this.transaction) == -1) {
            throw new IllegalArgumentException("Invalid transaction \"" + this.transaction + "\".");
        }
        if (!StringUtil.isEmpty((String)this.type) && StringUtil.indexOf((String[])(types = new String[]{"query", "update", "execute", "call"}), (String)this.type) == -1) {
            throw new IllegalArgumentException("Invalid type \"" + this.type + "\".");
        }
        if (!StringUtil.isEmpty((String)this.isolation) && StringUtil.indexOf((String[])(isolations = new String[]{"readCommitted", "readUncommitted", "repeatableRead", "serializable"}), (String)this.isolation) == -1) {
            throw new IllegalArgumentException("Invalid isolation \"" + this.isolation + "\".");
        }
    }

    private void executeBatch() throws Exception {
        JSONArray ja;
        if (this.arrayData == null) {
            Object obj = WebUtil.fetchObject((HttpServletRequest)this.request, (String)this.arrayName);
            if (obj instanceof JSONArray) {
                ja = (JSONArray)obj;
            } else {
                if (obj == null) {
                    return;
                }
                String val = obj.toString();
                if (val.isEmpty()) {
                    return;
                }
                ja = new JSONArray(val);
            }
        } else {
            ja = this.arrayData;
        }
        int j = ja.length();
        if (j == 0) {
            return;
        }
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            int k = 0;
            while (k < this.paramCount) {
                Object[] param = (Object[])this.paramList.get(k);
                String name = (String)param[0];
                if (!((Boolean)param[2]).booleanValue() && jo.has(name)) {
                    Object valObj = JsonUtil.opt((JSONObject)jo, (String)name);
                    DbUtil.setObject((PreparedStatement)this.statement, (int)(k + 1), (int)((Integer)param[1]), (Object)valObj);
                    if (Var.debug) {
                        this.paramValList.set(k, StringUtil.toString((Object)valObj));
                    }
                }
                ++k;
            }
            if (Var.debug) {
                this.printSql();
            }
            if (this.batchUpdate) {
                this.statement.addBatch();
            } else {
                int affectedRows = this.statement.executeUpdate();
                if (this.uniqueUpdate && affectedRows != 1) {
                    this.notUnique();
                }
            }
            ++i;
        }
        if (this.batchUpdate) {
            this.statement.executeBatch();
        }
    }

    private void notUnique() {
        throw new RuntimeException(Str.format((HttpServletRequest)this.request, (String)"updateNotUnique", (Object[])new Object[0]));
    }

    private void replaceMacros() {
        StringBuilder buf = new StringBuilder();
        int startPos = 0;
        int endPos = 0;
        int lastPos = 0;
        while ((startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1) {
            buf.append(this.sql.substring(lastPos, startPos));
            startPos += 2;
            buf.append("'{?");
            buf.append(this.sql.substring((endPos += 2) - 1, endPos));
            buf.append('\'');
            lastPos = endPos;
        }
        buf.append(this.sql.substring(lastPos));
        this.debugSql = buf.toString();
        this.formattedSql = StringUtil.replaceAll((String)this.debugSql, (String)"'{?}'", (String)"?");
    }

    private void regParameters() throws Exception {
        int index = 1;
        int startPos = 0;
        int endPos = 0;
        this.paramList = new ArrayList();
        this.paramValMap = new LinkedHashMap();
        if (Var.debug) {
            this.paramValList = new ArrayList();
        }
        CallableStatement callStatement = this.statement instanceof CallableStatement ? (CallableStatement)this.statement : null;
        boolean isCall = callStatement != null;
        while ((startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1) {
            int type;
            Integer typeObj;
            String paraName;
            int dotPos;
            boolean isOutParam;
            String param = this.sql.substring(startPos += 2, endPos);
            endPos += 2;
            String orgParam = param;
            boolean bl = isOutParam = isCall && param.startsWith("@");
            if (isOutParam) {
                boolean hasSub;
                String typeText;
                dotPos = (param = param.substring(1)).indexOf(46);
                if (dotPos == -1) {
                    typeText = "varchar";
                    paraName = param;
                } else {
                    typeText = param.substring(0, dotPos);
                    paraName = param.substring(dotPos + 1);
                }
                boolean bl2 = hasSub = typeText.indexOf(61) != -1;
                if (hasSub) {
                    typeObj = DbUtil.getFieldType((String)StringUtil.getNamePart((String)typeText));
                    if (typeObj == null) {
                        throw new Exception("Invalid type " + typeText);
                    }
                    type = typeObj;
                    int subType = Integer.parseInt(StringUtil.getValuePart((String)typeText));
                    callStatement.registerOutParameter(index, type, subType);
                } else {
                    typeObj = DbUtil.getFieldType((String)typeText);
                    if (typeObj == null) {
                        throw new Exception("Invalid type " + typeText);
                    }
                    type = typeObj;
                    callStatement.registerOutParameter(index, type);
                }
                if (Var.debug) {
                    this.paramValList.add(orgParam);
                }
            } else {
                dotPos = param.indexOf(46);
                if (dotPos == -1) {
                    type = 12;
                    paraName = param;
                } else {
                    typeObj = DbUtil.getFieldType((String)param.substring(0, dotPos));
                    if (typeObj == null) {
                        type = 12;
                        paraName = param;
                    } else {
                        type = typeObj;
                        paraName = param.substring(dotPos + 1);
                    }
                }
                Object obj = WebUtil.fetchObject((HttpServletRequest)this.request, (String)paraName);
                DbUtil.setObject((PreparedStatement)this.statement, (int)index, (int)type, (Object)obj);
                if (Var.debug) {
                    this.paramValList.add(StringUtil.toString((Object)obj));
                }
                this.paramValMap.put(paraName, obj);
            }
            Object[] paramObjects = new Object[]{paraName, type, isOutParam};
            this.paramList.add(paramObjects);
            ++index;
        }
        this.paramCount = this.paramList.size();
    }

    private void filterDataPermission(Object paramValue, String paraName, String userId) {
        if (DataPermissionBuffer.exitType((String)paraName)) {
            ArrayList permissionList = DataPermissionBuffer.getPermissionData((String)userId, (String)paraName);
            if (paramValue != null) {
                List<String> paramValueList = Arrays.asList(ObjectUtils.toString((Object)paramValue).split(","));
                if (permissionList != null) {
                    ArrayList<String> newValue = new ArrayList<String>();
                    for (String pv : paramValueList) {
                        if (!permissionList.contains(pv)) continue;
                        newValue.add(pv);
                    }
                    paramValue = CollectionUtil.join(newValue, (String)",");
                } else {
                    paramValue = null;
                }
            } else if (permissionList != null) {
                paramValue = CollectionUtil.join((Iterable)permissionList, (String)",");
            }
        }
    }

    private HashMap<String, Object> getOutParameter() throws Exception {
        CallableStatement st = (CallableStatement)this.statement;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < this.paramCount) {
            Object[] param = (Object[])this.paramList.get(i);
            if (((Boolean)param[2]).booleanValue()) {
                Object object = DbUtil.getObject((CallableStatement)st, (int)(i + 1), (int)((Integer)param[1]));
                if (object instanceof ResultSet) {
                    WebUtil.setObject((HttpServletRequest)this.request, (String)SysUtil.getId(), (Object)object);
                }
                map.put((String)param[0], object);
            }
            ++i;
        }
        return map;
    }

    private void checkError(Object object) throws Exception {
        ResultSet rs;
        if (!StringUtil.isEmpty((String)this.errorText) && object instanceof ResultSet && (rs = (ResultSet)object).next()) {
            throw new RuntimeException(this.errorText);
        }
    }

    private void printSql() {
        String sql = this.debugSql;
        for (String s : this.paramValList) {
            sql = StringUtil.replaceFirst((String)sql, (String)"{?}", (String)s);
        }
        logger.debug("\u6a21\u5757\u3010" + this.request.getParameter("xwl") + "\u3011\u6267\u884c\u7684SQL\u8bed\u53e5:" + StringUtil.toLine((String)sql));
        Console.log((HttpServletRequest)this.request, (Object)sql);
    }
}

