/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Var;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class MgDataOutput {
    public static void outputExc(JSONArray headers, JSONArray records, String title, boolean neptune, boolean isAjax, String finalXlsxPath, String filename) throws Exception {
        HSSFWorkbook book = null;
        OutputStream out = null;
        int startRow = 0;
        String sheetName = "VolckerReport";
        try {
            try {
                book = new HSSFWorkbook();
                Sheet sheet = book.createSheet();
                if (!StringUtil.isEmpty((String)sheetName)) {
                    book.setSheetName(book.getSheetIndex(sheet), sheetName);
                }
                if (title != null) {
                    startRow = 1;
                }
                Object[] values = MgDataOutput.createHeaders((Sheet)sheet, (JSONArray)headers, (int)startRow, (boolean)neptune);
                int headerCols = (Integer)values[0];
                int headerRows = (Integer)values[1];
                JSONArray fields = (JSONArray)values[2];
                if (title != null) {
                    MgDataOutput.createTitle((Sheet)sheet, (String)title, (int)headerCols);
                }
                startRow += headerRows;
                if (Var.getBool((String)"sys.service.excel.freezePane")) {
                    sheet.createFreezePane(0, startRow);
                }
                MgDataOutput.createRecord((Sheet)sheet, (JSONArray)records, (JSONArray)fields, (int)startRow, (String)filename);
                out = new FileOutputStream(finalXlsxPath);
                book.write(out);
            }
            catch (Exception e) {
                e.printStackTrace();
                book.close();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            book.close();
            if (out != null) {
                out.close();
            }
        }
    }

    public static StringBuilder outputDat(JSONArray headers, JSONArray records, String filename) throws Exception {
        StringBuilder text = new StringBuilder();
        JSONArray leafs = new JSONArray();
        String lineSeparator = "\n";
        leafs.put(0);
        MgDataOutput.markParents((JSONArray)leafs, (JSONArray)headers, null, (int)0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            if (i > 0) {
                text.append('|');
            }
            text.append(leafs.getJSONObject(i).optString("text"));
            ++i;
        }
        text.append(lineSeparator);
        MgDataOutput.getDatContent((StringBuilder)text, (JSONArray)records, (JSONArray)leafs, (boolean)false, (String)filename, (String)lineSeparator);
        return text;
    }

    private static void createRecord(Sheet sheet, JSONArray records, JSONArray fields, int startRow, String filename) {
        Cell cell;
        Row row;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        Workbook book = sheet.getWorkbook();
        Object[] cellStyles = MgDataOutput.createCellStyle((Workbook)book, (String)"text");
        CellStyle baseStyle = (CellStyle)cellStyles[0];
        CellStyle[] colStyles = new CellStyle[l];
        short rowHeight = (Short)cellStyles[1];
        int k = 0;
        while (k < l) {
            JSONObject field = fields.getJSONObject(k);
            fieldNames[k] = field.optString("field");
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(MgDataOutput.getAlignment((String)field.optString("align"), (short)1));
            if (Boolean.TRUE.equals(field.opt("autoWrap"))) {
                style.setWrapText(true);
            }
            colStyles[k] = style;
            ++k;
        }
        int i = 0;
        while (i < j) {
            row = sheet.createRow(startRow + i);
            row.setHeight(rowHeight);
            JSONObject record = (JSONObject)records.opt(i);
            k = 0;
            while (k < l) {
                cell = row.createCell(k);
                cell.setCellStyle(colStyles[k]);
                Object value = JsonUtil.opt((JSONObject)record, (String)fieldNames[k]);
                if (value != null) {
                    cell.setCellValue(value.toString());
                }
                ++k;
            }
            ++i;
        }
        row = sheet.createRow(startRow + j);
        row.setHeight(rowHeight);
        i = 0;
        while (i < l) {
            cell = row.createCell(i);
            cell.setCellStyle(colStyles[i]);
            if (i == 0) {
                cell.setCellValue("#EOF#");
            }
            if (i == 1) {
                cell.setCellValue("VV_2162966_" + filename + "_1_FED_MSHX.dat");
            }
            if (i == 2) {
                cell.setCellValue((double)(startRow + j + 1));
            }
            if (i == 3) {
                cell.setCellValue(filename);
            }
            if (i == 4) {
                cell.setCellValue("volcker@morganstanleyhuaxin.com");
            }
            if (i == 5) {
                SimpleDateFormat myFmt = new SimpleDateFormat("yyyyMMdd:HH:mm");
                cell.setCellValue(myFmt.format(new Date()));
            }
            ++i;
        }
    }

    private static void createTitle(Sheet sheet, String title, int headerCols) {
        Row row = sheet.createRow(0);
        Object[] styles = MgDataOutput.createCellStyle((Workbook)sheet.getWorkbook(), (String)"title");
        row.setHeight(((Short)styles[1]).shortValue());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headerCols - 1));
        Cell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)styles[0]);
        cell.setCellValue(title);
    }

    private static Object[] createHeaders(Sheet sheet, JSONArray headers, int startRow, boolean neptune) {
        Workbook book = sheet.getWorkbook();
        JSONArray processedHeaders = new JSONArray();
        Object[] values = MgDataOutput.prepareHeaders((Sheet)sheet, (JSONArray)headers, (JSONArray)processedHeaders, (int)startRow, (boolean)neptune);
        Cell[][] cells = (Cell[][])values[0];
        Object[] styles = MgDataOutput.createCellStyle((Workbook)book, (String)"header");
        CellStyle baseStyle = (CellStyle)styles[0];
        int j = processedHeaders.length();
        int i = 0;
        while (i < j) {
            JSONObject header = processedHeaders.getJSONObject(i);
            int x = header.getInt("x");
            int y = header.getInt("y");
            int colspan = Math.max(header.getInt("colspan"), 0);
            int rowspan = Math.max(header.getInt("rowspan"), 0);
            if (colspan > 0 || rowspan > 0) {
                sheet.addMergedRegion(new CellRangeAddress(y + startRow, y + startRow + rowspan, x, x + colspan));
            }
            Cell cell = cells[x][y];
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(MgDataOutput.getAlignment((String)header.optString("titleAlign"), (short)(header.has("child") ? (short)2 : 1)));
            cell.setCellStyle(style);
            cell.setCellValue(header.optString("text"));
            ++i;
        }
        Object[] result = new Object[]{cells.length, cells[0].length, values[1]};
        return result;
    }

    private static Object[] prepareHeaders(Sheet sheet, JSONArray rawHeaders, JSONArray processedHeaders, int startRow, boolean neptune) {
        JSONArray leafs = new JSONArray();
        Object[] result = new Object[2];
        int flexWidth = Var.getInt((String)"sys.service.excel.flexColumnMaxWidth");
        Object[] styles = MgDataOutput.createCellStyle((Workbook)sheet.getWorkbook(), (String)"header");
        CellStyle style = (CellStyle)styles[0];
        short rowHeight = (Short)styles[1];
        double rate = neptune ? 32.06 : 36.55;
        leafs.put(0);
        MgDataOutput.markParents((JSONArray)leafs, (JSONArray)rawHeaders, null, (int)0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            JSONObject node = leafs.getJSONObject(i);
            int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
            sheet.setColumnWidth(i, (int)((double)width * rate));
            node.put("rowspan", maxDepth - node.getInt("y"));
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                processedHeaders.put((Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        Cell[][] cells = new Cell[j][++maxDepth];
        int k = 0;
        while (k < maxDepth) {
            Row row = sheet.createRow(k + startRow);
            row.setHeight(rowHeight);
            int l = 0;
            while (l < j) {
                Cell cell = row.createCell(l);
                cell.setCellStyle(style);
                cells[l][k] = cell;
                ++l;
            }
            ++k;
        }
        result[0] = cells;
        result[1] = leafs;
        return result;
    }

    private static void markParents(JSONArray leafs, JSONArray headers, JSONObject parent, int depth) {
        int j = headers.length();
        leafs.put(0, Math.max(leafs.getInt(0), depth));
        int i = 0;
        while (i < j) {
            JSONArray items;
            JSONObject header = headers.getJSONObject(i);
            header.put("y", depth);
            header.put("colspan", -1);
            header.put("rowspan", -1);
            if (parent != null) {
                header.put("parent", (Object)parent);
                parent.put("child", (Object)header);
            }
            if ((items = (JSONArray)header.opt("items")) != null) {
                MgDataOutput.markParents((JSONArray)leafs, (JSONArray)items, (JSONObject)header, (int)(depth + 1));
            } else {
                leafs.put((Object)header);
            }
            ++i;
        }
    }

    public static Workbook getBook(String string) throws Exception {
        ByteArrayInputStream is = null;
        if (!StringUtil.isEmpty((String)string)) {
            is = new ByteArrayInputStream(StringUtil.decodeBase64((String)string));
        }
        if (Var.getBool((String)"sys.service.excel.xlsx")) {
            return is == null ? new XSSFWorkbook() : new XSSFWorkbook((InputStream)is);
        }
        return is == null ? new HSSFWorkbook() : new HSSFWorkbook((InputStream)is);
    }

    public static Object[] createCellStyle(Workbook book, String type) {
        String backColor;
        CellStyle style = book.createCellStyle();
        Font font = book.createFont();
        String fontName = Var.getString((String)("sys.service.excel." + type + ".fontName"));
        int fontHeight = Var.getInt((String)("sys.service.excel." + type + ".fontHeight"));
        double rowHeight = Var.getDouble((String)("sys.service.excel." + type + ".rowHeight"));
        Object[] result = new Object[2];
        if (!fontName.isEmpty()) {
            font.setFontName(fontName);
        }
        font.setBoldweight((short)Var.getInt((String)("sys.service.excel." + type + ".fontWeight")));
        font.setFontHeight((short)fontHeight);
        if (rowHeight < 10.0) {
            rowHeight *= (double)fontHeight;
        }
        if (!"text".equals(type) && Var.getBool((String)("sys.service.excel." + type + ".wrapText"))) {
            style.setWrapText(true);
        }
        if ("title".equals(type)) {
            String align = Var.getString((String)("sys.service.excel." + type + ".align"));
            if (!align.isEmpty()) {
                Object[][] alignments = new Object[][]{{"\u5c45\u4e2d", (short)2}, {"\u5de6", (short)1}, {"\u53f3", (short)3}, {"\u5c45\u4e2d\u9009\u62e9", (short)6}, {"\u586b\u5145", (short)4}, {"\u5e38\u89c4", (short)0}, {"\u4e24\u7aef\u5bf9\u9f50", (short)5}};
                style.setAlignment(((Short)SysUtil.getValue((Object[][])alignments, (String)align)).shortValue());
            }
        } else if (Var.getBool((String)"sys.service.excel.border")) {
            style.setBorderTop((short)1);
            style.setBorderBottom((short)1);
            style.setBorderLeft((short)1);
            style.setBorderRight((short)1);
        }
        if ("header".equals(type) && !"\u9ed8\u8ba4".equals(backColor = Var.getString((String)"sys.service.excel.header.backColor"))) {
            Object[][] colors = new Object[][]{{"\u9ed8\u8ba4", -1}, {"\u91d1\u8272", (short)51}, {"\u7070\u8272", (short)22}, {"\u6d45\u9ec4", (short)43}};
            style.setFillForegroundColor(((Short)SysUtil.getValue((Object[][])colors, (String)backColor)).shortValue());
            style.setFillPattern((short)1);
        }
        style.setVerticalAlignment((short)1);
        style.setFont(font);
        result[0] = style;
        result[1] = Double.valueOf(rowHeight).shortValue();
        return result;
    }

    public static short getAlignment(String align, short defaultAlign) {
        if ("right".equals(align)) {
            return 3;
        }
        if ("center".equals(align)) {
            return 2;
        }
        if ("left".equals(align)) {
            return 1;
        }
        return defaultAlign;
    }

    public static String excelToJson(InputStream inputStream, boolean xlsxFormat) throws Exception {
        int rowIndex = 0;
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuilder text = new StringBuilder("");
        try (Object book = xlsxFormat ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);){
            Sheet sheet = book.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                if (rowIndex > 1) {
                    text.append("\n{");
                } else if (rowIndex > 0) {
                    text.append('{');
                }
                Row row = (Row)rows.next();
                Iterator cells = row.cellIterator();
                int colIndex = 0;
                while (cells.hasNext()) {
                    Cell cell = (Cell)cells.next();
                    Object value = MgDataOutput.getCellValue((Cell)cell);
                    if (rowIndex == 0) {
                        if (value == null) {
                            throw new NullPointerException("Field name has null value.");
                        }
                        String valueStr = value.toString();
                        int pos = valueStr.indexOf(40);
                        int pos1 = valueStr.indexOf("\uff08");
                        if (pos1 != -1 && (pos == -1 || pos1 < pos)) {
                            pos = pos1;
                        }
                        if (pos == -1) {
                            fieldList.add(valueStr);
                        } else {
                            fieldList.add(valueStr.substring(0, pos));
                        }
                    } else {
                        if (colIndex > 0) {
                            text.append(',');
                        }
                        if (colIndex >= fieldList.size()) {
                            throw new RuntimeException("Row " + (rowIndex + 1) + " column " + (colIndex + 1) + " is out of bounds.");
                        }
                        text.append(StringUtil.quote((String)((String)fieldList.get(colIndex))));
                        text.append(':');
                        text.append(StringUtil.encode((Object)value));
                    }
                    ++colIndex;
                }
                if (rowIndex > 0) {
                    text.append('}');
                }
                ++rowIndex;
            }
        }
        return text.toString();
    }

    public static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 0: 
            case 2: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static String toJavaDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "D", "w", "z", "W", "t", "L", "o", "O", "P", "T", "Z", "c", "U", "F", "MS", "l", "M", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"y", "yy"}, {"Y", "yyyy"}, {"m", "MM"}, {"n", "M"}, {"d", "dd"}, {"j", "d"}, {"H", "HH"}, {"h", "hh"}, {"G", "H"}, {"g", "h"}, {"i", "mm"}, {"s", "ss"}, {"u", "SSS"}, {"a", "'_x'"}, {"A", "'_X'"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-MM-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)s[0], (String)s[1]);
            ++n2;
        }
        return format;
    }

    public static String toExcelDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "w", "z", "W", "t", "L", "o", "u", "O", "P", "T", "Z", "c", "U", "MS", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"d", "dd"}, {"D", "aaa"}, {"j", "d"}, {"l", "aaaa"}, {"F", "mmmm"}, {"m", "mm"}, {"M", "mmm"}, {"n", "m"}, {"Y", "yyyy"}, {"y", "yy"}, {"a", "am/pm"}, {"A", "AM/PM"}, {"g", "h"}, {"G", "hh"}, {"h", "h"}, {"H", "hh"}, {"i", "mm"}, {"s", "ss"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-mm-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)s[0], (String)s[1]);
            ++n2;
        }
        return format;
    }

    public static void importToExcel(File file, JSONObject data, OutputStream outputStream) throws Exception {
        boolean isXlsx = FileUtil.getFileExt((String)file.getName()).toLowerCase().equals("xlsx");
        FileInputStream is = new FileInputStream(file);
        Object book = null;
        try {
            book = isXlsx ? new XSSFWorkbook((InputStream)is) : new HSSFWorkbook((InputStream)is);
            Sheet sheet = book.getSheetAt(0);
            MgDataOutput.importToSheet((Sheet)sheet, (JSONObject)data);
            book.write(outputStream);
            book.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(book);
            ((InputStream)is).close();
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)book);
        ((InputStream)is).close();
    }

    public static void importToSheet(Sheet sheet, JSONObject data) {
        ArrayList<String> fields = null;
        Iterator rows = sheet.rowIterator();
        int rowIndex = 0;
        int strIndex = 0;
        String field = null;
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Iterator cells = row.cellIterator();
            fields = new ArrayList<String>();
            while (cells.hasNext()) {
                Cell cell = (Cell)cells.next();
                Object value = MgDataOutput.getCellValue((Cell)cell);
                if (value == null) continue;
                String string = value.toString();
                if (StringUtils.contains((String)string, (String)"{#") && StringUtils.contains((String)string, (String)"#}")) {
                    strIndex = StringUtils.indexOf((String)string, (String)"{#");
                    if (strIndex != 0) {
                        field = StringUtils.substringBetween((String)string, (String)"{#", (String)"#}");
                        value = data.opt(field);
                        if (value != null) {
                            cell.setCellValue(String.valueOf(StringUtils.substringBefore((String)string, (String)"{#")) + value.toString() + StringUtils.substringAfter((String)string, (String)"#}"));
                        } else {
                            cell.setCellValue(String.valueOf(StringUtils.substringBefore((String)string, (String)"{#")) + StringUtils.substringAfter((String)string, (String)"#}"));
                        }
                    } else {
                        value = data.opt(string = string.substring(2, string.length() - 2));
                        if (value == JSONObject.NULL) {
                            cell.setCellValue(" ");
                        } else if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                        } else if (value instanceof Date) {
                            cell.setCellValue((Date)value);
                        } else if (value instanceof Boolean) {
                            cell.setCellValue(((Boolean)value).booleanValue());
                        } else {
                            cell.setCellValue(ObjectUtils.toString((Object)value, (String)""));
                        }
                    }
                }
                if (!StringUtils.contains((String)string, (String)"{R#") || !StringUtils.contains((String)string, (String)"#}")) continue;
                string = string.substring(StringUtils.indexOf((String)string, (String)"{R#") + 3, string.length() - 2);
                fields.add(string);
            }
            if (fields.size() > 0) {
                MgDataOutput.createRows((Sheet)sheet, (JSONArray)data.getJSONArray("rows"), fields, (int)rowIndex);
            }
            ++rowIndex;
        }
    }

    private static void createRows(Sheet sheet, JSONArray records, List<String> fields, int startRow) {
        int j = records.length();
        int l = fields.size();
        int i = 0;
        while (i < j) {
            Row row = sheet.createRow(startRow + i);
            JSONObject record = (JSONObject)records.opt(i);
            int k = 0;
            while (k < l) {
                Cell cell = row.createCell(k);
                Object value = JsonUtil.opt((JSONObject)record, (String)fields.get(k));
                if (value == JSONObject.NULL) {
                    cell.setCellValue("");
                }
                if (value instanceof Number) {
                    cell.setCellValue(((Number)value).doubleValue());
                } else if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                } else if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                } else {
                    cell.setCellValue(ObjectUtils.toString((Object)value, (String)""));
                }
                ++k;
            }
            ++i;
        }
    }

    private static void getDatContent(StringBuilder buf, JSONArray records, JSONArray fields, boolean hasRowNumber, String filename, String lineSeparator) {
        int j = records.length();
        int m = j + 2;
        int l = fields.length();
        String[] fieldNames = new String[l];
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyyMMdd:HH:mm");
        String lastText = "#EOF#|VV_2162966_" + filename + "_1_FED_MSHX.dat|" + m + "|" + filename + "|volcker@morganstanleyhuaxin.com|" + myFmt.format(new Date());
        String[] aligns = new String[l];
        boolean[] wraps = new boolean[l];
        int k = 0;
        while (k < l) {
            JSONObject field = fields.getJSONObject(k);
            fieldNames[k] = field.optString("field");
            aligns[k] = field.optString("align");
            wraps[k] = Boolean.TRUE.equals(field.opt("autoWrap"));
            ++k;
        }
        int i = 0;
        while (i < j) {
            JSONObject record = (JSONObject)records.opt(i);
            if (i > 0) {
                buf.append(lineSeparator);
            }
            k = 0;
            while (k < l) {
                Object value = JsonUtil.opt((JSONObject)record, (String)fieldNames[k]);
                if (value == null) {
                    buf.append("\t");
                } else {
                    if (!value.equals("") && k > 0) {
                        buf.append("|");
                    }
                    String valueText = value.toString();
                    buf.append(valueText);
                }
                ++k;
            }
            ++i;
        }
        buf.append("\n" + lastText);
    }
}

