/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Base;
import com.wb.tool.MailSender;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;

public class MailSender {
    private Session session;
    private Transport transport;

    public MailSender(String smtp, String username, String password, boolean needAuth) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtp);
        props.put("mail.smtp.auth", Boolean.toString(needAuth));
        this.session = Session.getDefaultInstance((Properties)props, null);
        this.transport = this.session.getTransport("smtp");
        try {
            this.transport.connect(smtp, username, password);
        }
        catch (Throwable e) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.transport.close();
    }

    public void send(String from, String to, String cc, String bcc, String title, String content) throws Exception {
        this.send(from, to, cc, bcc, title, content, null, null, null, null);
    }

    public void send(String from, String to, String cc, String bcc, String title, String content, String attachFiles, HttpServletRequest request, String attachObjects, String attachObjectNames) throws Exception {
        MimeMultipart multipart = new MimeMultipart();
        MimeMessage message = new MimeMessage(this.session);
        int sepPos = from.indexOf(60);
        if (sepPos != -1) {
            message.setFrom((Address)new InternetAddress(MimeUtility.encodeText((String)from.substring(sepPos + 1, from.length() - 1)), from.substring(0, sepPos).trim()));
        } else {
            message.setFrom((Address)new InternetAddress(from));
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        if (!StringUtil.isEmpty((String)cc)) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (!StringUtil.isEmpty((String)bcc)) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        message.setSubject(title);
        message.setSentDate(new Date());
        this.addContent((Multipart)multipart, content);
        this.attachFiles((Multipart)multipart, attachFiles, request, attachObjects, attachObjectNames);
        message.setContent((Multipart)multipart);
        message.saveChanges();
        this.transport.sendMessage((Message)message, message.getAllRecipients());
    }

    private void addContent(Multipart multipart, String content) throws Exception {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)content, "text/html;charset=utf-8");
        multipart.addBodyPart((BodyPart)bodyPart);
    }

    private void attachFiles(Multipart multipart, String attachFiles, HttpServletRequest request, String attachObjects, String attachObjectNames) throws Exception {
        MimeBodyPart bodyPart;
        int i;
        int j;
        if (!StringUtil.isEmpty((String)attachFiles)) {
            if (!attachFiles.startsWith("[")) {
                attachFiles = "[" + attachFiles + "]";
            }
            JSONArray ja = new JSONArray(attachFiles);
            j = ja.length();
            i = 0;
            while (i < j) {
                bodyPart = new MimeBodyPart();
                String file = ja.getString(i);
                bodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(new File(Base.path, file))));
                bodyPart.setFileName(MimeUtility.encodeText((String)FileUtil.getFilename((String)file)));
                bodyPart.setHeader("content-id", "attach" + i);
                multipart.addBodyPart((BodyPart)bodyPart);
                ++i;
            }
        }
        if (!StringUtil.isEmpty((String)attachObjects)) {
            boolean hasObjNames;
            String[] objNames = null;
            String[] list = StringUtil.split((String)attachObjects, (String)",");
            boolean bl = hasObjNames = !StringUtil.isEmpty((String)attachObjectNames);
            if (hasObjNames) {
                objNames = StringUtil.split((String)attachObjectNames, (String)",");
            }
            j = list.length;
            i = 0;
            while (i < j) {
                Object object = request.getAttribute(list[i]);
                if (object != null) {
                    BinDataSource dataSource = object instanceof InputStream ? new BinDataSource(this, (InputStream)object) : (object instanceof byte[] ? new BinDataSource(this, (byte[])object) : new BinDataSource(this, object.toString()));
                    bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                    if (hasObjNames) {
                        bodyPart.setFileName(MimeUtility.encodeText((String)objNames[i]));
                    } else {
                        bodyPart.setFileName(MimeUtility.encodeText((String)list[i]));
                    }
                    bodyPart.setHeader("content-id", list[i]);
                    multipart.addBodyPart((BodyPart)bodyPart);
                }
                ++i;
            }
        }
    }
}

