/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Var;
import com.wb.util.DateUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelObject {
    public static String excelToJson(InputStream inputStream, boolean xlsxFormat) throws Exception {
        int rowIndex = 0;
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuilder text = new StringBuilder("");
        try (Object book = xlsxFormat ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);){
            Sheet sheet = book.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                if (rowIndex > 1) {
                    text.append("\n{");
                } else if (rowIndex > 0) {
                    text.append('{');
                }
                Row row = (Row)rows.next();
                Iterator cells = row.cellIterator();
                int colIndex = 0;
                while (cells.hasNext()) {
                    Cell cell = (Cell)cells.next();
                    Object value = ExcelObject.getCellValue((Cell)cell);
                    if (rowIndex == 0) {
                        if (value == null) {
                            throw new NullPointerException("Field name has null value.");
                        }
                        String valueStr = value.toString();
                        int pos = valueStr.indexOf(40);
                        int pos1 = valueStr.indexOf("\uff08");
                        if (pos1 != -1 && (pos == -1 || pos1 < pos)) {
                            pos = pos1;
                        }
                        if (pos == -1) {
                            fieldList.add(valueStr);
                        } else {
                            fieldList.add(valueStr.substring(0, pos));
                        }
                    } else {
                        if (colIndex > 0) {
                            text.append(',');
                        }
                        if (colIndex >= fieldList.size()) {
                            throw new RuntimeException("Row " + (rowIndex + 1) + " column " + (colIndex + 1) + " is out of bounds.");
                        }
                        text.append(StringUtil.quote((String)((String)fieldList.get(colIndex))));
                        text.append(':');
                        text.append(StringUtil.encode((Object)value));
                    }
                    ++colIndex;
                }
                if (rowIndex > 0) {
                    text.append('}');
                }
                ++rowIndex;
            }
        }
        return text.toString();
    }

    public static String getDisplayText(Cell cell) {
        Object object = ExcelObject.getCellValue((Cell)cell);
        if (object == null) {
            return "";
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Double) {
            double doubleVal = (Double)object;
            String format = cell.getCellStyle().getDataFormatString();
            String value = StringUtil.formatNumber((double)doubleVal, (String)ExcelObject.convertNumFormat((String)format));
            if (doubleVal < 0.0 && format != null && format.indexOf(59) != -1 && format.indexOf("[Red]") != -1) {
                value = "<span style=\"color:red;\">" + value + "</span>";
            }
            return value;
        }
        if (object instanceof Date) {
            return DateUtil.format((Date)((Date)object), (String)"yyyy/M/d");
        }
        return object.toString();
    }

    public static String convertNumFormat(String format) {
        if (format == null) {
            return "0";
        }
        if ("General".equals(format)) {
            return "0.##";
        }
        String[] keys = new String[]{"\"", "_", "(", ")", "*", " "};
        int pos = format.indexOf(59);
        if (pos != -1) {
            format = format.substring(0, pos);
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)key, (String)"");
            ++n2;
        }
        return format;
    }

    public static short getAlignment(String align, short defaultAlign) {
        if ("right".equals(align)) {
            return 3;
        }
        if ("center".equals(align)) {
            return 2;
        }
        if ("left".equals(align)) {
            return 1;
        }
        return defaultAlign;
    }

    public static String toHtmlAlign(short align, String defaultAlign) {
        switch (align) {
            case 1: {
                return "left";
            }
            case 2: {
                return "center";
            }
            case 3: {
                return "right";
            }
            case 5: {
                return "justify";
            }
        }
        return defaultAlign;
    }

    public static String toHtmlVerticalAlign(short align, String defaultAlign) {
        switch (align) {
            case 0: {
                return "top";
            }
            case 1: {
                return "middle";
            }
            case 2: {
                return "bottom";
            }
        }
        return defaultAlign;
    }

    public static Workbook getBook() {
        if (Var.getBool((String)"sys.service.excel.xlsx")) {
            return new XSSFWorkbook();
        }
        return new HSSFWorkbook();
    }

    public static String getExtName() {
        if (Var.getBool((String)"sys.service.excel.xlsx")) {
            return ".xlsx";
        }
        return ".xls";
    }

    public static String toExcelDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "w", "z", "W", "t", "L", "o", "u", "O", "P", "T", "Z", "c", "U", "MS", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"d", "dd"}, {"D", "aaa"}, {"j", "d"}, {"l", "aaaa"}, {"F", "mmmm"}, {"m", "mm"}, {"M", "mmm"}, {"n", "m"}, {"Y", "yyyy"}, {"y", "yy"}, {"a", "am/pm"}, {"A", "AM/PM"}, {"g", "h"}, {"G", "hh"}, {"h", "h"}, {"H", "hh"}, {"i", "mm"}, {"s", "ss"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-mm-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)s[0], (String)s[1]);
            ++n2;
        }
        return format;
    }

    public static String toJavaDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "D", "w", "z", "W", "t", "L", "o", "O", "P", "T", "Z", "c", "U", "F", "MS", "l", "M", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"y", "yy"}, {"Y", "yyyy"}, {"m", "MM"}, {"n", "M"}, {"d", "dd"}, {"j", "d"}, {"H", "HH"}, {"h", "hh"}, {"G", "H"}, {"g", "h"}, {"i", "mm"}, {"s", "ss"}, {"u", "SSS"}, {"a", "'_x'"}, {"A", "'_X'"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-MM-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)s[0], (String)s[1]);
            ++n2;
        }
        return format;
    }

    public static String getCellStyle(XSSFCellStyle style, boolean isNumber) {
        XSSFColor color;
        StringBuilder buf = new StringBuilder();
        XSSFFont font = style.getFont();
        buf.append("text-align:");
        buf.append(ExcelObject.toHtmlAlign((short)style.getAlignment(), (String)(isNumber ? "right" : "left")));
        buf.append(";vertical-align:");
        buf.append(ExcelObject.toHtmlVerticalAlign((short)style.getVerticalAlignment(), (String)"middle"));
        buf.append(";font-family:");
        buf.append(font.getFontName());
        buf.append(";font-size:");
        buf.append(font.getFontHeightInPoints());
        buf.append("pt;font-weight:");
        buf.append(font.getBoldweight());
        String rgb = ExcelObject.getRGBColor((XSSFColor)font.getXSSFColor());
        if (rgb != null) {
            buf.append(";color:");
            buf.append(rgb);
        }
        if ((color = style.getFillForegroundXSSFColor()) != null && (rgb = ExcelObject.getRGBColor((XSSFColor)color)) != null) {
            buf.append(";background-color:");
            buf.append(rgb);
        }
        if (font.getItalic()) {
            buf.append(";font-style:italic;");
        }
        if (font.getStrikeout()) {
            buf.append(";text-decoration:line-through;");
        } else if (FontUnderline.valueOf((byte)font.getUnderline()) != FontUnderline.NONE) {
            buf.append(";text-decoration:underline;");
        }
        buf.append(";border-top:");
        buf.append(ExcelObject.getBorderStyle((short)style.getBorderTop(), (XSSFColor)style.getTopBorderXSSFColor()));
        buf.append(";border-right:");
        buf.append(ExcelObject.getBorderStyle((short)style.getBorderRight(), (XSSFColor)style.getRightBorderXSSFColor()));
        buf.append(";border-bottom:");
        buf.append(ExcelObject.getBorderStyle((short)style.getBorderBottom(), (XSSFColor)style.getBottomBorderXSSFColor()));
        buf.append(";border-left:");
        buf.append(ExcelObject.getBorderStyle((short)style.getBorderLeft(), (XSSFColor)style.getLeftBorderXSSFColor()));
        return buf.toString();
    }

    private static String getBorderStyle(short border, XSSFColor color) {
        String style;
        String width;
        switch (border) {
            case 4: 
            case 7: {
                width = "thin";
                style = "dotted";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: {
                width = "thin";
                style = "dashed";
                break;
            }
            case 6: {
                width = "thin";
                style = "double";
                break;
            }
            case 2: {
                width = "medium";
                style = "solid";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                width = "medium";
                style = "dashed";
                break;
            }
            case 0: {
                return "none";
            }
            case 5: {
                width = "thick";
                style = "solid";
                break;
            }
            default: {
                width = "thin";
                style = "solid";
            }
        }
        String rgb = ExcelObject.getRGBColor((XSSFColor)color);
        if (rgb == null) {
            rgb = "black";
        }
        return String.format("%s %s %s", width, style, rgb);
    }

    public static String getRGBColor(XSSFColor color) {
        if (color == null) {
            return null;
        }
        byte[] xrgb = color.getRgbWithTint();
        if (xrgb == null) {
            return null;
        }
        int red = xrgb[0] < 0 ? xrgb[0] + 256 : xrgb[0];
        int green = xrgb[1] < 0 ? xrgb[1] + 256 : xrgb[1];
        int blue = xrgb[2] < 0 ? xrgb[2] + 256 : xrgb[2];
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    public static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 0: 
            case 2: {
                if (ExcelObject.isDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static boolean isDateFormatted(Cell cell) {
        String format = cell.getCellStyle().getDataFormatString();
        if (format == null) {
            return true;
        }
        if (format.toLowerCase().equals("general")) {
            return false;
        }
        if (format.startsWith("reserved")) {
            return true;
        }
        int pos = format.lastIndexOf(93);
        if (pos != -1) {
            format = format.substring(pos + 1);
        }
        return format.indexOf(48) == -1 && format.indexOf(35) == -1;
    }

    public static boolean isNumericCell(Cell cell) {
        int cellType = cell.getCellType();
        return cellType == 2 || cellType == 0;
    }

    public static void fillRows(Sheet sheet, JSONArray fill, JSONObject params) {
        if (fill == null) {
            return;
        }
        int j = fill.length();
        int i = 0;
        while (i < j) {
            JSONObject obj = fill.optJSONObject(i);
            int x = obj.optInt("x");
            int y = obj.optInt("y");
            JSONArray data = JsonUtil.getArray((Object)params.opt(obj.optString("name")));
            String[] fields = ExcelObject.createRows((Sheet)sheet, (int)x, (int)y, (JSONArray)data);
            if (data != null) {
                JSONObject mergeConfig;
                try {
                    mergeConfig = new JSONObject();
                    JSONArray mergeRows = obj.optJSONArray("mergeRows");
                    JSONArray mergeCols = obj.optJSONArray("mergeCols");
                    JSONArray mergeInfo = new JSONArray();
                    mergeConfig.put("mergeInfo", (Object)mergeInfo);
                    if (mergeRows != null) {
                        mergeConfig.put("mergeRows", true);
                    }
                    String[] stringArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String field = stringArray[n2];
                        JSONArray mergeItem = new JSONArray();
                        if (mergeRows != null) {
                            mergeItem.put(mergeRows.indexOf((Object)field) != -1);
                        } else {
                            mergeItem.put(false);
                        }
                        mergeItem.put(JSONObject.NULL);
                        mergeInfo.put((Object)mergeItem);
                        ++n2;
                    }
                    if (mergeCols != null) {
                        mergeConfig.put("mergeCols", true);
                        int l = mergeCols.length();
                        int k = 0;
                        while (k < l) {
                            JSONArray subItem = mergeCols.getJSONArray(k);
                            int n3 = subItem.length();
                            int m = 0;
                            while (m < n3) {
                                mergeInfo.getJSONArray(StringUtil.indexOf((String[])fields, (String)subItem.getString(m))).put(1, (Object)("g" + k));
                                ++m;
                            }
                            ++k;
                        }
                    }
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("Invalid merge config " + obj.toString());
                }
                ExcelObject.mergeCells((Sheet)sheet, (JSONObject)mergeConfig, (int)y, (int)(y + data.length()));
            }
            ++i;
        }
    }

    public static String[] createRows(Sheet sheet, int x, int y, JSONArray recs) {
        Cell cell;
        Row row = sheet.getRow(y);
        CellStyle rowStyle = row.getRowStyle();
        short height = row.getHeight();
        int l = row.getLastCellNum() - x;
        String[] fields = new String[l];
        CellStyle[] style = new CellStyle[l];
        int k = x;
        while (k < l) {
            cell = row.getCell(k);
            Object objVal = ExcelObject.getCellValue((Cell)cell);
            int m = k - x;
            fields[m] = objVal == null ? null : StringUtil.force((String)objVal.toString());
            style[m] = cell.getCellStyle();
            ++k;
        }
        if (recs == null || recs.length() == 0) {
            ExcelObject.removeRow((Sheet)sheet, (int)y);
            return fields;
        }
        int j = recs.length();
        sheet.shiftRows(y, sheet.getLastRowNum(), j - 1);
        int i = 0;
        while (i < j) {
            row = sheet.createRow(i + y);
            row.setRowStyle(rowStyle);
            row.setHeight(height);
            JSONObject rec = recs.optJSONObject(i);
            if (rec != null) {
                k = 0;
                while (k < l) {
                    cell = row.createCell(k + x);
                    cell.setCellStyle(style[k]);
                    ExcelObject.setCellValue((Cell)cell, (Object)JsonUtil.opt((JSONObject)rec, (String)fields[k]));
                    ++k;
                }
            }
            ++i;
        }
        return fields;
    }

    public static void setCellValue(Cell cell, Object value) {
        if (value == null) {
            cell.setCellValue("");
        } else if (value instanceof String) {
            String strVal = (String)value;
            if (DateUtil.isDate((String)strVal)) {
                cell.setCellValue((Date)DateUtil.strToDate((String)strVal));
            } else {
                if (strVal.indexOf(10) != -1) {
                    cell.getCellStyle().setWrapText(true);
                }
                cell.setCellValue(strVal);
            }
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            String strVal = value.toString();
            if (strVal.indexOf(10) != -1) {
                cell.getCellStyle().setWrapText(true);
            }
            cell.setCellValue(value.toString());
        }
    }

    public static void removeRow(Sheet sheet, int rowIndex) {
        Row removingRow;
        int lastRowNum = sheet.getLastRowNum();
        int mergeRegions = sheet.getNumMergedRegions();
        int i = mergeRegions - 1;
        while (i >= 0) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (range.getFirstRow() <= rowIndex && range.getLastRow() >= rowIndex) {
                sheet.removeMergedRegion(i);
            }
            --i;
        }
        if (rowIndex >= 0 && rowIndex < lastRowNum) {
            sheet.shiftRows(rowIndex + 1, lastRowNum, -1);
        }
        if (rowIndex == lastRowNum && (removingRow = sheet.getRow(rowIndex)) != null) {
            sheet.removeRow(removingRow);
        }
    }

    public static void executeInstruction(Sheet sheet, JSONObject params) {
        JSONArray ja;
        int lastRowIndex = sheet.getLastRowNum();
        Row lastRow = sheet.getRow(lastRowIndex);
        if (lastRow == null) {
            return;
        }
        Cell cell = lastRow.getCell(0);
        if (cell == null) {
            return;
        }
        Object value = ExcelObject.getCellValue((Cell)cell);
        if (value == null) {
            return;
        }
        String instruction = value.toString();
        if (!(instruction = WebUtil.replaceParams((JSONObject)params, (String)instruction)).startsWith("!!")) {
            return;
        }
        instruction = instruction.substring(2);
        ExcelObject.removeRow((Sheet)sheet, (int)lastRowIndex);
        try {
            ja = instruction.startsWith("{") ? new JSONArray("[" + instruction + "]") : new JSONArray(instruction);
            int j = ja.length();
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                jo.put("mergeRows", (Object)JsonUtil.toArray((Object)jo.opt("mergeRows")));
                JSONArray mergeCols = jo.optJSONArray("mergeCols");
                if (mergeCols != null && mergeCols.length() > 0 && !(mergeCols.opt(0) instanceof JSONArray)) {
                    jo.put("mergeCols", (Object)new JSONArray().put((Object)mergeCols));
                }
                ++i;
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid fill instruction " + instruction);
        }
        ExcelObject.fillRows((Sheet)sheet, (JSONArray)ja, (JSONObject)params);
    }

    public static void mergeCells(Sheet sheet, JSONObject config, int startRow, int endRow) {
        boolean isLast;
        String value;
        Object object;
        Cell cell;
        Row row;
        String prevValue;
        int rowIndex;
        int span;
        Iterator rows;
        int i;
        JSONArray mergeInfo = config.optJSONArray("mergeInfo");
        int j = mergeInfo.length();
        int lastRowNum = sheet.getLastRowNum();
        int lastColNum = j - 1;
        if (config.optBoolean("mergeRows")) {
            i = 0;
            while (i < j) {
                if (mergeInfo.getJSONArray(i).getBoolean(0)) {
                    rows = sheet.rowIterator();
                    span = 0;
                    rowIndex = 0;
                    prevValue = null;
                    while (rows.hasNext()) {
                        row = (Row)rows.next();
                        if (rowIndex < startRow) {
                            ++rowIndex;
                            continue;
                        }
                        if (rowIndex > endRow) break;
                        cell = row.getCell(i);
                        object = ExcelObject.getCellValue((Cell)cell);
                        value = object == null ? "" : object.toString();
                        boolean bl = isLast = rowIndex == lastRowNum;
                        if (prevValue != null && (!value.equals(prevValue) || isLast)) {
                            if (isLast) {
                                if (value.equals(prevValue)) {
                                    ++span;
                                } else {
                                    isLast = false;
                                }
                            }
                            if (span > 1) {
                                if (isLast) {
                                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - span + 1, rowIndex - 1, i, i));
                                } else {
                                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - span, rowIndex - 1, i, i));
                                }
                            }
                            span = 0;
                        }
                        prevValue = value;
                        ++span;
                        ++rowIndex;
                    }
                }
                ++i;
            }
        }
        rowIndex = 0;
        if (config.optBoolean("mergeCols")) {
            rows = sheet.rowIterator();
            String[] colGroup = new String[j];
            i = 0;
            while (i < j) {
                colGroup[i] = mergeInfo.getJSONArray(i).optString(1);
                ++i;
            }
            while (rows.hasNext()) {
                row = (Row)rows.next();
                if (rowIndex < startRow) {
                    ++rowIndex;
                    continue;
                }
                if (rowIndex > endRow) break;
                Iterator cells = row.cellIterator();
                span = 0;
                int colIndex = 0;
                prevValue = null;
                String prevGroup = null;
                while (cells.hasNext()) {
                    cell = (Cell)cells.next();
                    object = ExcelObject.getCellValue((Cell)cell);
                    String group = colGroup[colIndex];
                    value = object == null ? "" : object.toString();
                    boolean bl = isLast = colIndex == lastColNum;
                    if (!(prevValue == null || value.equals(prevValue) && group.equals(prevGroup) && !isLast)) {
                        if (isLast) {
                            if (value.equals(prevValue)) {
                                ++span;
                            } else {
                                isLast = false;
                            }
                        }
                        if (span > 1) {
                            if (isLast && !group.isEmpty()) {
                                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex - span + 1, colIndex));
                            } else if (!prevGroup.isEmpty()) {
                                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex - span, colIndex - 1));
                            }
                        }
                        span = 0;
                    }
                    prevValue = value;
                    prevGroup = group;
                    ++span;
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
    }
}

