/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Base;
import com.wb.common.KVBuffer;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.tool.ExcelObject;
import com.wb.util.DateUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import com.wb.util.ZipUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataOutput {
    public static void outputExcel(HttpServletRequest request, HttpServletResponse response, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune, boolean isAjax, boolean isZip, String extName, String mergeScript) throws Exception {
        int startRow = 0;
        String bookData = null;
        JSONArray topHtml = reportInfo.optJSONArray("topHtml");
        JSONArray bottomHtml = reportInfo.optJSONArray("bottomHtml");
        try (Workbook book = isZip ? DataOutput.getBook(null) : DataOutput.getBook((String)WebUtil.fetch((HttpServletRequest)request, (String)"xRestReportData"));){
            Sheet sheet = book.createSheet();
            String sheetName = WebUtil.fetch((HttpServletRequest)request, (String)"xSheetName");
            if (!StringUtil.isEmpty((String)sheetName)) {
                book.setSheetName(book.getSheetIndex(sheet), sheetName);
            }
            if (topHtml != null) {
                DataOutput.createHtml((Sheet)sheet, (JSONArray)topHtml);
                startRow = topHtml.length();
                title = null;
            }
            if (title != null) {
                startRow = 1;
            }
            Object[] values = DataOutput.createHeaders((Sheet)sheet, (JSONArray)headers, (int)startRow, (boolean)neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (title != null) {
                DataOutput.createTitle((Sheet)sheet, (String)title, (int)headerCols);
            }
            startRow += headerRows;
            if (Var.getBool((String)"sys.service.excel.freezePane")) {
                sheet.createFreezePane(0, startRow);
            }
            DataOutput.createRecords((HttpServletRequest)request, (Sheet)sheet, (JSONArray)records, (JSONArray)fields, (int)startRow, (String)dateFormat, (String)timeFormat);
            DataOutput.mergeCells((Sheet)sheet, (JSONObject)reportInfo, (int)startRow);
            if (bottomHtml != null) {
                DataOutput.createHtml((Sheet)sheet, (JSONArray)bottomHtml);
            }
            if (!StringUtil.isEmpty((String)mergeScript)) {
                DataOutput.doMergeScript((Sheet)sheet, (String)mergeScript);
            }
            if (isZip || isAjax) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                book.write((OutputStream)os);
                bookData = StringUtil.encodeBase64((byte[])os.toByteArray());
                if (isZip) {
                    DataOutput.outputZip((ServletOutputStream)response.getOutputStream(), (String)bookData, (String)WebUtil.fetch((HttpServletRequest)request, (String)"xRestReportData"), (String)WebUtil.fetch((HttpServletRequest)request, (String)"xAllFileName"), (String)extName);
                    return;
                }
            } else {
                book.write((OutputStream)response.getOutputStream());
            }
        }
        if (isAjax) {
            WebUtil.send((HttpServletResponse)response, (Object)bookData);
        }
    }

    private static void doMergeScript(Sheet sheet, String mergeScript) {
        if (StringUtil.isEmpty((String)mergeScript)) {
            return;
        }
        JSONArray items = new JSONArray(mergeScript);
        int j = items.length();
        int i = 0;
        while (i < j) {
            JSONObject item = items.optJSONObject(i);
            String cmd = item.optString("cmd");
            if ("del".equals(cmd)) {
                sheet.getRow(item.optInt("row")).getCell(item.optInt("col")).setCellValue("");
            } else {
                sheet.addMergedRegion(new CellRangeAddress(item.optInt("firstRow"), item.optInt("lastRow"), item.optInt("firstCol"), item.optInt("lastCol")));
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void outputZip(ServletOutputStream outputStream, String bookData, String fetch, String xAllFileName, String extName) throws Exception {
        datas = new JSONArray(fetch);
        fileNames = new JSONArray(xAllFileName);
        j = fileNames.length();
        files = new File[j + 1];
        try {
            datas.put((Object)bookData);
            i = 0;
            while (i < j) {
                files[i] = new File(Base.path, "wb/system/tmp/" + fileNames.getString(i) + extName);
                FileUtils.writeByteArrayToFile((File)files[i], (byte[])StringUtil.decodeBase64((String)datas.getString(i)));
                ++i;
            }
            ZipUtil.zip((File[])files, (OutputStream)outputStream);
        }
        finally {
            i = 0;
            ** while (i < j)
        }
lbl-1000:
        // 1 sources

        {
            files[i].delete();
            ++i;
            continue;
        }
lbl23:
        // 1 sources

    }

    private static void mergeCells(Sheet sheet, JSONObject reportInfo, int startRow) {
        boolean isLast;
        String value;
        Object object;
        Cell cell;
        Row row;
        String prevValue;
        int rowIndex;
        int span;
        Iterator rows;
        int i;
        JSONArray mergeInfo = reportInfo.optJSONArray("mergeInfo");
        int j = mergeInfo.length();
        int lastRowNum = sheet.getLastRowNum();
        int lastColNum = j - 1;
        if (reportInfo.optBoolean("mergeRows")) {
            i = 0;
            while (i < j) {
                if (mergeInfo.getJSONArray(i).getBoolean(0)) {
                    rows = sheet.rowIterator();
                    span = 0;
                    rowIndex = 0;
                    prevValue = null;
                    while (rows.hasNext()) {
                        row = (Row)rows.next();
                        if (rowIndex < startRow) {
                            ++rowIndex;
                            continue;
                        }
                        cell = row.getCell(i);
                        object = DataOutput.getCellValue((Cell)cell);
                        value = object == null ? "" : object.toString();
                        boolean bl = isLast = rowIndex == lastRowNum;
                        if (prevValue != null && (!value.equals(prevValue) || isLast)) {
                            if (isLast) {
                                if (value.equals(prevValue)) {
                                    ++span;
                                } else {
                                    isLast = false;
                                }
                            }
                            if (span > 1) {
                                if (isLast) {
                                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - span + 1, rowIndex, i, i));
                                } else {
                                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - span, rowIndex - 1, i, i));
                                }
                            }
                            span = 0;
                        }
                        prevValue = value;
                        ++span;
                        ++rowIndex;
                    }
                }
                ++i;
            }
        }
        rowIndex = 0;
        if (reportInfo.optBoolean("mergeCols")) {
            rows = sheet.rowIterator();
            String[] colGroup = new String[j];
            i = 0;
            while (i < j) {
                colGroup[i] = mergeInfo.getJSONArray(i).optString(1);
                ++i;
            }
            while (rows.hasNext()) {
                row = (Row)rows.next();
                if (rowIndex < startRow) {
                    ++rowIndex;
                    continue;
                }
                Iterator cells = row.cellIterator();
                span = 0;
                int colIndex = 0;
                prevValue = null;
                String prevGroup = null;
                while (cells.hasNext()) {
                    cell = (Cell)cells.next();
                    object = DataOutput.getCellValue((Cell)cell);
                    String group = colGroup[colIndex];
                    value = object == null ? "" : object.toString();
                    boolean bl = isLast = colIndex == lastColNum;
                    if (!(prevValue == null || value.equals(prevValue) && group.equals(prevGroup) && !isLast)) {
                        if (isLast) {
                            if (value.equals(prevValue)) {
                                ++span;
                            } else {
                                isLast = false;
                            }
                        }
                        if (span > 1) {
                            if (isLast && !group.isEmpty()) {
                                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex - span + 1, colIndex));
                            } else if (!prevGroup.isEmpty()) {
                                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex - span, colIndex - 1));
                            }
                        }
                        span = 0;
                    }
                    prevValue = value;
                    prevGroup = group;
                    ++span;
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
    }

    private static void createTitle(Sheet sheet, String title, int headerCols) {
        Row row = sheet.createRow(0);
        Object[] styles = DataOutput.createCellStyle((Workbook)sheet.getWorkbook(), (String)"title");
        row.setHeight(((Short)styles[1]).shortValue());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headerCols - 1));
        Cell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)styles[0]);
        cell.setCellValue(title);
    }

    private static void createHtml(Sheet sheet, JSONArray data) {
        Workbook book = sheet.getWorkbook();
        int y = data.length();
        int startIndex = sheet.getLastRowNum();
        if (startIndex > 0) {
            ++startIndex;
        }
        int x = 0;
        while (x < y) {
            JSONObject dataRow = data.optJSONObject(x);
            JSONArray dataCells = dataRow.optJSONArray("items");
            Row row = sheet.createRow(startIndex + x);
            row.setHeight((short)(dataRow.optInt("height") * 20));
            int j = dataCells.length();
            int cellIndex = 0;
            int i = 0;
            while (i < j) {
                int fontSize;
                JSONObject dataCell = dataCells.optJSONObject(i);
                int colSpan = dataCell.optInt("colSpan");
                Cell cell = row.createCell(cellIndex);
                cell.setCellValue(dataCell.optString("value"));
                CellStyle style = book.createCellStyle();
                style.setAlignment(DataOutput.getAlignment((String)dataCell.optString("align"), (short)1));
                style.setVerticalAlignment((short)1);
                Font font = book.createFont();
                if ("bold".equals(dataCell.optString("weight"))) {
                    font.setBoldweight((short)700);
                }
                if ((fontSize = dataCell.optInt("size")) > 0) {
                    font.setFontHeightInPoints((short)fontSize);
                }
                style.setFont(font);
                cell.setCellStyle(style);
                int k = 1;
                while (k < colSpan) {
                    row.createCell(cellIndex + k);
                    ++k;
                }
                if (colSpan > 1) {
                    sheet.addMergedRegion(new CellRangeAddress(startIndex + x, startIndex + x, cellIndex, cellIndex + colSpan - 1));
                }
                cellIndex += colSpan;
                ++i;
            }
            ++x;
        }
    }

    private static Object[] createHeaders(Sheet sheet, JSONArray headers, int startRow, boolean neptune) {
        Workbook book = sheet.getWorkbook();
        JSONArray processedHeaders = new JSONArray();
        Object[] values = DataOutput.prepareHeaders((Sheet)sheet, (JSONArray)headers, (JSONArray)processedHeaders, (int)startRow, (boolean)neptune);
        Cell[][] cells = (Cell[][])values[0];
        Object[] styles = DataOutput.createCellStyle((Workbook)book, (String)"header");
        CellStyle baseStyle = (CellStyle)styles[0];
        int j = processedHeaders.length();
        int i = 0;
        while (i < j) {
            JSONObject header = processedHeaders.getJSONObject(i);
            int x = header.getInt("x");
            int y = header.getInt("y");
            int colspan = Math.max(header.getInt("colspan"), 0);
            int rowspan = Math.max(header.getInt("rowspan"), 0);
            if (colspan > 0 || rowspan > 0) {
                sheet.addMergedRegion(new CellRangeAddress(y + startRow, y + startRow + rowspan, x, x + colspan));
            }
            Cell cell = cells[x][y];
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(DataOutput.getAlignment((String)header.optString("titleAlign"), (short)(header.has("child") ? (short)2 : 1)));
            cell.setCellStyle(style);
            cell.setCellValue(header.optString("text"));
            ++i;
        }
        Object[] result = new Object[]{cells.length, cells[0].length, values[1]};
        return result;
    }

    private static Object[] prepareHeaders(Sheet sheet, JSONArray rawHeaders, JSONArray processedHeaders, int startRow, boolean neptune) {
        JSONArray leafs = new JSONArray();
        Object[] result = new Object[2];
        int flexWidth = Var.getInt((String)"sys.service.excel.flexColumnMaxWidth");
        Object[] styles = DataOutput.createCellStyle((Workbook)sheet.getWorkbook(), (String)"header");
        CellStyle style = (CellStyle)styles[0];
        short rowHeight = (Short)styles[1];
        double rate = neptune ? 32.06 : 36.55;
        leafs.put(0);
        DataOutput.markParents((JSONArray)leafs, (JSONArray)rawHeaders, null, (int)0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            JSONObject node = leafs.getJSONObject(i);
            int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
            sheet.setColumnWidth(i, (int)((double)width * rate));
            node.put("rowspan", maxDepth - node.getInt("y"));
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                processedHeaders.put((Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        Cell[][] cells = new Cell[j][++maxDepth];
        int k = 0;
        while (k < maxDepth) {
            Row row = sheet.createRow(k + startRow);
            row.setHeight(rowHeight);
            int l = 0;
            while (l < j) {
                Cell cell = row.createCell(l);
                cell.setCellStyle(style);
                cells[l][k] = cell;
                ++l;
            }
            ++k;
        }
        result[0] = cells;
        result[1] = leafs;
        return result;
    }

    private static void markParents(JSONArray leafs, JSONArray headers, JSONObject parent, int depth) {
        int j = headers.length();
        leafs.put(0, Math.max(leafs.getInt(0), depth));
        int i = 0;
        while (i < j) {
            JSONArray items;
            JSONObject header = headers.getJSONObject(i);
            header.put("y", depth);
            header.put("colspan", -1);
            header.put("rowspan", -1);
            if (parent != null) {
                header.put("parent", (Object)parent);
                parent.put("child", (Object)header);
            }
            if ((items = (JSONArray)header.opt("items")) != null) {
                DataOutput.markParents((JSONArray)leafs, (JSONArray)items, (JSONObject)header, (int)(depth + 1));
            } else {
                leafs.put((Object)header);
            }
            ++i;
        }
    }

    private static void createRecords(HttpServletRequest request, Sheet sheet, JSONArray records, JSONArray fields, int startRow, String defaultDateFormat, String defaultTimeFormat) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        Workbook book = sheet.getWorkbook();
        Object[] cellStyles = DataOutput.createCellStyle((Workbook)book, (String)"text");
        CellStyle baseStyle = (CellStyle)cellStyles[0];
        CellStyle[] colStyles = new CellStyle[l];
        CellStyle[][] dateTimeStyles = new CellStyle[l][2];
        short rowHeight = (Short)cellStyles[1];
        String boolString = Var.getString((String)"sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        boolean[] isRate = new boolean[l];
        int[] dataTypes = new int[l];
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            String keyName;
            JSONObject field = fields.getJSONObject(k);
            fieldNames[k] = field.optString("field");
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(DataOutput.getAlignment((String)field.optString("align"), (short)1));
            if (Boolean.TRUE.equals(field.opt("autoWrap"))) {
                style.setWrapText(true);
            }
            if ((keyName = field.optString("keyName")).isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.buffer.get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!StringUtil.isEmpty((String)format)) {
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (StringUtil.isEmpty((String)format)) {
                    CellStyle dateStyle = book.createCellStyle();
                    dateStyle.cloneStyleFrom(style);
                    CellStyle dateTimeStyle = book.createCellStyle();
                    dateTimeStyle.cloneStyleFrom(style);
                    format = DataOutput.toExcelDateFormat((String)defaultDateFormat, (boolean)true);
                    dateStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][0] = dateStyle;
                    format = DataOutput.toExcelDateFormat((String)(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat), (boolean)true);
                    dateTimeStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][1] = dateTimeStyle;
                    style = dateStyle;
                } else {
                    dateTimeStyles[0][0] = null;
                    if ((format = DataOutput.toExcelDateFormat((String)format, (boolean)false)) == null) {
                        format = DataOutput.toExcelDateFormat((String)defaultDateFormat, (boolean)true);
                    }
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            colStyles[k] = style;
            ++k;
        }
        int i = 0;
        while (i < j) {
            Row row = sheet.createRow(startRow + i);
            row.setHeight(rowHeight);
            JSONObject record = (JSONObject)records.opt(i);
            k = 0;
            while (k < l) {
                Cell cell = row.createCell(k);
                cell.setCellStyle(colStyles[k]);
                Object value = JsonUtil.opt((JSONObject)record, (String)fieldNames[k]);
                if (value != null) {
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((ConcurrentHashMap)((ConcurrentHashMap)keyMaps[k]), (HttpServletRequest)request, (Object)value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                            cell.setCellValue(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (dateTimeStyles[k][0] == null) {
                                date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            } else {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr((Date)date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    cell.setCellStyle(dateTimeStyles[k][1]);
                                } else {
                                    cell.setCellStyle(dateTimeStyles[k][0]);
                                }
                            }
                            cell.setCellValue(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                cell.setCellValue(StringUtil.getBool((String)value.toString()) ? trueText : falseText);
                                break;
                            }
                            cell.setCellValue(StringUtil.getBool((String)value.toString()));
                            break;
                        }
                        default: {
                            cell.setCellValue(value.toString());
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public static Workbook getBook(String string) throws Exception {
        ByteArrayInputStream is = null;
        if (!StringUtil.isEmpty((String)string)) {
            is = new ByteArrayInputStream(StringUtil.decodeBase64((String)string));
        }
        if (Var.getBool((String)"sys.service.excel.xlsx")) {
            return is == null ? new XSSFWorkbook() : new XSSFWorkbook((InputStream)is);
        }
        return is == null ? new HSSFWorkbook() : new HSSFWorkbook((InputStream)is);
    }

    public static String getExtName() {
        if (Var.getBool((String)"sys.service.excel.xlsx")) {
            return ".xlsx";
        }
        return ".xls";
    }

    public static Object[] createCellStyle(Workbook book, String type) {
        String backColor;
        CellStyle style = book.createCellStyle();
        Font font = book.createFont();
        String fontName = Var.getString((String)("sys.service.excel." + type + ".fontName"));
        int fontHeight = Var.getInt((String)("sys.service.excel." + type + ".fontHeight"));
        double rowHeight = Var.getDouble((String)("sys.service.excel." + type + ".rowHeight"));
        Object[] result = new Object[2];
        if (!fontName.isEmpty()) {
            font.setFontName(fontName);
        }
        font.setBoldweight((short)Var.getInt((String)("sys.service.excel." + type + ".fontWeight")));
        font.setFontHeight((short)fontHeight);
        if (rowHeight < 10.0) {
            rowHeight *= (double)fontHeight;
        }
        if (!"text".equals(type) && Var.getBool((String)("sys.service.excel." + type + ".wrapText"))) {
            style.setWrapText(true);
        }
        if ("title".equals(type)) {
            String align = Var.getString((String)("sys.service.excel." + type + ".align"));
            if (!align.isEmpty()) {
                Object[][] alignments = new Object[][]{{"\u5c45\u4e2d", (short)2}, {"\u5de6", (short)1}, {"\u53f3", (short)3}, {"\u5c45\u4e2d\u9009\u62e9", (short)6}, {"\u586b\u5145", (short)4}, {"\u5e38\u89c4", (short)0}, {"\u4e24\u7aef\u5bf9\u9f50", (short)5}};
                style.setAlignment(((Short)SysUtil.getValue((Object[][])alignments, (String)align)).shortValue());
            }
        } else if (Var.getBool((String)"sys.service.excel.border")) {
            style.setBorderTop((short)1);
            style.setBorderBottom((short)1);
            style.setBorderLeft((short)1);
            style.setBorderRight((short)1);
        }
        if ("header".equals(type) && !"\u9ed8\u8ba4".equals(backColor = Var.getString((String)"sys.service.excel.header.backColor"))) {
            Object[][] colors = new Object[][]{{"\u9ed8\u8ba4", -1}, {"\u91d1\u8272", (short)51}, {"\u7070\u8272", (short)22}, {"\u6d45\u9ec4", (short)43}};
            style.setFillForegroundColor(((Short)SysUtil.getValue((Object[][])colors, (String)backColor)).shortValue());
            style.setFillPattern((short)1);
        }
        style.setVerticalAlignment((short)1);
        style.setFont(font);
        result[0] = style;
        result[1] = Double.valueOf(rowHeight).shortValue();
        return result;
    }

    public static short getAlignment(String align, short defaultAlign) {
        if ("right".equals(align)) {
            return 3;
        }
        if ("center".equals(align)) {
            return 2;
        }
        if ("left".equals(align)) {
            return 1;
        }
        return defaultAlign;
    }

    public static String excelToJson(InputStream inputStream, boolean xlsxFormat) throws Exception {
        int rowIndex = 0;
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuilder text = new StringBuilder("");
        try (Object book = xlsxFormat ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);){
            Sheet sheet = book.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                if (rowIndex > 1) {
                    text.append("\n{");
                } else if (rowIndex > 0) {
                    text.append('{');
                }
                Row row = (Row)rows.next();
                Iterator cells = row.cellIterator();
                int colIndex = 0;
                while (cells.hasNext()) {
                    Cell cell = (Cell)cells.next();
                    Object value = DataOutput.getCellValue((Cell)cell);
                    if (rowIndex == 0) {
                        if (value == null) {
                            throw new NullPointerException("Field name has null value.");
                        }
                        String valueStr = value.toString();
                        int pos = valueStr.indexOf(40);
                        int pos1 = valueStr.indexOf("\uff08");
                        if (pos1 != -1 && (pos == -1 || pos1 < pos)) {
                            pos = pos1;
                        }
                        if (pos == -1) {
                            fieldList.add(valueStr);
                        } else {
                            fieldList.add(valueStr.substring(0, pos));
                        }
                    } else {
                        if (colIndex > 0) {
                            text.append(',');
                        }
                        if (colIndex >= fieldList.size()) {
                            throw new RuntimeException("Row " + (rowIndex + 1) + " column " + (colIndex + 1) + " is out of bounds.");
                        }
                        text.append(StringUtil.quote((String)((String)fieldList.get(colIndex))));
                        text.append(':');
                        text.append(StringUtil.encode((Object)value));
                    }
                    ++colIndex;
                }
                if (rowIndex > 0) {
                    text.append('}');
                }
                ++rowIndex;
            }
        }
        return text.toString();
    }

    public static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 0: 
            case 2: {
                if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static void outputHtml(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String title, String dateFormat, String timeFormat, boolean neptune, int rowNumberWidth, String rowNumberTitle, String decimalSeparator, String thousandSeparator) throws Exception {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html><html><head><meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\"><title>");
        if (StringUtil.isEmpty((String)title)) {
            html.append(Str.format((HttpServletRequest)request, (String)"preview", (Object[])new Object[0]));
        } else {
            html.append(title);
        }
        html.append("</title><style type=\"text/css\">table{table-layout:fixed;border-collapse:collapse;word-wrap:break-word;");
        String value = Var.getString((String)"sys.service.preview.textFont");
        if (!value.isEmpty()) {
            html.append("font-family:");
            html.append(value);
            html.append(';');
        }
        html.append("line-height:");
        html.append(Var.getString((String)"sys.service.preview.textLineHeight"));
        html.append(";font-size:");
        html.append(Var.getString((String)"sys.service.preview.textFontSize"));
        html.append(";}.header{");
        value = Var.getString((String)"sys.service.preview.headerBackColor");
        if (!value.isEmpty()) {
            html.append("background-color:");
            html.append(value);
            html.append(';');
        }
        html.append("font-weight:");
        html.append(Var.getString((String)"sys.service.preview.headerFontWeight"));
        html.append(";}td{border:1px solid #000000;padding:0 2px 0 2px;}th{border:0;}.wrap{word-wrap:break-word;}</style></head><body>");
        JSONArray fields = DataOutput.createHtmlHeaders((StringBuilder)html, (JSONArray)headers, (String)title, (boolean)neptune, (int)rowNumberWidth, (String)rowNumberTitle);
        DataOutput.getTextContent((HttpServletRequest)request, (StringBuilder)html, (JSONArray)records, (JSONArray)fields, (String)dateFormat, (String)timeFormat, (rowNumberWidth > -1 ? 1 : 0) != 0, (boolean)true, (String)decimalSeparator, (String)thousandSeparator, null);
        html.append("</table></body></html>");
        outputStream.write(html.toString().getBytes("utf-8"));
    }

    public static void outputText(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String defaultDateFormat, String defaultTimeFormat, String decimalSeparator, String thousandSeparator) throws Exception {
        StringBuilder text = new StringBuilder();
        JSONArray leafs = new JSONArray();
        String lineSeparator = SysUtil.getLineSeparator();
        leafs.put(0);
        DataOutput.markParents((JSONArray)leafs, (JSONArray)headers, null, (int)0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            if (i > 0) {
                text.append('\t');
            }
            text.append(leafs.getJSONObject(i).optString("text"));
            ++i;
        }
        text.append(lineSeparator);
        DataOutput.getTextContent((HttpServletRequest)request, (StringBuilder)text, (JSONArray)records, (JSONArray)leafs, (String)defaultDateFormat, (String)defaultTimeFormat, (boolean)false, (boolean)false, (String)decimalSeparator, (String)thousandSeparator, (String)lineSeparator);
        outputStream.write(text.toString().getBytes("utf-8"));
    }

    private static JSONArray createHtmlHeaders(StringBuilder html, JSONArray rawHeaders, String title, boolean neptune, int rowNumberWidth, String rowNumberTitle) {
        JSONArray row;
        JSONObject node;
        JSONArray leafs = new JSONArray();
        JSONArray grid = new JSONArray();
        int flexWidth = Var.getInt((String)"sys.service.excel.flexColumnMaxWidth");
        double rate = neptune ? 0.87719298 : 1.0;
        int tableWidth = rowNumberWidth > -1 ? (rowNumberWidth = (int)Math.round((double)rowNumberWidth * rate)) : 0;
        leafs.put(0);
        DataOutput.markParents((JSONArray)leafs, (JSONArray)rawHeaders, null, (int)0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            node = leafs.getJSONObject(i);
            tableWidth += DataOutput.getHtmlCellWidth((JSONObject)node, (int)flexWidth, (double)rate);
            int y = node.getInt("y");
            node.put("rowspan", maxDepth - y);
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                y = node.getInt("y");
                row = grid.optJSONArray(y);
                if (row == null) {
                    row = new JSONArray();
                    grid.put(y, (Object)row);
                }
                row.put(i, (Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        if (title != null) {
            html.append("<p style=\"text-align:center;width:");
            html.append(tableWidth);
            html.append("px;");
            String value = Var.getString((String)"sys.service.preview.titleFont");
            if (!value.isEmpty()) {
                html.append("font-family:");
                html.append(value);
                html.append(';');
            }
            html.append("font-weight:");
            html.append(Var.getString((String)"sys.service.preview.titleFontWeight"));
            html.append(";line-height:");
            html.append(Var.getString((String)"sys.service.preview.titleLineHeight"));
            html.append(";font-size:");
            html.append(Var.getString((String)"sys.service.preview.titleFontSize"));
            html.append(";\">");
            html.append(StringUtil.toHTML((String)title, (boolean)true, (boolean)true));
            html.append("</p>");
        }
        html.append("<table style=\"width:");
        html.append(tableWidth);
        html.append("px;\">");
        html.append("<tr style=\"height:0\">");
        if (rowNumberWidth > -1) {
            html.append("<th width=\"");
            html.append(rowNumberWidth);
            html.append("px\"></th>");
        }
        j = leafs.length();
        i = 0;
        while (i < j) {
            node = leafs.getJSONObject(i);
            html.append("<th width=\"");
            html.append(DataOutput.getHtmlCellWidth((JSONObject)node, (int)flexWidth, (double)rate));
            html.append("px\"></th>");
            ++i;
        }
        html.append("</tr>");
        j = grid.length();
        i = 0;
        while (i < j) {
            html.append("<tr class=\"header\">");
            if (rowNumberWidth > -1 && i == 0) {
                html.append("<td rowspan=\"");
                html.append(maxDepth + 1);
                html.append("\">");
                html.append(rowNumberTitle);
                html.append("</td>");
            }
            row = grid.getJSONArray(i);
            int l = row.length();
            int k = 0;
            while (k < l) {
                node = row.optJSONObject(k);
                if (node != null) {
                    int rowspan;
                    html.append("<td align=\"");
                    int colspan = node.getInt("colspan");
                    String align = node.optString("titleAlign");
                    if (StringUtil.isEmpty((String)align) && colspan > 0) {
                        align = "center";
                    }
                    html.append(align);
                    html.append('\"');
                    if (colspan > 0) {
                        html.append(" colspan=\"");
                        html.append(colspan + 1);
                        html.append("\"");
                    }
                    if ((rowspan = node.getInt("rowspan")) > 0) {
                        html.append(" rowspan=\"");
                        html.append(rowspan + 1);
                        html.append("\"");
                    }
                    html.append('>');
                    html.append(node.optString("text"));
                    html.append("</td>");
                }
                ++k;
            }
            html.append("</tr>");
            ++i;
        }
        return leafs;
    }

    private static int getHtmlCellWidth(JSONObject node, int flexWidth, double rate) {
        int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
        return (int)Math.round((double)width * rate);
    }

    private static void getTextContent(HttpServletRequest request, StringBuilder buf, JSONArray records, JSONArray fields, String defaultDateFormat, String defaultTimeFormat, boolean hasRowNumber, boolean isHtml, String decimalSeparator, String thousandSeparator, String lineSeparator) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        String boolString = Var.getString((String)"sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        String[] aligns = new String[l];
        boolean[] wraps = new boolean[l];
        boolean[] isRate = new boolean[l];
        int[] dataTypes = new int[l];
        Format[] formats = new Format[l];
        SimpleDateFormat dateFormat = new SimpleDateFormat(DataOutput.toJavaDateFormat((String)defaultDateFormat, (boolean)true));
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(DataOutput.toJavaDateFormat((String)(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat), (boolean)true));
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            JSONObject field = fields.getJSONObject(k);
            String keyName = field.optString("keyName");
            if (keyName.isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.buffer.get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            formats[k] = null;
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!format.isEmpty()) {
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator(decimalSeparator.charAt(0));
                    dfs.setGroupingSeparator(thousandSeparator.charAt(0));
                    decimalFormat.setDecimalFormatSymbols(dfs);
                    formats[k] = decimalFormat;
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (!StringUtil.isEmpty((String)format)) {
                    formats[k] = (format = DataOutput.toJavaDateFormat((String)format, (boolean)false)) == null ? dateFormat : new SimpleDateFormat(format);
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            fieldNames[k] = field.optString("field");
            aligns[k] = field.optString("align");
            wraps[k] = Boolean.TRUE.equals(field.opt("autoWrap"));
            ++k;
        }
        int i = 0;
        while (i < j) {
            JSONObject record = (JSONObject)records.opt(i);
            if (isHtml) {
                buf.append("<tr>");
                if (hasRowNumber) {
                    buf.append("<td align=\"right\">");
                    buf.append(i + 1);
                    buf.append("</td>");
                }
            } else if (i > 0) {
                buf.append(lineSeparator);
            }
            k = 0;
            while (k < l) {
                Object value = JsonUtil.opt((JSONObject)record, (String)fieldNames[k]);
                if (value == null) {
                    if (isHtml) {
                        buf.append("<td></td>");
                    } else {
                        buf.append("\t");
                    }
                } else {
                    String valueText;
                    if (isHtml) {
                        buf.append("<td");
                        if (!aligns[k].isEmpty()) {
                            buf.append(" align=\"");
                            buf.append(aligns[k]);
                            buf.append("\"");
                        }
                        if (wraps[k]) {
                            buf.append(" class=\"wrap\"");
                        }
                        buf.append('>');
                    } else if (k > 0) {
                        buf.append("\t");
                    }
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((ConcurrentHashMap)((ConcurrentHashMap)keyMaps[k]), (HttpServletRequest)request, (Object)value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number;
                            if (value instanceof Number) {
                                if (formats[k] == null) {
                                    valueText = StringUtil.replaceFirst((String)value.toString(), (String)".", (String)decimalSeparator);
                                    break;
                                }
                                number = ((Number)value).doubleValue();
                                valueText = formats[k].format(number);
                                break;
                            }
                            if (formats[k] == null) {
                                valueText = StringUtil.replaceFirst((String)value.toString(), (String)".", (String)decimalSeparator);
                                break;
                            }
                            number = Double.parseDouble(value.toString());
                            valueText = formats[k].format(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (formats[k] == null) {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr((Date)date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    valueText = dateTimeFormat.format((Object)date);
                                    break;
                                }
                                valueText = dateFormat.format((Object)date);
                                break;
                            }
                            date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            valueText = formats[k].format(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                valueText = StringUtil.getBool((String)value.toString()) ? trueText : falseText;
                                break;
                            }
                            valueText = value.toString();
                            break;
                        }
                        default: {
                            valueText = value.toString();
                        }
                    }
                    if (isHtml) {
                        buf.append(StringUtil.toHTML((String)valueText, (boolean)true, (boolean)true));
                        buf.append("</td>");
                    } else {
                        buf.append(valueText);
                    }
                }
                ++k;
            }
            if (isHtml) {
                buf.append("</tr>");
            }
            ++i;
        }
    }

    public static String toJavaDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "D", "w", "z", "W", "t", "L", "o", "O", "P", "T", "Z", "c", "U", "F", "MS", "l", "M", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"y", "yy"}, {"Y", "yyyy"}, {"m", "MM"}, {"n", "M"}, {"d", "dd"}, {"j", "d"}, {"H", "HH"}, {"h", "hh"}, {"G", "H"}, {"g", "h"}, {"i", "mm"}, {"s", "ss"}, {"u", "SSS"}, {"a", "'_x'"}, {"A", "'_X'"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-MM-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)s[0], (String)s[1]);
            ++n2;
        }
        return format;
    }

    public static String toExcelDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "w", "z", "W", "t", "L", "o", "u", "O", "P", "T", "Z", "c", "U", "MS", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"d", "dd"}, {"D", "aaa"}, {"j", "d"}, {"l", "aaaa"}, {"F", "mmmm"}, {"m", "mm"}, {"M", "mmm"}, {"n", "m"}, {"Y", "yyyy"}, {"y", "yy"}, {"a", "am/pm"}, {"A", "AM/PM"}, {"g", "h"}, {"G", "hh"}, {"h", "h"}, {"H", "hh"}, {"i", "mm"}, {"s", "ss"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-mm-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll((String)format, (String)s[0], (String)s[1]);
            ++n2;
        }
        return format;
    }

    public static void importToExcel(File file, JSONObject data, OutputStream outputStream) throws Exception {
        boolean isXlsx = FileUtil.getFileExt((String)file.getName()).toLowerCase().equals("xlsx");
        FileInputStream is = new FileInputStream(file);
        Object book = null;
        try {
            book = isXlsx ? new XSSFWorkbook((InputStream)is) : new HSSFWorkbook((InputStream)is);
            Sheet sheet = book.getSheetAt(0);
            DataOutput.importToSheet((Sheet)sheet, (JSONObject)data);
            book.write(outputStream);
            book.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(book);
            ((InputStream)is).close();
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)book);
        ((InputStream)is).close();
    }

    public static void importToSheet(Sheet sheet, JSONObject data) {
        ArrayList<String> fields = null;
        Iterator rows = sheet.rowIterator();
        int rowIndex = 0;
        int strIndex = 0;
        String field = null;
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Iterator cells = row.cellIterator();
            fields = new ArrayList<String>();
            while (cells.hasNext()) {
                Cell cell = (Cell)cells.next();
                Object value = DataOutput.getCellValue((Cell)cell);
                if (value == null) continue;
                String string = value.toString();
                if (StringUtils.contains((String)string, (String)"{#") && StringUtils.contains((String)string, (String)"#}")) {
                    strIndex = StringUtils.indexOf((String)string, (String)"{#");
                    if (strIndex != 0) {
                        field = StringUtils.substringBetween((String)string, (String)"{#", (String)"#}");
                        value = data.opt(field);
                        if (value != null) {
                            cell.setCellValue(String.valueOf(StringUtils.substringBefore((String)string, (String)"{#")) + value.toString() + StringUtils.substringAfter((String)string, (String)"#}"));
                        } else {
                            cell.setCellValue(String.valueOf(StringUtils.substringBefore((String)string, (String)"{#")) + StringUtils.substringAfter((String)string, (String)"#}"));
                        }
                    } else {
                        value = data.opt(string = string.substring(2, string.length() - 2));
                        if (value == JSONObject.NULL) {
                            cell.setCellValue(" ");
                        } else if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                        } else if (value instanceof Date) {
                            cell.setCellValue((Date)value);
                        } else if (value instanceof Boolean) {
                            cell.setCellValue(((Boolean)value).booleanValue());
                        } else {
                            cell.setCellValue(ObjectUtils.toString((Object)value, (String)""));
                        }
                    }
                }
                if (!StringUtils.contains((String)string, (String)"{R#") || !StringUtils.contains((String)string, (String)"#}")) continue;
                string = string.substring(StringUtils.indexOf((String)string, (String)"{R#") + 3, string.length() - 2);
                fields.add(string);
            }
            if (fields.size() > 0) {
                DataOutput.createRows((Sheet)sheet, (JSONArray)data.getJSONArray("rows"), fields, (int)rowIndex);
            }
            ++rowIndex;
        }
    }

    private static void createRows(Sheet sheet, JSONArray records, List<String> fields, int startRow) {
        int j = records.length();
        int l = fields.size();
        int i = 0;
        while (i < j) {
            Row row = sheet.createRow(startRow + i);
            JSONObject record = (JSONObject)records.opt(i);
            int k = 0;
            while (k < l) {
                Cell cell = row.createCell(k);
                Object value = JsonUtil.opt((JSONObject)record, (String)fields.get(k));
                if (value == JSONObject.NULL) {
                    cell.setCellValue("");
                }
                if (value instanceof Number) {
                    cell.setCellValue(((Number)value).doubleValue());
                } else if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                } else if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                } else {
                    cell.setCellValue(ObjectUtils.toString((Object)value, (String)""));
                }
                ++k;
            }
            ++i;
        }
    }

    public static void outputExcel(OutputStream outputStream, JSONArray headers, JSONArray records, String title, JSONObject reportInfo, String dateFormat, String timeFormat, boolean neptune) throws Exception {
        int startRow = 0;
        JSONArray topHtml = reportInfo.optJSONArray("topHtml");
        JSONArray bottomHtml = reportInfo.optJSONArray("bottomHtml");
        try (Workbook book = ExcelObject.getBook();){
            Sheet sheet = book.createSheet();
            if (topHtml != null) {
                DataOutput.createHtml((Sheet)sheet, (JSONArray)topHtml);
                startRow = topHtml.length();
                title = null;
            }
            if (title != null) {
                startRow = 1;
            }
            Object[] values = DataOutput.createHeaders((Sheet)sheet, (JSONArray)headers, (int)startRow, (boolean)neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (title != null) {
                DataOutput.createTitle((Sheet)sheet, (String)title, (int)headerCols);
            }
            startRow += headerRows;
            if (Var.getBool((String)"sys.service.excel.freezePane")) {
                sheet.createFreezePane(0, startRow);
            }
            DataOutput.createRecords((Sheet)sheet, (JSONArray)records, (JSONArray)fields, (int)startRow, (String)dateFormat, (String)timeFormat);
            ExcelObject.mergeCells((Sheet)sheet, (JSONObject)reportInfo, (int)startRow, (int)Integer.MAX_VALUE);
            if (bottomHtml != null) {
                DataOutput.createHtml((Sheet)sheet, (JSONArray)bottomHtml);
            }
            book.write(outputStream);
        }
    }

    private static void createRecords(Sheet sheet, JSONArray records, JSONArray fields, int startRow, String defaultDateFormat, String defaultTimeFormat) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        Workbook book = sheet.getWorkbook();
        Object[] cellStyles = DataOutput.createCellStyle((Workbook)book, (String)"text");
        CellStyle baseStyle = (CellStyle)cellStyles[0];
        CellStyle[] colStyles = new CellStyle[l];
        CellStyle[][] dateTimeStyles = new CellStyle[l][2];
        short rowHeight = (Short)cellStyles[1];
        String boolString = Var.getString((String)"sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        int[] dataTypes = new int[l];
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            String keyName;
            JSONObject field = fields.getJSONObject(k);
            fieldNames[k] = field.optString("field");
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(ExcelObject.getAlignment((String)field.optString("align"), (short)1));
            if (Boolean.TRUE.equals(field.opt("autoWrap"))) {
                style.setWrapText(true);
            }
            if ((keyName = field.optString("keyName")).isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.buffer.get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!StringUtil.isEmpty((String)format)) {
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (StringUtil.isEmpty((String)format)) {
                    CellStyle dateStyle = book.createCellStyle();
                    dateStyle.cloneStyleFrom(style);
                    CellStyle dateTimeStyle = book.createCellStyle();
                    dateTimeStyle.cloneStyleFrom(style);
                    format = ExcelObject.toExcelDateFormat((String)defaultDateFormat, (boolean)true);
                    dateStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][0] = dateStyle;
                    format = ExcelObject.toExcelDateFormat((String)(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat), (boolean)true);
                    dateTimeStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][1] = dateTimeStyle;
                    style = dateStyle;
                } else {
                    dateTimeStyles[0][0] = null;
                    if ((format = ExcelObject.toExcelDateFormat((String)format, (boolean)false)) == null) {
                        format = ExcelObject.toExcelDateFormat((String)defaultDateFormat, (boolean)true);
                    }
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            colStyles[k] = style;
            ++k;
        }
        int i = 0;
        while (i < j) {
            Row row = sheet.createRow(startRow + i);
            row.setHeight(rowHeight);
            JSONObject record = (JSONObject)records.opt(i);
            k = 0;
            while (k < l) {
                Cell cell = row.createCell(k);
                cell.setCellStyle(colStyles[k]);
                Object value = JsonUtil.opt((JSONObject)record, (String)fieldNames[k]);
                if (value != null) {
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((ConcurrentHashMap)((ConcurrentHashMap)keyMaps[k]), (Object)value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                            cell.setCellValue(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (dateTimeStyles[k][0] == null) {
                                date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            } else {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr((Date)date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    cell.setCellStyle(dateTimeStyles[k][1]);
                                } else {
                                    cell.setCellStyle(dateTimeStyles[k][0]);
                                }
                            }
                            cell.setCellValue(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                cell.setCellValue(StringUtil.getBool((String)value.toString()) ? trueText : falseText);
                                break;
                            }
                            cell.setCellValue(StringUtil.getBool((String)value.toString()));
                            break;
                        }
                        default: {
                            cell.setCellValue(value.toString());
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
    }
}

