/*
 * Decompiled with CFR 0.152.
 */
package com.wb.task;

import com.rw.dao.BaseDAO;
import com.rw.email.service.EmailService;
import com.rw.model.FileModel;
import com.rw.util.PropKit;
import com.rw.util.SpringContextHolder;
import com.wb.common.Base;
import com.wb.tool.MailSender;
import com.wb.util.DateUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MailTask
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        MailSender mailSender = null;
        long start = System.currentTimeMillis();
        String jobDesc = context.getJobDetail().getDescription();
        try {
            try {
                LogUtil.info((Object)("Start job " + jobDesc));
                String stmp_host = PropKit.getProperty((String)"mail.smtp.host");
                boolean stmp_auth = Boolean.parseBoolean(PropKit.getProperty((String)"mail.smtp.auth"));
                String username = PropKit.getProperty((String)"mail.username");
                String password = PropKit.getProperty((String)"mail.password");
                String fromUser = PropKit.getProperty((String)"mail.fromUser");
                int max_retry_count = Integer.parseInt(StringUtils.defaultIfBlank((String)PropKit.getProperty((String)"mail.maxRetryCount"), (String)"5"));
                mailSender = new MailSender(stmp_host, username, password, stmp_auth);
                String queryNoSendedSql = "SELECT mail.MAIL_ID,mail.MAIL_SUBJECT,mail.MAIL_CONTENT,mail.IS_HTML,mail.SRC,mail.OBJECT_ID,mail.CREATOR,mail.CREATE_TIME,mailreceiver.TO_USER,mailreceiver.RECV_ADDR,mailreceiver.SEND_TYPE,mailreceiver.RETRY_TIMES,mailreceiver.MAIL_ATTACHMENT FROM T_MAIL mail LEFT JOIN T_MAIL_RECEIVER mailreceiver on mail.MAIL_ID = mailreceiver.MAIL_ID WHERE mailreceiver.STATUS = 0 AND mail.IS_VALID = 1 AND mail.EXPIRED_TIME > GETDATE()";
                String updateSendedStateSql = "UPDATE T_MAIL_RECEIVER SET STATUS = ? , RETRY_TIMES = ?, LAST_PROCESS_TIME = GETDATE() WHERE MAIL_ID = ?";
                EmailService emailService = (EmailService)SpringContextHolder.getBean((String)"emailService");
                BaseDAO baseDAO = (BaseDAO)SpringContextHolder.getBean((String)"baseDAO");
                List mailList = emailService.getEmails(queryNoSendedSql);
                for (Map mail : mailList) {
                    int status;
                    int hasRetryCount;
                    String mailId;
                    block22: {
                        mailId = (String)mail.get("MAIL_ID");
                        String to = (String)mail.get("RECV_ADDR");
                        String subject = (String)mail.get("MAIL_SUBJECT");
                        String content = (String)mail.get("MAIL_CONTENT");
                        String isHtml = (String)mail.get("IS_HTML");
                        String attachment = ObjectUtils.toString(mail.get("MAIL_ATTACHMENT"), (String)"");
                        hasRetryCount = mail.get("RETRY_TIMES") == null ? 0 : Integer.parseInt(mail.get("RETRY_TIMES").toString());
                        try {
                            if (StringUtils.isNotBlank((String)attachment)) {
                                String[] ids = StringUtils.split((String)attachment.trim(), (String)",");
                                ArrayList<String> attachementFileList = new ArrayList<String>(ids.length);
                                FileModel fileModel = null;
                                String fileName = null;
                                File file = null;
                                String[] stringArray = ids;
                                int n = ids.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String id = stringArray[n2];
                                    if (StringUtils.isNotBlank((String)id) && (fileModel = baseDAO.getFileFromDB(id)) != null) {
                                        fileName = String.valueOf(fileModel.getName()) + "." + fileModel.getExtension();
                                        file = new File(System.getProperty("java.io.tmpdir"), fileModel.getId());
                                        File destFile = new File(Base.path, String.valueOf(fileModel.getName()) + "." + fileModel.getExtension());
                                        FileUtils.copyFile((File)file, (File)destFile);
                                        attachementFileList.add(fileName);
                                    }
                                    ++n2;
                                }
                                mailSender.send(fromUser, to, "", "", subject, content, StringUtils.join(attachementFileList, (String)","), null, null, null);
                            } else {
                                mailSender.send(fromUser, to, "", "", subject, content);
                            }
                            status = 1;
                            LogUtil.info((Object)StringUtil.concat((String[])new String[]{"send mail  for (subject='" + subject + "', to='" + to + "\u53d1\u9001\u6210\u529f\uff01", " in ", DateUtil.format((long)(System.currentTimeMillis() - start))}));
                        }
                        catch (Exception e) {
                            LogUtil.error((Object)("send mail error for (subject='" + subject + "', to='" + to + "')  is " + e.getMessage()));
                            status = 2;
                            if (hasRetryCount + 1 >= max_retry_count) break block22;
                            status = 0;
                        }
                    }
                    emailService.updateSendedState(updateSendedStateSql, new Object[]{status, ++hasRetryCount, mailId});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtil.error((Object)StringUtil.concat((String[])new String[]{"Execute mail job ", jobDesc, " failed with error ", SysUtil.getRootError((Throwable)e), " in ", DateUtil.format((long)(System.currentTimeMillis() - start))}));
                try {
                    mailSender.close();
                }
                catch (Exception e2) {
                    LogUtil.error((Object)("\u5173\u95ed\u90ae\u4ef6\u670d\u52a1\u5668\u5931\u8d25:" + e2.getMessage()));
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.error((Object)StringUtil.concat((String[])new String[]{"Execute mail job ", jobDesc, " failed with error ", SysUtil.getRootError((Throwable)e), " in ", DateUtil.format((long)(System.currentTimeMillis() - start))}));
                try {
                    mailSender.close();
                }
                catch (Exception e3) {
                    LogUtil.error((Object)("\u5173\u95ed\u90ae\u4ef6\u670d\u52a1\u5668\u5931\u8d25:" + e3.getMessage()));
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                mailSender.close();
            }
            catch (Exception e) {
                LogUtil.error((Object)("\u5173\u95ed\u90ae\u4ef6\u670d\u52a1\u5668\u5931\u8d25:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }
}

