/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.Resource;
import com.wb.common.Var;
import com.wb.tool.DataOutput;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import com.wb.util.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class Service {
    public static void saveState(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!Var.saveState) {
            throw new RuntimeException("Variable sys.controls.saveState disabled.");
        }
        String clientState = "clientState";
        String state = Resource.getString((HttpServletRequest)request, (String)clientState, null);
        JSONObject stateObject = StringUtil.isEmpty((String)state) ? new JSONObject() : new JSONObject(state);
        stateObject.put(WebUtil.fetch((HttpServletRequest)request, (String)"name"), (Object)WebUtil.fetch((HttpServletRequest)request, (String)"value"));
        Resource.set((HttpServletRequest)request, (String)clientState, (String)stateObject.toString());
    }

    private static void download(HttpServletRequest request, HttpServletResponse response, boolean webFilesOnly) throws Exception {
        String filename;
        JSONArray ja = new JSONArray(WebUtil.fetch((HttpServletRequest)request, (String)"files"));
        int j = ja.length();
        File base = null;
        File sysFolder = null;
        File[] files = new File[j];
        if (webFilesOnly) {
            base = new File(Base.path, "wb");
            sysFolder = new File(Base.path, "wb/system");
        }
        int i = 0;
        while (i < j) {
            if (webFilesOnly) {
                files[i] = new File(Base.path, ja.optString(i));
                if (!FileUtil.isAncestor((File)base, (File)files[i]) || FileUtil.isAncestor((File)sysFolder, (File)files[i]) || FileUtil.isAncestor((File)Base.modulePath, (File)files[i])) {
                    SysUtil.accessDenied();
                }
            } else {
                files[i] = new File(ja.optString(i));
            }
            ++i;
        }
        boolean useZip = StringUtil.getBool((String)WebUtil.fetch((HttpServletRequest)request, (String)"zip")) || j > 1 || files[0].isDirectory();
        String downloadName = WebUtil.fetch((HttpServletRequest)request, (String)"downloadName");
        if (StringUtil.isEmpty((String)downloadName)) {
            filename = files[0].getName();
            if (j == 1) {
                if (useZip) {
                    filename = String.valueOf(FileUtil.removeExtension((String)filename)) + ".zip";
                }
            } else {
                File parentFile = files[0].getParentFile();
                filename = parentFile == null ? "file.zip" : String.valueOf(parentFile.getName()) + ".zip";
            }
            if (filename.equals(".zip") || filename.equals("/.zip")) {
                filename = "file.zip";
            }
        } else {
            filename = downloadName;
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename((HttpServletRequest)request, (String)filename));
        if (useZip) {
            ZipUtil.zip((File[])files, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        } else {
            WebUtil.send((HttpServletResponse)response, (Object)new FileInputStream(files[0]));
        }
    }

    public static void downloadAtAll(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.download((HttpServletRequest)request, (HttpServletResponse)response, (boolean)false);
    }

    public static void downloadAtApp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.download((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean unzip = StringUtil.getBool((String)((String)request.getAttribute("unzip")));
        boolean sync = StringUtil.getBool((String)((String)request.getAttribute("sync")));
        String path = request.getAttribute("path").toString();
        InputStream stream = (InputStream)request.getAttribute("file");
        String filename = (String)request.getAttribute("filename");
        if (filename == null) {
            filename = (String)request.getAttribute("file__name");
        }
        if (unzip) {
            File syncPath;
            if (!filename.toLowerCase().endsWith(".zip")) throw new Exception("Invalid zip file.");
            File destPath = new File(path);
            ZipUtil.unzip((InputStream)stream, (File)destPath);
            if (!sync || (syncPath = FileUtil.getSyncPath((File)destPath)) == null) return;
            FileUtils.copyDirectory((File)destPath, (File)syncPath);
            return;
        } else {
            File syncPath;
            File destPath = new File(path, filename);
            FileUtil.saveStream((InputStream)stream, (File)destPath);
            if (!sync || (syncPath = FileUtil.getSyncPath((File)destPath)) == null) return;
            FileUtils.copyFile((File)destPath, (File)syncPath);
        }
    }

    public static void getProgress(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("progressId");
        HttpSession session = request.getSession(true);
        Long pos = (Long)session.getAttribute("sys.upread." + id);
        Long len = (Long)session.getAttribute("sys.uplen." + id);
        double result = pos == null || len == null || len == 0L ? 0.0 : (double)pos.longValue() / (double)len.longValue();
        WebUtil.send((HttpServletResponse)response, (Object)result);
    }

    public static void importData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream stream;
        String filename;
        boolean fromServer = StringUtil.getBool((String)WebUtil.fetch((HttpServletRequest)request, (String)"fromServer"));
        if (fromServer) {
            filename = WebUtil.fetch((HttpServletRequest)request, (String)"filename");
            stream = new FileInputStream(new File(filename));
            filename = filename.toLowerCase();
        } else {
            filename = ((String)request.getAttribute("file__name")).toLowerCase();
            stream = (InputStream)request.getAttribute("file");
        }
        try {
            String tableName = WebUtil.fetch((HttpServletRequest)request, (String)"table");
            boolean trans = StringUtil.getBool((String)WebUtil.fetch((HttpServletRequest)request, (String)"trans"));
            Connection connection = DbUtil.getConnection((String)WebUtil.fetch((HttpServletRequest)request, (String)"jndi"));
            try {
                if (trans) {
                    connection.setAutoCommit(false);
                }
                if (filename.endsWith(".gz")) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(stream), "utf-8"));
                    DbUtil.importData((Connection)connection, (String)tableName, (BufferedReader)reader);
                } else if (filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
                    BufferedReader reader = new BufferedReader(new StringReader(DataOutput.excelToJson((InputStream)stream, (boolean)filename.endsWith(".xlsx"))));
                    DbUtil.importData((Connection)connection, (String)tableName, (BufferedReader)reader);
                } else {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                    String fields = reader.readLine();
                    char separator = fields.indexOf(9) == -1 ? (char)',' : '\t';
                    String[] fieldList = StringUtil.split((String)fields, (char)separator);
                    DbUtil.importData((Connection)connection, (String)tableName, (BufferedReader)reader, (String[])fieldList, (char)separator);
                }
                if (trans) {
                    connection.commit();
                }
            }
            finally {
                DbUtil.close((Object)connection);
            }
        }
        finally {
            stream.close();
        }
    }

    public static void exportJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run((HttpServletRequest)request, (String)WebUtil.fetch((HttpServletRequest)request, (String)"sql"), (String)WebUtil.fetch((HttpServletRequest)request, (String)"jndi"));
        String filename = WebUtil.fetch((HttpServletRequest)request, (String)"filename");
        if (filename == null) {
            filename = "data.gz";
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename((HttpServletRequest)request, (String)filename));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)response.getOutputStream()), "utf-8"));){
            DbUtil.exportData((ResultSet)rs, (Writer)writer);
        }
        response.flushBuffer();
    }

    public static void exportJsonToServer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run((HttpServletRequest)request, (String)WebUtil.fetch((HttpServletRequest)request, (String)"sql"), (String)WebUtil.fetch((HttpServletRequest)request, (String)"jndi"));
        String filename = WebUtil.fetch((HttpServletRequest)request, (String)"filename");
        File file = new File(filename);
        if (file.exists()) {
            throw new Exception("\u6587\u4ef6 \u201c" + filename + "\u201d \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(file);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), "utf-8"));
            DbUtil.exportData((ResultSet)rs, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            fos.close();
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        fos.close();
    }
}

