/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.Resource;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Value;
import com.wb.common.XwlBuffer;
import com.wb.interact.IDE;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class Portal {
    private static JSONArray getModuleList(HttpServletRequest request, String path, String[] roles, int type) throws Exception {
        File base;
        int displayType;
        int n = displayType = type == 1 ? 1 : 3;
        if (path == null) {
            base = Base.modulePath;
        } else {
            base = new File(Base.modulePath, path);
            if (!FileUtil.isAncestor((File)Base.modulePath, (File)base)) {
                SysUtil.accessDenied();
            }
        }
        path = String.valueOf(path) + "/";
        ArrayList fileNames = IDE.getSortedFile((File)base);
        JSONObject content = null;
        JSONArray fileArray = new JSONArray();
        for (Map.Entry entry : fileNames) {
            String fileName = (String)entry.getKey();
            File file = new File(base, fileName);
            if (!file.exists() || !XwlBuffer.canDisplay((File)file, (String[])roles, (int)displayType)) continue;
            boolean isFolder = file.isDirectory();
            if (isFolder) {
                if (type != 1 && !Portal.hasLoginModule((File)file)) continue;
                File configFile = new File(file, "folder.json");
                content = configFile.exists() ? JsonUtil.readObject((File)configFile) : new JSONObject();
            } else {
                if (type != 1 && !file.getName().endsWith(".xwl")) continue;
                content = XwlBuffer.get((String)(String.valueOf(path) + fileName), (boolean)false);
                if (type != 1 && Boolean.FALSE.equals(content.opt("loginRequired"))) continue;
            }
            JSONObject fileObject = new JSONObject();
            String title = content.optString("title");
            String qtip = content.optString("qtip");
            if (title.startsWith("Str.")) {
                title = Str.format((HttpServletRequest)request, (String)title.substring(4), (Object[])new Object[0]);
            }
            fileObject.put("text", (Object)StringUtil.select((String[])new String[]{title, fileName}));
            fileObject.put("qtip", (Object)qtip);
            String relPath = FileUtil.getModulePath((File)file);
            fileObject.put("path", (Object)relPath);
            fileObject.put("fileName", (Object)fileName);
            fileObject.put("inframe", Boolean.TRUE.equals(content.opt("inframe")));
            if (isFolder) {
                fileObject.put("children", (Object)Portal.getModuleList((HttpServletRequest)request, (String)relPath, (String[])roles, (int)type));
            } else {
                String pageLink = (String)content.opt("pageLink");
                if (!StringUtil.isEmpty((String)pageLink)) {
                    fileObject.put("pageLink", (Object)pageLink);
                }
                fileObject.put("leaf", true);
            }
            fileObject.put("cls", (Object)"wb_pointer");
            String iconCls = content.optString("iconCls");
            if (!StringUtil.isEmpty((String)iconCls)) {
                fileObject.put("iconCls", (Object)iconCls);
            }
            if (type == 2 && !isFolder) {
                fileObject.put("checked", false);
            }
            fileArray.put((Object)fileObject);
        }
        return fileArray;
    }

    private static boolean hasLoginModule(File path) throws IOException {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles((File)path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            JSONObject content;
            File file = fileArray[n2];
            if (file.isDirectory() ? Portal.hasLoginModule((File)file) : file.getName().endsWith(".xwl") && Boolean.TRUE.equals((content = XwlBuffer.get((String)FileUtil.getModulePath((File)file), (boolean)true)).opt("loginRequired"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void initHome(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean treeHidden;
        boolean treeCollapsed;
        int viewIndex;
        int treeWidth;
        String desktopString = Resource.getString((HttpServletRequest)request, (String)"desktop", null);
        if (desktopString == null) {
            desktopString = Resource.getString((String)"sys.home.desktop", null);
        }
        if (desktopString != null) {
            JSONArray portlets;
            String qtip;
            JSONObject desktop = new JSONObject(desktopString);
            treeWidth = desktop.optInt("treeWidth", 200);
            viewIndex = desktop.optInt("viewIndex", 0);
            treeCollapsed = desktop.optBoolean("treeCollapsed", false);
            treeHidden = desktop.optBoolean("treeHidden", false);
            JSONArray pages = desktop.optJSONArray("pages");
            if (pages != null) {
                int j = pages.length();
                int activeIndex = desktop.optInt("active", 0);
                JSONArray tabItems = new JSONArray();
                int i = 0;
                while (i < j) {
                    JSONObject page = pages.optJSONObject(i);
                    String rawUrl = page.optString("url");
                    String url = FileUtil.getModuleFile((String)rawUrl, (boolean)true);
                    JSONObject module = XwlBuffer.get((String)url, (boolean)true);
                    if (module == null) {
                        if (i <= activeIndex) {
                            --activeIndex;
                        }
                    } else {
                        String pageLink;
                        JSONObject item = new JSONObject();
                        item.put("url", (Object)rawUrl);
                        String title = (String)module.opt("title");
                        if (title.startsWith("Str.")) {
                            title = Str.format((HttpServletRequest)request, (String)title.substring(4), (Object[])new Object[0]);
                        }
                        item.put("title", (Object)StringUtil.select((String[])new String[]{title, FileUtil.getFilename((String)url)}));
                        item.put("iconCls", (Object)((String)module.opt("iconCls")));
                        item.put("useIFrame", Boolean.TRUE.equals(module.opt("inframe")));
                        String params = page.optString("params");
                        if (!StringUtil.isEmpty((String)params)) {
                            item.put("params", (Object)new JSONObject(params));
                        }
                        if (!StringUtil.isEmpty((String)(pageLink = (String)module.opt("pageLink")))) {
                            JsonUtil.apply((JSONObject)item, (JSONObject)new JSONObject(pageLink));
                        }
                        if (StringUtils.isNotBlank((String)(qtip = ObjectUtils.toString((Object)module.opt("qtip"), (String)"")))) {
                            item.put("qtip", (Object)qtip);
                        }
                        tabItems.put((Object)item);
                    }
                    ++i;
                }
                request.setAttribute("activeIndex", (Object)activeIndex);
                request.setAttribute("tabItems", (Object)StringUtil.text((String)tabItems.toString()));
            }
            if ((portlets = desktop.optJSONArray("portlets")) != null) {
                int j = portlets.length();
                int i = 0;
                while (i < j) {
                    JSONArray cols = portlets.optJSONArray(i);
                    int l = cols.length();
                    int k = 0;
                    while (k < l) {
                        JSONObject portlet = cols.optJSONObject(k);
                        String url = FileUtil.getModuleFile((String)portlet.optString("url"), (boolean)true);
                        JSONObject module = XwlBuffer.get((String)url, (boolean)true);
                        if (module == null) {
                            cols.remove(k);
                            --k;
                            --l;
                        } else {
                            String title = (String)module.opt("title");
                            if (title.startsWith("Str.")) {
                                title = Str.format((HttpServletRequest)request, (String)title.substring(4), (Object[])new Object[0]);
                            }
                            portlet.put("title", (Object)StringUtil.select((String[])new String[]{title, FileUtil.getFilename((String)url)}));
                            portlet.put("iconCls", (Object)((String)module.opt("iconCls")));
                            portlet.put("useIFrame", Boolean.TRUE.equals(module.opt("inframe")));
                            String pageLink = (String)module.opt("pageLink");
                            if (!StringUtil.isEmpty((String)pageLink)) {
                                JsonUtil.apply((JSONObject)portlet, (JSONObject)new JSONObject(pageLink));
                            }
                            if (StringUtils.isNotBlank((String)(qtip = ObjectUtils.toString((Object)module.opt("qtip"), (String)"")))) {
                                portlet.put("qtip", (Object)qtip);
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
                request.setAttribute("portlets", (Object)StringUtil.text((String)portlets.toString()));
            }
        } else {
            treeWidth = 200;
            viewIndex = 0;
            treeCollapsed = false;
            treeHidden = false;
        }
        request.setAttribute("treeWidth", (Object)treeWidth);
        request.setAttribute("viewIndex", (Object)viewIndex);
        request.setAttribute("treeCollapsed", (Object)treeCollapsed);
        request.setAttribute("treeHidden", (Object)treeHidden);
        request.setAttribute("hideSetDefaultDesktop", (Object)(!XwlBuffer.canAccess((HttpServletRequest)request, (String)"m?xwl=sys/portal/home/save-default-desktop") ? 1 : 0));
        request.setAttribute("hideSetAllDesktop", (Object)(!XwlBuffer.canAccess((HttpServletRequest)request, (String)"m?xwl=sys/portal/home/save-all-desktop") ? 1 : 0));
    }

    public static void saveDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.doSaveDesktop((HttpServletRequest)request, (int)1);
    }

    public static void saveAsDefaultDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.doSaveDesktop((HttpServletRequest)request, (int)2);
    }

    public static void saveAsAllDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.doSaveDesktop((HttpServletRequest)request, (int)3);
    }

    private static void doSaveDesktop(HttpServletRequest request, int type) throws Exception {
        JSONObject desktop = new JSONObject();
        desktop.put("treeWidth", Integer.parseInt(request.getParameter("treeWidth")));
        desktop.put("viewIndex", Integer.parseInt(request.getParameter("viewIndex")));
        desktop.put("treeCollapsed", Boolean.parseBoolean(request.getParameter("treeCollapsed")));
        desktop.put("treeHidden", Boolean.parseBoolean(request.getParameter("treeHidden")));
        desktop.put("pages", (Object)new JSONArray(request.getParameter("pages")));
        desktop.put("portlets", (Object)new JSONArray(request.getParameter("portlets")));
        desktop.put("active", Integer.parseInt(request.getParameter("active")));
        if (type == 1) {
            Resource.set((HttpServletRequest)request, (String)"desktop", (String)desktop.toString());
        } else {
            if (type == 3) {
                DbUtil.run((HttpServletRequest)request, (String)"delete from WB_RESOURCE where RES_ID like 'desktop@%'");
            }
            Resource.set((String)"sys.home.desktop", (String)desktop.toString());
        }
    }

    public static void getAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList((HttpServletRequest)request, (String)request.getParameter("path"), (String[])Session.getRoles((HttpServletRequest)request), (int)1)));
    }

    public static void getPermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList((HttpServletRequest)request, (String)request.getParameter("path"), (String[])Session.getRoles((HttpServletRequest)request), (int)2)));
    }

    public static void getUserPermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("children", (Object)Portal.getModuleList((HttpServletRequest)request, (String)request.getParameter("path"), (String[])Session.getRoles((HttpServletRequest)request), (int)3)));
    }

    public static void setTheme(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String theme = request.getParameter("theme");
        Value.set((HttpServletRequest)request, (String)"theme", (String)theme);
        WebUtil.setSessionValue((HttpServletRequest)request, (String)"sys.theme", (Object)theme);
    }

    public static void setTouchTheme(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String theme = request.getParameter("theme");
        Value.set((HttpServletRequest)request, (String)"touchTheme", (String)theme);
        WebUtil.setSessionValue((HttpServletRequest)request, (String)"sys.touchTheme", (Object)theme);
    }

    public static void initTouchHome(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        boolean isNotLogin = session == null || session.getAttribute("sys.logined") == null;
        request.setAttribute("isNotLogin", (Object)(isNotLogin ? 1 : 0));
    }

    private static void searchModule(HttpServletRequest request, HttpServletResponse response, boolean isPerm) throws Exception {
        JSONArray array = new JSONArray();
        String query = request.getParameter("query").toLowerCase();
        String[] roles = Session.getRoles((HttpServletRequest)request);
        if (query.isEmpty()) {
            query = ".xwl";
        }
        Portal.doSearchFile((HttpServletRequest)request, (File)Base.modulePath, (String)query.toLowerCase(), (String)"", (String)"", (JSONArray)array, (boolean)isPerm, (String[])roles);
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("rows", (Object)array));
    }

    public static void searchAppModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.searchModule((HttpServletRequest)request, (HttpServletResponse)response, (boolean)false);
    }

    public static void searchPermModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Portal.searchModule((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
    }

    private static boolean doSearchFile(HttpServletRequest request, File folder, String searchName, String parentText, String parentFile, JSONArray array, boolean isPerm, String[] roles) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles((File)folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (XwlBuffer.canDisplay((File)file, (String[])roles, (int)(isPerm ? 3 : 1))) {
                if (file.isDirectory()) {
                    String folderTitle;
                    JSONObject jo;
                    File indexFile = new File(file, "folder.json");
                    String folderFile = file.getName();
                    if (indexFile.exists()) {
                        jo = JsonUtil.readObject((File)indexFile);
                        folderTitle = jo.optString("title");
                        if (folderTitle.isEmpty()) {
                            folderTitle = folderFile;
                        }
                    } else {
                        folderTitle = folderFile;
                    }
                    if (folderTitle.startsWith("Str.")) {
                        folderTitle = Str.format((HttpServletRequest)request, (String)folderTitle.substring(4), (Object[])new Object[0]);
                    }
                    if (!isPerm && folderTitle.toLowerCase().indexOf(searchName) != -1) {
                        jo = new JSONObject();
                        jo.put("path", (Object)parentText);
                        jo.put("title", (Object)folderTitle);
                        jo.put("file", (Object)folderFile);
                        jo.put("parentFile", (Object)parentFile);
                        array.put((Object)jo);
                        if (array.length() > 99) {
                            return true;
                        }
                    }
                    if (Portal.doSearchFile((HttpServletRequest)request, (File)file, (String)searchName, (String)StringUtil.concat((String[])new String[]{parentText, "/", folderTitle}), (String)StringUtil.concat((String[])new String[]{parentFile, "/", folderFile}), (JSONArray)array, (boolean)isPerm, (String[])roles)) {
                        return true;
                    }
                } else {
                    String path = FileUtil.getModulePath((File)file);
                    if (path.endsWith(".xwl")) {
                        JSONObject moduleData = XwlBuffer.get((String)path, (boolean)false);
                        if (!isPerm || !Boolean.FALSE.equals(moduleData.opt("loginRequired"))) {
                            String title = moduleData.optString("title");
                            if (title.isEmpty()) {
                                title = path.substring(path.lastIndexOf(47) + 1);
                            }
                            if (title.startsWith("Str.")) {
                                title = Str.format((HttpServletRequest)request, (String)title.substring(4), (Object[])new Object[0]);
                            }
                            if (title.toLowerCase().indexOf(searchName) != -1) {
                                JSONObject jo = new JSONObject();
                                jo.put("path", (Object)parentText);
                                jo.put("title", (Object)title);
                                jo.put("file", (Object)file.getName());
                                jo.put("parentFile", (Object)parentFile);
                                array.put((Object)jo);
                                if (array.length() > 99) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static void getMobileAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList appList = new ArrayList();
        JSONArray outputList = new JSONArray();
        String[] roles = Session.getRoles((HttpServletRequest)request);
        Portal.scanMobileApp((HttpServletRequest)request, appList, (File)new File(Base.modulePath, "apps"), (String[])roles);
        for (JSONObject jo : appList) {
            outputList.put((Object)jo);
        }
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("rows", (Object)outputList));
    }

    private static void scanMobileApp(HttpServletRequest request, ArrayList<JSONObject> appList, File path, String[] roles) throws Exception {
        ArrayList fileNames = IDE.getSortedFile((File)path);
        for (Map.Entry entry : fileNames) {
            JSONObject viewport;
            String fileName = (String)entry.getKey();
            File file = new File(path, fileName);
            if (!XwlBuffer.canDisplay((File)file, (String[])roles, (int)2)) continue;
            if (file.isDirectory()) {
                Portal.scanMobileApp((HttpServletRequest)request, appList, (File)file, (String[])roles);
                continue;
            }
            String url = FileUtil.getModulePath((File)file);
            JSONObject content = XwlBuffer.get((String)url, (boolean)true);
            if (content == null || (viewport = Portal.getViewport((JSONObject)content)) == null) continue;
            viewport = viewport.getJSONObject("configs");
            JSONObject item = new JSONObject();
            String title = content.optString("title");
            if (title.startsWith("Str.")) {
                title = Str.format((HttpServletRequest)request, (String)title.substring(4), (Object[])new Object[0]);
            }
            item.put("title", (Object)StringUtil.select((String[])new String[]{title, file.getName()}));
            String image = viewport.optString("appImage");
            if (image.isEmpty()) {
                String glyph = viewport.optString("appGlyph");
                if (glyph.isEmpty()) {
                    item.put("glyph", (Object)"&#xf10a;");
                } else {
                    item.put("glyph", (Object)StringUtil.concat((String[])new String[]{"&#x", glyph, ";"}));
                }
            } else {
                item.put("image", (Object)image);
            }
            item.put("url", (Object)url);
            appList.add(item);
        }
    }

    private static JSONObject getViewport(JSONObject rootNode) throws Exception {
        JSONObject module = (JSONObject)((JSONArray)rootNode.opt("children")).opt(0);
        JSONArray items = (JSONArray)module.opt("children");
        if (items == null) {
            return null;
        }
        int j = items.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = (JSONObject)items.opt(i);
            if ("tviewport".equals(jo.opt("type"))) {
                return jo;
            }
            ++i;
        }
        return null;
    }
}

