/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.UrlBuffer;
import com.wb.common.Value;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.interact.Controls;
import com.wb.tool.Console;
import com.wb.tool.QueueWriter;
import com.wb.tool.ScriptCompressor;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.LogUtil;
import com.wb.util.SortUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class IDE {
    private static final String[] imageTypes = new String[]{"gif", "jpg", "png", "bmp"};

    public static void getList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("root".equals(request.getParameter("node"))) {
            IDE.getBaseList((HttpServletRequest)request, (HttpServletResponse)response);
        } else if ("module".equals(request.getParameter("type"))) {
            IDE.getModuleList((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            IDE.getFileList((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public static void getFileList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File[] files;
        File base;
        String path = request.getParameter("path");
        String type = request.getParameter("type");
        JSONArray fileArray = new JSONArray();
        String mode = request.getParameter("mode");
        boolean isIde = StringUtil.isEmpty((String)mode);
        boolean isTouch = "1".equals(mode);
        boolean isTree = "2".equals(mode);
        boolean isGrid = "3".equals(mode);
        boolean isAdmin = WebUtil.hasRole((HttpServletRequest)request, (String)"admin");
        if (StringUtil.isEmpty((String)path)) {
            if (!isAdmin) {
                IDE.checkFilePerm(null);
            }
            base = null;
            files = File.listRoots();
        } else {
            base = new File(path);
            if (!isAdmin) {
                IDE.checkFilePerm((File)base);
            }
            files = FileUtil.listFiles((File)base);
        }
        if (isGrid) {
            String[] sortInfo = WebUtil.getSortInfo((HttpServletRequest)request);
            String[] fields = new String[]{"text", "size", "type", "date"};
            SortUtil.sort((File[])files, (int)StringUtil.indexOf((String[])fields, (String)sortInfo[0]), (boolean)sortInfo[1].equalsIgnoreCase("desc"));
        } else {
            SortUtil.sort((File[])files);
        }
        File[] fileArray2 = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            boolean isDir = file.isDirectory();
            if (!isTree || isDir) {
                String fileDir = FileUtil.getPath((File)file);
                if (!(isIde && "app".equals(type) && file.equals(Base.modulePath) || "file".equals(type) && file.equals(Base.path))) {
                    JSONObject fileObject = new JSONObject();
                    fileObject.put("text", (Object)StringUtil.select((String[])new String[]{file.getName(), fileDir}));
                    if (isDir) {
                        if (isTouch || isGrid) {
                            fileObject.put("icon", (Object)"wb/images/folder.gif");
                        }
                        if (isIde && FileUtil.isEmpty((File)file) || isTree && !FileUtil.hasFolder((File)file)) {
                            fileObject.put("children", (Object)new JSONArray());
                        }
                    } else {
                        fileObject.put("size", file.length());
                        fileObject.put("leaf", true);
                        if (isGrid) {
                            fileObject.put("icon", (Object)WebUtil.encode((String)fileDir));
                        } else if (!isTree) {
                            fileObject.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode((String)fileDir)));
                        }
                    }
                    if (isGrid || isTouch) {
                        fileObject.put("date", (Object)new Date(file.lastModified()));
                        fileObject.put("type", (Object)(isDir ? "\u6587\u4ef6\u5939" : FileUtil.getFileType((File)file)));
                    }
                    fileArray.put((Object)fileObject);
                }
            }
            ++n2;
        }
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put(isGrid ? "rows" : "children", (Object)fileArray));
    }

    private static void getModuleList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = request.getParameter("path");
        File base = new File(path);
        if (!FileUtil.isAncestor((File)Base.path, (File)base)) {
            SysUtil.accessDenied();
        }
        ArrayList fileNames = IDE.getSortedFile((File)base);
        JSONArray fileArray = new JSONArray();
        for (Map.Entry entry : fileNames) {
            String icon;
            File file;
            String fileName = (String)entry.getKey();
            if ("folder.json".equalsIgnoreCase(fileName) || !(file = new File(base, fileName)).exists()) continue;
            boolean isFolder = file.isDirectory();
            JSONObject content = null;
            if (isFolder) {
                File configFile = new File(file, "folder.json");
                if (configFile.exists()) {
                    content = JsonUtil.readObject((File)configFile);
                }
            } else if (fileName.endsWith(".xwl")) {
                content = XwlBuffer.get((String)FileUtil.getModulePath((File)file), (boolean)false);
            }
            if (content == null) {
                content = new JSONObject();
                if (!isFolder) {
                    content.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode((String)FileUtil.getPath((File)file))));
                }
            }
            JSONObject fileObject = new JSONObject();
            fileObject.put("text", (Object)fileName);
            fileObject.put("title", (Object)content.optString("title"));
            fileObject.put("isFunction", Boolean.TRUE.equals(content.opt("isFunction")));
            boolean hidden = Boolean.TRUE.equals(content.opt("hidden"));
            fileObject.put("hidden", hidden);
            if (hidden) {
                fileObject.put("cls", (Object)"x-highlight");
            }
            fileObject.put("inframe", Boolean.TRUE.equals(content.opt("inframe")));
            fileObject.put("pageLink", (Object)content.optString("pageLink"));
            fileObject.put("qtip", (Object)content.optString("qtip"));
            String iconCls = content.optString("iconCls");
            if (!StringUtil.isEmpty((String)iconCls)) {
                fileObject.put("iconCls", (Object)iconCls);
            }
            if (!StringUtil.isEmpty((String)(icon = content.optString("icon")))) {
                fileObject.put("icon", (Object)icon);
            }
            if (isFolder) {
                if (!IDE.hasChildren((File)file)) {
                    fileObject.put("children", (Object)new JSONArray());
                }
            } else {
                fileObject.put("leaf", true);
            }
            fileArray.put((Object)fileObject);
        }
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("children", (Object)fileArray));
    }

    private static void getBaseList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray list = new JSONArray();
        JSONObject node = new JSONObject();
        String sysFolderBase = Var.getString((String)"sys.ide.sysFolderBase");
        node.put("text", (Object)"\u6a21\u5757");
        node.put("iconCls", (Object)"module_icon");
        node.put("expanded", true);
        node.put("base", (Object)(String.valueOf(FileUtil.getPath((File)Base.modulePath)) + '/'));
        node.put("type", (Object)"module");
        list.put((Object)node);
        node = new JSONObject();
        node.put("text", (Object)"\u5e94\u7528");
        node.put("iconCls", (Object)"application_icon");
        node.put("base", (Object)(String.valueOf(FileUtil.getPath((File)Base.path)) + '/'));
        node.put("type", (Object)"app");
        list.put((Object)node);
        if (!sysFolderBase.equals("app")) {
            node = new JSONObject();
            node.put("text", (Object)"\u7cfb\u7edf");
            node.put("iconCls", (Object)"system_icon");
            sysFolderBase = sysFolderBase.equals("server") ? String.valueOf(FileUtil.getPath((String)Base.path.getParentFile().getParent())) + '/' : "";
            node.put("base", (Object)sysFolderBase);
            node.put("type", (Object)"file");
            list.put((Object)node);
        }
        WebUtil.send((HttpServletResponse)response, (Object)list);
    }

    public static void setProperty(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean needConfig;
        JSONObject map = WebUtil.fetch((HttpServletRequest)request);
        File configFile = null;
        File oldFile = new File(map.getString("path"));
        String url = map.optString("url");
        String oldName = oldFile.getName();
        String newName = map.getString("text");
        String qtip = map.getString("qtip");
        boolean nameModified = !oldName.equals(newName);
        boolean urlValid = map.optBoolean("urlValid");
        JSONObject indexContent = null;
        boolean isDir = oldFile.isDirectory();
        if (urlValid && !UrlBuffer.exists((String)url, (File)oldFile)) {
            throw new IllegalArgumentException("URL\u6377\u5f84 \"" + url + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        File newFile = nameModified ? new File(oldFile.getParent(), newName) : oldFile;
        if (nameModified) {
            FileUtil.syncRename((File)oldFile, (File)newFile);
        }
        File indexFile = new File(newFile.getParentFile(), "folder.json");
        boolean indexFileExists = indexFile.exists();
        boolean isModule = map.getBoolean("isModule");
        boolean bl = needConfig = isModule || indexFileExists;
        if (needConfig) {
            JSONArray idxArray;
            int index;
            if (indexFileExists) {
                indexContent = JsonUtil.readObject((File)indexFile);
            } else if (isModule) {
                indexContent = new JSONObject();
                indexContent.put("index", (Object)new JSONArray());
            }
            if (isModule) {
                JSONObject content;
                if (isDir) {
                    configFile = new File(newFile, "folder.json");
                    if (configFile.exists()) {
                        content = JsonUtil.readObject((File)configFile);
                    } else {
                        content = new JSONObject();
                        content.put("index", (Object)new JSONArray());
                    }
                } else {
                    content = JsonUtil.readObject((File)newFile);
                }
                content.put("title", (Object)map.getString("title"));
                content.put("iconCls", (Object)map.getString("iconCls"));
                content.put("hidden", map.getBoolean("hidden"));
                if (isDir) {
                    FileUtil.syncSave((File)configFile, (String)content.toString());
                } else {
                    boolean isFunction = map.getBoolean("isFunction");
                    content.put("inframe", map.getBoolean("inframe"));
                    content.put("pageLink", (Object)map.getString("pageLink"));
                    content.put("isFunction", isFunction);
                    content.put("qtip", (Object)qtip);
                    IDE.updateModule((File)newFile, (JSONObject)content, null, (boolean)false);
                    if (isFunction) {
                        IDE.createFunction((HttpServletRequest)request);
                    }
                }
            }
            if (nameModified && indexFileExists && (index = (idxArray = indexContent.getJSONArray("index")).indexOf((Object)oldName)) != -1) {
                idxArray.put(index, (Object)newName);
                FileUtil.syncSave((File)indexFile, (String)indexContent.toString());
            }
        }
        if (isModule) {
            String newRelPath = FileUtil.getModulePath((File)newFile);
            String oldRelPath = nameModified ? FileUtil.getModulePath((File)oldFile) : newRelPath;
            boolean changed = false;
            if (isDir) {
                if (nameModified && UrlBuffer.change((String)oldRelPath, (String)newRelPath, (boolean)isDir)) {
                    changed = true;
                }
            } else {
                if (UrlBuffer.remove((String)oldRelPath)) {
                    changed = true;
                }
                if (urlValid && !url.isEmpty()) {
                    UrlBuffer.put((String)(String.valueOf('/') + url), (String)newRelPath);
                    changed = true;
                }
            }
            if (changed) {
                UrlBuffer.save();
            }
        }
        JSONObject result = new JSONObject();
        result.put("lastModified", (Object)DateUtil.getTimestamp((long)newFile.lastModified()));
        result.put("path", (Object)FileUtil.getPath((File)newFile));
        result.put("qtip", (Object)qtip);
        if (nameModified) {
            JSONObject resp = new JSONObject();
            JSONArray src = new JSONArray();
            JSONArray moveTo = new JSONArray();
            src.put((Object)FileUtil.getPath((File)oldFile));
            moveTo.put((Object)FileUtil.getPath((File)newFile));
            Object[] changeInfo = IDE.changePath((JSONArray)src, (JSONArray)moveTo);
            resp.put("files", changeInfo[0]);
            resp.put("change", changeInfo[1]);
            resp.put("moveTo", (Object)moveTo);
            result.put("refactorInfo", (Object)resp);
        }
        WebUtil.send((HttpServletResponse)response, (Object)result);
    }

    public static void searchFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray array = new JSONArray();
        String query = request.getParameter("query").toLowerCase();
        if (query.isEmpty()) {
            query = ".xwl";
        }
        IDE.doSearchFile((File)Base.path, (String)query, (JSONArray)array);
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("rows", (Object)array));
    }

    private static boolean doSearchFile(File folder, String searchName, JSONArray array) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles((File)folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (IDE.doSearchFile((File)file, (String)searchName, (JSONArray)array)) {
                    return true;
                }
            } else {
                String path = FileUtil.getPath((File)file);
                String name = path.substring(path.lastIndexOf(47) + 1).toLowerCase();
                if (!name.equals("folder.json") && name.indexOf(searchName) != -1) {
                    JSONObject jo = new JSONObject();
                    jo.put("path", (Object)path);
                    array.put((Object)jo);
                    if (array.length() > 99) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static void total(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File file = new File(request.getParameter("path"));
        JSONObject result = new JSONObject();
        boolean isDir = file.isDirectory();
        result.put("lastModified", (Object)DateUtil.getTimestamp((long)file.lastModified()));
        result.put("fileSize", file.length());
        if (isDir && FileUtil.isAncestor((File)Base.path, (File)file)) {
            int[] info = new int[4];
            IDE.total((File)file, (int[])info);
            result.put("total", (Object)info);
        }
        if (!isDir && FileUtil.isAncestor((File)Base.modulePath, (File)file) && file.getName().endsWith(".xwl")) {
            result.put("url", (Object)UrlBuffer.find((File)file));
        }
        WebUtil.send((HttpServletResponse)response, (Object)result);
    }

    private static void total(File folder, int[] info) {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles((File)folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                info[2] = info[2] + 1;
                IDE.total((File)file, (int[])info);
            } else {
                if (file.getName().endsWith(".xwl")) {
                    info[0] = info[0] + 1;
                }
                info[1] = info[1] + 1;
                info[3] = (int)((long)info[3] + file.length());
            }
            ++n2;
        }
    }

    public static void search(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String searchType = request.getParameter("searchType");
        if ("shortcut".equals(searchType)) {
            IDE.searchShortcut((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        JSONArray pathList = new JSONArray(request.getParameter("pathList"));
        String searchText = request.getParameter("search");
        String[] filePatterns = StringUtil.split((String)request.getParameter("filePatterns"), (char)',', (boolean)true);
        boolean whole = Boolean.parseBoolean(request.getParameter("whole"));
        boolean isReplace = Boolean.parseBoolean(request.getParameter("isReplace"));
        Pattern searchPattern = null;
        int pathListLen = pathList.length();
        ArrayList<File> searchedFiles = new ArrayList<File>(pathListLen);
        JSONArray rows = new JSONArray();
        searchPattern = Boolean.parseBoolean(request.getParameter("regularExp")) ? Pattern.compile(searchText) : Pattern.compile(StringUtil.concat((String[])new String[]{Boolean.parseBoolean(request.getParameter("caseSensitive")) ? "" : "(?i)", whole ? "\\b" : "", "\\Q", searchText, "\\E", whole ? "\\b" : ""}));
        int i = 0;
        while (i < pathListLen) {
            File file = new File(pathList.getString(i));
            if (!FileUtil.isAncestor((File)Base.path, (File)file)) {
                throw new IllegalArgumentException("\u7981\u6b62\u68c0\u7d22\u5e94\u7528\u76ee\u5f55\u4e4b\u5916\u7684\u6587\u4ef6\u3002");
            }
            boolean searched = false;
            for (File f : searchedFiles) {
                if (!FileUtil.isAncestor((File)f, (File)file)) continue;
                searched = true;
                break;
            }
            if (!searched) {
                IDE.doSearch((File)file, (JSONArray)rows, (Pattern)searchPattern, (String[])filePatterns, isReplace ? request.getParameter("replace") : null);
                searchedFiles.add(file);
            }
            ++i;
        }
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("rows", (Object)rows));
    }

    private static boolean doSearch(File file, JSONArray rows, Pattern pattern, String[] filePatterns, String replaceText) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = FileUtil.listFiles((File)file);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                boolean match;
                File f = fileArray[n2];
                if (filePatterns.length == 0 || f.isDirectory()) {
                    match = true;
                } else {
                    match = false;
                    String[] stringArray = filePatterns;
                    int n3 = filePatterns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filePattern = stringArray[n4];
                        if (FilenameUtils.wildcardMatch((String)f.getName(), (String)filePattern, (IOCase)IOCase.SYSTEM)) {
                            match = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (match && !IDE.doSearch((File)f, (JSONArray)rows, (Pattern)pattern, (String[])filePatterns, (String)replaceText)) {
                    return false;
                }
                ++n2;
            }
        } else {
            if (IDE.debugVersionExists((File)file)) {
                return true;
            }
            String text = FileUtil.readString((File)file);
            String path = FileUtil.getPath((File)file);
            if (replaceText == null) {
                if (path.endsWith(".xwl") ? !IDE.searchXwl((String)text, (String)path, (Pattern)pattern, (JSONArray)rows) : !IDE.searchText((String)text, (String)path, (Pattern)pattern, (JSONArray)rows, null, null)) {
                    return false;
                }
            } else {
                String replacedText;
                if (path.endsWith(".xwl")) {
                    replaceText = StringUtil.text((String)replaceText);
                }
                if (!(replacedText = pattern.matcher(text).replaceAll(Matcher.quoteReplacement(replaceText))).equals(text)) {
                    FileUtil.syncSave((File)file, (String)replacedText);
                    JSONObject row = new JSONObject();
                    row.put("content", (Object)("\u66ff\u6362\uff1a" + replaceText));
                    row.put("path", (Object)path);
                    row.put("lastModified", (Object)DateUtil.getTimestamp((long)file.lastModified()));
                    rows.put((Object)row);
                }
            }
        }
        return true;
    }

    private static boolean searchText(String text, String path, Pattern pattern, JSONArray rows, String nodePath, String itemName) {
        int lastPos = 0;
        int line = 1;
        int textLength = text.length();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int minPos;
            int matchTextLength;
            JSONObject row = new JSONObject();
            if (rows.length() == 999) {
                row.put("content", (Object)"\u8d85\u8fc71000\u9879\u88ab\u641c\u7d22\u5230\uff0c\u505c\u6b62\u641c\u7d22\u3002");
                rows.put((Object)row);
                return false;
            }
            int pos = matcher.start();
            int afterTextPos = pos + (matchTextLength = matcher.end() - pos);
            if (afterTextPos > (minPos = Math.min(textLength, pos + 70))) {
                return true;
            }
            row.put("content", (Object)StringUtil.concat((String[])new String[]{StringUtil.toHTML((String)text.substring(Math.max(0, pos - 30), pos), (boolean)false, (boolean)false), "<strong>", StringUtil.toHTML((String)text.substring(pos, afterTextPos), (boolean)false, (boolean)false), "</strong>", afterTextPos >= textLength ? "" : StringUtil.toHTML((String)text.substring(afterTextPos, minPos), (boolean)false, (boolean)false)}));
            int[] lineInfo = StringUtil.stringOccur((String)text, (char)'\n', (int)lastPos, (int)pos);
            lastPos = pos;
            row.put("path", (Object)path);
            row.put("line", line += lineInfo[0]);
            row.put("ch", pos - lineInfo[1]);
            row.put("nodePath", (Object)nodePath);
            row.put("itemName", (Object)itemName);
            rows.put((Object)row);
            pos += matchTextLength;
        }
        return true;
    }

    public static void searchShortcut(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String shortcut = request.getParameter("shortcut");
        Set es = UrlBuffer.buffer.entrySet();
        JSONArray ja = new JSONArray();
        for (Map.Entry e : es) {
            String key = ((String)e.getKey()).substring(1);
            if (!FilenameUtils.wildcardMatch((String)key, (String)shortcut, (IOCase)IOCase.INSENSITIVE)) continue;
            JSONObject jo = new JSONObject();
            if (ja.length() == 999) {
                jo.put("content", (Object)"\u8d85\u8fc71000\u9879\u88ab\u641c\u7d22\u5230\uff0c\u505c\u6b62\u641c\u7d22\u3002");
                ja.put((Object)jo);
                break;
            }
            jo.put("content", (Object)key);
            jo.put("path", (Object)FileUtil.getPath((File)new File(Base.modulePath, (String)e.getValue())));
            jo.put("line", 1);
            jo.put("ch", 1);
            ja.put((Object)jo);
        }
        WebUtil.send((HttpServletResponse)response, (Object)new JSONObject().put("rows", (Object)ja));
    }

    private static boolean debugVersionExists(File file) {
        if (Var.getBool((String)"sys.ide.searchIgnoreRelease")) {
            String filename = file.getName();
            File debugFile = new File(file.getParentFile(), String.valueOf(FileUtil.removeExtension((String)filename)) + "-debug." + FileUtil.getFileExt((String)filename));
            return debugFile.exists();
        }
        return false;
    }

    private static boolean searchXwl(String text, String path, Pattern pattern, JSONArray rows) {
        JSONObject xwl = new JSONObject(text);
        return IDE.scanXwl((JSONObject)xwl, (String)path, (Pattern)pattern, (JSONArray)rows, (String)"");
    }

    private static boolean scanXwl(JSONObject xwl, String path, Pattern pattern, JSONArray rows, String nodePath) {
        JSONArray children = xwl.optJSONArray("children");
        if (children != null) {
            int j = children.length();
            int i = 0;
            while (i < j) {
                String currentPath;
                JSONObject jo = children.getJSONObject(i);
                JSONObject configs = jo.getJSONObject("configs");
                if (!IDE.scanItems((JSONObject)configs, (String)path, (Pattern)pattern, (JSONArray)rows, (String)(currentPath = String.valueOf(nodePath) + "/" + configs.getString("itemId")), (String)"Configs")) {
                    return false;
                }
                if (jo.has("events") && !IDE.scanItems((JSONObject)jo.getJSONObject("events"), (String)path, (Pattern)pattern, (JSONArray)rows, (String)currentPath, (String)"Events")) {
                    return false;
                }
                if (!IDE.scanXwl((JSONObject)jo, (String)path, (Pattern)pattern, (JSONArray)rows, (String)currentPath)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean scanItems(JSONObject jo, String path, Pattern pattern, JSONArray rows, String nodePath, String type) {
        Set items = jo.entrySet();
        for (Map.Entry item : items) {
            String key = (String)item.getKey();
            if (!IDE.searchText((String)key, (String)path, (Pattern)pattern, (JSONArray)rows, (String)nodePath, (String)(String.valueOf(type) + "=" + key))) {
                return false;
            }
            if (IDE.searchText((String)item.getValue().toString(), (String)path, (Pattern)pattern, (JSONArray)rows, (String)nodePath, (String)(String.valueOf(type) + "=" + key))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasChildren(File dir) {
        File[] files = FileUtil.listFiles((File)dir);
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                return true;
            }
            if (!file.getName().equals("folder.json")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject moduleConfigs;
        String name = request.getParameter("name");
        String title = request.getParameter("title");
        String iconCls = request.getParameter("iconCls");
        String qtip = request.getParameter("qtip");
        String url = null;
        boolean hidden = Boolean.parseBoolean(request.getParameter("hidden"));
        boolean isDir = Boolean.parseBoolean(request.getParameter("isDir"));
        JSONObject content = new JSONObject();
        JSONObject moduleMeta = moduleConfigs = Controls.get((String)"module").optJSONObject("configs");
        content.put("title", (Object)title);
        content.put("iconCls", (Object)iconCls);
        content.put("hidden", hidden);
        content.put("qtip", (Object)qtip);
        if (!isDir) {
            boolean isFunction = Boolean.parseBoolean(request.getParameter("isFunction"));
            content.put("isFunction", isFunction);
            if (isFunction) {
                IDE.createFunction((HttpServletRequest)request);
            }
            content.put("roles", (Object)new JSONObject());
            content.put("inframe", Boolean.parseBoolean(request.getParameter("inframe")));
            content.put("pageLink", (Object)request.getParameter("pageLink"));
            url = request.getParameter("url");
            if (!UrlBuffer.exists((String)url, null)) {
                throw new IllegalArgumentException("URL\u6377\u5f84 \"" + url + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
            }
            if (!name.endsWith(".xwl")) {
                name = name.toLowerCase().endsWith(".xwl") ? String.valueOf(name.substring(0, name.length() - 3)) + "xwl" : String.valueOf(name) + ".xwl";
            }
            JSONObject module = new JSONObject();
            moduleConfigs = new JSONObject();
            moduleConfigs.put("itemId", (Object)"module");
            Set moduleConfigEntries = moduleMeta.entrySet();
            for (Map.Entry entry : moduleConfigEntries) {
                Object value = ((JSONObject)entry.getValue()).opt("value");
                if (value == null) continue;
                moduleConfigs.put((String)entry.getKey(), (Object)value.toString());
            }
            module.put("children", (Object)new JSONArray());
            module.put("configs", (Object)moduleConfigs);
            module.put("type", (Object)"module");
            content.put("children", (Object)new JSONArray().put((Object)module));
        }
        File base = new File(request.getParameter("path"));
        File file = IDE.addModule((File)base, (String)name, (boolean)isDir, (JSONObject)content);
        IDE.setFileIndex((File)base, (String)request.getParameter("indexName"), (JSONArray)new JSONArray().put((Object)name), (String)request.getParameter("type"));
        if (isDir) {
            JSONObject fileInfo = new JSONObject();
            fileInfo.put("file", (Object)name);
            fileInfo.put("title", (Object)title);
            fileInfo.put("iconCls", (Object)iconCls);
            fileInfo.put("hidden", hidden);
            fileInfo.put("qtip", (Object)qtip);
            WebUtil.send((HttpServletResponse)response, (Object)fileInfo);
        } else {
            if (!url.isEmpty()) {
                UrlBuffer.put((String)(String.valueOf('/') + url), (String)FileUtil.getModulePath((File)file));
                UrlBuffer.save();
            }
            IDE.doOpen((JSONArray)new JSONArray().put((Object)FileUtil.getPath((File)file)), null, null, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private static void createFunction(HttpServletRequest request) throws Exception {
        String text = request.getParameter("text");
        if (StringUtils.isNotBlank((String)text)) {
            text = StringUtils.substringBefore((String)text, (String)".");
        }
        Connection conn = null;
        CallableStatement cst = null;
        try {
            try {
                conn = DbUtil.getConnection();
                cst = conn.prepareCall("{call P_FUNCTION_DESC(?,?,?,?,?,?,?)}");
                cst.setString(1, text);
                cst.setString(2, "");
                cst.setString(3, "");
                cst.setString(4, WebUtil.fetch((HttpServletRequest)request, (String)"title"));
                cst.setString(5, WebUtil.fetch((HttpServletRequest)request, (String)"sys.username"));
                cst.registerOutParameter(6, 12);
                cst.registerOutParameter(7, 4);
                cst.execute();
            }
            catch (Throwable e) {
                LogUtil.error((Object)e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(cst);
            DbUtil.close((Object)conn);
            throw throwable;
        }
        DbUtil.close((Object)cst);
        DbUtil.close((Object)conn);
    }

    private static void setFileIndex(File folder, String indexFileName, JSONArray insertFileNames, String type) throws Exception {
        int index;
        int i;
        JSONArray indexArray;
        JSONObject content;
        File file = new File(folder, "folder.json");
        int j = insertFileNames.length();
        if (file.exists()) {
            content = JsonUtil.readObject((File)file);
            indexArray = content.getJSONArray("index");
            i = 0;
            while (i < j) {
                index = indexArray.indexOf((Object)insertFileNames.getString(i));
                if (index != -1) {
                    indexArray.remove(index);
                }
                ++i;
            }
            int k = indexArray.length();
            i = k - 1;
            while (i >= 0) {
                File checkFile = new File(folder, indexArray.getString(i));
                if (!checkFile.exists()) {
                    indexArray.remove(i);
                }
                --i;
            }
            if (StringUtil.isEmpty((String)indexFileName) || "append".equals(type)) {
                index = -1;
            } else {
                index = indexArray.indexOf((Object)indexFileName);
                if (index != -1 && "after".equals(type)) {
                    ++index;
                }
            }
        } else {
            content = new JSONObject();
            indexArray = new JSONArray();
            content.put("index", (Object)indexArray);
            index = -1;
        }
        if (index == -1) {
            i = j - 1;
            while (i >= 0) {
                indexArray.put((Object)insertFileNames.getString(i));
                --i;
            }
        } else {
            i = 0;
            while (i < j) {
                indexArray.add(index, (Object)insertFileNames.getString(i));
                ++i;
            }
        }
        FileUtil.syncSave((File)file, (String)content.toString());
    }

    private static File addModule(File base, String name, boolean isDir, JSONObject content) throws Exception {
        File file = new File(base, name);
        if (isDir) {
            FileUtil.syncCreate((File)file, (boolean)true);
            File configFile = new File(file, "folder.json");
            content.put("index", (Object)new JSONArray());
            FileUtil.syncSave((File)configFile, (String)content.toString());
        } else {
            FileUtil.syncCreate((File)file, (boolean)false);
            FileUtil.syncSave((File)file, (String)content.toString());
        }
        return file;
    }

    public static void getThreadList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        StringBuilder buf = new StringBuilder();
        Collator collator = Collator.getInstance();
        int daemonThreads = 0;
        Arrays.sort(threadArray, new /* Unavailable Anonymous Inner Class!! */);
        Thread[] threadArray2 = threadArray;
        int n = threadArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray2[n2];
            buf.append("<p");
            if (thread.isDaemon()) {
                ++daemonThreads;
                buf.append(" style=\"color:blue\">");
            } else {
                buf.append(">");
            }
            buf.append(thread.getName());
            buf.append(" (");
            buf.append(thread.getPriority());
            buf.append(")</p>");
            ++n2;
        }
        buf.append("<p>\u5408\u8ba1\u7ebf\u7a0b\uff1a");
        buf.append(threadArray.length);
        buf.append("\uff0c\u5b88\u62a4\u7ebf\u7a0b\uff1a");
        buf.append(daemonThreads);
        buf.append("\uff0c\u666e\u901a\u7ebf\u7a0b\uff1a");
        buf.append(threadArray.length - daemonThreads);
        buf.append("</p>");
        WebUtil.send((HttpServletResponse)response, (Object)buf);
    }

    public static void addFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("name");
        String path = request.getParameter("path");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("\u7236\u76ee\u5f55\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u3002");
        }
        boolean isDir = Boolean.parseBoolean(request.getParameter("isDir"));
        JSONObject fileInfo = new JSONObject();
        File file = IDE.addFile((File)new File(path), (String)name, (boolean)isDir);
        if (isDir) {
            fileInfo.put("children", (Object)new JSONArray());
        } else {
            fileInfo.put("leaf", true);
            fileInfo.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode((String)FileUtil.getPath((File)file))));
        }
        fileInfo.put("text", (Object)name);
        WebUtil.send((HttpServletResponse)response, (Object)fileInfo);
    }

    public static void reload(HttpServletRequest request, HttpServletResponse response) {
        SysUtil.reload((int)1);
    }

    private static File addFile(File base, String name, boolean isDir) throws Exception {
        File file = new File(base, name);
        if (isDir) {
            FileUtil.syncCreate((File)file, (boolean)true);
        } else {
            FileUtil.syncCreate((File)file, (boolean)false);
        }
        return file;
    }

    public static ArrayList<Map.Entry<String, Integer>> getSortedFile(File dir) throws Exception {
        HashMap<String, Integer> jsonMap = new HashMap<String, Integer>();
        String[] fileNames = dir.list();
        SortUtil.sort((String[])fileNames);
        int j = fileNames.length;
        int i = 0;
        while (i < j) {
            jsonMap.put(fileNames[j - i - 1], Integer.MAX_VALUE - i);
            ++i;
        }
        File configFile = new File(dir, "folder.json");
        if (configFile.exists()) {
            JSONArray indexArray = JsonUtil.readObject((File)configFile).getJSONArray("index");
            j = indexArray.length();
            i = 0;
            while (i < j) {
                jsonMap.put(indexArray.getString(i), i);
                ++i;
            }
        }
        return SortUtil.sortValue(jsonMap, (boolean)true);
    }

    public static void saveFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File file;
        JSONObject content;
        boolean confirm = !Boolean.parseBoolean(request.getParameter("noConfirm"));
        JSONArray files = new JSONArray(StringUtil.getString((InputStream)request.getInputStream()));
        JSONArray lastModifiedData = new JSONArray();
        String filename = null;
        int j = files.length();
        int modifiedCount = 0;
        int i = 0;
        while (i < j) {
            content = files.getJSONObject(i);
            file = new File(content.getString("file"));
            if (confirm && file.lastModified() != content.getTimestamp("lastModified").getTime()) {
                if (filename == null) {
                    filename = content.getString("file");
                }
                ++modifiedCount;
            }
            ++i;
        }
        if (modifiedCount > 0) {
            SysUtil.error((String)("\u6587\u4ef6 \"" + FileUtil.getFilename(filename) + "\"" + (modifiedCount > 1 ? " \u7b49 " + modifiedCount + " \u9879" : " ") + "\u5df2\u7ecf\u88ab\u4fee\u6539\uff0c\u786e\u5b9a\u8981\u4fdd\u5b58\u5417\uff1f"), (String)"101");
        }
        i = 0;
        while (i < j) {
            content = files.getJSONObject(i);
            filename = content.getString("file");
            String saveContent = content.getString("content");
            file = new File(filename);
            String fileExt = FileUtil.getFileExt((String)filename).toLowerCase();
            if (StringUtil.indexOf((String[])imageTypes, (String)fileExt) == -1) {
                if ("xwl".equals(fileExt)) {
                    IDE.updateModule((File)file, (JSONObject)new JSONObject(saveContent), null, (boolean)false);
                } else {
                    FileUtil.syncSave((File)file, (String)saveContent, (String)content.optString("charset"));
                }
            } else {
                FileUtil.syncSave((File)file, (byte[])StringUtil.decodeBase64((String)saveContent));
            }
            lastModifiedData.put((Object)DateUtil.getTimestamp((long)file.lastModified()));
            ++i;
        }
        WebUtil.send((HttpServletResponse)response, (Object)lastModifiedData);
    }

    public static synchronized void updateModule(File file, JSONObject moduleData, String[] roles, boolean addRoles) throws Exception {
        boolean keepLastModified = false;
        if (moduleData == null) {
            if (roles == null) {
                return;
            }
            keepLastModified = true;
        }
        JSONObject data = JsonUtil.readObject((File)file);
        JSONObject oldRoles = (JSONObject)data.opt("roles");
        if (moduleData != null) {
            data = moduleData;
            data.put("roles", (Object)oldRoles);
        }
        if (roles != null) {
            String[] stringArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (addRoles) {
                    oldRoles.put(role, 1);
                } else {
                    oldRoles.remove(role);
                }
                ++n2;
            }
        }
        FileUtil.syncSave((File)file, (String)data.toString(), (String)"utf-8", (boolean)keepLastModified);
    }

    public static void openFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        IDE.doOpen((JSONArray)new JSONArray(request.getParameter("fileNames")), (String)request.getParameter("charset"), (String)request.getParameter("type"), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    private static void doOpen(JSONArray fileNames, String charset, String type, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray result = new JSONArray();
        boolean isAdmin = WebUtil.hasRole((HttpServletRequest)request, (String)"admin");
        boolean fromEditor = "1".equals(type);
        int j = fileNames.length();
        int i = 0;
        while (i < j) {
            JSONObject content;
            String filename = fileNames.getString(i);
            String shortFilename = FileUtil.getFilename((String)filename);
            String fileExt = FileUtil.getFileExt((String)filename).toLowerCase();
            File file = new File(filename);
            if (!isAdmin) {
                IDE.checkFilePerm((File)file);
            }
            if (!fromEditor && fileExt.equals("xwl")) {
                content = new JSONObject(FileUtil.readString((File)file));
                IDE.fillProperties((JSONObject)content);
                content.put("file", (Object)shortFilename);
            } else {
                String fileText;
                content = new JSONObject();
                content.put("file", (Object)shortFilename);
                content.put("icon", (Object)("m?xwl=dev/ide/get-file-icon&file=" + WebUtil.encode((String)filename)));
                if (StringUtil.indexOf((String[])imageTypes, (String)fileExt) == -1) {
                    if (StringUtil.isEmpty((String)charset)) {
                        charset = FileUtil.isAncestor((File)Base.path, (File)file) ? "utf-8" : Var.getString((String)"sys.locale.charset");
                    } else if ("[\u7cfb\u7edf\u9ed8\u8ba4]".equals(charset)) {
                        charset = null;
                    }
                    if (StringUtil.isEmpty((String)charset)) {
                        fileText = FileUtils.readFileToString((File)file);
                        content.put("charset", (Object)"[\u7cfb\u7edf\u9ed8\u8ba4]");
                    } else {
                        fileText = FileUtils.readFileToString((File)file, (String)charset);
                        content.put("charset", (Object)charset);
                    }
                } else {
                    fileText = StringUtil.encodeBase64((InputStream)new FileInputStream(file));
                }
                content.put("content", (Object)fileText);
            }
            content.put("lastModified", (Object)DateUtil.getTimestamp((long)file.lastModified()));
            content.put("path", (Object)filename);
            result.put((Object)content);
            ++i;
        }
        WebUtil.send((HttpServletResponse)response, (Object)result);
    }

    public static void getOutputs(HttpServletRequest request, HttpServletResponse response) throws Exception {
        QueueWriter out = IDE.getSysOut((HttpServletRequest)request);
        String string = out.toString();
        out.clear();
        WebUtil.send((HttpServletResponse)response, (Object)string);
    }

    private static void fillProperties(JSONObject json) throws IOException {
        JSONArray controls = json.getJSONArray("children");
        int j = controls.length();
        int i = 0;
        while (i < j) {
            JSONObject control = controls.getJSONObject(i);
            String type = control.getString("type");
            JSONObject fillControl = Controls.get((String)type);
            if (fillControl == null) {
                throw new NullPointerException("\u63a7\u4ef6 \"" + type + "\" \u6ca1\u6709\u627e\u5230\u3002");
            }
            JSONObject configs = control.optJSONObject("configs");
            if (configs != null) {
                control.put("text", (Object)configs.optString("itemId"));
            }
            JSONObject fillGeneral = fillControl.getJSONObject("general");
            control.put("iconCls", (Object)fillGeneral.getString("iconCls"));
            if (control.has("children") && control.length() > 0) {
                IDE.fillProperties((JSONObject)control);
            }
            ++i;
        }
    }

    public static void getFileIcon(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = WebUtil.decode((String)request.getParameter("file"));
        String fileExt = FileUtil.getFileExt((String)fileName).toLowerCase();
        String[] zipTypes = new String[]{"zip", "rar", "gzip", "gz", "tar", "cab"};
        File file = null;
        boolean isAdmin = WebUtil.hasRole((HttpServletRequest)request, (String)"admin");
        if (StringUtil.indexOf((String[])imageTypes, (String)fileExt) != -1) {
            long fileLen;
            file = new File(fileName);
            if (!isAdmin) {
                IDE.checkFilePerm((File)file);
            }
            if ((fileLen = file.length()) > 10240L || fileLen == 0L) {
                file = null;
            }
        }
        if (file == null) {
            fileName = fileExt.equals("doc") || fileExt.equals("docx") ? "file_doc" : (fileExt.equals("xls") || fileExt.equals("xlsx") ? "file_xls" : (fileExt.equals("ppt") || fileExt.equals("pptx") ? "file_ppt" : (fileExt.equals("htm") || fileExt.equals("html") ? "web" : (fileExt.equals("jar") || fileExt.equals("war") ? "file_jar" : (StringUtil.indexOf((String[])zipTypes, (String)fileExt) != -1 ? "file_zip" : (fileExt.equals("txt") ? "file_txt" : (fileExt.equals("js") ? "file_js" : (fileExt.equals("css") ? "file_css" : (fileExt.equals("java") ? "file_java" : (fileExt.equals("jsp") ? "file_jsp" : (fileExt.equals("xml") ? "file_xml" : (fileExt.equals("xwl") ? "file_xwl" : "file_default"))))))))))));
            file = new File(Base.path, StringUtil.concat((String[])new String[]{"wb/images/", String.valueOf(fileName) + ".gif"}));
            response.setContentType("image/gif");
        } else {
            response.setContentType("image/" + fileExt);
        }
        try (FileInputStream is = new FileInputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        }
        response.flushBuffer();
    }

    public static void deleteFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray files = new JSONArray(request.getParameter("files"));
        int j = files.length();
        int i = 0;
        while (i < j) {
            String filename = files.getString(i);
            File file = new File(filename);
            FileUtil.syncDelete((File)file, (boolean)true);
            ++i;
        }
    }

    public static void setData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        String sessionName = request.getParameter("sessionName");
        Value.set((HttpServletRequest)request, (String)name, (String)value);
        if (sessionName != null) {
            WebUtil.setSessionValue((HttpServletRequest)request, (String)sessionName, (Object)value);
        }
    }

    public static void moveFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String isCopyStr = request.getParameter("isCopy");
        boolean fromPaste = !StringUtil.isEmpty((String)isCopyStr);
        boolean isCopy = "true".equals(isCopyStr);
        boolean confirm = !Boolean.parseBoolean(request.getParameter("noConfirm"));
        JSONArray src = new JSONArray(request.getParameter("src"));
        JSONArray moveTo = null;
        File dstFile = new File(request.getParameter("dst"));
        String dropPosition = request.getParameter("dropPosition");
        String overwriteFilename = null;
        int j = src.length();
        int overwriteCount = 0;
        File folder = dropPosition.equals("append") ? dstFile : dstFile.getParentFile();
        if (folder == null) {
            throw new Exception("\u65e0\u6cd5\u590d\u5236\u5230\u6b64\u76ee\u5f55\u3002");
        }
        int i = 0;
        while (i < j) {
            String filename;
            File newDstFile;
            if (src.getString(i).isEmpty()) {
                throw new IllegalArgumentException("\u590d\u5236\u6e90\u542b\u65e0\u6548\u76ee\u5f55\u3002");
            }
            File srcFile = new File(src.getString(i));
            if (FileUtil.isAncestor((File)srcFile, (File)(newDstFile = new File(folder, filename = srcFile.getName())), (boolean)false)) {
                throw new IllegalArgumentException("\u4e0a\u7ea7\u76ee\u5f55 \"" + filename + "\" \u4e0d\u80fd\u590d\u5236\u5230\u4e0b\u7ea7\u76ee\u5f55\u3002");
            }
            if (newDstFile.exists()) {
                boolean sameFolder = folder.equals(srcFile.getParentFile());
                if (fromPaste) {
                    if (!isCopy && sameFolder) {
                        throw new IllegalArgumentException("\u540c\u4e00\u76ee\u5f55\u5185\u526a\u5207 \"" + filename + "\" \u65e0\u6548\u3002");
                    }
                    if (confirm && !sameFolder) {
                        if (overwriteFilename == null) {
                            overwriteFilename = filename;
                        }
                        ++overwriteCount;
                    }
                } else if (!sameFolder) {
                    throw new IllegalArgumentException("\"" + filename + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
                }
            }
            ++i;
        }
        if (overwriteCount > 0) {
            SysUtil.error((String)("\"" + overwriteFilename + "\"" + (overwriteCount > 1 ? " \u7b49 " + overwriteCount + " \u9879" : " ") + "\u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5417\uff1f"), (String)"101");
        }
        JSONArray srcNames = new JSONArray();
        if (fromPaste) {
            moveTo = IDE.copyFiles((JSONArray)src, (File)folder, (!isCopy ? 1 : 0) != 0);
            j = moveTo.length();
            i = j - 1;
            while (i >= 0) {
                Object[] moveInfo = (Object[])moveTo.get(i);
                if (!((Boolean)moveInfo[1]).booleanValue()) {
                    srcNames.put((Object)FileUtil.getFilename((String)((String)moveInfo[0])));
                }
                --i;
            }
        } else {
            i = j - 1;
            while (i >= 0) {
                srcNames.put((Object)FileUtil.getFilename((String)src.getString(i)));
                if (folder.equals(new File(src.getString(i)).getParentFile())) {
                    src.remove(i);
                }
                --i;
            }
            moveTo = IDE.doMoveFiles((JSONArray)src, (File)folder);
        }
        if ("module".equals(request.getParameter("type"))) {
            IDE.setFileIndex((File)folder, (String)dstFile.getName(), (JSONArray)srcNames, (String)dropPosition);
        }
        JSONObject resp = new JSONObject();
        if (!isCopy) {
            Object[] result = IDE.changePath((JSONArray)src, (JSONArray)moveTo);
            resp.put("files", result[0]);
            resp.put("change", result[1]);
        }
        resp.put("moveTo", (Object)moveTo);
        WebUtil.send((HttpServletResponse)response, (Object)resp);
    }

    private static Object[] changePath(JSONArray source, JSONArray dest) throws Exception {
        JSONArray rows = new JSONArray();
        ArrayList<Object[]> changes = new ArrayList<Object[]>();
        boolean changed = false;
        int j = source.length();
        int i = 0;
        while (i < j) {
            File srcFile = new File(source.getString(i));
            Object value = dest.opt(i);
            File dstFile = value instanceof String ? new File((String)value) : new File((String)((Object[])value)[0]);
            boolean isDir = dstFile.isDirectory();
            if (FileUtil.isAncestor((File)Base.modulePath, (File)srcFile) && FileUtil.isAncestor((File)Base.modulePath, (File)dstFile) && (isDir || srcFile.getName().endsWith(".xwl") && dstFile.getName().endsWith(".xwl"))) {
                String dstPath;
                String srcPath = FileUtil.getModulePath((File)srcFile);
                if (UrlBuffer.change((String)srcPath, (String)(dstPath = FileUtil.getModulePath((File)dstFile)), (boolean)isDir)) {
                    changed = true;
                }
                if (!isDir) {
                    srcPath = srcPath.substring(0, srcPath.length() - 4);
                    dstPath = dstPath.substring(0, dstPath.length() - 4);
                }
                Object[] change = new Object[2];
                if (isDir) {
                    change[0] = Pattern.compile("\\bxwl=" + srcPath + "\\b/");
                    change[1] = "xwl=" + dstPath + "/";
                } else {
                    change[0] = Pattern.compile("(\\bxwl=" + srcPath + "\\b)(?![/\\-\\.])");
                    change[1] = "xwl=" + dstPath;
                }
                changes.add(change);
            }
            ++i;
        }
        if (changed) {
            UrlBuffer.save();
        }
        IDE.doChangePath((File)Base.modulePath, changes, (JSONArray)rows);
        IDE.doChangePath((File)new File(Base.path, "wb/script"), changes, (JSONArray)rows);
        Object[] result = new Object[]{rows, changes};
        return result;
    }

    private static void doChangePath(File folder, ArrayList<Object[]> changes, JSONArray rows) throws Exception {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles((File)folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                IDE.doChangePath((File)file, changes, (JSONArray)rows);
            } else {
                String fileExt = FileUtil.getFileExt((String)file.getName()).toLowerCase();
                if (fileExt.equals("xwl") || fileExt.equals("js")) {
                    String text;
                    String replacedText = text = FileUtil.readString((File)file);
                    for (Object[] change : changes) {
                        replacedText = ((Pattern)change[0]).matcher(replacedText).replaceAll((String)change[1]);
                    }
                    if (!replacedText.equals(text)) {
                        FileUtil.syncSave((File)file, (String)replacedText);
                        JSONObject row = new JSONObject();
                        row.put("path", (Object)FileUtil.getPath((File)file));
                        row.put("lastModified", (Object)DateUtil.getTimestamp((long)file.lastModified()));
                        rows.put((Object)row);
                    }
                }
            }
            ++n2;
        }
    }

    private static JSONArray copyFiles(JSONArray src, File dstFolder, boolean deleteOld) throws Exception {
        int j = src.length();
        JSONArray newNames = new JSONArray();
        int i = 0;
        while (i < j) {
            File file = new File(src.getString(i));
            Object[] object = FileUtil.syncCopy((File)file, (File)dstFolder);
            if (deleteOld) {
                FileUtil.syncDelete((File)file, (boolean)false);
            }
            newNames.put((Object)object);
            ++i;
        }
        return newNames;
    }

    private static JSONArray doMoveFiles(JSONArray src, File dstFile) throws Exception {
        int j = src.length();
        JSONArray result = new JSONArray();
        int i = 0;
        while (i < j) {
            File file = new File(src.getString(i));
            FileUtil.syncMove((File)file, (File)dstFile);
            Object[] object = new Object[]{FileUtil.getPath((File)new File(dstFile, file.getName())), false};
            result.put((Object)object);
            ++i;
        }
        return result;
    }

    public static void initIDE(HttpServletRequest request, HttpServletResponse response) {
        IDE.getSysOut((HttpServletRequest)request);
    }

    private static QueueWriter getSysOut(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        QueueWriter out = (QueueWriter)session.getAttribute("sys.out");
        if (out == null) {
            out = new QueueWriter(Var.getInt((String)"sys.ide.consoleBufferSize"));
            session.setAttribute("sys.out", (Object)out);
        }
        return out;
    }

    public static ArrayList<String> getIconList() {
        File iconPath = new File(Base.path, "wb/images");
        File[] files = FileUtil.listFiles((File)iconPath);
        ArrayList<String> list = new ArrayList<String>();
        SortUtil.sort((File[])files);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                list.add(String.valueOf(FileUtil.removeExtension((String)file.getName())) + "_icon");
            }
            ++n2;
        }
        return list;
    }

    public static void compressScriptFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean compressAll = Boolean.parseBoolean(request.getParameter("compressAll"));
        IDE.makeFile((HttpServletRequest)request, (File)Base.path, (boolean)compressAll);
    }

    public static void checkFilePerm(File path) throws IOException {
        File base;
        String sysFolderBase = Var.getString((String)"sys.ide.sysFolderBase");
        if ("server".equals(sysFolderBase)) {
            base = Base.path.getParentFile().getParentFile();
        } else if ("app".equals(sysFolderBase)) {
            if (FileUtil.isAncestor((File)new File(Base.path, "wb/system"), (File)path) || FileUtil.isAncestor((File)new File(Base.path, "META-INF"), (File)path) || FileUtil.isAncestor((File)new File(Base.path, "WEB-INF"), (File)path)) {
                SysUtil.accessDenied();
            }
            base = Base.path;
        } else {
            base = null;
        }
        if (!(base == null || path != null && FileUtil.isAncestor((File)base, (File)path))) {
            SysUtil.accessDenied();
        }
    }

    public static void makeFile(HttpServletRequest request, File folder, boolean compressAll) throws IOException {
        File[] files;
        File[] fileArray = files = FileUtil.listFiles((File)folder);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                IDE.makeFile((HttpServletRequest)request, (File)file, (boolean)compressAll);
            } else {
                String name = file.getName();
                String ext = FileUtil.getFileExt((String)name).toLowerCase();
                if ((ext.equals("js") || ext.equals("css")) && (name = FileUtil.removeExtension((String)name)).endsWith("-debug")) {
                    File newFile = new File(file.getParent(), String.valueOf(name.substring(0, name.length() - 6)) + "." + ext);
                    if (compressAll || file.lastModified() != newFile.lastModified()) {
                        Console.log((HttpServletRequest)request, (Object)("Compressing " + file.toString()));
                        if (ext.equals("js")) {
                            ScriptCompressor.compressJs((File)file, (File)newFile, (boolean)false);
                        } else {
                            ScriptCompressor.compressCss((File)file, (File)newFile);
                        }
                        newFile.setLastModified(file.lastModified());
                        File syncFile = FileUtil.getSyncPath((File)newFile);
                        if (syncFile != null) {
                            FileUtils.copyFile((File)newFile, (File)syncFile);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

