/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.compatible.CustomResponse;
import com.wb.tool.DataOutput;
import com.wb.tool.ExcelObject;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePush {
    public static void getFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = WebUtil.fetch((HttpServletRequest)request, (String)"filename");
        String data = WebUtil.fetch((HttpServletRequest)request, (String)"data");
        boolean gzip = Boolean.parseBoolean(WebUtil.fetch((HttpServletRequest)request, (String)"gzip"));
        if (filename == null) {
            filename = gzip ? "data.gz" : "data";
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename((HttpServletRequest)request, (String)filename));
        if (gzip) {
            try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)response.getOutputStream());){
                gos.write(data.getBytes("utf-8"));
            }
            response.flushBuffer();
        } else {
            WebUtil.send((HttpServletResponse)response, (Object)data);
        }
    }

    public static void getText(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.send((HttpServletResponse)response, (Object)request.getParameter("text"));
    }

    public static void getExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ext = ExcelObject.getExtName();
        String filename = WebUtil.fetch((HttpServletRequest)request, (String)"filename");
        String title = WebUtil.fetch((HttpServletRequest)request, (String)"title");
        filename = StringUtil.isEmpty((String)filename) ? "data" + ext : String.valueOf(filename) + ext;
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename((HttpServletRequest)request, (String)filename));
        DataOutput.outputExcel((OutputStream)response.getOutputStream(), (JSONArray)new JSONArray(WebUtil.fetch((HttpServletRequest)request, (String)"headers")), (JSONArray)new JSONArray(WebUtil.fetch((HttpServletRequest)request, (String)"rows")), (String)(StringUtil.isEmpty((String)title) ? null : title), (JSONObject)new JSONObject("{mergeInfo:[]}"), (String)StringUtil.select((String[])new String[]{WebUtil.fetch((HttpServletRequest)request, (String)"dateFormat"), "Y-m-d"}), (String)StringUtil.select((String[])new String[]{WebUtil.fetch((HttpServletRequest)request, (String)"timeFormat"), "H:i:s"}), (boolean)false);
        response.flushBuffer();
    }

    public static void writeFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = WebUtil.fetch((HttpServletRequest)request, (String)"filename");
        String data = WebUtil.fetch((HttpServletRequest)request, (String)"data");
        boolean gzip = Boolean.parseBoolean(WebUtil.fetch((HttpServletRequest)request, (String)"gzip"));
        File file = new File(filename);
        if (file.exists()) {
            throw new Exception("\u6587\u4ef6 \u201c" + filename + "\u201d \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        if (gzip) {
            FileOutputStream fos = null;
            GZIPOutputStream gos = null;
            try {
                fos = new FileOutputStream(file);
                gos = new GZIPOutputStream(fos);
                gos.write(data.getBytes("utf-8"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gos);
                fos.close();
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)gos);
            fos.close();
        } else {
            FileUtil.writeString((File)file, (String)data);
        }
    }

    public static void transfer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray records;
        String fileExtName;
        JSONObject metaParams = new JSONObject(request.getParameter("__metaParams"));
        boolean isHtml = false;
        boolean isZip = "true".equals(WebUtil.fetch((HttpServletRequest)request, (String)"isZip"));
        String type = metaParams.optString("type");
        if ("excel".equals(type)) {
            fileExtName = DataOutput.getExtName();
        } else if ("text".equals(type)) {
            fileExtName = ".txt";
        } else if ("html".equals(type)) {
            fileExtName = ".html";
            isHtml = true;
        } else {
            throw new IllegalArgumentException("Invalid request file type.");
        }
        String data = metaParams.optString("data", null);
        if (data == null) {
            CustomResponse resp = new CustomResponse(response);
            request.setAttribute("sys.rowOnly", (Object)1);
            request.setAttribute("sys.fromExport", (Object)1);
            WebUtil.include((HttpServletRequest)request, (HttpServletResponse)resp, (String)metaParams.optString("url"));
            String respText = FilePush.getResponseString((CustomResponse)resp);
            if (respText.startsWith("<textarea>")) {
                data = respText.substring(10, respText.length() - 11);
                JSONObject responseObject = new JSONObject(data);
                data = (String)responseObject.opt("value");
                if (!responseObject.optBoolean("success")) {
                    WebUtil.send((HttpServletResponse)response, (String)data, (boolean)false);
                    return;
                }
            } else {
                if (!(respText = respText.trim()).startsWith("{") || !respText.endsWith("}")) {
                    WebUtil.send((HttpServletResponse)response, (String)respText, (boolean)false);
                    return;
                }
                data = respText;
            }
            records = new JSONObject(data).getJSONArray("rows");
        } else {
            records = new JSONArray(data);
        }
        JSONArray headers = metaParams.optJSONArray("headers");
        String title = metaParams.optString("title", null);
        JSONObject reportInfo = metaParams.optJSONObject("reportInfo");
        String dateFormat = metaParams.optString("dateFormat");
        String timeFormat = metaParams.optString("timeFormat");
        boolean neptune = metaParams.optBoolean("neptune");
        String decimalSeparator = metaParams.optString("decimalSeparator");
        String thousandSeparator = metaParams.optString("thousandSeparator");
        String filename = metaParams.optString("filename");
        if (StringUtil.isEmpty((String)filename)) {
            filename = "data";
        }
        filename = isZip ? String.valueOf(filename) + ".zip" : String.valueOf(filename) + fileExtName;
        if (!isHtml) {
            response.setHeader("content-type", "application/force-download");
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename((HttpServletRequest)request, (String)filename));
        }
        if ("excel".equals(type)) {
            DataOutput.outputExcel((HttpServletRequest)request, (HttpServletResponse)response, (JSONArray)headers, (JSONArray)records, (String)title, (JSONObject)reportInfo, (String)dateFormat, (String)timeFormat, (boolean)neptune, (boolean)"true".equals(WebUtil.fetch((HttpServletRequest)request, (String)"isAjax")), (boolean)isZip, (String)fileExtName, (String)WebUtil.fetch((HttpServletRequest)request, (String)"mergeScript"));
        } else if ("text".equals(type)) {
            DataOutput.outputText((HttpServletRequest)request, (OutputStream)response.getOutputStream(), (JSONArray)headers, (JSONArray)records, (String)dateFormat, (String)timeFormat, (String)decimalSeparator, (String)thousandSeparator);
        } else {
            DataOutput.outputHtml((HttpServletRequest)request, (OutputStream)response.getOutputStream(), (JSONArray)headers, (JSONArray)records, (String)title, (String)dateFormat, (String)timeFormat, (boolean)neptune, (int)metaParams.getInt("rowNumberWidth"), (String)metaParams.optString("rowNumberTitle"), (String)decimalSeparator, (String)thousandSeparator);
        }
        response.flushBuffer();
    }

    private static String getResponseString(CustomResponse response) throws Exception {
        String result;
        byte[] data = response.getBytes();
        if (data.length > 2 && data[0] == 31 && data[1] == -117) {
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data));){
                result = StringUtil.getString((InputStream)is);
            }
        } else {
            result = new String(data, "utf-8");
        }
        return result;
    }
}

