/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class Controls {
    private static ConcurrentHashMap<String, JSONObject> buffer;
    private static final File file;

    static {
        file = new File(Base.path, "wb/system/controls.json");
    }

    public static void open(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JsonUtil.readObject((File)file);
        JSONArray data = new JSONArray();
        JSONArray nodes = new JSONArray(request.getParameter("controls"));
        int j = nodes.length();
        int i = 0;
        while (i < j) {
            String id = nodes.getString(i);
            JSONObject control = JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)id);
            if (control == null) {
                throw new IOException("\"" + id + "\" \u6ca1\u6709\u627e\u5230\u3002");
            }
            data.put((Object)control);
            ++i;
        }
        WebUtil.send((HttpServletResponse)response, (Object)data);
    }

    public static void getControlTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JsonUtil.readObject((File)file);
        if ("ide".equals(request.getParameter("type"))) {
            Controls.setControlNode((JSONObject)json);
        }
        WebUtil.send((HttpServletResponse)response, (Object)json);
    }

    private static void setControlNode(JSONObject node) {
        if (node.has("leaf")) {
            node.remove("leaf");
            node.put("type", node.get("id"));
            node.put("control", true);
            node.put("children", (Object)new JSONArray());
        } else {
            JSONArray children = node.getJSONArray("children");
            int j = children.length();
            int i = 0;
            while (i < j) {
                Controls.setControlNode((JSONObject)children.getJSONObject(i));
                ++i;
            }
        }
    }

    public static synchronized void addControl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JsonUtil.readObject((File)file);
        String name = request.getParameter("name");
        String parent = request.getParameter("parent");
        String selNode = request.getParameter("selNode");
        String folderId = "";
        boolean isFolder = Boolean.parseBoolean(request.getParameter("isFolder"));
        folderId = StringUtil.concat((String[])new String[]{"n", SysUtil.getId()});
        if (JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)(isFolder ? folderId : name)) != null) {
            throw new IOException("\u540d\u79f0 \"" + name + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        JSONObject parentNode = JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)parent);
        JSONObject newNode = new JSONObject();
        newNode.put("text", (Object)name);
        if (isFolder) {
            newNode.put("id", (Object)folderId);
            newNode.put("children", (Object)new JSONArray());
        } else {
            newNode.put("id", (Object)name);
            newNode.put("iconCls", (Object)"item_icon");
            newNode.put("leaf", true);
            newNode.put("general", (Object)new JSONObject("{iconCls:'item_icon'}"));
            newNode.put("configs", (Object)new JSONObject("{itemId:{type:'string'}}"));
            newNode.put("events", (Object)new JSONObject());
        }
        JSONArray children = parentNode.getJSONArray("children");
        if (selNode.isEmpty()) {
            children.put((Object)newNode);
        } else {
            JSONObject node = JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)selNode);
            int index = children.indexOf((Object)node);
            children.add(++index, (Object)newNode);
        }
        Controls.save((JSONObject)json);
        if (!isFolder) {
            buffer.put("name", new JSONObject(newNode.toString()));
        }
        WebUtil.send((HttpServletResponse)response, (Object)folderId);
    }

    public static synchronized void saveControls(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject control;
        JSONObject json = JsonUtil.readObject((File)file);
        JSONArray nodes = new JSONArray(StringUtil.getString((InputStream)request.getInputStream()));
        int j = nodes.length();
        int i = 0;
        while (i < j) {
            control = nodes.getJSONObject(i);
            String id = control.getString("id");
            if (!JsonUtil.replace((JSONObject)json, (String)"children", (String)"id", (String)id, (Object)control.get("data"))) {
                throw new IOException("\"" + id + "\" \u6ca1\u6709\u627e\u5230\u3002");
            }
            ++i;
        }
        Controls.save((JSONObject)json);
        i = 0;
        while (i < j) {
            control = nodes.getJSONObject(i);
            buffer.put(control.getString("id"), new JSONObject(control.get("data").toString()));
            ++i;
        }
    }

    public static synchronized void renameFolder(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id;
        JSONObject json = JsonUtil.readObject((File)file);
        JSONObject folder = JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)(id = request.getParameter("id")));
        if (folder == null) {
            throw new IOException("\u76ee\u5f55 \"" + id + "\" \u5df2\u7ecf\u88ab\u5220\u9664\u3002");
        }
        folder.put("text", (Object)request.getParameter("newName"));
        Controls.save((JSONObject)json);
    }

    public static synchronized void deleteControls(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JsonUtil.readObject((File)file);
        JSONArray nodes = new JSONArray(request.getParameter("controls"));
        int j = nodes.length();
        int i = 0;
        while (i < j) {
            JsonUtil.remove((JSONObject)json, (String)"children", (String)"id", (String)nodes.getString(i));
            ++i;
        }
        Controls.save((JSONObject)json);
        buffer.clear();
        Controls.saveToBuffer((JSONObject)json);
    }

    public static synchronized void moveControls(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JsonUtil.readObject((File)file);
        JSONArray sourceNodes = new JSONArray(request.getParameter("sourceNodes"));
        String destNodeId = request.getParameter("destNode");
        JSONObject destNode = JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)destNodeId);
        String dropPosition = request.getParameter("dropPosition");
        int j = sourceNodes.length();
        int i = 0;
        while (i < j) {
            String id = sourceNodes.getString(i);
            String movedNode = JsonUtil.remove((JSONObject)json, (String)"children", (String)"id", (String)id);
            if (dropPosition.equals("append")) {
                JSONArray destChildren = destNode.getJSONArray("children");
                destChildren.put((Object)new JSONObject(movedNode));
            } else {
                JSONArray parentNode = JsonUtil.findArray((JSONObject)json, (String)"children", (String)"id", (String)destNodeId);
                int index = parentNode.indexOf((Object)destNode);
                if (dropPosition.equals("after")) {
                    ++index;
                }
                parentNode.add(index, (Object)new JSONObject(movedNode));
            }
            ++i;
        }
        Controls.save((JSONObject)json);
    }

    public static synchronized void copyControl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = JsonUtil.readObject((File)file);
        String source = request.getParameter("source");
        String dest = request.getParameter("dest");
        JSONObject control = JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)source);
        if (control == null) {
            throw new IOException("\u63a7\u4ef6 \"" + source + "\" \u6ca1\u6709\u627e\u5230\u3002");
        }
        if (JsonUtil.findObject((JSONObject)json, (String)"children", (String)"id", (String)dest) != null) {
            throw new IOException("\u540d\u79f0 \"" + dest + "\" \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        JSONArray parentNode = JsonUtil.findArray((JSONObject)json, (String)"children", (String)"id", (String)source);
        int index = parentNode.indexOf((Object)control);
        JSONObject newControl = new JSONObject(control.toString()).put("id", (Object)dest).put("text", (Object)dest);
        parentNode.add(index + 1, (Object)newControl);
        Controls.save((JSONObject)json);
        buffer.put("name", new JSONObject(newControl.toString()));
    }

    public static JSONObject get(String id) throws IOException {
        JSONObject object = (JSONObject)buffer.get(id);
        if (object == null) {
            throw new IOException("\u63a7\u4ef6 \"" + id + "\" \u6ca1\u6709\u627e\u5230\u3002");
        }
        return object;
    }

    private static void save(JSONObject json) throws Exception {
        FileUtil.syncSave((File)file, (String)json.toString());
    }

    public static synchronized void load() {
        try {
            buffer = new ConcurrentHashMap();
            Controls.saveToBuffer((JSONObject)new JSONObject(FileUtil.readString((File)file)));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveToBuffer(JSONObject json) {
        JSONArray ja = json.getJSONArray("children");
        int j = ja.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            if (jo.optBoolean("leaf")) {
                buffer.put(jo.getString("id"), new JSONObject(jo.toString()));
            } else {
                Controls.saveToBuffer((JSONObject)jo);
            }
            ++i;
        }
    }
}

