/*
 * Decompiled with CFR 0.152.
 */
package com.wb.controls;

import com.wb.controls.ScriptControl;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class HtmlControl
extends ScriptControl {
    public void create() throws Exception {
        String html;
        String value;
        String tag = StringUtil.select((String[])new String[]{this.gs("tagType"), (String)this.generalMeta.opt("type")});
        StringBuilder tagEnd = new StringBuilder(tag.length() + 3);
        String xtype = (String)this.generalMeta.opt("xtype");
        tagEnd.append("</").append(tag).append(">");
        ArrayList<String> classList = new ArrayList<String>();
        ArrayList<String> styleList = new ArrayList<String>();
        this.headerHtml.append('<');
        this.headerHtml.append(tag);
        if (xtype != null) {
            this.headerHtml.append(' ');
            this.headerHtml.append(xtype);
        }
        if (!(value = this.generalMeta.optString("baseClass")).isEmpty()) {
            classList.add(value);
        }
        this.processConfigs(classList, styleList);
        value = this.gs("class");
        if (!value.isEmpty()) {
            classList.add(value);
        }
        if (!(value = StringUtil.join(classList, (char)' ')).isEmpty()) {
            this.headerHtml.append(" class=\"");
            this.headerHtml.append(value);
            this.headerHtml.append('\"');
        }
        if (!(value = this.gs("style")).isEmpty()) {
            styleList.add(value);
        }
        if (!(value = StringUtil.join(styleList, (char)';')).isEmpty()) {
            this.headerHtml.append(" style=\"");
            this.headerHtml.append(value);
            if (!value.endsWith(";")) {
                this.headerHtml.append(';');
            }
            this.headerHtml.append('\"');
        }
        this.headerHtml.append('>');
        String glyph = this.gs("glyph");
        if (!glyph.isEmpty()) {
            this.headerHtml.append("<span class=\"wb_glyph\">&#" + Integer.valueOf(glyph, 16) + ";</span> ");
        }
        if (!(html = this.gs("text")).isEmpty()) {
            this.headerHtml.append(html);
        }
        if (!(html = this.gs("html")).isEmpty()) {
            this.headerHtml.append(html);
        }
        if (!Boolean.FALSE.equals(this.generalMeta.opt("tagEnd"))) {
            this.footerHtml.insert(0, tagEnd);
        }
    }

    protected void processConfigs(ArrayList<String> classList, ArrayList<String> styleList) {
        Set es = this.configs.entrySet();
        boolean hasGroup = classList != null && styleList != null;
        for (Map.Entry entry : es) {
            String group;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            JSONObject itemObject = (JSONObject)this.configsMeta.opt(key);
            if (itemObject == null || Boolean.TRUE.equals(itemObject.opt("hidden"))) continue;
            String rename = (String)itemObject.opt("rename");
            if (rename != null) {
                key = rename;
            }
            if (hasGroup && (group = (String)itemObject.opt("group")) != null) {
                if ("class".equals(group)) {
                    classList.add(value);
                    continue;
                }
                styleList.add(StringUtil.concat((String[])new String[]{key, ":", value}));
                continue;
            }
            this.headerHtml.append(' ');
            this.headerHtml.append(key);
            this.headerHtml.append('=');
            char firstChar = value.charAt(0);
            if (firstChar == '@') {
                this.headerHtml.append(WebUtil.replaceParams((HttpServletRequest)this.request, (String)value.substring(1)));
                continue;
            }
            String type = (String)itemObject.opt("type");
            if (type.startsWith("exp")) {
                this.headerHtml.append(WebUtil.replaceParams((HttpServletRequest)this.request, (String)value));
                continue;
            }
            this.headerHtml.append(StringUtil.quote((String)WebUtil.replaceParams((HttpServletRequest)this.request, (String)value)));
        }
        String tagItems = this.gs("tagConfigs");
        if (!tagItems.isEmpty()) {
            this.headerHtml.append(' ');
            this.headerHtml.append(tagItems);
        }
    }
}

