/*
 * Decompiled with CFR 0.152.
 */
package com.wb.controls;

import com.wb.controls.Control;
import com.wb.tool.DataProvider;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class DpControl
extends Control {
    public void create() throws Exception {
        this.getContent(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContent(boolean directOutput) throws Exception {
        long endIndex;
        long beginIndex;
        if (this.gb("disabled", false)) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        Long totalCount = null;
        String jndi = this.gs("jndi");
        String limitRecords = this.gs("limitRecords");
        String limitExportRecords = this.gs("limitExportRecords");
        String startParam = this.request.getParameter("start");
        String limitParam = this.request.getParameter("limit");
        String type = this.gs("type");
        if (StringUtil.isEmpty((String)type) || "array".equals(type)) {
            this.setOrderVars();
        }
        String sql = this.gs("sql");
        String totalSql = this.gs("totalSql");
        if (StringUtil.isEmpty((String)startParam)) {
            beginIndex = 1L;
            this.request.setAttribute("start", (Object)0L);
        } else {
            beginIndex = Long.parseLong(startParam) + 1L;
        }
        if (StringUtil.isEmpty((String)limitParam)) {
            endIndex = Long.MAX_VALUE;
            this.request.setAttribute("limit", (Object)endIndex);
        } else {
            endIndex = beginIndex + Long.parseLong(limitParam) - 1L;
        }
        this.request.setAttribute("beginIndex", (Object)beginIndex);
        this.request.setAttribute("endIndex", (Object)endIndex);
        Object result = this.getResult(DbUtil.run((HttpServletRequest)this.request, (String)sql, (String)jndi));
        if (!(result instanceof ResultSet)) {
            String text = StringUtil.concat((String[])new String[]{"{\"total\":1,\"metaData\":{\"fields\":[{\"name\":\"result\",\"type\":\"string\"}]},\"columns\":[{\"xtype\":\"rownumberer\",\"width\":40},{\"dataIndex\":\"result\",flex:1,\"text\":\"result\"}],\"rows\":[{\"result\":", result == null ? "null" : StringUtil.quote((String)result.toString()), "}],\"elapsed\":", Long.toString(System.currentTimeMillis() - startTime), "}"});
            if (!directOutput) return text;
            WebUtil.send((HttpServletResponse)this.response, (Object)text);
            return null;
        }
        ResultSet resultSet = (ResultSet)result;
        if (!StringUtil.isEmpty((String)totalSql)) {
            Object totalResult = this.getResult(DbUtil.run((HttpServletRequest)this.request, (String)totalSql, (String)jndi));
            if (totalResult == null) {
                throw new NullPointerException("No value in the totalSql.");
            }
            if (totalResult instanceof ResultSet) {
                ResultSet totalResultSet = (ResultSet)totalResult;
                if (!totalResultSet.next()) throw new NullPointerException("Empty total ResultSet.");
                totalCount = Long.parseLong(totalResultSet.getString(1));
            } else {
                totalCount = Long.parseLong(totalResult.toString());
            }
        }
        DataProvider dp = new DataProvider();
        dp.startTime = startTime;
        dp.request = this.request;
        dp.response = this.response;
        dp.resultSet = resultSet;
        dp.fields = this.gs("fields");
        dp.fieldsTag = this.gs("fieldsTag");
        dp.keyDefines = this.gs("keyDefines");
        dp.totalCount = totalCount;
        dp.createColumns = this.gb("createColumns", true);
        if (this.gb("autoPage", true)) {
            dp.beginIndex = beginIndex;
            dp.endIndex = endIndex;
        }
        if (!limitRecords.isEmpty()) {
            dp.limitRecords = Integer.parseInt(limitRecords);
        }
        if (!limitExportRecords.isEmpty()) {
            dp.limitExportRecords = Integer.parseInt(limitExportRecords);
        }
        dp.tag = this.gs("tag");
        dp.type = type;
        String dictTableNames = this.gs("dictTableNames");
        dp.createKeyValues = this.gb("createKeyValues", false);
        dp.dictTableNames = dictTableNames.isEmpty() ? null : StringUtil.split((String)dictTableNames, (char)',', (boolean)true);
        dp.dictFieldsMap = this.gs("dictFieldsMap");
        if (!directOutput) return dp.getScript();
        dp.output();
        return null;
    }

    private Object getResult(Object result) {
        if (result instanceof HashMap) {
            HashMap map = (HashMap)result;
            Set es = map.entrySet();
            String itemId = StringUtil.select((String[])new String[]{this.gs("itemId")});
            for (Map.Entry e : es) {
                Map.Entry entry = e;
                String name = (String)entry.getKey();
                if (name.equals("return")) {
                    name = itemId;
                } else if (!itemId.isEmpty()) {
                    name = StringUtil.concat((String[])new String[]{itemId, ".", name});
                }
                this.request.setAttribute(name, entry.getValue());
            }
            Object val = map.get(StringUtil.select((String[])new String[]{this.gs("resultName"), "result"}));
            if (val == null) {
                return map.get("return");
            }
            return val;
        }
        return result;
    }

    private void setOrderVars() throws Exception {
        String sort = this.request.getParameter("sort");
        if (StringUtil.isEmpty((String)sort) || this.request.getAttribute("sql.orderBy") != null) {
            return;
        }
        JSONArray ja = new JSONArray(sort);
        int j = ja.length();
        if (j > 0) {
            String defaultPrefix;
            JSONObject orderJo;
            StringBuilder exp = new StringBuilder();
            int order = 0;
            String direction = "";
            String orderFields = this.gs("orderFields");
            if (StringUtil.isEmpty((String)orderFields)) {
                orderJo = null;
                defaultPrefix = null;
            } else {
                orderJo = new JSONObject(orderFields);
                defaultPrefix = orderJo.optString("default", null);
            }
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                if (i > 0) {
                    exp.append(',');
                }
                String property = jo.getString("property");
                if (jo.has("sorterIndex")) {
                    order = jo.getInt("sorterIndex");
                }
                if (orderJo != null) {
                    if (orderJo.has(property)) {
                        String prefix = orderJo.optString(property);
                        if (!prefix.isEmpty()) {
                            exp.append(prefix);
                            exp.append('.');
                        }
                    } else if (defaultPrefix != null) {
                        exp.append(defaultPrefix);
                        exp.append('.');
                    }
                }
                exp.append(property);
                direction = jo.optString("direction");
                if (StringUtil.isSame((String)direction, (String)"desc")) {
                    exp.append(" desc");
                }
                ++i;
            }
            this.request.setAttribute("I_ORDER_BY", (Object)order);
            this.request.setAttribute("I_ORDER_DIR", (Object)direction);
            this.request.setAttribute("sql.orderBy", (Object)(" order by " + exp));
            this.request.setAttribute("sql.orderFields", (Object)("," + exp));
        }
    }
}

