/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.rw.util.HttpKit;
import com.rw.util.PropKit;
import com.wb.common.SimpleListener;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.tool.Encrypter;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class Session {
    public static ConcurrentHashMap<String, HashSet<HttpSession>> userList = new ConcurrentHashMap();
    private static Object lock = new Object();

    public static void verifySSO(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String redirect = (String)request.getAttribute("redirect");
        request.setAttribute("sso", (Object)1);
        Session.createSession((HttpServletRequest)request);
    }

    public static void verify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer = StringUtil.opt((String)request.getHeader("Referer"));
        String redirect = request.getParameter("redirect");
        HttpSession session = request.getSession(false);
        if (Var.getBool((String)"sys.session.verifyImage.enabled")) {
            if (session == null) {
                throw new Exception(Str.format((HttpServletRequest)request, (String)"vcExpired", (Object[])new Object[0]));
            }
            String verifyCode = (String)session.getAttribute("sys.verifyCode");
            session.removeAttribute("sys.verifyCode");
            if (StringUtil.isEmpty((String)verifyCode) || !StringUtil.isSame((String)verifyCode, (String)request.getParameter("verifyCode"))) {
                throw new Exception(Str.format((HttpServletRequest)request, (String)"vcInvalid", (Object[])new Object[0]));
            }
        }
        if (session != null) {
            session.invalidate();
        }
        Session.createSession((HttpServletRequest)request);
        if (referer.endsWith("/login") || referer.endsWith("m?xwl=sys/session/login")) {
            referer = Var.getString((String)"sys.home");
        }
        if (referer.endsWith("/tlogin") || referer.endsWith("m?xwl=sys/session/tlogin")) {
            referer = Var.getString((String)"sys.homeMobile");
        }
        if (StringUtil.isEmpty((String)redirect)) {
            WebUtil.send((HttpServletResponse)response, (Object)referer);
        } else {
            response.sendRedirect(redirect);
        }
    }

    public static void getSessionList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String user = request.getParameter("user");
        int start = Integer.parseInt(request.getParameter("start"));
        int limit = Integer.parseInt(request.getParameter("limit"));
        int index = -1;
        JSONArray rows = new JSONArray();
        HashSet sessions = (HashSet)userList.get(user);
        if (limit > Var.limitRecords) {
            limit = Var.limitRecords;
        }
        int end = start + limit;
        if (sessions != null) {
            for (HttpSession session : sessions) {
                if (++index < start) continue;
                if (index >= end) break;
                JSONObject row = new JSONObject();
                row.put("ip", session.getAttribute("sys.ip"));
                row.put("userAgent", session.getAttribute("sys.userAgent"));
                row.put("createDate", (Object)new Date(session.getCreationTime()));
                row.put("lastAccessDate", (Object)new Date(session.getLastAccessedTime()));
                rows.put((Object)row);
            }
        }
        JSONObject result = new JSONObject();
        result.put("rows", (Object)rows);
        result.put("total", sessions == null ? 0 : sessions.size());
        WebUtil.send((HttpServletResponse)response, (Object)result);
    }

    public static void getUserList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int start = Integer.parseInt(request.getParameter("start"));
        int limit = Integer.parseInt(request.getParameter("limit"));
        int index = -1;
        JSONArray rows = new JSONArray();
        Set es = userList.entrySet();
        if (limit > Var.limitRecords) {
            limit = Var.limitRecords;
        }
        int end = start + limit;
        for (Map.Entry e : es) {
            if (++index < start) continue;
            if (index >= end) break;
            HashSet sessions = (HashSet)e.getValue();
            int sessionCount = 0;
            HttpSession session = null;
            for (HttpSession sess : sessions) {
                if (session == null) {
                    session = sess;
                }
                ++sessionCount;
            }
            if (sessionCount == 0) continue;
            JSONObject row = new JSONObject();
            row.put("sessionCount", sessionCount);
            row.put("user", e.getKey());
            row.put("username", session.getAttribute("sys.username"));
            row.put("dispname", session.getAttribute("sys.dispname"));
            row.put("ip", session.getAttribute("sys.ip"));
            row.put("userAgent", session.getAttribute("sys.userAgent"));
            rows.put((Object)row);
        }
        JSONObject result = new JSONObject();
        result.put("rows", (Object)rows);
        result.put("total", userList.size());
        WebUtil.send((HttpServletResponse)response, (Object)result);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public static String[] getRoles(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (String[])session.getAttribute("sys.roles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSession(HttpServletRequest request) throws Exception {
        String sql;
        String username;
        int timeout = Var.sessionTimeout;
        boolean sso = WebUtil.exists((HttpServletRequest)request, (String)"sso");
        if (sso) {
            username = (String)request.getAttribute("username");
            sql = "select SHORTNAME,BADGE as USER_NAME,NAME as DISPLAY_NAME,USER_ID,DEPT_ID,LOGIN_TIMES,ACCESS_IP from v_user_index where SHORTNAME={?username?}";
        } else {
            username = request.getParameter("username");
            sql = "select USER_ID,USER_NAME,DISPLAY_NAME,PASSWORD,USE_LANG,DEPT_ID,LOGIN_TIMES,CREATE_DATE,UPDATE_DATE,ACCESS_IP,ACCESS_MAC from WB_USER where USER_NAME={?username?} and STATUS=1";
        }
        String password = request.getParameter("password");
        ResultSet rs = (ResultSet)DbUtil.run((HttpServletRequest)request, (String)sql);
        if (!rs.next()) {
            throw new IllegalArgumentException(Str.format((HttpServletRequest)request, (String)"userNotExist", (Object[])new Object[]{username}));
        }
        String userId = StringUtils.defaultIfBlank((String)rs.getString("USER_ID"), (String)"");
        username = rs.getString("USER_NAME");
        String dispname = rs.getString("DISPLAY_NAME");
        String orgNum = rs.getString("DEPT_ID");
        int isFirstLogin = rs.getInt("LOGIN_TIMES");
        String accessIP = rs.getString("ACCESS_IP");
        String userIP = HttpKit.getIpAddr((HttpServletRequest)request);
        if (StringUtils.equalsIgnoreCase((String)PropKit.getProperty((String)"sys.ip"), (String)"1") && !Session.accessIP((String)accessIP, (String)userIP)) {
            throw new IllegalArgumentException(Str.format((HttpServletRequest)request, (String)"accessIP", (Object[])new Object[0]));
        }
        if (!sso && !rs.getString("PASSWORD").equals(Encrypter.getMD5((String)password))) {
            throw new IllegalArgumentException(Str.format((HttpServletRequest)request, (String)"passwordInvalid", (Object[])new Object[0]));
        }
        HttpSession session = request.getSession(true);
        session.setAttribute("sys.logined", (Object)true);
        if (timeout == -1) {
            timeout = Integer.MAX_VALUE;
        }
        if (timeout > 0) {
            session.setMaxInactiveInterval(timeout);
        }
        session.setAttribute("sys.user", (Object)userId);
        session.setAttribute("sys.username", (Object)username);
        session.setAttribute("sys.dispname", (Object)dispname);
        session.setAttribute("sys.orgNum", (Object)orgNum);
        session.setAttribute("sys.isFirstLogin", (Object)isFirstLogin);
        session.setAttribute("sys.userAgent", (Object)StringUtil.substring((String)request.getHeader("user-agent"), (int)0, (int)500));
        session.setAttribute("sys.ip", (Object)userIP);
        if (!StringUtil.isEmpty((String)userId)) {
            DbUtil.run((HttpServletRequest)request, (String)"update WB_USER set LOGIN_TIMES=LOGIN_TIMES+1 where USER_ID={?sys.user?}");
        }
        Session.storeUserValues((HttpServletRequest)request, (HttpSession)session, (String)userId);
        SimpleListener simpleListener = new SimpleListener();
        if (Var.uniqueLogin) {
            String[] usernames = new String[]{username};
            Object object = lock;
            synchronized (object) {
                Session.removeSession((String[])usernames);
                session.setAttribute("sys.simpleListener", (Object)simpleListener);
            }
        } else {
            session.setAttribute("sys.simpleListener", (Object)simpleListener);
        }
    }

    private static boolean accessIPandMAC(String accessIP, String accessMAC, String ip, String mac) {
        boolean macflag = false;
        boolean ipflag = false;
        if (StringUtils.isNotBlank((String)accessIP) && StringUtils.isNotBlank((String)accessMAC) && StringUtils.isNotBlank((String)ip) && StringUtils.isNotBlank((String)mac)) {
            String[] ipArr = accessIP.split(";");
            Object[] macArr = accessMAC.split(";");
            if (Arrays.binarySearch(macArr, mac) != -1) {
                macflag = true;
            }
            for (String one : ipArr) {
                if (one.equals(ip)) {
                    ipflag = true;
                    break;
                }
                if (!Session.checkIP((String)one, (String)ip)) continue;
                ipflag = true;
                break;
            }
        }
        return macflag && ipflag;
    }

    private static boolean accessIP(String accessIP, String ip) {
        boolean ipflag = false;
        if (StringUtils.isNotBlank((String)accessIP) && StringUtils.isNotBlank((String)ip)) {
            String[] ipArr;
            for (String one : ipArr = accessIP.split(";")) {
                if (one.equals(ip)) {
                    ipflag = true;
                } else {
                    if (!Session.checkIP((String)one, (String)ip)) continue;
                    ipflag = true;
                }
                break;
            }
        } else if (StringUtils.isBlank((String)accessIP)) {
            ipflag = true;
        }
        return ipflag;
    }

    private static boolean accessMAC(String accessMAC, String mac) {
        boolean macflag = false;
        if (StringUtils.isNotBlank((String)accessMAC) && StringUtils.isNotBlank((String)mac)) {
            Object[] macArr = accessMAC.split(";");
            if (Arrays.binarySearch(macArr, mac) != -1) {
                macflag = true;
            }
        } else if (StringUtils.isBlank((String)accessMAC)) {
            macflag = true;
        }
        return macflag;
    }

    private static boolean checkIP(String one, String ip) {
        if (StringUtils.contains((String)one, (String)"*")) {
            String[] oneArr = StringUtils.split((String)one, (String)".");
            String[] ipArr = StringUtils.split((String)ip, (String)".");
            for (int i = 0; i < oneArr.length; ++i) {
                if (oneArr[i].equals("*") || oneArr[i].equals(ipArr[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void storePwdState(HttpSession session, String createDate, String updateDate) throws Exception {
        String pwdState = PropKit.getProperty((String)"sys.pwdState");
        if (StringUtils.isNotBlank((String)pwdState) && StringUtils.equals((String)pwdState, (String)"1")) {
            if (StringUtils.isBlank((String)updateDate)) {
                session.setAttribute("sys.pwdState", (Object)Session.getPwdState((String)createDate));
            } else {
                session.setAttribute("sys.pwdState", (Object)Session.getPwdState((String)updateDate));
            }
        } else {
            session.setAttribute("sys.pwdState", (Object)0);
        }
    }

    private static Integer getPwdState(String dataTime) {
        LocalDateTime today = LocalDateTime.now();
        DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime date = LocalDateTime.parse(dataTime, f);
        long c = today.getLong(ChronoField.EPOCH_DAY) - date.getLong(ChronoField.EPOCH_DAY);
        if (c > 90L) {
            return -1;
        }
        if (c > 83L && c <= 90L) {
            return (int)(90L - c + 1L);
        }
        return 0;
    }

    private static void storeUserValues(HttpServletRequest request, HttpSession session, String userId) throws Exception {
        String[] names = Var.sessionVars.split(",");
        String[] valueIds = new String[names.length];
        ArrayList<String> roles = new ArrayList<String>();
        boolean i = false;
        ResultSet rs = (ResultSet)DbUtil.run((HttpServletRequest)request, (String)"{call dbo.SP_USERID_ROLE({?sys.user?})}");
        while (rs.next()) {
            roles.add(rs.getString(1));
        }
        session.setAttribute("sys.roles", (Object)roles.toArray(new String[roles.size()]));
    }

    public static void removeSession(String[] userIds) {
        if (!Var.recordSession) {
            return;
        }
        for (String userId : userIds) {
            HashSet sessions = (HashSet)userList.get(userId);
            if (sessions == null) continue;
            HttpSession[] sessionArray = new HttpSession[sessions.size()];
            int i = 0;
            for (HttpSession session : sessions) {
                sessionArray[i++] = session;
            }
            for (HttpSession session : sessionArray) {
                session.invalidate();
            }
            userList.remove(userId);
        }
    }

    public static void updateSession(String userId, String[] roles, boolean status) {
        if (!Var.recordSession) {
            return;
        }
        HashSet sessions = (HashSet)userList.get(userId);
        if (sessions != null) {
            if (status) {
                for (HttpSession session : sessions) {
                    session.setAttribute("sys.roles", (Object)roles);
                }
            } else {
                String[] userIds = new String[]{userId};
                Session.removeSession((String[])userIds);
            }
        }
    }
}

