/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.rw.util.PropKit;
import com.wb.common.Resource;
import com.wb.common.ScriptBuffer;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.controls.Control;
import com.wb.controls.ExtControl;
import com.wb.controls.ScriptControl;
import com.wb.interact.Controls;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private StringBuilder headerHtml = new StringBuilder();
    private ArrayList<String> footerHtml = new ArrayList(15);
    private int htmlPointer;
    private StringBuilder headerScript = new StringBuilder();
    private ArrayList<String> footerScript = new ArrayList(15);
    private int scriptPointer;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static final int RUN_NORMAL = 0;
    private static final int RUN_MODULE = 1;
    private static final int RUN_CONTROL = 2;
    private static final int RUN_INVOKE = 3;

    public Parser(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String moduleFile) throws ServletException {
        boolean hasExcept = false;
        List fileItemList = null;
        ConcurrentHashMap varMap = null;
        try {
            varMap = new ConcurrentHashMap();
            this.request.setAttribute("sys.varMap", varMap);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                fileItemList = WebUtil.setUploadFile((HttpServletRequest)this.request);
            }
            this.execute(moduleFile, this.request.getParameter("xwlt") == null ? 0 : 3, null);
        }
        catch (Throwable e) {
            try {
                hasExcept = true;
                String username = (String)this.request.getSession().getAttribute("sys.username");
                logger.error("\u7528\u6237\u3010" + username + "\u3011\u5728" + DateUtil.dateToStr((Date)new Date()) + "\u8bf7\u6c42\u6a21\u5757:[" + moduleFile + "]\u53d1\u751f\u9519\u8bef:" + SysUtil.getRootExcept((Throwable)e));
                WebUtil.showException((Throwable)e, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
            }
            catch (Throwable throwable) {
                this.closeObjects(varMap, hasExcept);
                if (fileItemList != null) {
                    WebUtil.clearUploadFile((HttpServletRequest)this.request, fileItemList);
                }
                throw throwable;
            }
            this.closeObjects(varMap, hasExcept);
            if (fileItemList != null) {
                WebUtil.clearUploadFile((HttpServletRequest)this.request, (List)fileItemList);
            }
        }
        this.closeObjects(varMap, hasExcept);
        if (fileItemList != null) {
            WebUtil.clearUploadFile((HttpServletRequest)this.request, (List)fileItemList);
        }
    }

    private void execute(String moduleFile, int runType, String xwlId) throws Exception {
        boolean createFrame;
        boolean runInvoke;
        JSONObject fullModule = XwlBuffer.get((String)moduleFile, (boolean)false);
        JSONObject module = (JSONObject)((JSONArray)fullModule.opt("children")).opt(0);
        JSONObject configs = (JSONObject)module.opt("configs");
        boolean runNormal = runType == 0;
        boolean bl = runInvoke = runType == 3;
        if (runNormal || runInvoke) {
            String method = this.getString(configs, "method");
            String tokens = this.getString(configs, "tokens");
            if (!method.isEmpty() && !method.equalsIgnoreCase(this.request.getMethod())) {
                throw new IllegalArgumentException("Method not allowed");
            }
            if ((tokens.isEmpty() || !this.checkToken(tokens)) && Boolean.TRUE.equals(fullModule.opt("loginRequired"))) {
                if (!WebUtil.checkLogin((HttpServletRequest)this.request, (HttpServletResponse)this.response)) {
                    return;
                }
                if (!XwlBuffer.canAccess((JSONObject)fullModule, (String[])Session.getRoles((HttpServletRequest)this.request))) {
                    throw new Exception(Str.format((HttpServletRequest)this.request, (String)"forbidden", (Object[])new Object[]{StringUtil.select((String[])new String[]{fullModule.optString("title"), FileUtil.getFilename((String)moduleFile)}), moduleFile}));
                }
            }
        }
        JSONObject events = (JSONObject)module.opt("events");
        JSONObject emptyJson = new JSONObject();
        JSONObject moduleGeneral = (JSONObject)Controls.get((String)"module").opt("general");
        String theme = null;
        String touchTheme = null;
        boolean[] libTypes = null;
        boolean hasChildren = module.has("children");
        boolean hasEvents = events != null;
        HttpSession session = null;
        String content = this.getString(configs, "logMessage");
        if (!content.isEmpty()) {
            LogUtil.info((HttpServletRequest)this.request, (Object)content);
        }
        if (!(content = this.getString(configs, "initScript")).isEmpty()) {
            ScriptBuffer.run((String)StringUtil.concat((String[])new String[]{(String)configs.opt("id"), ".is"}), (String)content, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (String)moduleFile);
        }
        if (!(content = this.getString(configs, "serverMethod")).isEmpty()) {
            SysUtil.executeMethod((String)content, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        }
        if ((createFrame = this.getBool(configs, "createFrame", true)) && runNormal) {
            this.headerHtml.append("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\"/>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\" />\n<meta name=\"renderer\" content=\"webkit\" />\n<meta name=\"description\" content=\"ckofs\"/>\n<title>");
            String title = this.getString(configs, "title");
            if (title.isEmpty()) {
                title = fullModule.optString("title");
                if (title.startsWith("Str.")) {
                    title = Str.format((HttpServletRequest)this.request, (String)title.substring(4), (Object[])new Object[0]);
                }
            } else if (title.equals("-")) {
                title = null;
            }
            if (!StringUtil.isEmpty((String)title)) {
                this.headerHtml.append(title);
            }
            this.headerHtml.append("</title>");
            this.appendScript(this.headerHtml, this.getString(configs, "head"));
            session = this.request.getSession(false);
            String string = theme = session == null ? null : (String)session.getAttribute("sys.theme");
            if (theme == null) {
                theme = Var.getString((String)"sys.app.theme");
            }
            String string2 = touchTheme = session == null ? null : (String)session.getAttribute("sys.touchTheme");
            if (touchTheme == null) {
                touchTheme = Var.getString((String)"sys.app.touchTheme");
            }
            libTypes = this.setLinks(configs, theme, touchTheme);
            String tagConfigs = this.getString(configs, "tagConfigs");
            if (tagConfigs.isEmpty()) {
                if ("0".equals(PropKit.getProperty((String)"body.forbid"))) {
                    this.headerHtml.append("\n</head>\n<body>");
                } else {
                    this.headerHtml.append("\n</head>\n<body oncontextmenu='return false' oncopy='document.selection.empty()' onbeforecopy='return false'>");
                }
            } else {
                this.headerHtml.append("\n</head>\n<body ");
                this.headerHtml.append(tagConfigs);
                this.headerHtml.append('>');
            }
            this.headerScript.append("<script language=\"javascript\" type=\"text/javascript\">");
        }
        this.appendScript(this.headerHtml, this.getString(configs, "initHtml"));
        if (createFrame) {
            String namespace;
            if (this.headerScript.length() > 0) {
                this.headerScript.append('\n');
            }
            if (runNormal && libTypes[1] != false) {
                this.headerScript.append("Ext.onReady(function(contextOptions,contextOwner){");
                if (Var.saveState) {
                    this.headerScript.append("\nWb.stateProviderData=");
                    this.headerScript.append(Resource.getString((HttpServletRequest)this.request, (String)"clientState", null));
                    this.headerScript.append(";\nExt.state.Manager.setProvider(Ext.create('Ext.state.WbProvider'));");
                }
            } else if (runNormal && libTypes[2] != false) {
                this.headerScript.append("Ext.setup({");
                if (hasChildren) {
                    this.headerScript.append(this.getTouchViewport((JSONArray)module.opt("children"), moduleGeneral, runNormal));
                }
                this.headerScript.append("onReady:function(contextOptions,contextOwner){");
            } else {
                this.headerScript.append("(function(contextOptions,contextOwner){");
            }
            if ((namespace = (String)configs.opt("itemId")).equals("module")) {
                this.headerScript.append("\nvar app={};");
            } else {
                this.headerScript.append("\nWb.ns(\"");
                this.headerScript.append(namespace);
                this.headerScript.append("\");\nvar app=");
                this.headerScript.append(namespace);
                this.headerScript.append(";");
            }
            if (runNormal && libTypes[2] != false) {
                this.headerScript.append("\nthis.appScope=app;\napp[this.itemId]=this;");
            }
            this.headerScript.append("\napp.contextOwner=contextOwner;");
            if (runNormal) {
                this.headerScript.append("\nwindow.app=app;\nWb.init({zo:");
                if (Var.useLocalTime) {
                    Calendar cal = Calendar.getInstance();
                    this.headerScript.append((cal.get(15) + cal.get(16)) / 60000);
                } else {
                    this.headerScript.append("-1");
                }
                if (Var.maskTimeout != 1500) {
                    this.headerScript.append(",mask:");
                    this.headerScript.append(Var.maskTimeout);
                }
                if (Var.ajaxTimeout != 0) {
                    this.headerScript.append(",timeout:");
                    this.headerScript.append(Var.ajaxTimeout);
                }
                if (!"gray".equals(theme)) {
                    this.headerScript.append(",theme:\"");
                    this.headerScript.append(theme);
                    this.headerScript.append('\"');
                }
                if (!"classic".equals(touchTheme)) {
                    this.headerScript.append(",touchTheme:\"");
                    this.headerScript.append(touchTheme);
                    this.headerScript.append('\"');
                }
                String string = theme = session == null ? null : (String)session.getAttribute("sys.editTheme");
                if (theme == null) {
                    theme = Var.getString((String)"sys.ide.editTheme");
                }
                if (!"default".equals(theme)) {
                    this.headerScript.append(",editTheme:\"");
                    this.headerScript.append(theme);
                    this.headerScript.append('\"');
                }
                this.headerScript.append("});");
            } else if ((runType == 2 || runType == 1) && xwlId != null) {
                this.headerScript.append("\ncontextOwner[");
                this.headerScript.append(StringUtil.quote((String)xwlId));
                this.headerScript.append("]=app;");
            }
        }
        if (!(content = this.getString(configs, "importModules")).isEmpty()) {
            this.importModules(content);
        }
        if (!(content = this.getString(configs, "serverScript")).isEmpty()) {
            ScriptBuffer.run((String)StringUtil.concat((String[])new String[]{(String)configs.opt("id"), ".ss"}), (String)content, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (String)moduleFile);
        }
        if (hasEvents) {
            String beforeunload = this.getString(events, "beforeunload");
            if (!beforeunload.isEmpty()) {
                this.appendScript(this.headerScript, StringUtil.concat((String[])new String[]{"Wb.onUnload(function(){\n", beforeunload, "\n},contextOwner);"}));
            }
            this.appendScript(this.headerScript, this.getString(events, "initialize"));
        }
        if (hasChildren) {
            this.scan(module, moduleGeneral, emptyJson, runNormal);
        }
        if (this.response.isCommitted()) {
            return;
        }
        this.appendScript(this.headerHtml, this.getString(configs, "finalHtml"));
        if (hasEvents) {
            this.appendScript(this.headerScript, this.getString(events, "finalize"));
        }
        if (createFrame) {
            if (runNormal) {
                if (libTypes[1] != false) {
                    this.headerScript.append("\n});");
                } else if (libTypes[2] != false) {
                    this.headerScript.append("\n}});");
                } else {
                    this.headerScript.append("\n})();");
                }
            } else if (runType == 2) {
                this.headerScript.append("\nreturn Wb.optMain(app);\n})(null,app)");
            } else if (runType == 1) {
                this.headerScript.append("\n})(null,app);");
            } else {
                this.headerScript.append("\nreturn app;\n})();");
            }
        }
        if (runNormal) {
            if (createFrame) {
                this.headerScript.append("\n</script>\n</body>\n</html>");
            }
            this.output();
        } else if (runInvoke) {
            this.output();
        }
    }

    private boolean checkToken(String tokens) {
        String[] ls;
        String token = this.request.getParameter("_token");
        if (StringUtil.isEmpty((String)token)) {
            return false;
        }
        for (String s : ls = StringUtil.split((String)tokens, (String)",")) {
            if (!token.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public void output() throws IOException {
        if (this.headerHtml.length() > 0 && this.headerScript.length() > 0) {
            this.headerHtml.append('\n');
        }
        this.headerHtml.append((CharSequence)this.headerScript);
        if (this.headerHtml.length() > 0) {
            if (WebUtil.jsonResponse((HttpServletRequest)this.request)) {
                WebUtil.send((HttpServletResponse)this.response, (String)this.headerHtml.toString(), (boolean)true);
            } else {
                WebUtil.send((HttpServletResponse)this.response, (Object)this.headerHtml);
            }
        }
    }

    private void scan(JSONObject parentNode, JSONObject parentGeneral, JSONObject emptyJson, boolean normalType) throws Exception {
        JSONArray ja = (JSONArray)parentNode.opt("children");
        int j = ja.length();
        int k = j - 1;
        for (int i = 0; i < j; ++i) {
            JSONObject configItems;
            boolean isScriptControl;
            ExtControl control;
            JSONObject jo = (JSONObject)ja.opt(i);
            String type = (String)jo.opt("type");
            JSONObject meta = Controls.get((String)type);
            JSONObject general = (JSONObject)meta.opt("general");
            String className = (String)general.opt("class");
            if (className == null) {
                control = new ExtControl();
                isScriptControl = true;
            } else if (className.equals("null")) {
                control = null;
                isScriptControl = false;
                if (type.equals("xwl")) {
                    boolean rootParent = Boolean.TRUE.equals(parentGeneral.opt("root"));
                    this.addModule(jo, rootParent);
                    if (!rootParent && i < j - 1) {
                        this.headerScript.append(',');
                    }
                }
            } else {
                if (className.indexOf(46) == -1) {
                    className = "com.wb.controls." + className;
                }
                control = (Control)Class.forName(className).newInstance();
                isScriptControl = control instanceof ScriptControl;
            }
            if (control != null) {
                control.init(this.request, this.response, jo, meta, parentGeneral, i == k, normalType);
                control.create();
            }
            if (isScriptControl) {
                ScriptControl sc = (ScriptControl)control;
                this.appendScript(this.headerHtml, sc.getHeaderHtml());
                this.pushHtml(sc.getFooterHtml());
                this.appendScript(this.headerScript, sc.getHeaderScript());
                this.pushScript(sc.getFooterScript());
            }
            if (jo.has("children")) {
                this.scan(jo, general, emptyJson, normalType);
            }
            if (!isScriptControl) continue;
            this.appendScript(this.headerHtml, this.popHtml());
            String lastScript = this.popScript();
            int quoteIndex = lastScript.lastIndexOf(125);
            if (quoteIndex != -1 && (configItems = (JSONObject)jo.opt("__configs")) != null) {
                this.appendScript(this.headerScript, lastScript.substring(0, quoteIndex));
                this.headerScript.append(',');
                this.scan(configItems, emptyJson, emptyJson, normalType);
                this.appendScript(this.headerScript, lastScript.substring(quoteIndex));
                continue;
            }
            this.appendScript(this.headerScript, lastScript);
        }
    }

    private void addModule(JSONObject jo, boolean rootParent) throws Exception {
        JSONObject configs = (JSONObject)jo.opt("configs");
        String file = this.getString(configs, "file");
        if (file != null) {
            this.execute(FileUtil.getModuleFile((String)file), rootParent ? 1 : 2, (String)configs.opt("itemId"));
        }
    }

    private void pushHtml(String script) {
        ++this.htmlPointer;
        if (this.footerHtml.size() < this.htmlPointer) {
            this.footerHtml.add(script);
        } else {
            this.footerHtml.set(this.htmlPointer - 1, script);
        }
    }

    private String popHtml() {
        --this.htmlPointer;
        return (String)this.footerHtml.get(this.htmlPointer);
    }

    private void pushScript(String script) {
        ++this.scriptPointer;
        if (this.footerScript.size() < this.scriptPointer) {
            this.footerScript.add(script);
        } else {
            this.footerScript.set(this.scriptPointer - 1, script);
        }
    }

    private String popScript() {
        --this.scriptPointer;
        return (String)this.footerScript.get(this.scriptPointer);
    }

    private void appendScript(StringBuilder buf, String script) {
        if (!StringUtil.isEmpty((String)script)) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(script);
        }
    }

    private void importModules(String modules) throws Exception {
        JSONArray moduleArray = new JSONArray(modules);
        int j = moduleArray.length();
        for (int i = 0; i < j; ++i) {
            this.execute(FileUtil.getModuleFile((String)((String)moduleArray.opt(i))), 1, null);
        }
    }

    private boolean[] setLinks(JSONObject configs, String theme, String touchTheme) {
        int index;
        String value;
        int i;
        int j;
        ArrayList<String> cssArray = new ArrayList<String>();
        ArrayList<String> jsArray = new ArrayList<String>();
        JSONArray cssLinks = null;
        JSONArray jsLinks = null;
        String loadJS = this.getString(configs, "loadJS");
        String lang = (String)this.request.getAttribute("sys.useLang");
        boolean[] libTypes = new boolean[4];
        String debugSuffix = Var.debug ? "-debug" : "";
        this.request.setAttribute("debugSuffix", (Object)debugSuffix);
        String cssLinksText = this.getString(configs, "cssLinks");
        String jsLinksText = this.getString(configs, "jsLinks");
        if (!cssLinksText.isEmpty()) {
            cssLinks = new JSONArray(cssLinksText);
        }
        if (!jsLinksText.isEmpty()) {
            jsLinks = new JSONArray(jsLinksText);
        }
        if (loadJS.isEmpty()) {
            loadJS = "ext";
        }
        jsArray.add(StringUtil.concat((String[])new String[]{"wb/script/locale/wb-lang-", Str.optLanguage((String)lang), debugSuffix, ".js"}));
        if (loadJS.indexOf("ext") != -1) {
            libTypes[1] = true;
            cssArray.add(StringUtil.concat((String[])new String[]{"wb/libs/ext/resources/ext-theme-", theme, "/ext-theme-", theme, "-all", debugSuffix, ".css"}));
            jsArray.add(StringUtil.concat((String[])new String[]{"wb/libs/ext/ext-all", debugSuffix, ".js"}));
            jsArray.add(StringUtil.concat((String[])new String[]{"wb/libs/ext/locale/ext-lang-", Str.optExtLanguage((String)lang), debugSuffix, ".js"}));
            jsArray.add("wb/libs/echarts/echarts.min.js");
        }
        if (loadJS.indexOf("touch") != -1) {
            libTypes[2] = true;
            cssArray.add(StringUtil.concat((String[])new String[]{"wb/libs/touch/resources/css/", touchTheme, debugSuffix, ".css"}));
            jsArray.add(StringUtil.concat((String[])new String[]{"wb/libs/touch/locale/t-lang-", Str.optTouchLanguage((String)lang), debugSuffix, ".js"}));
            jsArray.add(StringUtil.concat((String[])new String[]{"wb/libs/touch/sencha-touch-all", debugSuffix, ".js"}));
        }
        if (loadJS.indexOf("bootstrap") != -1) {
            libTypes[3] = true;
            cssArray.add(StringUtil.concat((String[])new String[]{"wb/libs/bs/css/bootstrap", debugSuffix, ".css"}));
            jsArray.add(StringUtil.concat((String[])new String[]{"wb/libs/jquery/jquery", debugSuffix, ".js"}));
            jsArray.add(StringUtil.concat((String[])new String[]{"wb/libs/bs/js/bootstrap", debugSuffix, ".js"}));
        }
        if (loadJS.indexOf("jquery") != -1) {
            jsArray.add("wb/libs/jquery/jquery" + debugSuffix + ".js");
        }
        cssArray.add(StringUtil.concat((String[])new String[]{"wb/css/style", debugSuffix, ".css"}));
        jsArray.add(StringUtil.concat((String[])new String[]{"wb/script/wb", debugSuffix, ".js"}));
        if (cssLinks != null) {
            j = cssLinks.length();
            for (i = 0; i < j; ++i) {
                value = cssLinks.getString(i);
                index = cssArray.indexOf(value);
                if (index != -1) {
                    cssArray.remove(index);
                }
                cssArray.add(value);
            }
        }
        if (jsLinks != null) {
            j = jsLinks.length();
            for (i = 0; i < j; ++i) {
                value = jsLinks.getString(i);
                index = jsArray.indexOf(value);
                if (index != -1) {
                    jsArray.remove(index);
                }
                jsArray.add(value);
            }
        }
        for (String css : cssArray) {
            this.headerHtml.append("\n<link type=\"text/css\" rel=\"stylesheet\" href=\"");
            this.headerHtml.append(css);
            this.headerHtml.append("\">");
        }
        for (String js : jsArray) {
            this.headerHtml.append("\n<script type=\"text/javascript\" src=\"");
            this.headerHtml.append(js);
            this.headerHtml.append("\"></script>");
        }
        return libTypes;
    }

    private String getString(JSONObject object, String name) {
        String value = (String)object.opt(name);
        if (value == null) {
            return "";
        }
        return WebUtil.replaceParams((HttpServletRequest)this.request, (String)value);
    }

    private boolean getBool(JSONObject object, String name, boolean defaultValue) {
        String value = this.getString(object, name);
        if (value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private void closeObjects(ConcurrentHashMap<String, Object> map, boolean isExcept) {
        Set<Map.Entry<String, Object>> es = map.entrySet();
        ArrayList<Connection> connList = new ArrayList<Connection>();
        ArrayList<Statement> stList = new ArrayList<Statement>();
        for (Map.Entry<String, Object> e : es) {
            Object object = e.getValue();
            if (object == null) continue;
            if (object instanceof ResultSet) {
                DbUtil.close((Object)((ResultSet)object));
                continue;
            }
            if (object instanceof Statement) {
                stList.add((Statement)object);
                continue;
            }
            if (object instanceof Connection) {
                connList.add((Connection)object);
                continue;
            }
            if (object instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)object));
                continue;
            }
            if (!(object instanceof OutputStream)) continue;
            IOUtils.closeQuietly((OutputStream)((OutputStream)object));
        }
        for (Statement st : stList) {
            DbUtil.close((Object)st);
        }
        for (Connection conn : connList) {
            if (isExcept) {
                DbUtil.close((Object)conn);
                continue;
            }
            DbUtil.closeCommit((Connection)conn);
        }
    }

    private String getTouchViewport(JSONArray items, JSONObject parentGeneral, boolean normalType) throws Exception {
        if (items == null) {
            return "";
        }
        JSONObject meta = Controls.get((String)"tviewport");
        StringBuilder script = new StringBuilder();
        int j = items.length();
        int k = j - 1;
        for (int i = 0; i < j; ++i) {
            JSONObject jo = (JSONObject)items.opt(i);
            if (!"tviewport".equals(jo.opt("type"))) continue;
            ExtControl control = new ExtControl();
            control.normalMode = false;
            control.init(this.request, this.response, jo, meta, parentGeneral, i == k, normalType);
            control.create();
            script.append("\nviewport:");
            script.append(control.getHeaderScript());
            script.append(control.getFooterScript());
            script.append(',');
            return script.toString();
        }
        return "";
    }
}

