/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.Str;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class KVBuffer {
    public static ConcurrentHashMap<String, ConcurrentHashMap<Object, String>> buffer;

    public static String getList(String keyName) {
        ConcurrentHashMap map = (ConcurrentHashMap)buffer.get(keyName);
        if (map == null) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        Set es = map.entrySet();
        boolean isFirst = true;
        buf.append("[");
        for (Map.Entry e : es) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(",");
            }
            buf.append("{\"K\":");
            Object K = e.getKey();
            if (K instanceof Integer) {
                buf.append(Integer.toString((Integer)K));
            } else {
                buf.append(StringUtil.quote((String)((String)K)));
            }
            buf.append(",\"V\":");
            String V = (String)e.getValue();
            V = V.startsWith("@") ? V.substring(1) : StringUtil.quote((String)V);
            buf.append(V);
            buf.append("}");
        }
        buf.append("]");
        return buf.toString();
    }

    public static synchronized void load() {
        try {
            buffer = new ConcurrentHashMap();
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            String keyName = null;
            String preKeyName = null;
            ConcurrentHashMap<Object, String> map = new ConcurrentHashMap<Object, String>();
            try {
                conn = DbUtil.getConnection();
                st = conn.createStatement();
                rs = st.executeQuery("select * from V_WB_KEY order by KEY_NAME");
                while (rs.next()) {
                    keyName = rs.getString("KEY_NAME");
                    if (preKeyName != null && !preKeyName.equals(keyName)) {
                        buffer.put(preKeyName, map);
                        map = new ConcurrentHashMap();
                    }
                    String K = rs.getString("K");
                    map.put(rs.getInt("TYPE") == 1 ? K : Integer.valueOf(Integer.parseInt(K)), rs.getString("V"));
                    preKeyName = keyName;
                }
                if (preKeyName != null) {
                    buffer.put(preKeyName, map);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close((Object)st);
                DbUtil.close((Object)conn);
                throw throwable;
            }
            DbUtil.close((Object)rs);
            DbUtil.close((Object)st);
            DbUtil.close((Object)conn);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getValue(ConcurrentHashMap<?, ?> map, HttpServletRequest request, Object key) {
        Object value = key instanceof Number ? map.get(((Number)key).intValue()) : map.get(key.toString());
        if (value == null) {
            return key.toString();
        }
        String str = value.toString();
        if (str.startsWith("@Str.")) {
            return Str.format((HttpServletRequest)request, (String)str.substring(5), (Object[])new Object[0]);
        }
        return str;
    }

    public static String getValue(ConcurrentHashMap<?, ?> map, Object key) {
        if (key == null) {
            return null;
        }
        Object value = key instanceof Number ? map.get(((Number)key).intValue()) : map.get(key.toString());
        if (value == null) {
            return key.toString();
        }
        return value.toString();
    }
}

