/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.FileBuffer;
import com.wb.common.Parser;
import com.wb.common.ScriptBuffer;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.tool.Encrypter;
import com.wb.tool.TaskManager;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(Base.class);
    public static ServletContext servletContext;
    public static File path;
    public static int pathLen;
    public static File modulePath;
    public static String modulePathText;
    public static int modulePathLen;
    public static Date startTime;
    public static ConcurrentHashMap<String, Object> map;
    private static boolean initFailed;
    private static Throwable initError;

    static {
        map = new ConcurrentHashMap();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (initFailed) {
            throw new RuntimeException(initError);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String url = req.getServletPath();
        String xwl = UrlBuffer.get((String)url);
        if (xwl != null) {
            request.setCharacterEncoding("utf-8");
            if (xwl.isEmpty()) {
                xwl = request.getParameter("xwl");
                if (xwl == null) {
                    resp.sendError(400, "null xwl");
                    return;
                }
                xwl = StringUtil.concat((String[])new String[]{xwl, ".xwl"});
            }
            this.setRequest(req);
            Parser parser = new Parser(req, resp);
            parser.parse(xwl);
        } else {
            String lowerUrl = url.toLowerCase();
            if (lowerUrl.startsWith("/wb/modules/") || lowerUrl.startsWith("/wb/system/")) {
                resp.sendError(403, url);
            } else if (Var.cacheEnabled && lowerUrl.startsWith("/wb/")) {
                FileBuffer.service((String)url, (HttpServletRequest)req, (HttpServletResponse)resp);
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            startTime = new Date();
            servletContext = config.getServletContext();
            path = new File(servletContext.getRealPath("/"));
            pathLen = FileUtil.getPath((File)path).length() + 1;
            modulePath = new File(path, "wb/modules");
            modulePathText = FileUtil.getPath((File)modulePath);
            modulePathLen = modulePathText.length() + 1;
            SysUtil.reload((int)2);
            if (!Var.jndi.isEmpty() && !Var.getBool((String)"sys.service.allowInstall")) {
                SysUtil.reload((int)3);
                TaskManager.start();
            }
            this.checkLicense();
            this.runInitScript();
        }
        catch (Throwable e) {
            initFailed = true;
            initError = e;
        }
    }

    private void setRequest(HttpServletRequest request) {
        long time = System.currentTimeMillis();
        request.setAttribute("sys.date", (Object)new Date(time - time % 1000L));
        request.setAttribute("sys.id", (Object)SysUtil.getId());
        WebUtil.setLanguage((HttpServletRequest)request);
    }

    private void checkLicense() throws Exception {
        String code = FileUtil.readString((File)new File(path, "wb/system/lic.dat"));
        String validCode = "2782051B84F1254EA33242FCC377861A";
        String key = "wblic";
        int index = code.indexOf("lic=");
        if (index != -1 && ((code = code.substring(index + 4)).equals(validCode) || code.equals(Encrypter.getMD5((String)(String.valueOf(SysUtil.getMacAddress()) + key))))) {
            return;
        }
        System.exit(0);
    }

    private void runInitScript() throws Exception {
        File file = new File(path, "wb/system/init.js");
        if (file.exists()) {
            ScriptBuffer.run((String)FileUtil.readString((File)file));
        }
    }

    public void destroy() {
        try {
            TaskManager.stop();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

