/*
 * Decompiled with CFR 0.152.
 */
package com.rw.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class SystemKit {
    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getUnixMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec("ifconfig eth0");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                int index = -1;
                while ((line = bufferedReader.readLine()) != null) {
                    index = line.toLowerCase().indexOf("hwaddr");
                    if (index < 0) continue;
                    mac = line.substring(index + "hwaddr".length() + 1).trim();
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                bufferedReader = null;
                process = null;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    public static String getWindowsMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec("ipconfig /all");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                int index = -1;
                while ((line = bufferedReader.readLine()) != null) {
                    System.out.println(line);
                    index = line.toLowerCase().indexOf("physical address");
                    if (index < 0) continue;
                    index = line.indexOf(":");
                    if (index >= 0) {
                        System.out.println(mac);
                        mac = line.substring(index + 1).trim();
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                bufferedReader = null;
                process = null;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    public static String getMACAddress() throws Exception {
        InetAddress ia = InetAddress.getLocalHost();
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < mac.length) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? String.valueOf(0) + s : s);
            ++i;
        }
        return sb.toString().toUpperCase();
    }
}

