/*
 * Decompiled with CFR 0.152.
 */
package com.rw.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PoiKit {
    public static void copySheet(HSSFSheet targetSheet, HSSFSheet sourceSheet, HSSFWorkbook targetWork, HSSFWorkbook sourceWork) throws Exception {
        if (targetSheet == null || sourceSheet == null || targetWork == null || sourceWork == null) {
            throw new IllegalArgumentException("\u8c03\u7528PoiUtil.copySheet()\u65b9\u6cd5\u65f6\uff0ctargetSheet\u3001sourceSheet\u3001targetWork\u3001sourceWork\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6545\u629b\u51fa\u8be5\u5f02\u5e38\uff01");
        }
        PoiKit.copySheet((HSSFSheet)targetSheet, (HSSFSheet)sourceSheet, (HSSFWorkbook)targetWork, (HSSFWorkbook)sourceWork, (boolean)true);
    }

    public static void copySheet(HSSFSheet targetSheet, HSSFSheet sourceSheet, HSSFWorkbook targetWork, HSSFWorkbook sourceWork, boolean copyStyle) throws Exception {
        if (targetSheet == null || sourceSheet == null || targetWork == null || sourceWork == null) {
            throw new IllegalArgumentException("\u8c03\u7528PoiUtil.copySheet()\u65b9\u6cd5\u65f6\uff0ctargetSheet\u3001sourceSheet\u3001targetWork\u3001sourceWork\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6545\u629b\u51fa\u8be5\u5f02\u5e38\uff01");
        }
        int maxColumnNum = 0;
        HashMap styleMap = copyStyle ? new HashMap() : null;
        HSSFPatriarch patriarch = targetSheet.createDrawingPatriarch();
        int i = sourceSheet.getFirstRowNum();
        while (i <= sourceSheet.getLastRowNum()) {
            HSSFRow sourceRow = sourceSheet.getRow(i);
            HSSFRow targetRow = targetSheet.createRow(i);
            if (sourceRow != null) {
                PoiKit.copyRow((HSSFRow)targetRow, (HSSFRow)sourceRow, (HSSFWorkbook)targetWork, (HSSFWorkbook)sourceWork, (HSSFPatriarch)patriarch, styleMap);
                if (sourceRow.getLastCellNum() > maxColumnNum) {
                    maxColumnNum = sourceRow.getLastCellNum();
                }
            }
            ++i;
        }
        PoiKit.mergerRegion((HSSFSheet)targetSheet, (HSSFSheet)sourceSheet);
        i = 0;
        while (i <= maxColumnNum) {
            targetSheet.setColumnWidth(i, sourceSheet.getColumnWidth(i));
            ++i;
        }
    }

    public static void copyRow(HSSFRow targetRow, HSSFRow sourceRow, HSSFWorkbook targetWork, HSSFWorkbook sourceWork, HSSFPatriarch targetPatriarch, Map<String, HSSFCellStyle> styleMap) throws Exception {
        if (targetRow == null || sourceRow == null || targetWork == null || sourceWork == null || targetPatriarch == null) {
            throw new IllegalArgumentException("\u8c03\u7528PoiUtil.copyRow()\u65b9\u6cd5\u65f6\uff0ctargetRow\u3001sourceRow\u3001targetWork\u3001sourceWork\u3001targetPatriarch\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6545\u629b\u51fa\u8be5\u5f02\u5e38\uff01");
        }
        targetRow.setHeight(sourceRow.getHeight());
        int i = sourceRow.getFirstCellNum();
        while (i <= sourceRow.getLastCellNum()) {
            HSSFCell sourceCell = sourceRow.getCell(i);
            HSSFCell targetCell = targetRow.getCell(i);
            if (sourceCell != null) {
                if (targetCell == null) {
                    targetCell = targetRow.createCell(i);
                }
                PoiKit.copyCell((HSSFCell)targetCell, (HSSFCell)sourceCell, (HSSFWorkbook)targetWork, (HSSFWorkbook)sourceWork, styleMap);
                PoiKit.copyComment((HSSFCell)targetCell, (HSSFCell)sourceCell, (HSSFPatriarch)targetPatriarch);
            }
            ++i;
        }
    }

    public static void copyCell(HSSFCell targetCell, HSSFCell sourceCell, HSSFWorkbook targetWork, HSSFWorkbook sourceWork, Map<String, HSSFCellStyle> styleMap) {
        if (targetCell == null || sourceCell == null || targetWork == null || sourceWork == null) {
            throw new IllegalArgumentException("\u8c03\u7528PoiUtil.copyCell()\u65b9\u6cd5\u65f6\uff0ctargetCell\u3001sourceCell\u3001targetWork\u3001sourceWork\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6545\u629b\u51fa\u8be5\u5f02\u5e38\uff01");
        }
        if (styleMap != null) {
            if (targetWork == sourceWork) {
                targetCell.setCellStyle(sourceCell.getCellStyle());
            } else {
                String stHashCode = "" + sourceCell.getCellStyle().hashCode();
                HSSFCellStyle targetCellStyle = styleMap.get(stHashCode);
                if (targetCellStyle == null) {
                    targetCellStyle = targetWork.createCellStyle();
                    targetCellStyle.cloneStyleFrom(sourceCell.getCellStyle());
                    styleMap.put(stHashCode, targetCellStyle);
                }
                targetCell.setCellStyle(targetCellStyle);
            }
        }
        switch (sourceCell.getCellType()) {
            case 1: {
                targetCell.setCellValue((RichTextString)sourceCell.getRichStringCellValue());
                break;
            }
            case 0: {
                targetCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            }
            case 3: {
                targetCell.setCellType(3);
                break;
            }
            case 4: {
                targetCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            }
            case 5: {
                targetCell.setCellErrorValue(sourceCell.getErrorCellValue());
                break;
            }
            case 2: {
                targetCell.setCellFormula(sourceCell.getCellFormula());
                break;
            }
        }
    }

    public static void copyComment(HSSFCell targetCell, HSSFCell sourceCell, HSSFPatriarch targetPatriarch) throws Exception {
        if (targetCell == null || sourceCell == null || targetPatriarch == null) {
            throw new IllegalArgumentException("\u8c03\u7528PoiUtil.copyCommentr()\u65b9\u6cd5\u65f6\uff0ctargetCell\u3001sourceCell\u3001targetPatriarch\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6545\u629b\u51fa\u8be5\u5f02\u5e38\uff01");
        }
        HSSFComment comment = sourceCell.getCellComment();
        if (comment != null) {
            HSSFComment newComment = targetPatriarch.createComment((HSSFAnchor)new HSSFClientAnchor());
            newComment.setAuthor(comment.getAuthor());
            newComment.setColumn(comment.getColumn());
            newComment.setFillColor(comment.getFillColor());
            newComment.setHorizontalAlignment(comment.getHorizontalAlignment());
            newComment.setLineStyle(comment.getLineStyle());
            newComment.setLineStyleColor(comment.getLineStyleColor());
            newComment.setLineWidth(comment.getLineWidth());
            newComment.setMarginBottom(comment.getMarginBottom());
            newComment.setMarginLeft(comment.getMarginLeft());
            newComment.setMarginTop(comment.getMarginTop());
            newComment.setMarginRight(comment.getMarginRight());
            newComment.setNoFill(comment.isNoFill());
            newComment.setRow(comment.getRow());
            newComment.setShapeType(comment.getShapeType());
            newComment.setString((RichTextString)comment.getString());
            newComment.setVerticalAlignment(comment.getVerticalAlignment());
            newComment.setVisible(comment.isVisible());
            targetCell.setCellComment((Comment)newComment);
        }
    }

    public static void mergerRegion(HSSFSheet targetSheet, HSSFSheet sourceSheet) throws Exception {
        if (targetSheet == null || sourceSheet == null) {
            throw new IllegalArgumentException("\u8c03\u7528PoiUtil.mergerRegion()\u65b9\u6cd5\u65f6\uff0ctargetSheet\u6216\u8005sourceSheet\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6545\u629b\u51fa\u8be5\u5f02\u5e38\uff01");
        }
        int i = 0;
        while (i < sourceSheet.getNumMergedRegions()) {
            CellRangeAddress oldRange = sourceSheet.getMergedRegion(i);
            CellRangeAddress newRange = new CellRangeAddress(oldRange.getFirstRow(), oldRange.getLastRow(), oldRange.getFirstColumn(), oldRange.getLastColumn());
            targetSheet.addMergedRegion(newRange);
            ++i;
        }
    }

    public static HSSFColor setMForeColor(HSSFWorkbook workbook) {
        HSSFPalette palette = workbook.getCustomPalette();
        HSSFColor hssfColor = null;
        byte[] rgb = new byte[]{-35, -15, -1};
        try {
            hssfColor = palette.findColor(rgb[0], rgb[1], rgb[2]);
            if (hssfColor == null) {
                palette.setColorAtIndex((short)13, rgb[0], rgb[1], rgb[2]);
                hssfColor = palette.getColor((short)13);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hssfColor;
    }

    public static HSSFColor setMBorderColor(HSSFWorkbook workbook) {
        HSSFPalette palette = workbook.getCustomPalette();
        HSSFColor hssfColor = null;
        byte[] byArray = new byte[3];
        byArray[1] = -128;
        byArray[2] = -64;
        byte[] rgb = byArray;
        try {
            hssfColor = palette.findColor(rgb[0], rgb[1], rgb[2]);
            if (hssfColor == null) {
                palette.setColorAtIndex((short)14, rgb[0], rgb[1], rgb[2]);
                hssfColor = palette.getColor((short)14);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hssfColor;
    }
}

