/*
 * Decompiled with CFR 0.152.
 */
package com.rw.util;

import com.wb.common.Str;
import com.wb.util.LogUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpKit {
    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getHttpServletResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getMAC(String ip, HttpServletRequest request) {
        String str = "";
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -a " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream(), "GBK");
            LineNumberReader input = new LineNumberReader(ir);
            int i = 0;
            while (i < 100) {
                str = input.readLine();
                if (StringUtils.isNotBlank((String)str) && str.indexOf("MAC") > 1) {
                    macAddress = StringUtils.replace((String)str.substring(str.indexOf("=") + 2, str.length()), (String)"-", (String)"");
                    break;
                }
                ++i;
            }
        }
        catch (IOException e) {
            LogUtil.error((Object)("IP\u5730\u5740\u4e3a\uff1a" + ip + "\uff0c\u83b7\u53d6MAC\u5730\u5740\u5931\u8d25"));
            throw new IllegalArgumentException(Str.format((HttpServletRequest)request, (String)"getMacError", (Object[])new Object[0]));
        }
        return macAddress;
    }
}

