/*
 * Decompiled with CFR 0.152.
 */
package com.rw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExpressionKit {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionKit.class);

    public static boolean checkExpression(String exp) {
        if (StringUtils.isBlank((String)exp)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\{\\$(\\w+)\\}");
        Matcher matcher = pattern.matcher(exp);
        return matcher.find();
    }

    public static String replaceParas(String str, Map<String, Object> paras) {
        if (str == null || str.length() < 1) {
            return str;
        }
        Set<String> keys = paras.keySet();
        for (String key : keys) {
            Object param = paras.get(key);
            if (param == null) continue;
            param = param.toString().trim().replaceAll("\n|\r", "");
            param = param.toString().replaceAll("\\$", "\\\\\\$");
            str = Pattern.compile("\\{\\$" + key + "\\}", 2).matcher(str).replaceAll(param.toString());
        }
        Pattern pattern = Pattern.compile("\\{\\$(\\w+)\\}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            logger.warn("!!!!!paras:[" + matcher.group(0) + "] not be relaced");
        }
        return str.equals("null") ? "" : str;
    }

    public static Boolean isCondition(String exp) {
        Pattern p = Pattern.compile("(?i)\\<|\\>|\\=|(?<![a-zA-z])or(?![a-zA-z])|(?<![a-zA-z])and(?![a-zA-z])");
        Matcher matcher = p.matcher(exp);
        if (matcher.find()) {
            return true;
        }
        return false;
    }

    public static Boolean checkCondition(String condition, Map<String, Object> paras) {
        Boolean result = false;
        if (StringUtils.isBlank((String)condition)) {
            return true;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine scriptEngine = manager.getEngineByName("javascript");
        String exp = ExpressionKit.toJavascriptExpression((String)condition, paras);
        try {
            result = (Boolean)scriptEngine.eval(exp);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String toJavascriptExpression(String condition, Map<String, Object> paras) {
        String exp = ExpressionKit.replaceParas((String)condition, paras);
        exp = exp.replaceAll("=", "==");
        exp = exp.replaceAll("<>", "!=");
        exp = exp.replaceAll("(?i)(?<![a-zA-z])and(?![a-zA-z])", "&&");
        exp = exp.replaceAll("(?i)(?<![a-zA-z])or(?![a-zA-z])", "||");
        System.out.println("exp:" + exp);
        return exp;
    }

    public static Map<String, String> parseDatasource(String dataSource) {
        HashMap<String, String> parseResult = null;
        Pattern pattern = Pattern.compile("\\<\\$\\w+\\$\\>");
        Matcher matcher = pattern.matcher(dataSource);
        while (matcher.find()) {
            parseResult = new HashMap<String, String>();
            String dataSoureName = StringUtils.substringBetween((String)dataSource, (String)"<$", (String)"$>");
            String sql = StringUtils.replace((String)dataSource, (String)("<$" + dataSoureName + "$>"), (String)"");
            parseResult.put("dataSoureName", dataSoureName);
            parseResult.put("sql", sql);
        }
        return parseResult;
    }

    public static void main(String[] a) {
        String s = "select * from  <$iqDataSource$>ODS.TB_CHECK_RESULTS";
        Map m = ExpressionKit.parseDatasource((String)s);
        System.out.println((String)m.get("dataSoureName"));
        System.out.println((String)m.get("sql"));
    }
}

