/*
 * Decompiled with CFR 0.152.
 */
package com.rw.service;

import com.rw.annotation.SystemServiceLog;
import com.rw.dao.BaseDAO;
import com.rw.dao.ExcelDao;
import com.rw.model.excel.Col2Field;
import com.rw.model.excel.ExcelTemplate;
import com.rw.model.sp.Procedure;
import com.rw.model.sp.ProcedureArgument;
import com.rw.service.ExcelService;
import com.rw.util.ExcelKit;
import com.rw.util.ExpressionKit;
import com.wb.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="excelService")
public class ExcelServiceImpl
implements ExcelService {
    @Autowired
    private ExcelDao excelDao;
    @Autowired
    private BaseDAO baseDAO;

    @SystemServiceLog(description="\u83b7\u53d6Excel\u6a21\u677f\u4fe1\u606f")
    public List<ExcelTemplate> getTemplateInfo(String modelCode) throws RuntimeException {
        ArrayList<ExcelTemplate> excelTemplateList = new ArrayList<ExcelTemplate>();
        String templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.template_code=?";
        HashMap<String, String> codeParams = new HashMap<String, String>();
        codeParams.put("template_code", modelCode);
        List list = this.baseDAO.findList(templateManageSql, new Object[]{modelCode});
        if (list.size() > 0) {
            ExcelTemplate excelTemplate = new ExcelTemplate();
            Map map = (Map)list.get(0);
            int templateFlag = Integer.parseInt(ObjectUtils.toString(map.get("template_flag".toUpperCase())));
            String templateId = (String)map.get("template_id".toUpperCase());
            if (templateFlag != 3) {
                excelTemplate.setTemplateId(templateId);
                excelTemplate.setTemplateName((String)map.get("template_name".toUpperCase()));
                excelTemplate.setTemplateTbName((String)map.get("template_tb_name".toUpperCase()));
                excelTemplate.setStartRowsNum(Integer.parseInt(ObjectUtils.toString(map.get("start_rows_num".toUpperCase()), (String)"0")));
                excelTemplate.setEndRowsNum(Integer.parseInt(ObjectUtils.toString(map.get("end_rows_num".toUpperCase()), (String)"0")));
                excelTemplate.setTemplateFlag(templateFlag);
                excelTemplate.setTemplateSheetName((String)map.get("template_sheet_name".toUpperCase()));
                excelTemplateList.add(excelTemplate);
            } else {
                templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.parent_id= ? order by template_sort";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("parent_id", templateId);
                list = this.baseDAO.findList(templateManageSql, new Object[]{templateId});
                for (Map m : list) {
                    ExcelTemplate et = new ExcelTemplate();
                    et.setTemplateId((String)m.get("template_id".toUpperCase()));
                    et.setTemplateName((String)m.get("template_name".toUpperCase()));
                    et.setTemplateTbName((String)m.get("template_tb_name".toUpperCase()));
                    et.setStartRowsNum(Integer.parseInt(m.get("start_rows_num".toUpperCase()).toString()));
                    et.setEndRowsNum(Integer.parseInt(ObjectUtils.toString(m.get("end_rows_num".toUpperCase()), (String)"0")));
                    et.setTemplateFlag(Integer.parseInt(ObjectUtils.toString(m.get("template_flag".toUpperCase()))));
                    et.setTemplateSheetName((String)m.get("template_sheet_name".toUpperCase()));
                    excelTemplateList.add(et);
                }
            }
        }
        return excelTemplateList;
    }

    private List<Col2Field> getCol2FieldList(String templateId) throws RuntimeException {
        String templateFields = "select f.col_text,f.col_name,f.xls_col,f.field_type,f.default_value,f.template_sort,f.empty_is_imp from t_import_template_fields f where f.template_id=? and f.is_selected=1 order by template_sort";
        HashMap<String, String> idParams = new HashMap<String, String>();
        idParams.put("template_id", templateId);
        List list = this.baseDAO.findList(templateFields, new Object[]{templateId});
        ArrayList<Col2Field> col2FieldList = new ArrayList<Col2Field>(list.size());
        int i = 0;
        while (i < list.size()) {
            Map map = (Map)list.get(i);
            Col2Field model = new Col2Field();
            model.setColName(ObjectUtils.toString(map.get("col_name".toUpperCase())));
            model.setColText(ObjectUtils.toString(map.get("col_text".toUpperCase())));
            model.setFieldType(ObjectUtils.toString(map.get("field_type".toUpperCase())));
            model.setDefaultValue(ObjectUtils.toString(map.get("default_value".toUpperCase())));
            model.setEmptyIsImp(StringUtil.getBoolA((String)ObjectUtils.toString(map.get("empty_is_imp".toUpperCase()))).booleanValue());
            String xls_col = ObjectUtils.toString(map.get("XLS_COL"));
            model.setXlsCol(xls_col);
            if (StringUtils.isNotBlank((String)xls_col)) {
                model.setFieldIndex(ExcelKit.columnToIndex((String)xls_col) - 1);
            } else {
                String inds = ObjectUtils.toString(map.get("template_sort".toUpperCase()), (String)"0");
                model.setFieldIndex(Integer.parseInt(inds));
            }
            col2FieldList.add(model);
            ++i;
        }
        return col2FieldList;
    }

    private ExcelTemplate getExcelTemplate(Map<String, Object> map, Map<String, Object> reqParasMap) throws RuntimeException {
        ExcelTemplate excelTemplate = null;
        if (map != null) {
            String endSp;
            excelTemplate = new ExcelTemplate();
            excelTemplate.setTemplateId((String)map.get("template_id".toUpperCase()));
            excelTemplate.setTemplateName((String)map.get("template_name".toUpperCase()));
            excelTemplate.setTemplateTbName((String)map.get("template_tb_name".toUpperCase()));
            excelTemplate.setStartRowsNum(Integer.parseInt(ObjectUtils.toString((Object)map.get("start_rows_num".toUpperCase()), (String)"0")));
            excelTemplate.setEndRowsNum(Integer.parseInt(ObjectUtils.toString((Object)map.get("end_rows_num".toUpperCase()), (String)"0")));
            excelTemplate.setTemplateFlag(Integer.parseInt(ObjectUtils.toString((Object)map.get("template_flag".toUpperCase()), (String)"0")));
            excelTemplate.setTemplateSheetName((String)map.get("template_sheet_name".toUpperCase()));
            String startSp = ObjectUtils.toString((Object)map.get("start_exec_sp".toUpperCase()), null);
            if (StringUtils.isNotBlank((String)startSp)) {
                excelTemplate.setStartExecSp(this.parseSP(startSp, reqParasMap));
            }
            if (StringUtils.isNotBlank((String)(endSp = ObjectUtils.toString((Object)map.get("end_exec_sp".toUpperCase()), null)))) {
                excelTemplate.setEndExecSp(this.parseSP(endSp, reqParasMap));
            }
            excelTemplate.setCol2FieldList(this.getCol2FieldList(excelTemplate.getTemplateId()));
        }
        return excelTemplate;
    }

    @SystemServiceLog(description="serivce\u5c42\u5bfc\u5165Excel")
    public Map<String, ExcelTemplate> importExcel(String modelCode, Map<String, Object> reqParasMap) throws RuntimeException {
        LinkedHashMap<String, ExcelTemplate> excelTemplateMap = new LinkedHashMap<String, ExcelTemplate>();
        String templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.template_code=? ";
        HashMap<String, String> codeParams = new HashMap<String, String>();
        codeParams.put("template_id", modelCode);
        List list = this.baseDAO.findList(templateManageSql, new Object[]{modelCode});
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            int templateFlag = Integer.parseInt(ObjectUtils.toString(map.get("template_flag".toUpperCase()), (String)"0"));
            if (templateFlag != 3) {
                ExcelTemplate excelTemplate = this.getExcelTemplate(map, reqParasMap);
                excelTemplateMap.put(excelTemplate.getTemplateSheetName(), excelTemplate);
            } else {
                String templateId = (String)map.get("template_id".toUpperCase());
                templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.parent_id=? order by t.template_sort";
                HashMap<String, String> tempParams = new HashMap<String, String>();
                tempParams.put("template_id", templateId);
                list = this.baseDAO.findList(templateManageSql, new Object[]{templateId});
                for (Map m : list) {
                    ExcelTemplate excelTemplate = this.getExcelTemplate(m, reqParasMap);
                    if (excelTemplateMap.containsKey(excelTemplate.getTemplateSheetName())) {
                        excelTemplateMap.put(String.valueOf(excelTemplate.getTemplateSheetName()) + "&|+|&" + excelTemplate.getTemplateName(), excelTemplate);
                        continue;
                    }
                    excelTemplateMap.put(excelTemplate.getTemplateSheetName(), excelTemplate);
                }
            }
        }
        return excelTemplateMap;
    }

    @SystemServiceLog(description="\u6279\u91cf\u6267\u884c\u63d2\u5165sql\u8bed\u53e5")
    @Transactional
    public int insertBatch(List<String> batchSql) throws RuntimeException {
        return this.excelDao.batchUpdateSql(batchSql);
    }

    @SystemServiceLog(description="\u6267\u884c\u5bfc\u5165Excel\u7684sp")
    public Map<String, Object> importExcel4SP(String sp, List<ProcedureArgument> spaList) throws RuntimeException {
        Map spResult = this.baseDAO.querySp(sp, spaList);
        return spResult;
    }

    private Procedure parseSP(String sp, Map<String, Object> reqParasMap) throws RuntimeException {
        int firstIndex = StringUtils.indexOf((String)sp, (String)"{");
        int endIndex = StringUtils.lastIndexOf((String)sp, (String)"}");
        String paramStr = StringUtils.substring((String)sp, (int)(firstIndex + 1), (int)endIndex);
        Procedure pd = new Procedure();
        if (StringUtils.isNotEmpty((String)paramStr)) {
            String[] startParams = paramStr.split(";");
            int paramsLength = startParams.length;
            pd.setProceSql(sp.substring(0, sp.indexOf("{")));
            if (paramsLength > 0) {
                ArrayList<ProcedureArgument> paList = new ArrayList<ProcedureArgument>(paramsLength);
                int i = 0;
                while (i < paramsLength) {
                    String[] param = startParams[i].split(",");
                    if (param.length == 4) {
                        ProcedureArgument pa = new ProcedureArgument();
                        if (Integer.parseInt(param[0]) == 0) {
                            pa.setDirection("in");
                            pa.setIndex(Integer.parseInt(param[1]));
                            pa.setDefaultValue((Object)ExpressionKit.replaceParas((String)param[2], reqParasMap));
                            pa.setDataType(Integer.valueOf(Integer.parseInt(param[3])));
                            paList.add(pa);
                        } else if (Integer.parseInt(param[0]) == 1) {
                            pa.setDirection("out");
                            pa.setIndex(Integer.parseInt(param[1]));
                            pa.setArgName(param[2]);
                            pa.setDataType(Integer.valueOf(Integer.parseInt(param[3])));
                            paList.add(pa);
                        }
                    }
                    ++i;
                }
                pd.setProcedureArguments(paList);
            }
        } else {
            pd.setProceSql(sp.substring(0, sp.indexOf("{")));
        }
        return pd;
    }

    public String getTemplateFilePath(String modelCode) throws RuntimeException {
        String templateManageSql = "SELECT T.TEMPLATE_ID, T.TEMPLATE_NAME,T.TEMPLATE_TB_NAME,T.START_ROWS_NUM,T.END_ROWS_NUM,T.START_EXEC_SP,T.END_EXEC_SP,T.TEMPLATE_FLAG,T.TEMPLATE_SHEET_NAME,T.TEMPLATE_FILE_PATH FROM  T_IMPORT_TEMPLATE_MANAGE T WHERE T.TEMPLATE_CODE=? ";
        HashMap<String, String> codeParams = new HashMap<String, String>();
        codeParams.put("template_id", modelCode);
        Map one = this.baseDAO.findOne(templateManageSql, new Object[]{modelCode});
        if (one != null) {
            return ObjectUtils.toString(one.get("TEMPLATE_FILE_PATH"), null);
        }
        return null;
    }
}

