/*
 * Decompiled with CFR 0.152.
 */
package com.rw.model.excel;

import com.rw.model.excel.XCell;
import com.rw.model.excel.XCellStyle;
import com.rw.model.excel.XRow;
import com.rw.model.excel.XSheet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class ExcelTranslate {
    private static final Logger logger = Logger.getLogger(ExcelTranslate.class);
    private Workbook workbook;
    private FormulaEvaluator evaluator;
    private int maxRow;
    private int maxCol = 0;
    private List<XSheet> sheetList = new ArrayList();
    private List<CellRangeAddress> cellRangeAddressList = new ArrayList();

    public List<XSheet> getSheetList() {
        return this.sheetList;
    }

    public void setSheetList(List<XSheet> sheetList) {
        this.sheetList = sheetList;
    }

    private void readMaxCell(Sheet sheet) {
        this.maxCol = 0;
        Iterator rit = sheet.rowIterator();
        while (rit.hasNext()) {
            Row row = (Row)rit.next();
            if (row.getLastCellNum() <= this.maxCol) continue;
            this.maxCol = row.getLastCellNum();
        }
    }

    public Workbook create(String fileName, InputStream fis) throws IOException, InvalidFormatException {
        if (StringUtils.endsWithIgnoreCase((String)fileName, (String)"xls")) {
            return new HSSFWorkbook(fis);
        }
        if (StringUtils.endsWithIgnoreCase((String)fileName, (String)"xlsx")) {
            return new XSSFWorkbook(fis);
        }
        throw new IllegalArgumentException("\u4f60\u7684excel\u7248\u672c\u76ee\u524dpoi\u89e3\u6790\u4e0d\u4e86");
    }

    public void readExcel(String fileName, InputStream fis, int maxRow, List<String> sheetNameList) throws Exception {
        try {
            logger.info((Object)"---------Excel\u89e3\u6790\u5f00\u59cb--------------");
            this.workbook = WorkbookFactory.create((InputStream)fis);
            this.evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
            int sheetNumber = this.workbook.getNumberOfSheets();
            String sheetName = null;
            Sheet sheet = null;
            XSheet xSheet = null;
            int n = 0;
            while (n < sheetNumber) {
                if (!this.workbook.isSheetHidden(n) && !this.workbook.isSheetVeryHidden(n)) {
                    sheet = this.workbook.getSheetAt(n);
                    xSheet = new XSheet();
                    sheetName = sheet.getSheetName();
                    if (sheetNameList != null && !CollectionUtils.isEmpty(sheetNameList) && sheetNameList.contains(sheetName)) {
                        this.readSheet(maxRow, sheet, xSheet);
                    } else if (sheetNameList == null || CollectionUtils.isEmpty(sheetNameList)) {
                        this.readSheet(maxRow, sheet, xSheet);
                    }
                }
                ++n;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw e;
        }
        catch (InvalidFormatException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private void readSheet(int maxRow, Sheet sheet, XSheet xSheet) {
        xSheet.setLabel(sheet.getSheetName());
        logger.info((Object)("--------sheetName=" + sheet.getSheetName() + "-----------"));
        xSheet.setDefaultCellWidth(sheet.getDefaultColumnWidth());
        xSheet.setDefaultRowHeight((int)sheet.getDefaultRowHeight());
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            this.cellRangeAddressList.add(ca);
            ++i;
        }
        this.readMaxCell(sheet);
        xSheet.setMaxColNum(this.maxCol);
        int maxRowNum = 0;
        maxRowNum = maxRow != 0 ? (sheet.getLastRowNum() > maxRow ? maxRow : sheet.getLastRowNum()) : sheet.getLastRowNum();
        logger.info((Object)("\u5bfc\u5165Excel\u6700\u5927\u6761\u6570:" + maxRowNum));
        int r = 0;
        while (r <= maxRowNum) {
            Row row = sheet.getRow(r);
            if (!row.getZeroHeight()) {
                XRow xRow = new XRow();
                xRow.setRowIndex(r);
                int c = 0;
                while (c < this.maxCol) {
                    XCell xcell = this.getCell(sheet, r, c);
                    xRow.getCellList().add(xcell);
                    ++c;
                }
                xSheet.getRowList().add(xRow);
            }
            ++r;
        }
        this.sheetList.add(xSheet);
    }

    public void readExcel1Sheet(String fileName, InputStream fis, int maxRow, String sheetName) {
        try {
            this.workbook = WorkbookFactory.create((InputStream)fis);
            Sheet sheet = this.workbook.getSheet(sheetName);
            XSheet xSheet = new XSheet();
            xSheet.setLabel(sheet.getSheetName());
            xSheet.setDefaultCellWidth(sheet.getDefaultColumnWidth());
            xSheet.setDefaultRowHeight((int)sheet.getDefaultRowHeight());
            int sheetMergeCount = sheet.getNumMergedRegions();
            int i = 0;
            while (i < sheetMergeCount) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                this.cellRangeAddressList.add(ca);
                ++i;
            }
            this.readMaxCell(sheet);
            xSheet.setMaxColNum(this.maxCol);
            int maxRowNum = 0;
            maxRowNum = maxRow != 0 ? (sheet.getLastRowNum() > maxRow ? maxRow : sheet.getLastRowNum()) : sheet.getLastRowNum();
            int r = 0;
            while (r <= maxRowNum) {
                Row row = sheet.getRow(r);
                if (!row.getZeroHeight()) {
                    XRow xRow = new XRow();
                    xRow.setRowIndex(r);
                    int c = 0;
                    while (c < this.maxCol) {
                        XCell xcell = this.getCell(sheet, r, c);
                        xRow.getCellList().add(xcell);
                        ++c;
                    }
                    xSheet.getRowList().add(xRow);
                }
                ++r;
            }
            this.sheetList.add(xSheet);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        catch (InvalidFormatException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public XCell getCell(Sheet sheet, int rowIndex, int colIndex) {
        XCell c = new XCell();
        c.setColIndex(colIndex);
        c.setRowIndex(rowIndex);
        c.setWidth(sheet.getDefaultColumnWidth());
        Row row = sheet.getRow(rowIndex);
        if (row == null || row.getZeroHeight()) {
            return c;
        }
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            return c;
        }
        if (this.isMergedRegion(sheet, rowIndex, colIndex)) {
            int[] mergeRange = this.getMergedRegionRange(sheet, rowIndex, colIndex);
            if (mergeRange[0] == rowIndex && mergeRange[1] == colIndex) {
                c.setColSpan(mergeRange[3] - mergeRange[1] + 1);
                c.setRowSpan(mergeRange[2] - mergeRange[0] + 1);
            } else {
                c.setColSpan(0);
                c.setRowSpan(0);
            }
        } else {
            c.setColSpan(1);
            c.setRowSpan(1);
        }
        c.setValue(this.getValue(sheet, cell));
        c.setxCellStyle(new XCellStyle(cell.getCellStyle(), sheet.getWorkbook()));
        return c;
    }

    private Object getValue(Sheet sheet, Cell cell) {
        Cell newCell = null;
        int cellColIndex = cell.getColumnIndex();
        int cellRowIndex = cell.getRowIndex();
        if (this.isMergedRegion(sheet, cellRowIndex, cellColIndex)) {
            newCell = this.getMergedRegionCell(sheet, cellRowIndex, cellColIndex);
            return this.getCellValue(newCell);
        }
        return this.getCellValue(cell);
    }

    private Object getCellValue(Cell cell) {
        Object cellValue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case 1: {
                    cellValue = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().getString();
                    break;
                }
                case 0: {
                    Date date;
                    SimpleDateFormat format;
                    String cellString = cell.getCellStyle().getDataFormatString();
                    if (StringUtils.isNotBlank((String)cellString) && cellString.contains("h:mm:ss")) {
                        format = new SimpleDateFormat("HH:mm:ss");
                        date = cell.getDateCellValue();
                        cellValue = format.format(date);
                    }
                    if (DateUtil.isInternalDateFormat((int)cell.getCellStyle().getDataFormat())) {
                        format = new SimpleDateFormat("yyyyMMdd");
                        date = cell.getDateCellValue();
                        cellValue = format.format(date);
                    }
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        format = new SimpleDateFormat("yyyyMMdd");
                        date = cell.getDateCellValue();
                        cellValue = format.format(date);
                        break;
                    }
                    cell.setCellType(1);
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    cellValue = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                    break;
                }
                case 2: {
                    try {
                        cellValue = this.readNumericCell(cell);
                    }
                    catch (Exception e1) {
                        try {
                            cellValue = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().getString();
                        }
                        catch (Exception e2) {
                            cellValue = "{$ERROR_VALUE}";
                        }
                    }
                    break;
                }
                default: {
                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                }
            }
        }
        return cellValue;
    }

    private Object readNumericCell(Cell cell) {
        Number result = null;
        double value = (cell = this.evaluator.evaluateInCell(cell)).getNumericCellValue();
        result = (double)((int)value) == value ? (Number)((int)value) : (Number)value;
        return result;
    }

    private Cell getValue(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell = null;
        for (CellRangeAddress range : this.cellRangeAddressList) {
            if (!range.isInRange(rowIndex, colIndex)) continue;
            Row row = sheet.getRow(range.getFirstRow());
            cell = row.getCell(range.getFirstColumn());
            break;
        }
        return cell;
    }

    private boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row >= firstRow && row <= lastRow && column >= firstColumn && column <= lastColumn) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Cell getMergedRegionCell(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row >= firstRow && row <= lastRow && column >= firstColumn && column <= lastColumn) {
                Row fRow = sheet.getRow(firstRow);
                Cell fCell = fRow.getCell(firstColumn);
                return fCell;
            }
            ++i;
        }
        return null;
    }

    private int[] getMergedRegionRange(Sheet sheet, int row, int column) {
        int[] rtnVal = new int[4];
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row >= firstRow && row <= lastRow && column >= firstColumn && column <= lastColumn) {
                rtnVal[0] = firstRow;
                rtnVal[1] = firstColumn;
                rtnVal[2] = lastRow;
                rtnVal[3] = lastColumn;
                break;
            }
            ++i;
        }
        return rtnVal;
    }
}

