/*
 * Decompiled with CFR 0.152.
 */
package com.rw.major.service;

import com.rw.major.dao.PushdataFeedbackDao;
import com.rw.major.model.FcerBean;
import com.rw.major.model.FcrcDeBean;
import com.rw.major.model.FcrcDeRcifBean;
import com.rw.major.model.FcrcKyBean;
import com.rw.major.model.FeedBackBean;
import com.rw.major.service.PushdataFeedbackBusiness;
import com.rw.major.util.FeedBackXmlUtil;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PushdataFeedbackBusinessImpl
implements PushdataFeedbackBusiness {
    private static final Logger log = Logger.getLogger(PushdataFeedbackBusinessImpl.class);
    @Autowired
    private PushdataFeedbackDao dao;

    private int analysisFeedbackType(String pk) {
        String head = pk.substring(0, 4);
        if ("FDSC".equals(head)) {
            return 1;
        }
        if ("FDCF".equals(head)) {
            return 2;
        }
        if ("FDRC".equals(head)) {
            String sssh = pk.substring(6, 8);
            if ("SH".equals(sssh)) {
                return 3;
            }
            if ("SS".equals(sssh)) {
                return 4;
            }
        }
        return 0;
    }

    public boolean checkFileUploaded(String pk) {
        return this.dao.checkFileUploaded(pk);
    }

    public FeedBackBean analysisXml(InputStream is, String pk) throws DocumentException {
        FeedBackBean feedback = null;
        int fdbktype = this.analysisFeedbackType(pk);
        int start = pk.indexOf("[");
        int end = pk.indexOf("]");
        String reportinfo = pk.substring(start + 1, end);
        String reporttype = reportinfo.substring(0, 1);
        String reportname = reportinfo.substring(1);
        if (fdbktype == 1) {
            feedback = FeedBackXmlUtil.analysisFDSCFeedback((InputStream)is, (String)pk);
        } else if (fdbktype == 2) {
            feedback = FeedBackXmlUtil.analysisFDCFFeedback((InputStream)is, (String)pk);
        } else if (fdbktype == 3) {
            feedback = FeedBackXmlUtil.analysisFDRC_DE_Feedback((InputStream)is, (String)pk);
        } else if (fdbktype == 4) {
            feedback = FeedBackXmlUtil.analysisFDRC_KY_Feedback((InputStream)is, (String)pk);
        }
        if (feedback != null) {
            feedback.setFdbktype(Integer.valueOf(fdbktype));
            feedback.setReporttype(reporttype);
            feedback.setReportname(reportname);
        }
        return feedback;
    }

    public FeedBackBean dealReportStatusAndPreReport(FeedBackBean feedback) {
        String reporttype = feedback.getReporttype();
        Integer fdbktype = feedback.getFdbktype();
        String reportname = feedback.getReportname();
        if ("N".equals(reporttype) || "A".equals(reporttype)) {
            if (fdbktype == 1) {
                feedback.setStatus(Integer.valueOf(1));
            } else if (fdbktype == 2 || fdbktype == 3 || fdbktype == 4) {
                feedback.setStatus(Integer.valueOf(2));
            } else {
                feedback.setStatus(Integer.valueOf(0));
            }
        } else if ("R".equals(reporttype)) {
            if (this.dao.checkHasResentPreReport(reportname)) {
                if (fdbktype == 1) {
                    this.dao.updateResentPreReportStatus(reportname, Integer.valueOf(3));
                    feedback.setStatus(Integer.valueOf(1));
                } else if (fdbktype == 2) {
                    feedback.setStatus(Integer.valueOf(4));
                } else if (fdbktype == 3 || fdbktype == 4) {
                    this.dao.updateResentPreReportStatus(reportname, Integer.valueOf(3));
                    feedback.setStatus(Integer.valueOf(2));
                } else {
                    feedback.setStatus(Integer.valueOf(0));
                }
            } else {
                feedback.setStatus(Integer.valueOf(-1));
            }
        } else if ("I".equals(reporttype)) {
            if (this.dao.checkHasFillsentPreReport(reportname)) {
                if (fdbktype == 1) {
                    this.dao.updateFillsentPreReportStatus(reportname, Integer.valueOf(3));
                    feedback.setStatus(Integer.valueOf(1));
                } else if (fdbktype == 2) {
                    feedback.setStatus(Integer.valueOf(4));
                } else if (fdbktype == 3 || fdbktype == 4) {
                    feedback.setStatus(Integer.valueOf(4));
                } else {
                    feedback.setStatus(Integer.valueOf(0));
                }
            } else {
                feedback.setStatus(Integer.valueOf(-2));
            }
        } else if (fdbktype == 1) {
            feedback.setStatus(Integer.valueOf(1));
        } else if (fdbktype == 2 || fdbktype == 3 || fdbktype == 4) {
            feedback.setStatus(Integer.valueOf(4));
        } else {
            feedback.setStatus(Integer.valueOf(0));
        }
        return feedback;
    }

    public void addFeedBack(FeedBackBean feedback) {
        List fcrcKys;
        List fcrcDes;
        String fdbkid = feedback.getFdbkid();
        this.dao.addFeedback(feedback.getFdbkid(), feedback.getFdbktype(), feedback.getSfid(), feedback.getErtn(), feedback.getRctn(), feedback.getReporttype(), feedback.getReportname(), feedback.getStatus());
        List fcers = feedback.getFcers();
        if (fcers != null && !fcers.isEmpty()) {
            for (FcerBean fcer : fcers) {
                this.dao.addFcer(fcer.getFdbkid(), fcer.getFcerid(), fcer.getErlc(), fcer.getErrs());
            }
        }
        if ((fcrcDes = feedback.getFcrcdes()) != null && !fcrcDes.isEmpty()) {
            for (FcrcDeBean fcrcDe : fcrcDes) {
                this.dao.addFcrcDe(fcrcDe.getFdbkid(), fcrcDe.getFcrcid(), fcrcDe.getOcnm(), fcrcDe.getOtdt(), fcrcDe.getOtcd(), fcrcDe.getOtic());
                List rcifs = fcrcDe.getRcifs();
                if (rcifs == null || rcifs.isEmpty()) continue;
                for (FcrcDeRcifBean rcif : rcifs) {
                    this.dao.addFcrcDeRcif(rcif.getFdbkid(), rcif.getFcrcid(), rcif.getRcifid(), rcif.getRclc(), rcif.getRcsg());
                }
            }
        }
        if ((fcrcKys = feedback.getFcrckys()) != null && !fcrcKys.isEmpty()) {
            for (FcrcKyBean fcrcKy : fcrcKys) {
                this.dao.addFcrcKy(fcrcKy.getFdbkid(), fcrcKy.getFcrcid(), fcrcKy.getRclc(), fcrcKy.getRcsg());
            }
        }
    }
}

