/*
 * Decompiled with CFR 0.152.
 */
package com.rw.major.service;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import com.rw.major.dao.BlacklistDao;
import com.rw.major.model.BlacklistQEBean;
import com.rw.major.model.BlacklistQIBean;
import com.rw.major.service.BlacklistBusiness;
import com.rw.major.util.RegexConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BlacklistBusinessImpl
implements BlacklistBusiness {
    @Autowired
    private BlacklistDao dao;

    public void saveBlacklist(InputStream is) {
        String pdfContent = this.readPdfConetnt(is);
        String regexQI = RegexConfig.get((String)"regexQI");
        System.out.println("regexQI === " + regexQI);
        List resultQI = this.paser(pdfContent, regexQI);
        List qilist = this.convertToQI(resultQI);
        String regexQE = RegexConfig.get((String)"regexQE");
        System.out.println("regexQE === " + regexQE);
        List resultQE = this.paser(pdfContent, regexQE);
        List qelist = this.convertToQE(resultQE);
        System.out.println("qilist size === " + qilist.size());
        System.out.println("qelist size === " + qelist.size());
        if (qilist != null && !qilist.isEmpty()) {
            this.dao.saveQIBlacklist(qilist);
        }
        if (qelist != null && !qelist.isEmpty()) {
            this.dao.saveQEBlacklist(qelist);
        }
    }

    private String readPdfConetnt(InputStream is) {
        StringBuffer str = new StringBuffer();
        try {
            PdfReader reader = new PdfReader(is);
            int num = reader.getNumberOfPages();
            int i = 1;
            while (i <= num) {
                str.append(PdfTextExtractor.getTextFromPage((PdfReader)reader, (int)i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str.toString();
    }

    private List<List<String>> paser(String fileContent, String regex) {
        int flag = 0;
        flag |= 2;
        flag |= 8;
        Pattern p = Pattern.compile(regex, flag |= 0x20);
        Matcher m = p.matcher(fileContent);
        ArrayList<List<String>> rtn = new ArrayList<List<String>>();
        while (m.find()) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 1;
            while (i <= m.groupCount()) {
                list.add(m.group(i));
                ++i;
            }
            rtn.add(list);
        }
        return rtn;
    }

    private List<BlacklistQIBean> convertToQI(List<List<String>> resultQI) {
        ArrayList<BlacklistQIBean> list = new ArrayList<BlacklistQIBean>();
        for (List<String> qistr : resultQI) {
            BlacklistQIBean bean = new BlacklistQIBean();
            bean.setQino(qistr.get(0).trim());
            bean.setName(qistr.get(1));
            bean.setTitle(qistr.get(2).trim());
            bean.setDesignation(qistr.get(3).trim());
            bean.setDob(qistr.get(4).trim());
            bean.setPob(qistr.get(5).trim());
            bean.setGqaka(qistr.get(6).trim());
            bean.setLqaka(qistr.get(7).trim());
            bean.setNationality(qistr.get(8).trim());
            bean.setPassportno(qistr.get(9).trim());
            bean.setNationalidno(qistr.get(10).trim());
            bean.setAddress(qistr.get(11).trim());
            bean.setListedon(qistr.get(12).trim());
            bean.setOtherinfo(qistr.get(13).trim());
            list.add(bean);
        }
        return list;
    }

    private List<BlacklistQEBean> convertToQE(List<List<String>> resultQE) {
        ArrayList<BlacklistQEBean> list = new ArrayList<BlacklistQEBean>();
        for (List<String> qestr : resultQE) {
            BlacklistQEBean bean = new BlacklistQEBean();
            bean.setQeno(qestr.get(0).trim());
            bean.setName(qestr.get(1));
            bean.setAka(qestr.get(2).trim());
            bean.setFka(qestr.get(3).trim());
            bean.setAddress(qestr.get(4).trim());
            bean.setListedon(qestr.get(5).trim());
            bean.setOtherinfo(qestr.get(6).trim());
            list.add(bean);
        }
        return list;
    }
}

