/*
 * Decompiled with CFR 0.152.
 */
package com.rw.dao.assist;

import com.rw.model.sp.ProcedureArgument;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.CallableStatementCreator;

public class CallableStatementCreatorImpl
implements CallableStatementCreator {
    private List<ProcedureArgument> arguments;
    private String sql;

    public CallableStatementCreatorImpl(String sql, List<ProcedureArgument> arguments) {
        this.arguments = arguments;
        this.sql = sql;
    }

    public CallableStatement createCallableStatement(Connection conn) {
        CallableStatement cstmt = null;
        try {
            cstmt = conn.prepareCall(this.sql);
            int n = 1;
            for (ProcedureArgument argument : this.arguments) {
                if ("in".equalsIgnoreCase(argument.getDirection())) {
                    cstmt.setObject(argument.getIndex() != 0 ? argument.getIndex() : n, argument.getDefaultValue());
                } else {
                    cstmt.registerOutParameter(argument.getIndex() != 0 ? argument.getIndex() : n, (int)argument.getDataType());
                }
                ++n;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u67e5\u8be2\u9519\u8bef[createCallableStatement]:" + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u9519\u8bef[doInCallableStatement]:" + e.getMessage());
        }
        return cstmt;
    }
}

