/*
 * Decompiled with CFR 0.152.
 */
package com.rw.dao;

import com.rw.dao.BaseDAOImpl;
import com.rw.dao.FileDAO;
import com.rw.model.FileModel;
import com.wb.common.Base;
import com.wb.common.Var;
import com.wb.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="fileDAO")
public class FileDAOImpl
extends BaseDAOImpl
implements FileDAO {
    public List<String> getFiles(String sql) throws Exception {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> filePath = null;
        InputStream is = null;
        try {
            conn = this.getConnection();
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            if (rs != null) {
                filePath = new ArrayList<String>();
                while (rs.next()) {
                    String fileName = rs.getString("FILE_NAME");
                    String fileType = rs.getString("FILE_TYPE");
                    is = rs.getBinaryStream("FILE_DATA");
                    String downloadFilePath = Var.getString((String)"sys.controls.downloadFile");
                    File tempFile = null;
                    tempFile = StringUtils.isNotBlank((String)downloadFilePath) ? new File(String.valueOf(downloadFilePath) + File.separatorChar + fileName) : new File(Base.path, "template" + File.separatorChar + "tempFile" + File.separatorChar + fileName);
                    if (is == null) continue;
                    FileOutputStream outputStream = new FileOutputStream(tempFile);
                    IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                    is.close();
                    ((OutputStream)outputStream).close();
                    filePath.add(tempFile.getPath());
                }
            }
            ArrayList<String> arrayList = filePath;
            return arrayList;
        }
        catch (Exception e) {
            LogUtil.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                rs.close();
                st.close();
                conn.close();
            }
            catch (SQLException e) {
                LogUtil.error((Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public List<FileModel> getFilesByObjectId(String objectId) throws Exception {
        return this.getFileFromDB(objectId);
    }

    public FileModel getFilesById(String Id) throws Exception {
        return this.getFileByIdFromDB(Id);
    }
}

