/*
 * Decompiled with CFR 0.152.
 */
package com.rw.dao;

import com.rw.dao.BaseDAO;
import com.rw.dao.assist.CallableStatementCallbackImpl;
import com.rw.dao.assist.CallableStatementCreatorImpl;
import com.rw.model.FileModel;
import com.rw.model.sp.ProcedureArgument;
import com.rw.util.DbKit;
import com.wb.util.DbUtil;
import com.wb.util.LogUtil;
import com.xiaoleilu.hutool.date.DateUtil;
import com.xiaoleilu.hutool.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="baseDAO")
public class BaseDAOImpl
implements BaseDAO {
    private static final Logger logger = LoggerFactory.getLogger(BaseDAOImpl.class);
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public List<Map<String, Object>> findList(String sql) throws RuntimeException {
        List result = null;
        try {
            result = this.jdbcTemplate.queryForList(sql);
        }
        catch (DataAccessException da) {
            logger.error(da.getMessage());
            throw new RuntimeException(da.getMessage());
        }
        return result;
    }

    public List<Map<String, Object>> findList(String sql, Object ... args) throws RuntimeException {
        try {
            return this.jdbcTemplate.queryForList(sql, args);
        }
        catch (DataAccessException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public Long count(String sql, Object ... args) throws RuntimeException {
        return this.jdbcTemplate.queryForLong(sql, args);
    }

    public Map<String, Object> findList(String sql, int currentPage, int pageSize, Object ... args) throws RuntimeException {
        String countsql = "select count(*) as ctnt from (" + sql + ") t";
        Long count = this.count(countsql, args);
        String pagingSql = DbKit.getPageSQL((String)sql, (int)currentPage, (int)pageSize);
        List dataList = this.findList(pagingSql, args);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", count);
        result.put("data", dataList);
        return result;
    }

    public Map<String, Object> findOne(String sql) throws RuntimeException {
        return this.jdbcTemplate.queryForMap(sql);
    }

    public Map<String, Object> findOne(String sql, Object ... args) throws RuntimeException {
        return this.jdbcTemplate.queryForMap(sql, args);
    }

    public int insert(String sql) throws RuntimeException {
        return this.jdbcTemplate.update(sql);
    }

    public int insert(String sql, Object ... args) throws RuntimeException {
        return this.jdbcTemplate.update(sql, args);
    }

    public int update(String sql) throws RuntimeException {
        return this.insert(sql);
    }

    public int update(String sql, Object ... args) throws RuntimeException {
        return this.insert(sql, args);
    }

    public int del(String sql) throws RuntimeException {
        return this.jdbcTemplate.update(sql);
    }

    public int del(String sql, Object ... args) throws RuntimeException {
        return this.jdbcTemplate.update(sql, args);
    }

    public Map<String, Object> querySp(String spName, List<ProcedureArgument> arguments) throws RuntimeException {
        String finalSql = DbKit.callSp((String)spName, (int)arguments.size());
        Map result = (Map)this.jdbcTemplate.execute((CallableStatementCreator)new CallableStatementCreatorImpl(finalSql, arguments), (CallableStatementCallback)new CallableStatementCallbackImpl(arguments));
        return result;
    }

    public List<Map<String, Object>> querySpOnlyCusor(String spName, List<ProcedureArgument> arguments) throws RuntimeException {
        String finalSql = DbKit.callSp((String)spName, (int)arguments.size());
        Map result = (Map)this.jdbcTemplate.execute((CallableStatementCreator)new CallableStatementCreatorImpl(finalSql, arguments), (CallableStatementCallback)new CallableStatementCallbackImpl(arguments));
        return (List)result.get("total");
    }

    public Connection getConnection() throws RuntimeException {
        try {
            Connection conn = this.jdbcTemplate.getDataSource().getConnection();
            DbUtil.buffer.put(DateUtil.now(), conn);
            return conn;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u83b7\u53d6\u4e0d\u5230\u8fde\u63a5[getConnection]:" + e.getMessage());
        }
    }

    public int batchUpdateSql(List<String> sqlList) throws RuntimeException {
        String[] sqlArr = sqlList.toArray(new String[sqlList.size()]);
        int[] i = this.jdbcTemplate.batchUpdate(sqlArr);
        return i.length;
    }

    public int[] batchUpdateSql(String sql, List<Map<String, Object>> dataList, List<String> colNameList) throws RuntimeException {
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>(dataList.size());
        int colSize = colNameList.size();
        for (Map<String, Object> data : dataList) {
            Object[] batchArg = new Object[colSize];
            int index = 0;
            while (index < colSize) {
                batchArg[index] = data.get(colNameList.get(index));
                ++index;
            }
            batchArgs.add(batchArg);
        }
        return this.jdbcTemplate.batchUpdate(sql, batchArgs);
    }

    public List<FileModel> getFileFromDB(String objectId) throws RuntimeException {
        StringBuilder sql = new StringBuilder();
        ArrayList<FileModel> list = new ArrayList<FileModel>();
        sql.append("select c.CONTENT,c.ID,f.NAME,f.CREATE_BY,f.CREATE_TIME,f.FILE_PATH,f.FILE_SIZE,f.EXTENSION from wolfdata.t_file_content c,wolfdata.t_files f where c.id = f.id and f.OBJECT_ID =?");
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            st = conn.prepareStatement(sql.toString());
            st.setString(1, objectId);
            rs = st.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    FileModel fileModel = new FileModel();
                    String fileId = rs.getString("ID");
                    fileModel.setId(fileId);
                    fileModel.setCreateBy(rs.getString("CREATE_BY"));
                    fileModel.setCreateTime((Date)rs.getDate("CREATE_TIME"));
                    fileModel.setName(rs.getString("NAME"));
                    fileModel.setFilePath(rs.getString("FILE_PATH"));
                    fileModel.setFileSize(Long.valueOf(rs.getLong("FILE_SIZE")));
                    fileModel.setExtension(rs.getString("EXTENSION"));
                    String tempFileName = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + fileId;
                    Blob blob = rs.getBlob("CONTENT");
                    if (blob != null) {
                        InputStream is = blob.getBinaryStream();
                        FileOutputStream outputStream = new FileOutputStream(tempFileName);
                        IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                        is.close();
                        ((OutputStream)outputStream).close();
                    }
                    list.add(fileModel);
                }
                ArrayList<FileModel> arrayList = list;
                return arrayList;
            }
            return null;
        }
        catch (Exception e) {
            LogUtil.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                rs.close();
                st.close();
                conn.close();
            }
            catch (SQLException e) {
                LogUtil.error((Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public String saveFileToDB(FileModel fileModel, File tempFile) throws SQLException, RuntimeException {
        String fileInfoSql = "insert into wolfdata.t_files(ID,OBJECT_ID,NAME,FILE_SIZE,EXTENSION,CREATE_BY,CREATE_TIME,FILE_FLAG) values(?,?,?,?,?,?,sysdate,?)";
        String sql = "insert into wolfdata.t_file_content(id,content) values(?,?)";
        Connection conn = null;
        Statement st = null;
        Object rset = null;
        boolean defaultCommit = true;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            st = conn.prepareStatement(fileInfoSql);
            st.setString(1, fileModel.getId());
            st.setString(2, fileModel.getObjectId());
            st.setString(3, fileModel.getName());
            st.setDouble(4, fileModel.getFileSize().longValue());
            st.setString(5, fileModel.getExtension());
            st.setString(6, fileModel.getCreateBy());
            st.setString(7, fileModel.getFileFlag());
            st.executeUpdate();
            st.close();
            FileInputStream inputStream = new FileInputStream(tempFile);
            st = conn.prepareStatement(sql);
            st.setString(1, fileModel.getId());
            st.setBlob(2, inputStream);
            st.executeUpdate();
            st.close();
            ((InputStream)inputStream).close();
            tempFile.delete();
            conn.commit();
            String string = fileModel.getId();
            return string;
        }
        catch (Exception e) {
            conn.rollback();
            LogUtil.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                conn.setAutoCommit(defaultCommit);
                st.close();
                conn.close();
            }
            catch (SQLException e) {
                LogUtil.error((Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public FileModel getFileByIdFromDB(String id) throws RuntimeException {
        StringBuilder sql = new StringBuilder();
        sql.append("select c.CONTENT,c.ID,f.NAME,f.CREATE_BY,f.CREATE_TIME,f.FILE_PATH,f.FILE_SIZE,f.EXTENSION from wolfdata.t_file_content c,wolfdata.t_files f where c.id = f.id and f.id =?");
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            st = conn.prepareStatement(sql.toString());
            st.setString(1, id);
            rs = st.executeQuery();
            if (rs != null && rs.next()) {
                FileModel fileModel = new FileModel();
                String fileId = rs.getString("ID");
                fileModel.setId(fileId);
                fileModel.setCreateBy(rs.getString("CREATE_BY"));
                fileModel.setCreateTime((Date)rs.getDate("CREATE_TIME"));
                fileModel.setName(rs.getString("NAME"));
                fileModel.setFilePath(rs.getString("FILE_PATH"));
                fileModel.setFileSize(Long.valueOf(rs.getLong("FILE_SIZE")));
                fileModel.setExtension(rs.getString("EXTENSION"));
                String tempFileName = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + fileId;
                Blob blob = rs.getBlob("CONTENT");
                if (blob != null) {
                    InputStream is = blob.getBinaryStream();
                    FileOutputStream outputStream = new FileOutputStream(tempFileName);
                    IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                    is.close();
                    ((OutputStream)outputStream).close();
                } else {
                    FileUtil.file((String)tempFileName);
                }
                FileModel fileModel2 = fileModel;
                return fileModel2;
            }
            return null;
        }
        catch (Exception e) {
            LogUtil.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                rs.close();
                st.close();
                conn.close();
            }
            catch (SQLException e) {
                LogUtil.error((Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

