/*
 * Decompiled with CFR 0.152.
 */
package com.rw.csdc.service;

import com.hundsun.t2sdk.common.core.context.ContextUtil;
import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.interfaces.IClient;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasets;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.rw.annotation.SystemServiceLog;
import com.rw.csdc.dao.CsdcClientCheckDAO;
import com.rw.csdc.service.CsdcClientCheckService;
import com.rw.util.CommonException;
import com.rw.util.PropKit;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csdcClientCheckService")
@Transactional(isolation=Isolation.DEFAULT, rollbackFor={CommonException.class})
public class CsdcClientCheckServiceImpl
implements CsdcClientCheckService {
    private static final Logger logger = LoggerFactory.getLogger(CsdcClientCheckServiceImpl.class);
    private static String op_branch_no;
    private static String op_station;
    private static String op_entrust_way;
    private static String branch_no;
    private static T2Services sdkServices;
    @Autowired
    CsdcClientCheckDAO csdcClientCheckDAO;

    @SystemServiceLog(description="\u901a\u8fc7\u5458\u5de5\u8eab\u4efd\u8bc1\u53f7\u7801\u83b7\u53d6\u4e2d\u767b\u8d26\u53f7\u5b9a\u4f4d\u4e32\u4fe1\u606f")
    public Map<String, Object> getPositionStr(String csdc_id_no, String csdc_id_kind, String csdc_client_name, int gt_busin_checkflag, String userId, String flag) throws CommonException {
        logger.info("******************\u63a5\u53e3\uff1a10201093:\u5f00\u59cb******************");
        Map<String, Object> resultMap = new HashMap<String, Object>();
        IClient client = null;
        try {
            boolean businessBeginFlag;
            IEvent rsp;
            logger.info("*******************\u5f00\u59cb\u540c\u6b65\u53d1\u9001*******************");
            if ("1".equals(flag)) {
                logger.info("********************\u63a5\u53e3\uff1a10201093,\u670d\u52a1\u5f00\u5173\u5224\u65ad\uff1a\u5f00\u59cb*******************");
                logger.info("************\u83b7\u53d6IClient********************");
                client = sdkServices.getClient("myserver");
                IEvent event = this.getEvent(1, csdc_id_no, csdc_id_kind, csdc_client_name, userId);
                rsp = client.sendReceive(event, 10000L);
                resultMap = this.getPostion(rsp);
                logger.info("********************\u63a5\u53e3\uff1a10201093,\u670d\u52a1\u5f00\u5173\u5224\u65ad:\u7ed3\u675f{}*******************", (Object)resultMap.toString());
            }
            boolean bl = businessBeginFlag = "0".equals(flag) || !resultMap.isEmpty() && resultMap.containsKey("deal_flag") && "0".equals(resultMap.get("deal_flag"));
            if (businessBeginFlag) {
                logger.info("*******************\u63a5\u53e3\uff1a10201093,\u5f00\u59cb\u529e\u7406\u4e1a\u52a1,\u83b7\u53d6position_str\u5f00\u59cb*******************");
                logger.info("************\u83b7\u53d6IClient********************");
                client = sdkServices.getClient("myserver");
                IEvent event = this.getEvent(0, csdc_id_no, csdc_id_kind, csdc_client_name, userId);
                rsp = client.sendReceive(event, 10000L);
                resultMap = this.getPostion(rsp);
                logger.info("*******************\u63a5\u53e3\uff1a10201093,\u5f00\u59cb\u529e\u7406\u4e1a\u52a1,\u83b7\u53d6position_str\u7ed3\u675f{}*******************", (Object)resultMap.toString());
                if (resultMap.containsKey("position_str") && StrUtil.isNotBlank((CharSequence)resultMap.get("position_str").toString())) {
                    String assettrans_status;
                    Map status;
                    String positionStr = resultMap.get("position_str").toString();
                    do {
                        status = this.getStatus(positionStr, userId);
                        logger.info("***************\u63a5\u53e3\uff1a10200532\u8f6e\u8bad\u4e2d\u767b\u56de\u62a5\u72b6\u6001\uff1a\u5f00\u59cb*************************");
                    } while (!status.containsKey("assettrans_status") || !"8".equals(assettrans_status = (String)status.get("assettrans_status")) && !"9".equals(assettrans_status));
                    logger.info("***************\u63a5\u53e3\uff1a10200532\u8f6e\u8bad\u4e2d\u767b\u56de\u62a5\u72b6\u6001:\u7ed3\u675f,assettrans_status={}*************************", status.get("assettrans_status"));
                    if (StrUtil.isNotBlank((CharSequence)assettrans_status) && "9".equals(assettrans_status)) {
                        logger.info("***************\u63a5\u53e3\uff1a10200532\u8f6e\u8bad\u4e2d\u767b\u56de\u62a5\u72b6\u6001\uff1a\u5931\u8d25*************************");
                        resultMap.put("deal_flag", status.get("deal_flag"));
                        resultMap.put("deal_info", (String)status.get("deal_info") + ",\u8f6e\u8bad\u4e2d\u767b\u56de\u62a5\u72b6\u6001\u5931\u8d25");
                    } else {
                        logger.info("***************\u63a5\u53e3\uff1a10200532\u8f6e\u8bad\u4e2d\u767b\u56de\u62a5\u72b6\u6001:\u6210\u529f*************************");
                        resultMap = this.getCsdcInfo(positionStr, userId);
                        logger.info("*************\u63a5\u53e3\uff1a10201090\u8c03\u7528\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)resultMap.toString());
                    }
                }
            } else {
                logger.info("*******************\u63a5\u53e3\uff1a10201093\u65e0\u6cd5\u63d0\u4f9b\u670d\u52a1*******************");
            }
        }
        catch (T2SDKException e1) {
            logger.error("getPositionStr{}", (Object)e1.getMessage());
            resultMap.put("error", e1.getMessage());
            throw new CommonException(e1.getMessage());
        }
        catch (Exception e) {
            logger.error("getPositionStr{}", (Object)e.getMessage());
            resultMap.put("error", e.getMessage());
            throw new CommonException(e.getMessage());
        }
        return resultMap;
    }

    @SystemServiceLog(description="\u901a\u8fc7\u5458\u5de5\u5b9a\u4f4d\u4e32\u83b7\u53d6\u5458\u5de5\u7684\u53f8\u5916\u8d26\u6237\u4fe1\u606f")
    public Map<String, Object> getCsdcInfo(String positionStr, String userId) throws CommonException {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        logger.info("*******************\u63a5\u53e3\uff1a10201090\u5f00\u59cb\u8c03\u7528\uff0c\u901a\u8fc7\u5b9a\u4f4d\u4e32\u4fe1\u606f\u8fd4\u56de\u5458\u5de5\u8d26\u6237\u8be6\u60c5:\u5f00\u59cb*******************");
        try {
            IClient client = sdkServices.getClient("myserver");
            logger.info("*******************\u6210\u529f\u83b7\u53d6IClient*******************");
            IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10201090", 0);
            IDataset iDataset = DatasetService.getDefaultInstance().getDataset();
            iDataset.addColumn("op_branch_no");
            iDataset.addColumn("operator_no");
            iDataset.addColumn("user_type");
            iDataset.addColumn("op_password");
            iDataset.addColumn("op_station");
            iDataset.addColumn("op_entrust_way");
            iDataset.addColumn("menu_id");
            iDataset.addColumn("function_id");
            iDataset.addColumn("branch_no");
            iDataset.addColumn("audit_action");
            iDataset.addColumn("position_str");
            iDataset.appendRow();
            logger.info("*******************\u6784\u9020dataset\u6570\u636e\u4fe1\u606fuserId={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};positionStr={}*******************", new Object[]{userId, op_branch_no, op_station, op_entrust_way, branch_no, positionStr});
            iDataset.updateString("op_branch_no", op_branch_no);
            iDataset.updateString("operator_no", userId);
            iDataset.updateString("user_type", "");
            iDataset.updateString("op_password", "");
            iDataset.updateString("op_station", op_station);
            iDataset.updateString("op_entrust_way", op_entrust_way);
            iDataset.updateString("menu_id", "");
            iDataset.updateString("function_id", "");
            iDataset.updateString("branch_no", branch_no);
            iDataset.updateString("audit_action", "");
            iDataset.updateString("position_str", positionStr);
            event.putEventData(iDataset);
            logger.info("*******************\u5f00\u59cb\u540c\u6b65\u53d1\u9001*******************");
            IEvent rsp = client.sendReceive(event, 10000L);
            logger.info("*******************\u5f00\u59cb\u83b7\u53d6\u540c\u6b65\u53d1\u9001\u7ed3\u679creturnCode:{}*******************", (Object)rsp.getReturnCode());
            if (rsp.getReturnCode() != 0) {
                result.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
                logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
            } else {
                logger.info("*******************\u5f00\u59cb\u83b7\u53d6IDatasets*******************");
                IDatasets eventDatas = rsp.getEventDatas();
                logger.info("*******************\u83b7\u53d6IDatasets\u4e2d\u5171\u6709{}\u4e2adataSet*******************", (Object)eventDatas.getDatasetCount());
                for (int i = 0; i < eventDatas.getDatasetCount(); ++i) {
                    logger.info("*******************DataSetName={}*******************", (Object)eventDatas.getDatasetName(i));
                    IDataset ds = eventDatas.getDataset(i);
                    if (null != ds) {
                        int j;
                        logger.info("*******************dataSetName\u7684\u7ed3\u679c\u96c6\u5b58\u5728*******************");
                        ArrayList resultList = new ArrayList();
                        int columnCount = ds.getColumnCount();
                        int index = 1;
                        logger.info("*******************\u83b7\u53d6Dataset\u7684columnCount={}*******************", (Object)columnCount);
                        for (j = 1; j <= columnCount; ++j) {
                            logger.info("\u7b2c{}\u5217\uff1a\u5217\u540d={},\u5217\u7c7b\u578b={}", new Object[]{j, ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                        }
                        ds.beforeFirst();
                        logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u884c,\u5171{}\u884c\u6570\u636e*******************", (Object)ds.getRowCount());
                        while (ds.hasNext()) {
                            logger.info("*******************\u7b2c{}\u884c*******************", (Object)index);
                            ds.next();
                            ++index;
                            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(columnCount);
                            logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u5217*******************");
                            block26: for (j = 1; j <= columnCount; ++j) {
                                String columnName = ds.getColumnName(j);
                                char columnType = ds.getColumnType(j);
                                logger.info("*******************\u7b2c{}\u5217\uff1acolumnName={},columnType={}*******************", new Object[]{j, columnName, Character.valueOf(columnType)});
                                switch (columnName) {
                                    case "csdc_stock_account": {
                                        String csdc_stock_account = ds.getString("csdc_stock_account");
                                        resultMap.put("csdc_stock_account", csdc_stock_account);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u8bc1\u5238\u8d26\u6237\u4fe1\u606f:" + csdc_stock_account);
                                        continue block26;
                                    }
                                    case "csdc_holder_status": {
                                        String csdc_holder_status = ds.getString("csdc_holder_status");
                                        resultMap.put("csdc_holder_status", csdc_holder_status);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba\u72b6\u6001\u4fe1\u606f:" + csdc_holder_status);
                                        continue block26;
                                    }
                                    case "csdc_acode_account": {
                                        String csdc_acode_account = ds.getString("csdc_acode_account");
                                        resultMap.put("csdc_acode_account", csdc_acode_account);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u4e00\u7801\u901a\u8d26\u6237\u4fe1\u606f:" + csdc_acode_account);
                                        continue block26;
                                    }
                                    case "csdc_id_no": {
                                        String csdc_id_no = ds.getString("csdc_id_no");
                                        resultMap.put("csdc_id_no", csdc_id_no);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u8bc1\u4ef6\u53f7\u4fe1\u606f:" + csdc_id_no);
                                        continue block26;
                                    }
                                    case "csdc_id_kind": {
                                        String csdc_id_kind = ds.getString("csdc_id_kind");
                                        resultMap.put("csdc_id_kind", csdc_id_kind);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u8bc1\u4ef6\u7c7b\u578b\u4fe1\u606f:" + csdc_id_kind);
                                        continue block26;
                                    }
                                    case "csdc_client_name": {
                                        String csdc_client_name = ds.getString("csdc_client_name");
                                        resultMap.put("csdc_client_name", csdc_client_name);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u59d3\u540d\u4fe1\u606f:" + csdc_client_name);
                                        continue block26;
                                    }
                                    case "csdc_open_organ_name": {
                                        String csdc_open_organ_name = ds.getString("csdc_open_organ_name");
                                        resultMap.put("csdc_open_organ_name", csdc_open_organ_name);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u5238\u5546\u4fe1\u606f:" + csdc_open_organ_name);
                                        continue block26;
                                    }
                                    case "csdc_open_date": {
                                        String csdc_open_date = ds.getString("csdc_open_date");
                                        resultMap.put("csdc_open_date", csdc_open_date);
                                        logger.debug("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u5f00\u6237\u65e5\u671f\u4fe1\u606f:" + csdc_open_date);
                                        continue block26;
                                    }
                                }
                            }
                            resultList.add(resultMap);
                        }
                        result.put("dataSet", resultList);
                        continue;
                    }
                    logger.info("*******************\u83b7\u53d6IDataset\u4e0d\u5b58\u5728*******************");
                }
            }
        }
        catch (T2SDKException e1) {
            logger.error("getCsdcInfo\u53d1\u751f\u9519\u8befT2SDKException\uff1a{}", (Object)e1.getMessage());
            result.put("error", e1.getMessage());
            throw new CommonException(e1.getMessage());
        }
        catch (Exception e) {
            logger.error("getCsdcInfo\u53d1\u751f\u9519\u8befException\uff1a{}", (Object)e.getMessage());
            result.put("error", e.getMessage());
            throw new CommonException(e.getMessage());
        }
        logger.info("*******************\u901a\u8fc7\u5b9a\u4f4d\u4e32\u4fe1\u606f\u8fd4\u56de\u5458\u5de5\u8d26\u6237\u8be6\u60c5:\u7ed3\u675f*******************");
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String addClient(List<Map<String, String>> csdcInfo, String batch, String idNo, String userId) throws CommonException {
        String msg;
        ArrayList<Object[]> argValues = new ArrayList<Object[]>();
        for (Map<String, String> csdc : csdcInfo) {
            ArrayList<String> values = new ArrayList<String>(9);
            if (StringUtils.isBlank((String)csdc.get("csdc_stock_account"))) continue;
            values.add(this.getUUID());
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_stock_account"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_holder_status"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_acode_account"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_id_no"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_id_kind"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_client_name"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_open_organ_name"), (String)""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_open_date"), (String)""));
            values.add(userId);
            values.add(idNo);
            values.add(batch);
            argValues.add(values.toArray());
        }
        if (argValues.isEmpty()) {
            this.csdcClientCheckDAO.updateBatchStatus(idNo, batch, 1, userId);
            return "\u65e0\u6709\u6548\u7684\u5458\u5de5\u8bc1\u5238\u8d26\u6237\u4fe1\u606f\u5b58\u5728\uff01";
        }
        boolean flag = this.csdcClientCheckDAO.addClientInfo(argValues);
        if (flag) {
            this.csdcClientCheckDAO.updateBatchStatus(idNo, batch, 1, userId);
            msg = "\u5458\u5de5\u8bc1\u5238\u8d26\u6237\u4fe1\u606f\u6210\u529f\u5165\u5e93\uff01";
        } else {
            this.csdcClientCheckDAO.updateBatchStatus(idNo, batch, 2, userId);
            msg = "\u5458\u5de5\u8bc1\u5238\u8d26\u6237\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff01";
        }
        return msg;
    }

    public String createAllBatchData() throws CommonException {
        return this.csdcClientCheckDAO.inertAllBatchData();
    }

    public String insertPartBatchData(String[] idArr, String[] idNoArr, String[] nameArr) throws CommonException {
        return this.csdcClientCheckDAO.insertBatchData(Arrays.asList(idArr), Arrays.asList(idNoArr), Arrays.asList(nameArr));
    }

    @Transactional(rollbackFor={CommonException.class}, propagation=Propagation.REQUIRED)
    public boolean updateBatchStatus(String no, String batch, int status, String userId) throws CommonException {
        return this.csdcClientCheckDAO.updateBatchStatus(no, batch, status, userId);
    }

    private String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private Map<String, Object> getPostion(IEvent rsp) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        logger.info("*******************\u5f00\u59cb\u83b7\u53d6\u540c\u6b65\u53d1\u9001\u7ed3\u679creturnCode:{}*******************", (Object)rsp.getReturnCode());
        if (rsp.getReturnCode() != 0) {
            resultMap.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
            logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
        } else {
            logger.info("*******************\u5f00\u59cb\u83b7\u53d6IDatasets*******************");
            IDatasets result = rsp.getEventDatas();
            IDataset ds = null;
            int datasetCount = result.getDatasetCount();
            logger.info("*******************\u5171\u6709{}\u4e2adataset*******************", (Object)datasetCount);
            for (int i = 0; i < datasetCount; ++i) {
                logger.info("*******************datasetName={}*******************", (Object)result.getDatasetName(i));
                ds = result.getDataset(i);
                if (null != ds) {
                    int j;
                    logger.info("*******************dataSetName={}\u7684\u7ed3\u679c\u96c6\u5b58\u5728*******************", (Object)ds.getDatasetName());
                    int columnCount = ds.getColumnCount();
                    int index = 1;
                    logger.info("*******************\u83b7\u53d6Dataset\u7684columnCount={}*******************", (Object)columnCount);
                    for (j = 1; j <= columnCount; ++j) {
                        logger.info("\u7b2c{}\u5217\uff1a\u5217\u540d={},\u5217\u7c7b\u578b={}", new Object[]{j, ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                    }
                    ds.beforeFirst();
                    logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u884c,\u5171{}\u884c\u6570\u636e*******************", (Object)ds.getRowCount());
                    while (ds.hasNext()) {
                        logger.info("*******************\u7b2c{}\u884c*******************", (Object)index);
                        ds.next();
                        ++index;
                        logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u5217*******************");
                        block13: for (j = 1; j <= columnCount; ++j) {
                            String columnName = ds.getColumnName(j);
                            char columnType = ds.getColumnType(j);
                            logger.info("*******************\u7b2c{}\u5217\uff1acolumnName={},columnType={}*******************", new Object[]{j, columnName, Character.valueOf(columnType)});
                            switch (columnName) {
                                case "position_str": {
                                    String position_str = ds.getString("position_str");
                                    resultMap.put("position_str", position_str);
                                    logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-position_str:" + position_str);
                                    continue block13;
                                }
                                case "deal_flag": {
                                    String deal_flag = ds.getString("deal_flag");
                                    resultMap.put("deal_flag", deal_flag);
                                    logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-deal_flag:" + deal_flag);
                                    continue block13;
                                }
                                case "deal_info": {
                                    String deal_info = ds.getString("deal_info");
                                    resultMap.put("deal_info", deal_info);
                                    logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-deal_info:" + deal_info);
                                    continue block13;
                                }
                            }
                        }
                    }
                    continue;
                }
                logger.info("*******************\u83b7\u53d6IDataset\u4e0d\u5b58\u5728*******************");
            }
        }
        return resultMap;
    }

    private Map<String, Object> getCsdc(String positionStr, String userId) throws CommonException {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        logger.info("*******************\u63a5\u53e3\uff1a10201090\u5f00\u59cb\u8c03\u7528\uff0c\u901a\u8fc7\u5b9a\u4f4d\u4e32\u4fe1\u606f\u8fd4\u56de\u5458\u5de5\u8d26\u6237\u8be6\u60c5:\u5f00\u59cb*******************");
        try {
            IClient client = sdkServices.getClient("myserver");
            IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10201090", 0);
            IDataset iDataset = DatasetService.getDefaultInstance().getDataset();
            iDataset.addColumn("op_branch_no");
            iDataset.addColumn("operator_no");
            iDataset.addColumn("user_type");
            iDataset.addColumn("op_password");
            iDataset.addColumn("op_station");
            iDataset.addColumn("op_entrust_way");
            iDataset.addColumn("menu_id");
            iDataset.addColumn("function_id");
            iDataset.addColumn("branch_no");
            iDataset.addColumn("audit_action");
            iDataset.addColumn("position_str");
            iDataset.appendRow();
            logger.info("*******************\u6784\u9020dataset\u6570\u636e\u4fe1\u606fuser_Id={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};positionStr={}*******************", new Object[]{userId, op_branch_no, op_station, op_entrust_way, branch_no, positionStr});
            iDataset.updateString("op_branch_no", op_branch_no);
            iDataset.updateString("operator_no", userId);
            iDataset.updateString("user_type", "");
            iDataset.updateString("op_password", "");
            iDataset.updateString("op_station", op_station);
            iDataset.updateString("op_entrust_way", op_entrust_way);
            iDataset.updateString("menu_id", "");
            iDataset.updateString("function_id", "");
            iDataset.updateString("branch_no", branch_no);
            iDataset.updateString("audit_action", "");
            iDataset.updateString("position_str", positionStr);
            event.putEventData(iDataset);
            logger.info("*******************\u5f00\u59cb\u540c\u6b65\u53d1\u9001*******************");
            IEvent rsp = client.sendReceive(event, 10000L);
            logger.info("*******************\u5f00\u59cb\u83b7\u53d6\u540c\u6b65\u53d1\u9001\u7ed3\u679creturnCode:{}*******************", (Object)rsp.getReturnCode());
            if (rsp.getReturnCode() != 0) {
                result.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
                logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
            } else {
                logger.info("*******************\u5f00\u59cb\u83b7\u53d6IDatasets*******************");
                IDatasets eventDatas = rsp.getEventDatas();
                logger.info("*******************\u83b7\u53d6IDatasets\u4e2d\u5171\u6709{}\u4e2adataSet*******************", (Object)eventDatas.getDatasetCount());
                for (int i = 0; i < eventDatas.getDatasetCount(); ++i) {
                    logger.info("*******************DataSetName={}*******************", (Object)eventDatas.getDatasetName(i));
                    IDataset ds = eventDatas.getDataset(i);
                    if (null != ds) {
                        int j;
                        logger.info("*******************dataSetName={}\u7684\u7ed3\u679c\u96c6\u5b58\u5728*******************", (Object)ds.getDatasetName());
                        ArrayList resultList = new ArrayList();
                        int columnCount = ds.getColumnCount();
                        int index = 1;
                        logger.info("*******************\u83b7\u53d6Dataset\u7684columnCount={}*******************", (Object)columnCount);
                        for (j = 1; j <= columnCount; ++j) {
                            logger.info("\u7b2c{}\u5217\uff1a\u5217\u540d={},\u5217\u7c7b\u578b={}", new Object[]{j, ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                        }
                        ds.beforeFirst();
                        logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u884c,\u5171{}\u884c\u6570\u636e*******************", (Object)ds.getRowCount());
                        while (ds.hasNext()) {
                            logger.info("*******************\u7b2c{}\u884c*******************", (Object)index);
                            ds.next();
                            ++index;
                            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(columnCount);
                            logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u5217*******************");
                            block26: for (j = 1; j <= columnCount; ++j) {
                                String columnName = ds.getColumnName(j);
                                char columnType = ds.getColumnType(j);
                                logger.info("*******************\u7b2c{}\u5217\uff1acolumnName={},columnType={}*******************", new Object[]{j, columnName, Character.valueOf(columnType)});
                                switch (columnName) {
                                    case "csdc_stock_account": {
                                        String csdc_stock_account = ds.getString("csdc_stock_account");
                                        resultMap.put("csdc_stock_account", csdc_stock_account);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u8bc1\u5238\u8d26\u6237\u4fe1\u606f:" + csdc_stock_account);
                                        continue block26;
                                    }
                                    case "csdc_holder_status": {
                                        String csdc_holder_status = ds.getString("csdc_holder_status");
                                        resultMap.put("csdc_holder_status", csdc_holder_status);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba\u72b6\u6001\u4fe1\u606f:" + csdc_holder_status);
                                        continue block26;
                                    }
                                    case "csdc_acode_account": {
                                        String csdc_acode_account = ds.getString("csdc_acode_account");
                                        resultMap.put("csdc_acode_account", csdc_acode_account);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u4e00\u7801\u901a\u8d26\u6237\u4fe1\u606f:" + csdc_acode_account);
                                        continue block26;
                                    }
                                    case "csdc_id_no": {
                                        String csdc_id_no = ds.getString("csdc_id_no");
                                        resultMap.put("csdc_id_no", csdc_id_no);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u8bc1\u4ef6\u53f7\u4fe1\u606f:" + csdc_id_no);
                                        continue block26;
                                    }
                                    case "csdc_id_kind": {
                                        String csdc_id_kind = ds.getString("csdc_id_kind");
                                        resultMap.put("csdc_id_kind", csdc_id_kind);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u8bc1\u4ef6\u7c7b\u578b\u4fe1\u606f:" + csdc_id_kind);
                                        continue block26;
                                    }
                                    case "csdc_client_name": {
                                        String csdc_client_name = ds.getString("csdc_client_name");
                                        resultMap.put("csdc_client_name", csdc_client_name);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u59d3\u540d\u4fe1\u606f:" + csdc_client_name);
                                        continue block26;
                                    }
                                    case "csdc_open_organ_name": {
                                        String csdc_open_organ_name = ds.getString("csdc_open_organ_name");
                                        resultMap.put("csdc_open_organ_name", csdc_open_organ_name);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u5238\u5546\u4fe1\u606f:" + csdc_open_organ_name);
                                        continue block26;
                                    }
                                    case "csdc_open_date": {
                                        String csdc_open_date = ds.getString("csdc_open_date");
                                        resultMap.put("csdc_open_date", csdc_open_date);
                                        logger.info("\u5458\u5de5\u53f8\u5916\u8d26\u6237\u4eba-\u5f00\u6237\u65e5\u671f\u4fe1\u606f:" + csdc_open_date);
                                        continue block26;
                                    }
                                }
                            }
                            resultList.add(resultMap);
                        }
                        result.put("dataSet", resultList);
                        continue;
                    }
                    logger.info("*******************\u83b7\u53d6IDataset\u4e0d\u5b58\u5728*******************");
                }
            }
        }
        catch (T2SDKException e1) {
            logger.error("getCsdc\u53d1\u751f\u9519\u8befT2SDKException\uff1a{}", (Object)e1.getMessage());
            result.put("error", e1.getMessage());
            throw new CommonException(e1.getMessage());
        }
        catch (Exception e) {
            logger.error("getCsdc\u53d1\u751f\u9519\u8befException\uff1a{}", (Object)e.getMessage());
            result.put("error", e.getMessage());
            throw new CommonException(e.getMessage());
        }
        logger.info("*******************\u63a5\u53e3\uff1a10201090\u901a\u8fc7\u5b9a\u4f4d\u4e32\u4fe1\u606f\u8fd4\u56de\u5458\u5de5\u8d26\u6237\u8be6\u60c5:\u7ed3\u675f*******************");
        return result;
    }

    private Map<String, String> getStatus(String positionStr, String userId) throws CommonException {
        HashMap<String, String> result;
        block25: {
            result = new HashMap<String, String>(2);
            logger.info("*******************\u63a5\u53e3\uff1a10200532\u5f00\u59cb\u8c03\u7528\uff0c\u901a\u8fc7\u5b9a\u4f4d\u4e32\u4fe1\u606f\u8fd4\u56de\u72b6\u6001\u4fe1\u606f:\u5f00\u59cb*******************");
            try {
                IClient client = sdkServices.getClient("myserver");
                IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10200532", 0);
                IDataset iDataset = DatasetService.getDefaultInstance().getDataset();
                iDataset.addColumn("op_branch_no");
                iDataset.addColumn("operator_no");
                iDataset.addColumn("user_type");
                iDataset.addColumn("op_password");
                iDataset.addColumn("op_station");
                iDataset.addColumn("op_entrust_way");
                iDataset.addColumn("menu_id");
                iDataset.addColumn("function_id");
                iDataset.addColumn("branch_no");
                iDataset.addColumn("audit_action");
                iDataset.addColumn("position_str");
                iDataset.appendRow();
                logger.info("*******************\u6784\u9020dataset\u6570\u636e\u4fe1\u606fuser_Id={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};positionStr={}*******************", new Object[]{userId, op_branch_no, op_station, op_entrust_way, branch_no, positionStr});
                iDataset.updateString("op_branch_no", op_branch_no);
                iDataset.updateString("operator_no", userId);
                iDataset.updateString("user_type", "");
                iDataset.updateString("op_password", "");
                iDataset.updateString("op_station", op_station);
                iDataset.updateString("op_entrust_way", op_entrust_way);
                iDataset.updateString("menu_id", "");
                iDataset.updateString("function_id", "");
                iDataset.updateString("branch_no", branch_no);
                iDataset.updateString("audit_action", "");
                iDataset.updateString("position_str", positionStr);
                event.putEventData(iDataset);
                logger.info("*******************\u5f00\u59cb\u540c\u6b65\u53d1\u9001*******************");
                IEvent rsp = client.sendReceive(event, 10000L);
                logger.info("*******************\u5f00\u59cb\u83b7\u53d6\u540c\u6b65\u53d1\u9001\u7ed3\u679creturnCode:{}*******************", (Object)rsp.getReturnCode());
                if (rsp.getReturnCode() != 0) {
                    result.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
                    logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
                    break block25;
                }
                logger.info("*******************\u5f00\u59cb\u83b7\u53d6IDatasets*******************");
                IDatasets eventDatas = rsp.getEventDatas();
                logger.info("*******************\u83b7\u53d6IDatasets\u4e2d\u5171\u6709{}\u4e2adataSet*******************", (Object)eventDatas.getDatasetCount());
                for (int i = 0; i < eventDatas.getDatasetCount(); ++i) {
                    logger.info("*******************DataSetName={}*******************", (Object)eventDatas.getDatasetName(i));
                    IDataset ds = eventDatas.getDataset(i);
                    if (null != ds) {
                        int j;
                        logger.info("*******************dataSetName={}\u7684\u7ed3\u679c\u96c6\u5b58\u5728*******************", (Object)ds.getDatasetName());
                        int columnCount = ds.getColumnCount();
                        int index = 1;
                        logger.info("*******************\u83b7\u53d6Dataset\u7684columnCount={}*******************", (Object)columnCount);
                        for (j = 1; j <= columnCount; ++j) {
                            logger.info("\u7b2c{}\u5217\uff1a\u5217\u540d={},\u5217\u7c7b\u578b={}", new Object[]{j, ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                        }
                        ds.beforeFirst();
                        logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u884c,\u5171{}\u884c\u6570\u636e*******************", (Object)ds.getRowCount());
                        while (ds.hasNext()) {
                            logger.info("*******************\u7b2c{}\u884c*******************", (Object)index);
                            ds.next();
                            ++index;
                            logger.info("*******************\u5f00\u59cb\u904d\u5386Dataset\u5217*******************");
                            block22: for (j = 1; j <= columnCount; ++j) {
                                String columnName = ds.getColumnName(j);
                                char columnType = ds.getColumnType(j);
                                logger.info("*******************\u7b2c{}\u5217\uff1acolumnName={},columnType={}*******************", new Object[]{j, columnName, Character.valueOf(columnType)});
                                switch (columnName) {
                                    case "csdc_entrust_type": {
                                        String csdc_entrust_type = ds.getString("csdc_entrust_type");
                                        result.put("csdc_entrust_type", csdc_entrust_type);
                                        logger.info("\u59d4\u6258\u7c7b\u522b:" + csdc_entrust_type);
                                        continue block22;
                                    }
                                    case "assettrans_status": {
                                        String assettrans_status = ds.getString("assettrans_status");
                                        result.put("assettrans_status", assettrans_status);
                                        logger.info("\u5b58\u7ba1\u6570\u636e\u4ea4\u6362\u72b6\u6001:" + assettrans_status);
                                        continue block22;
                                    }
                                    case "acode_account": {
                                        String acode_account = ds.getString("acode_account");
                                        result.put("acode_account", acode_account);
                                        logger.info("\u4e00\u7801\u901a\u8d26\u6237\u53f7\u7801:" + acode_account);
                                        continue block22;
                                    }
                                    case "deal_flag": {
                                        String deal_flag = ds.getString("deal_flag");
                                        result.put("deal_flag", deal_flag);
                                        logger.info("\u5904\u7406\u6807\u5fd7:" + deal_flag);
                                        continue block22;
                                    }
                                    case "deal_info": {
                                        String deal_info = ds.getString("deal_info");
                                        result.put("deal_info", deal_info);
                                        logger.info("\u5904\u7406\u4fe1\u606f:" + deal_info);
                                        continue block22;
                                    }
                                    case "position_str": {
                                        String position_str = ds.getString("position_str");
                                        result.put("position_str", position_str);
                                        logger.info("\u5b9a\u4f4d\u4e32:" + position_str);
                                        continue block22;
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    logger.info("*******************\u83b7\u53d6IDataset\u4e0d\u5b58\u5728*******************");
                }
            }
            catch (T2SDKException e1) {
                logger.error("getCsdc\u53d1\u751f\u9519\u8befT2SDKException\uff1a{}", (Object)e1.getMessage());
                result.put("error", e1.getMessage());
                throw new CommonException(e1.getMessage());
            }
            catch (Exception e) {
                logger.error("getCsdc\u53d1\u751f\u9519\u8befException\uff1a{}", (Object)e.getMessage());
                result.put("error", e.getMessage());
                throw new CommonException(e.getMessage());
            }
        }
        logger.info("*******************\u63a5\u53e3\uff1a10200532\u901a\u8fc7\u5b9a\u4f4d\u4e32\u4fe1\u606f\u8fd4\u56de\u5458\u5de5\u8d26\u6237\u72b6\u6001\u8be6\u60c5:\u7ed3\u675f*******************");
        return result;
    }

    private IEvent getEvent(int deal_flag, String csdc_id_no, String csdc_id_kind, String csdc_client_name, String userId) {
        IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10201093", 0);
        IDataset dataset = DatasetService.getDefaultInstance().getDataset();
        dataset.addColumn("op_branch_no");
        dataset.addColumn("operator_no");
        dataset.addColumn("user_type");
        dataset.addColumn("op_password");
        dataset.addColumn("op_station");
        dataset.addColumn("op_entrust_way");
        dataset.addColumn("menu_id");
        dataset.addColumn("function_id");
        dataset.addColumn("branch_no");
        dataset.addColumn("audit_action");
        dataset.addColumn("csdc_id_no");
        logger.debug("\u5458\u5de5\u8bc1\u4ef6\u53f7\u7801:" + csdc_id_no);
        dataset.addColumn("csdc_id_kind");
        logger.debug("\u5458\u5de5\u8bc1\u4ef6\u7c7b\u578b:" + csdc_id_kind);
        dataset.addColumn("csdc_client_name");
        logger.debug("\u5458\u5de5\u59d3\u540d:" + csdc_client_name);
        dataset.addColumn("gt_busin_checkflag");
        dataset.appendRow();
        logger.info("*******************\u6784\u9020dataset\u6570\u636e\u4fe1\u606fcsdc_id_no={};csdc_client_name={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};*******************", new Object[]{csdc_id_no, csdc_client_name, op_branch_no, op_station, op_entrust_way, branch_no});
        dataset.updateString("op_branch_no", op_branch_no);
        dataset.updateString("operator_no", userId);
        dataset.updateString("user_type", "");
        dataset.updateString("op_password", "");
        dataset.updateString("op_station", op_station);
        dataset.updateString("op_entrust_way", op_entrust_way);
        dataset.updateString("menu_id", "");
        dataset.updateString("function_id", "");
        dataset.updateString("branch_no", branch_no);
        dataset.updateString("audit_action", "");
        dataset.updateString("csdc_id_no", csdc_id_no);
        dataset.updateString("csdc_id_kind", csdc_id_kind);
        dataset.updateString("csdc_client_name", csdc_client_name);
        dataset.updateInt("gt_busin_checkflag", deal_flag);
        event.putEventData(dataset);
        return event;
    }

    static {
        try {
            op_branch_no = PropKit.getProperty((String)"csdc.op_branch_no");
            op_station = PropKit.getProperty((String)"csdc.op_station");
            op_entrust_way = PropKit.getProperty((String)"csdc.op_entrust_way");
            branch_no = PropKit.getProperty((String)"csdc.branch_no");
            logger.info("op_branch_no={};op_station={};op_entrust_way={};branch_no={}", new Object[]{op_branch_no, op_station, op_entrust_way, branch_no});
            sdkServices = T2Services.getInstance();
            sdkServices.init();
            sdkServices.start();
            logger.info("T2SD\u670d\u52a1\u542f\u52a8\u6210\u529f\uff01\uff01\uff01");
        }
        catch (CommonException e) {
            logger.error("\u63a5\u53e3\u53c2\u6570\u521d\u59cb\u5931\u8d25{}", (Object)e.getMessage());
        }
        catch (T2SDKException e) {
            logger.error("\u542f\u52a8T2SD\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }
}

