/*
 * Decompiled with CFR 0.152.
 */
package com.rw.csdc.dao;

import com.rw.csdc.dao.CsdcClientCheckDAO;
import com.rw.dao.BaseDAOImpl;
import com.rw.util.CommonException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="csdcClientCheckDAO")
public class CsdcClientCheckDAOImpl
extends BaseDAOImpl
implements CsdcClientCheckDAO {
    public Map<String, Object> getClientInfo(String csdc_stock_account) throws CommonException {
        String sql = "SELECT CSDC_STOCK_ACCOUNT,CSDC_HOLDER_STATUS,CSDC_ACODE_ACCOUNT,CSDC_ID_NO,CSDC_ID_KIND,CSDC_CLIENT_NAME,CSDC_OPENORGAN_NAME,CSDC_OPEN_DATE FROM CM_DATA.dbo.T_CSDC_CLIENT_INFO WHERE CSDC_STOCK_ACCOUNT = ?";
        Map one = this.findOne(sql, new Object[]{csdc_stock_account});
        return one;
    }

    public boolean addClientInfo(List<Object[]> clientInfoMap) throws CommonException {
        String sql = "INSERT INTO CM_DATA.dbo.T_CSDC_CLIENT_INFO(S_ID,CSDC_STOCK_ACCOUNT,CSDC_HOLDER_STATUS,CSDC_ACODE_ACCOUNT,CSDC_ID_NO,CSDC_ID_KIND,CSDC_CLIENT_NAME,CSDC_OPENORGAN_NAME,CSDC_OPEN_DATE,USER_ID,ID_NO,BATCH) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        int[] result = this.getJdbcTemplate().batchUpdate(sql, clientInfoMap);
        return result.length > 0;
    }

    public String insertBatchData(List<String> idList, List<String> nameList, List<String> idNoList) throws CommonException {
        String batch = LocalDate.now().toString().replaceAll("-", "");
        String sql = "insert into CM_DATA.dbo.T_USER_BATCH(USER_ID,USER_NAME,ID_NO,BATCH) SELECT ?,?,?,?  WHERE not exists(SELECT USER_ID FROM CM_DATA.dbo.T_USER_BATCH WHERE USER_ID=? and BATCH=?)";
        ArrayList<Object[]> rowdataList = new ArrayList<Object[]>(idList.size());
        for (int i = 0; i < idList.size(); ++i) {
            Object[] row = new Object[]{idList.get(i), nameList.get(i), idNoList.get(i), batch, idList.get(i), batch};
            rowdataList.add(row);
        }
        this.getJdbcTemplate().batchUpdate(sql, rowdataList);
        return batch;
    }

    public String inertAllBatchData() throws CommonException {
        String batch = LocalDate.now().toString().replaceAll("-", "");
        String allUserSql = "select count(1) as count from CM_DATA.dbo.T_EHR_USER";
        String sql = "insert into CM_DATA.dbo.T_USER_BATCH(USER_ID,USER_NAME,ID_NO,BATCH) SELECT USER_ID,USER_NAME,ID_NO,? from CM_DATA.dbo.T_EHR_USER WHERE not exists(select t.USER_ID FROM CM_DATA.dbo.T_USER_BATCH t,CM_DATA.dbo.T_EHR_USER tt WHERE t.USER_ID=tt.USER_ID and t.BATCH=?)";
        long cout = this.count(allUserSql, new Object[0]);
        ArrayList<Object[]> rowdataList = new ArrayList<Object[]>();
        int i = 0;
        while ((long)i < cout) {
            Object[] row = new Object[]{batch, batch};
            rowdataList.add(row);
            ++i;
        }
        this.getJdbcTemplate().batchUpdate(sql, rowdataList);
        return batch;
    }

    public boolean updateBatchStatus(String no, String batch, int status, String userId) throws CommonException {
        String sql = "update CM_DATA.dbo.T_USER_BATCH set STATUS=?,OP_TIME=getdate(),OP_USER=? where ID_NO=? and BATCH=?";
        int size = this.update(sql, new Object[]{status, userId, no, batch});
        return size > 0;
    }
}

