/*
 * Decompiled with CFR 0.152.
 */
package com.rw.csdc.controller;

import com.rw.annotation.SystemControllerLog;
import com.rw.csdc.service.CsdcClientCheckService;
import com.rw.util.CommonException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/csdc"})
public class CsdcClientCheckController {
    private static final Logger logger = LoggerFactory.getLogger(CsdcClientCheckController.class);
    @Autowired
    CsdcClientCheckService csdcClientCheckService;

    @SystemControllerLog(description="\u6839\u636e\u7528\u6237\u8eab\u4efd\u8bc1\u53f7\u7801\u83b7\u53d6\u53f8\u5916\u8d26\u6237\u4fe1\u606f")
    @RequestMapping(value={"/getCsdcInfo.jhtml"})
    @ResponseBody
    public Map<String, Object> getCsdcInfoByIdNo(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String idNo = request.getParameter("idNo");
            String clientName = request.getParameter("clientName");
            String batch = request.getParameter("batch");
            String userId = request.getParameter("userId");
            String flag = request.getParameter("flag");
            Map positionStr = this.csdcClientCheckService.getPositionStr(idNo, "01", clientName, 1, userId, flag);
            if (!positionStr.isEmpty()) {
                if (positionStr.containsKey("error")) {
                    this.csdcClientCheckService.updateBatchStatus(idNo, batch, 2, userId);
                    result.put("msg", positionStr.get("error"));
                    result.put("status", 2);
                } else if (positionStr.containsKey("deal_flag")) {
                    this.csdcClientCheckService.updateBatchStatus(idNo, batch, 3, userId);
                    result.put("msg", "deal_info:" + positionStr.get("deal_info") + ",position_str=" + positionStr.get("position_str"));
                    result.put("status", 3);
                } else if (positionStr.containsKey("dataSet")) {
                    List dataSets = (List)positionStr.get("dataSet");
                    if (dataSets.size() > 0) {
                        String msg = this.csdcClientCheckService.addClient(dataSets, batch, idNo, userId);
                        result.put("msg", "\u3010\u8bc1\u4ef6\u53f7\uff1a" + idNo + ",\u7528\u6237\u540d\uff1a" + clientName + "\u3011\uff1a" + msg);
                        result.put("status", 1);
                    } else {
                        this.csdcClientCheckService.updateBatchStatus(idNo, batch, 1, userId);
                        result.put("msg", "\u4e2d\u767b\u7cfb\u7edf\u4e2d\u8bc1\u4ef6\u53f7\uff1a" + idNo + "\u7684\u7528\u6237\u65e0\u80a1\u4e1c\u4ee3\u7801\u8d26\u53f7\u4fe1\u606f\uff01");
                        result.put("status", 1);
                    }
                }
            } else {
                this.csdcClientCheckService.updateBatchStatus(idNo, batch, 1, userId);
                result.put("msg", "\u4e2d\u767b\u7cfb\u7edf\u4e2d\u8bc1\u4ef6\u53f7\uff1a" + idNo + "\u7684\u7528\u6237\u65e0\u80a1\u4e1c\u4ee3\u7801\u8d26\u53f7\u4fe1\u606f\uff01");
                result.put("status", 1);
            }
        }
        catch (CommonException e) {
            result.put("msg", e.getMessage());
            result.put("status", 2);
            logger.error("\u83b7\u53d6\u5458\u5de5\u53f8\u5916\u8d26\u6237\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
        return result;
    }

    @SystemControllerLog(description="\u6839\u636e\u67e5\u8be2\u8981\u6c42\u521b\u5efa\u6279\u6b21\u6570\u636e\uff0c\u6279\u6b21\u53f7\u4e3a\u5f53\u524d\u65e5\u671f")
    @RequestMapping(value={"/createBatchData.jhtml"})
    @ResponseBody
    public Map<String, Object> createBatchData(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String batch = "";
        Boolean isAll = BooleanUtils.toBoolean((String)request.getParameter("isAll"));
        try {
            if (isAll.booleanValue()) {
                batch = this.csdcClientCheckService.createAllBatchData();
            } else {
                String ids = request.getParameter("ids");
                String idNos = request.getParameter("idNos");
                String names = request.getParameter("names");
                if (StringUtils.isNotBlank((String)ids) && StringUtils.isNotBlank((String)idNos) && StringUtils.isNotBlank((String)names)) {
                    String[] idArr = ids.split(",");
                    String[] idNoArr = idNos.split(",");
                    String[] nameArr = names.split(",");
                    batch = this.csdcClientCheckService.insertPartBatchData(idArr, idNoArr, nameArr);
                }
            }
            result.put("batch", batch);
        }
        catch (CommonException e) {
            result.put("msg", e.getMessage());
            logger.error("\u5efa\u7acb\u5458\u5de5\u6279\u6b21\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
        return result;
    }
}

