/*
 * Decompiled with CFR 0.152.
 */
package com.rw.controller;

import com.google.gson.Gson;
import com.rw.annotation.SystemControllerLog;
import com.rw.model.excel.Col2Field;
import com.rw.model.excel.ExcelTemplate;
import com.rw.model.excel.ExcelTranslate;
import com.rw.model.excel.XCell;
import com.rw.model.excel.XRow;
import com.rw.model.excel.XSheet;
import com.rw.model.sp.Procedure;
import com.rw.service.ExcelService;
import com.rw.util.ExpressionKit;
import com.rw.util.WebKit;
import com.wb.interact.Service;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ck/excel"})
public class ExcelController {
    private static final Logger logger = LoggerFactory.getLogger(ExcelController.class);
    private String excelUploadPath = String.valueOf(WebKit.getBasePath()) + File.separator + "IMPORT" + File.separator + "EXCEL";
    @Autowired
    private ExcelService excelService;

    @SystemControllerLog(description="\u542f\u52a8\u5bfc\u5165Excel\u7684\u9875\u9762")
    @RequestMapping(value={"/iExcel.jhtml"}, method={RequestMethod.GET})
    public ModelAndView index(@RequestParam(value="modelCode", required=true) String modelCode, @RequestParam(value="maxRow", defaultValue="0", required=false) Integer maxRow, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String filePath = this.excelService.getTemplateFilePath(modelCode);
        String userId = WebUtil.fetch((HttpServletRequest)request, (String)"sys.username");
        modelAndView.addObject("modelCode", (Object)modelCode);
        modelAndView.addObject("maxRow", (Object)maxRow);
        modelAndView.addObject("userId", (Object)userId);
        modelAndView.addObject("filePath", (Object)filePath);
        modelAndView.setViewName("iExcel");
        return modelAndView;
    }

    @SystemControllerLog(description="\u4e0b\u8f7d\u6a21\u7248")
    @RequestMapping(value={"/downTemplateFile.jhtml"})
    public void downTemplateFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filePath = request.getParameter("filePath");
        if (StringUtils.isNotBlank((String)filePath)) {
            request.setAttribute("files", (Object)("['" + filePath + "']"));
            Service.downloadAtApp((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    @SystemControllerLog(description="\u9884\u89c8Excel")
    @RequestMapping(value={"/previewExcel.jhtml"})
    public void previewExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug("upload is start.......");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver();
            commonsMultipartResolver.setDefaultEncoding("utf-8");
            commonsMultipartResolver.setMaxUploadSize(0x500000L);
            if (commonsMultipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
                CommonsMultipartFile file = (CommonsMultipartFile)multipartHttpServletRequest.getFile("fileData");
                String modelCode = multipartHttpServletRequest.getParameter("modelCode");
                String fileName = file.getOriginalFilename();
                Integer maxRow = request.getParameter("maxRow").equalsIgnoreCase("0") ? 30 : new Integer(request.getParameter("maxRow"));
                Integer flag = new Integer(request.getParameter("flag"));
                if (StringUtils.isEmpty((String)fileName)) {
                    result.put("error", "\u672a\u9009\u62e9\u6587\u4ef6\uff01");
                } else if (StringUtils.containsIgnoreCase((String)fileName, (String)"xls") || StringUtils.containsIgnoreCase((String)fileName, (String)"xlsx")) {
                    File uploadedFile;
                    byte[] bytes = file.getBytes();
                    File filePath = new File(this.excelUploadPath);
                    if (!filePath.exists()) {
                        filePath.mkdirs();
                    }
                    if ((uploadedFile = new File(filePath, fileName)).exists()) {
                        String[] fileNameStr = StringUtil.split((String)fileName, (String)".");
                        fileName = StringUtil.concat((String[])new String[]{fileNameStr[0], "-", SysUtil.getId(), ".", fileNameStr[1]});
                        uploadedFile = new File(filePath, fileName);
                    }
                    FileCopyUtils.copy((byte[])bytes, (File)uploadedFile);
                    logger.debug("upload is end.......");
                    if (flag == 1) {
                        FileInputStream fis = new FileInputStream(uploadedFile);
                        ExcelTranslate translate = new ExcelTranslate();
                        List excelTemplateInfo = this.excelService.getTemplateInfo(modelCode);
                        LinkedHashMap<String, String> html = new LinkedHashMap<String, String>();
                        int size = excelTemplateInfo.size();
                        if (size == 1) {
                            String sheetName = ((ExcelTemplate)excelTemplateInfo.get(0)).getTemplateSheetName();
                            String[] sheetNames = new String[]{sheetName};
                            translate.readExcel(fileName, (InputStream)fis, maxRow.intValue(), Arrays.asList(sheetNames));
                            List sheetList = translate.getSheetList();
                            if (sheetList.size() > 0) {
                                for (XSheet sheet : sheetList) {
                                    html.put(sheetName, sheet.toHtml(((ExcelTemplate)excelTemplateInfo.get(0)).getStartRowsNum()));
                                }
                            }
                            result.put("msg", html);
                            result.put("filename", fileName);
                            logger.info("********************************");
                            logger.info(uploadedFile.getAbsolutePath());
                            logger.info(String.valueOf(bytes.length));
                            logger.info("********************************");
                        } else if (size > 1) {
                            ArrayList<String> sheetNameList = new ArrayList<String>(size);
                            for (ExcelTemplate et : excelTemplateInfo) {
                                sheetNameList.add(et.getTemplateSheetName());
                            }
                            translate.readExcel(fileName, (InputStream)fis, maxRow.intValue(), sheetNameList);
                            List sheetList = translate.getSheetList();
                            for (XSheet sheet : sheetList) {
                                String sheetName = sheet.getLabel();
                                html.put(sheetName, sheet.toHtml());
                            }
                            result.put("msg", html);
                            result.put("filename", fileName);
                            logger.info("********************************");
                            logger.info(uploadedFile.getAbsolutePath());
                            logger.info(String.valueOf(bytes.length));
                            logger.info("********************************");
                        } else {
                            result.put("error", "modelCode=" + modelCode + "\u7684Excel\u5bfc\u5165\u6a21\u7248\u4e0d\u5b58\u5728\uff01");
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    } else {
                        result.put("filename", fileName);
                    }
                } else {
                    result.put("error", "\u975eExcel\u6587\u4ef6!");
                }
            } else {
                result.put("error", "\u975emultipart\u8868\u5355\u6570\u636e!");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error(SysUtil.getRootError((Throwable)e));
            result.put("error", SysUtil.getRootError((Throwable)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(SysUtil.getRootError((Throwable)e));
            result.put("error", SysUtil.getRootError((Throwable)e));
        }
        try {
            String json = new Gson().toJson(result);
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(json);
            response.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u5bfc\u5165\u9884\u89c8Excel\u7ed3\u679c\u8fd4\u56de\u9519\u8bef:" + e.getMessage());
            throw new Exception("\u5bfc\u5165\u9884\u89c8Excel\u7ed3\u679c\u8fd4\u56de\u9519\u8bef:" + e.getMessage());
        }
    }

    @SystemControllerLog(description="\u5bfc\u5165Excel")
    @RequestMapping(value={"/importExcel.jhtml"})
    public void importExcel(HttpServletRequest request, HttpServletResponse response) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            HashMap<String, String> reqParasMap = new HashMap<String, String>();
            JSONObject params = WebUtil.fetch((HttpServletRequest)request);
            Iterator keys = params.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = ObjectUtils.toString((Object)params.get(key));
                reqParasMap.put(key, value);
            }
            reqParasMap.putAll(this.getCommonParas(WebUtil.fetch((HttpServletRequest)request, (String)"sys.username")));
            String filePath = request.getParameter("filePath");
            String fileName = request.getParameter("fileName");
            String modelCode = request.getParameter("modelCode");
            File uploadedFile = null;
            InputStream fis = null;
            if (StringUtils.isEmpty((String)filePath) && StringUtils.isNotEmpty((String)fileName)) {
                uploadedFile = new File(String.valueOf(this.excelUploadPath) + File.separator + fileName);
                fis = new FileInputStream(uploadedFile);
            } else if (StringUtils.startsWithIgnoreCase((String)filePath, (String)"http")) {
                fis = new URL(filePath).openStream();
            } else {
                uploadedFile = new File(filePath);
                fis = new FileInputStream(uploadedFile);
            }
            Map excelTemplateMap = this.excelService.importExcel(modelCode, reqParasMap);
            ExcelTranslate translate = new ExcelTranslate();
            translate.readExcel(fileName, fis, 0, new ArrayList(excelTemplateMap.keySet()));
            List sheetList = translate.getSheetList();
            for (Map.Entry map : excelTemplateMap.entrySet()) {
                String sheetName = (String)map.getKey();
                if (StringUtils.contains((String)sheetName, (String)"&|+|&")) {
                    sheetName = StringUtils.substringBefore((String)sheetName, (String)"&|+|&");
                }
                for (XSheet xs : sheetList) {
                    if (!StringUtils.equalsIgnoreCase((String)sheetName, (String)xs.getLabel())) continue;
                    result.put((String)map.getKey(), this.executeTemplate((ExcelTemplate)map.getValue(), xs, reqParasMap));
                }
            }
            if (fis != null) {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            result.put("error", e.getMessage());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            result.put("error", e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            result.put("error", e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            result.put("error", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            result.put("error", e.getMessage());
        }
        try {
            Gson gson = new Gson();
            String json = gson.toJson(result);
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(json);
            response.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u5bfc\u5165Excel\u7ed3\u679c\u8fd4\u56de\u9519\u8bef:" + e.getMessage());
            throw new RuntimeException("\u5bfc\u5165Excel\u7ed3\u679c\u8fd4\u56de\u9519\u8bef:" + e.getMessage());
        }
    }

    private Map<String, Object> executeTemplate(ExcelTemplate excelTemplate, XSheet xs, Map<String, Object> reqParasMap) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ObjectUtils.notEqual((Object)excelTemplate.getStartExecSp(), null)) {
            Procedure procedure = excelTemplate.getStartExecSp();
            String sp = procedure.getProceSql();
            List paList = procedure.getProcedureArguments();
            logger.info("importExcel of \u6267\u884c\u524d\u7f6eSP\uff1a" + sp);
            logger.info("importExcel of \u6267\u884c\u524d\u7f6eSP\u53c2\u6570\uff1a" + paList);
            result.put("sp1", this.excelService.importExcel4SP(sp, paList));
        }
        ArrayList<String> batchInsertSql = new ArrayList<String>();
        StringBuilder colStr = new StringBuilder("(");
        for (Col2Field col2Field : excelTemplate.getCol2FieldList()) {
            colStr.append(col2Field.getColName());
            colStr.append(",");
        }
        int colStrIndex = colStr.lastIndexOf(",");
        if (colStrIndex >= 0) {
            colStr = colStr.deleteCharAt(colStrIndex);
        }
        colStr.append(")");
        List xrList = xs.getRowList();
        int endRow = excelTemplate.getEndRowsNum() == 0 ? xs.getRowList().size() : (excelTemplate.getEndRowsNum() > xs.getRowList().size() ? xs.getRowList().size() : excelTemplate.getEndRowsNum());
        int i = excelTemplate.getStartRowsNum();
        while (i < endRow) {
            XRow xr = (XRow)xrList.get(i);
            StringBuilder valStr = new StringBuilder("(");
            boolean impFlag = true;
            for (Col2Field col2Field : excelTemplate.getCol2FieldList()) {
                if (StringUtils.isNotEmpty((String)col2Field.getXlsCol())) {
                    if (xr.getCellList().size() > col2Field.getFieldIndex()) {
                        String type;
                        String value;
                        XCell xc = (XCell)xr.getCellList().get(col2Field.getFieldIndex());
                        String defaultValue = col2Field.getDefaultValue();
                        if (StringUtils.contains((String)defaultValue, (String)"{$")) {
                            defaultValue = ExpressionKit.replaceParas((String)defaultValue, reqParasMap);
                        }
                        if (StringUtils.isEmpty((String)(value = ObjectUtils.toString((Object)xc.getValue(), (String)"")))) {
                            if (!col2Field.isEmptyIsImp()) {
                                impFlag = false;
                                break;
                            }
                            if (StringUtils.isNotEmpty((String)defaultValue)) {
                                value = defaultValue;
                            }
                        }
                        if ((type = col2Field.getFieldType()).equalsIgnoreCase("NUMBER")) {
                            valStr.append(StringUtils.isNotEmpty((String)value) ? value : "null");
                            valStr.append(",");
                            continue;
                        }
                        valStr.append("'");
                        valStr.append(value);
                        valStr.append("'");
                        valStr.append(",");
                        continue;
                    }
                    valStr.append("null");
                    valStr.append(",");
                    continue;
                }
                String type = col2Field.getFieldType();
                String value = col2Field.getDefaultValue();
                reqParasMap.put("LINE_NO", String.valueOf(i));
                value = ExpressionKit.replaceParas((String)value, reqParasMap);
                if (type.equalsIgnoreCase("NUMBER")) {
                    valStr.append(StringUtils.isNotEmpty((String)value) ? value : "null");
                    valStr.append(",");
                    continue;
                }
                valStr.append("'");
                valStr.append(value);
                valStr.append("'");
                valStr.append(",");
            }
            if (impFlag) {
                int valStrIndex = valStr.lastIndexOf(",");
                if (valStrIndex >= 0) {
                    valStr = valStr.deleteCharAt(valStrIndex);
                }
                valStr.append(")");
                String sql = "INSERT INTO " + excelTemplate.getTemplateTbName() + colStr.toString() + " VALUES" + valStr.toString();
                logger.info(sql);
                batchInsertSql.add(sql);
            }
            ++i;
        }
        int count = 0;
        if (batchInsertSql.size() > 0) {
            try {
                count += this.excelService.insertBatch(batchInsertSql);
            }
            catch (Exception e) {
                result.put("error", e.getMessage());
            }
            result.put("count", count);
        }
        if (ObjectUtils.notEqual((Object)excelTemplate.getEndExecSp(), null)) {
            Procedure procedure = excelTemplate.getEndExecSp();
            String sp = procedure.getProceSql();
            List paList = procedure.getProcedureArguments();
            logger.info("importExcel of \u6267\u884c\u540e\u7f6eSP\uff1a" + sp);
            logger.info("importExcel of \u6267\u884c\u540e\u7f6eSP\u53c2\u6570\uff1a" + paList);
            result.put("sp2", this.excelService.importExcel4SP(sp, paList));
        }
        return result;
    }

    private Map<String, Object> getCommonParas(String userName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        Date date = new Date();
        paras.put("CURRENT_USER_NAME", userName);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        paras.put("CURRENT_DATE", sdf.format(date));
        paras.put("CURRENT_TIME", dateformat.format(date));
        paras.put("GUID", UUID.randomUUID().toString().replaceAll("-", ""));
        return paras;
    }
}

