/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aspect;

import com.google.gson.Gson;
import com.rw.annotation.SystemControllerLog;
import com.rw.annotation.SystemDaoLog;
import com.rw.annotation.SystemServiceLog;
import com.rw.service.LogService;
import com.rw.util.HttpKit;
import com.wb.util.LogUtil;
import com.wb.util.WebUtil;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class SystemLogAspect {
    @Resource
    private LogService logService;
    private static final Logger logger = LoggerFactory.getLogger(SystemLogAspect.class);
    private static String RECORD_TYPE_CONTROLLER = "10";
    private static String RECORD_TYPE_SERVICE = "11";
    private static String RECORD_TYPE_DAO = "12";

    @Pointcut(value="@annotation(com.rw.annotation.SystemControllerLog)")
    public void controllerAspect() {
    }

    @Pointcut(value="@annotation(com.rw.annotation.SystemServiceLog)")
    public void serviceAspect() {
    }

    @Pointcut(value="@annotation(com.rw.annotation.SystemDaoLog)")
    public void daoAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = HttpKit.getHttpServletRequest();
        HttpServletResponse response = HttpKit.getHttpServletResponse();
        try {
            logger.info("=====\u524d\u7f6e\u901a\u77e5\u5f00\u59cb=====");
            logger.info("\u8bf7\u6c42\u65b9\u6cd5:" + joinPoint.getTarget().getClass().getName() + "." + joinPoint.getSignature().getName() + "()");
            logger.info("\u65b9\u6cd5\u63cf\u8ff0:" + SystemLogAspect.getControllerMethodDescription((JoinPoint)joinPoint, (HttpServletRequest)request));
            logger.info("\u8bf7\u6c42\u4eba:" + WebUtil.fetch((HttpServletRequest)request, (String)"sys.username"));
            logger.info("\u8bf7\u6c42IP:" + request.getRemoteAddr());
            LogUtil.info((HttpServletRequest)request, (Object)SystemLogAspect.getControllerMethodDescription((JoinPoint)joinPoint, (HttpServletRequest)request));
            logger.info("=====\u524d\u7f6e\u901a\u77e5\u7ed3\u675f=====");
        }
        catch (Exception e) {
            logger.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
    }

    @AfterThrowing(pointcut="serviceAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        HttpServletRequest request = HttpKit.getHttpServletRequest();
        HttpServletResponse response = HttpKit.getHttpServletResponse();
        Gson gson = new Gson();
        String params = "";
        if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
            int i = 0;
            while (i < joinPoint.getArgs().length) {
                params = String.valueOf(params) + gson.toJson(joinPoint.getArgs()[i]) + ";";
                ++i;
            }
        }
        try {
            logger.info("=====\u5f02\u5e38\u901a\u77e5\u5f00\u59cb=====");
            logger.info("\u5f02\u5e38\u4ee3\u7801:" + e.getClass().getName());
            logger.info("\u5f02\u5e38\u4fe1\u606f:" + e.getMessage());
            logger.info("\u5f02\u5e38\u65b9\u6cd5:" + joinPoint.getTarget().getClass().getName() + "." + joinPoint.getSignature().getName() + "()");
            logger.info("\u65b9\u6cd5\u63cf\u8ff0:" + SystemLogAspect.getServiceMthodDescription((JoinPoint)joinPoint, (Throwable)e));
            logger.info("\u8bf7\u6c42\u4eba:" + WebUtil.fetch((HttpServletRequest)request, (String)"sys.username"));
            logger.info("\u8bf7\u6c42IP:" + request.getRemoteAddr());
            logger.info("\u8bf7\u6c42\u53c2\u6570:" + params);
            LogUtil.info((HttpServletRequest)request, (Object)SystemLogAspect.getServiceMthodDescription((JoinPoint)joinPoint, (Throwable)e));
            logger.info("=====\u5f02\u5e38\u901a\u77e5\u7ed3\u675f=====");
        }
        catch (Exception ex) {
            logger.error("==\u5f02\u5e38\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)ex.getMessage());
        }
        logger.error("\u5f02\u5e38\u65b9\u6cd5:{}\u5f02\u5e38\u4ee3\u7801:{}\u5f02\u5e38\u4fe1\u606f:{}\u53c2\u6570:{}", new Object[]{String.valueOf(joinPoint.getTarget().getClass().getName()) + joinPoint.getSignature().getName(), e.getClass().getName(), e.getMessage(), params});
    }

    @Around(value="daoAspect()")
    public Object around(ProceedingJoinPoint joinPoint) {
        HttpServletRequest request = HttpKit.getHttpServletRequest();
        HttpServletResponse response = HttpKit.getHttpServletResponse();
        Gson gson = new Gson();
        try {
            String desc = SystemLogAspect.getDaoMethodDescription((JoinPoint)joinPoint);
            LogUtil.info((HttpServletRequest)request, (Object)desc);
            Object result = joinPoint.proceed();
            String resultMsg = "\u6267\u884c\u6210\u529f\uff01";
            if (result != null && (resultMsg = "\u6267\u884c\u7ed3\u679c:" + gson.toJson(result)).length() > 2000) {
                resultMsg = resultMsg.substring(0, 2000);
            }
            LogUtil.info((HttpServletRequest)request, (Object)resultMsg);
            return result;
        }
        catch (Exception ex) {
            logger.error("==\u5f02\u5e38\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)ex.getMessage());
        }
        catch (Throwable e) {
            logger.error("==\u5f02\u5e38\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        return null;
    }

    public static String getServiceMthodDescription(JoinPoint joinPoint, Throwable e) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String exCode = e.getClass().getName();
        String exMsg = e.getMessage();
        StringBuffer description = new StringBuffer();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] clazzs;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (clazzs = method.getParameterTypes()).length == arguments.length) {
                description.append(method.getAnnotation(SystemServiceLog.class).description());
                description.append("\u53d1\u751f\u5f02\u5e38===>\u5f02\u5e38\u4ee3\u7801:").append(exCode).append(";\u5f02\u5e38\u4fe1\u606f:").append(exMsg);
                break;
            }
            ++n2;
        }
        Gson gson = new Gson();
        description.append(";\u53c2\u6570\u4fe1\u606f:").append(gson.toJson((Object)arguments));
        String desc = description.toString();
        if (desc.length() > 2000) {
            desc = description.substring(0, 2000);
        }
        return desc;
    }

    public static String getControllerMethodDescription(JoinPoint joinPoint, HttpServletRequest request) throws Exception {
        String desc;
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        StringBuffer description = new StringBuffer();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] clazzs;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (clazzs = method.getParameterTypes()).length == arguments.length) {
                description.append(method.getAnnotation(SystemControllerLog.class).description());
                break;
            }
            ++n2;
        }
        StringBuffer bf = new StringBuffer();
        if (arguments != null && arguments.length > 0) {
            Enumeration paraNames = request.getParameterNames();
            while (paraNames.hasMoreElements()) {
                String key = (String)paraNames.nextElement();
                bf.append(key).append("=");
                bf.append(request.getParameter(key)).append("&");
            }
            if (StringUtils.isBlank((String)bf.toString())) {
                bf.append(request.getQueryString());
            }
        }
        if (bf.length() > 0) {
            description.append("===>\u53c2\u6570\u4fe1\u606f:").append(bf);
        }
        if ((desc = description.toString()).length() > 2000) {
            desc = description.substring(0, 2000);
        }
        return desc;
    }

    public static String getDaoMethodDescription(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        StringBuffer description = new StringBuffer();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] clazzs;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (clazzs = method.getParameterTypes()).length == arguments.length) {
                description.append(method.getAnnotation(SystemDaoLog.class).description());
                break;
            }
            ++n2;
        }
        Gson gson = new Gson();
        description.append(";\u53c2\u6570\u4fe1\u606f:").append(gson.toJson((Object)arguments));
        String desc = description.toString();
        if (desc.length() > 2000) {
            desc = description.substring(0, 2000);
        }
        return desc;
    }
}

