/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class StrUtil {
    private static String excelDirPath = null;
    private static String zipDirPath = null;
    public static String classPath = null;

    public static String getExcelDirPath() {
        if (excelDirPath == null) {
            excelDirPath = String.valueOf(classPath) + File.separator + "excelTemplate" + File.separator;
        }
        return excelDirPath;
    }

    public static String getZipDirPath() throws IOException {
        if (zipDirPath == null) {
            String filePath = String.valueOf(classPath) + File.separator + "zipDir";
            File file = new File(filePath);
            if (!file.exists() && !file.isDirectory()) {
                file.mkdir();
            }
            zipDirPath = String.valueOf(filePath) + File.separator;
        }
        return zipDirPath;
    }

    public static String cvtToSpace(String str) {
        if (str == null || "".equals(str)) {
            str = " ";
        }
        return str;
    }

    public static String cvtToNull(String str) {
        if (str == null || "".equals(str)) {
            str = "";
        }
        return str;
    }

    public static String cvtToChnChar(String str) {
        str = "1".equals(str) ? "\u662f" : ("0".equals(str) ? "\u5426" : " ");
        return str;
    }

    public static String cvtToDate(String strDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String strReturn = "";
        try {
            Date date = dateFormat.parse(strDate);
            Calendar cldr = Calendar.getInstance();
            cldr.setTime(date);
            strReturn = String.valueOf(cldr.get(1)) + "/" + (cldr.get(2) + 1) + "/" + cldr.get(5);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return strReturn;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isDouble(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static String cvtRegNo(long zipNo) {
        String strZipNo = String.valueOf(zipNo);
        int length = strZipNo.length();
        switch (length) {
            case 1: {
                strZipNo = "000" + strZipNo;
                break;
            }
            case 2: {
                strZipNo = "00" + strZipNo;
                break;
            }
            case 3: {
                strZipNo = "0" + strZipNo;
                break;
            }
        }
        return strZipNo;
    }

    public static String listToString(List<String> list, char separator) {
        String result = "";
        if (list != null && list.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int size = list.size();
            int i = 0;
            while (i < size) {
                sb.append(list.get(i)).append(separator);
                ++i;
            }
            sb.deleteCharAt(sb.length() - 1);
            result = sb.toString();
        }
        return result;
    }

    public static List<String> StringToList(String str, String separator) {
        List<String> result = null;
        if (str != null && !"".equals(str)) {
            String[] array = str.split(separator);
            result = Arrays.asList(array);
        }
        return result;
    }

    public static int cvtReportTypeToInt(String reportType) {
        int exchangeSign = 1;
        if ("SH".equals(reportType)) {
            exchangeSign = 1;
        } else if ("SS".equals(reportType)) {
            exchangeSign = 2;
        }
        return exchangeSign;
    }
}

