/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.apache.log4j.Logger;

public class PropertiesUtil {
    private static final Logger log = Logger.getLogger(PropertiesUtil.class);
    private static PropertiesUtil propUtil = null;
    private static Map<String, Map> propFilesMap = null;

    private PropertiesUtil() {
    }

    public static PropertiesUtil getInstance() {
        if (propUtil == null) {
            propUtil = new PropertiesUtil();
            propFilesMap = new HashMap();
        }
        return propUtil;
    }

    public synchronized Map<String, String> load(String fileName) {
        log.debug((Object)"load start");
        Object obj = propFilesMap.get(fileName);
        if (obj != null) {
            return (Map)obj;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        try {
            PropertyResourceBundle cfg = (PropertyResourceBundle)PropertyResourceBundle.getBundle(fileName);
            Enumeration<String> keys = cfg.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = (String)cfg.getObject(key);
                propMap.put(key, value);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        propFilesMap.put(fileName, propMap);
        log.debug((Object)"load end");
        return propMap;
    }

    public synchronized Map<String, Integer> loadToInt(String fileName) {
        log.debug((Object)"loadToInt start");
        Object obj = propFilesMap.get(fileName);
        if (obj != null) {
            return (Map)obj;
        }
        HashMap<String, Integer> propMap = new HashMap<String, Integer>();
        try {
            PropertyResourceBundle cfg = (PropertyResourceBundle)PropertyResourceBundle.getBundle(fileName);
            Enumeration<String> keys = cfg.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = (String)cfg.getObject(key);
                propMap.put(key, new Integer(value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        propFilesMap.put(fileName, propMap);
        log.debug((Object)"loadToInt end");
        return propMap;
    }
}

