/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.manger.xml.xml;

import com.rw.aml.model.report.NssReportModel;
import com.rw.aml.model.table.TExpNssClientModel;
import com.rw.aml.model.table.TExpNssModel;
import com.rw.aml.model.table.TExpNssTradeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NssXmlBuilder {
    private static NssXmlBuilder builder;

    private NssXmlBuilder() {
    }

    public static NssXmlBuilder getInstance() {
        if (builder == null) {
            builder = new NssXmlBuilder();
        }
        return builder;
    }

    public String build(NssReportModel reportModel) throws RuntimeException {
        String result = this.getReportXML(reportModel);
        return result;
    }

    public List<String> build(List<NssReportModel> reportModelList) throws RuntimeException {
        ArrayList<String> resultList = new ArrayList<String>();
        for (NssReportModel reportModel : reportModelList) {
            String result = this.getReportXML(reportModel);
            resultList.add(result);
        }
        return resultList;
    }

    private String getReportXML(NssReportModel reportModel) throws RuntimeException {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"GB18030\" ?>");
        if (reportModel == null) {
            return sb.toString();
        }
        TExpNssModel baseModel = reportModel.getBaseModel();
        List clientModelList = reportModel.getClientModelList();
        List tradeModelList = reportModel.getTradeModelList();
        Map clientCorpInfoMap = reportModel.getClientCorpInfoMap();
        int clientCnt = 0;
        if (clientModelList != null) {
            clientCnt = clientModelList.size();
        }
        int tradeCnt = 0;
        if (tradeModelList != null) {
            tradeCnt = tradeModelList.size();
        }
        sb.append("<SSTR>");
        sb.append(baseModel.GetRBIFInfo(clientCnt, tradeCnt));
        sb.append("<CTIFs>");
        if (clientModelList != null) {
            i = 0;
            while (i < clientCnt) {
                TExpNssClientModel ctif = (TExpNssClientModel)clientModelList.get(i);
                String fdac = ctif.getFdac();
                List corpInfoList = (List)clientCorpInfoMap.get(fdac);
                sb.append(ctif.getXmlString(corpInfoList));
                ++i;
            }
        }
        sb.append("</CTIFs>");
        sb.append("<RPDIs>");
        if (tradeModelList != null) {
            i = 0;
            while (i < tradeCnt) {
                TExpNssTradeModel rpdi = (TExpNssTradeModel)tradeModelList.get(i);
                sb.append(rpdi.getXmlString());
                ++i;
            }
        }
        sb.append("</RPDIs>");
        sb.append("</SSTR>");
        return sb.toString();
    }
}

