/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.manger.xml.data;

import com.rw.aml.dao.NssReportDAO;
import com.rw.aml.model.report.NssReportModel;
import com.rw.aml.model.table.TExpNssClientModel;
import com.rw.aml.model.table.TExpNssModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NssDataBuilder {
    @Autowired
    private NssReportDAO nssReportDAO;
    private static NssDataBuilder builder;

    public static NssDataBuilder getInstance() {
        if (builder == null) {
            builder = new NssDataBuilder();
        }
        return builder;
    }

    public List<NssReportModel> getNssReportInfo(List<String> sstrIdList) throws Exception {
        ArrayList<NssReportModel> resultList = null;
        List baseModelList = this.nssReportDAO.getTExpNssInfo(sstrIdList);
        if (baseModelList != null && baseModelList.size() != 0) {
            int reportNum = baseModelList.size();
            resultList = new ArrayList<NssReportModel>(reportNum);
            for (TExpNssModel baseModel : baseModelList) {
                NssReportModel reportModel = this.getNssReportInfo(baseModel);
                resultList.add(reportModel);
            }
        }
        return resultList;
    }

    public NssReportModel getNssReportInfo(String sstrId) throws Exception {
        TExpNssModel baseModel = this.nssReportDAO.getTExpNssInfo(sstrId);
        NssReportModel reportModel = this.getNssReportInfo(baseModel);
        return reportModel;
    }

    private NssReportModel getNssReportInfo(TExpNssModel baseModel) throws Exception {
        NssReportModel reportModel = null;
        if (baseModel != null) {
            reportModel = new NssReportModel();
            reportModel.setBaseModel(baseModel);
            String subSstrId = baseModel.getSstrId();
            List clientModelList = this.nssReportDAO.getTExpNssClientInfoLst(subSstrId);
            reportModel.setClientModelList(clientModelList);
            HashMap<String, List> clientCorpInfoMap = null;
            if (clientModelList != null && clientModelList.size() != 0) {
                clientCorpInfoMap = new HashMap<String, List>();
                for (TExpNssClientModel clientModel : clientModelList) {
                    String fdac = clientModel.getFdac();
                    Object obj = clientCorpInfoMap.get(fdac);
                    if (obj != null) continue;
                    List corpInfoList = this.nssReportDAO.getTExpClientCorpInfoLst(fdac);
                    clientCorpInfoMap.put(fdac, corpInfoList);
                }
            }
            reportModel.setClientCorpInfoMap(clientCorpInfoMap);
            List tradeModelList = this.nssReportDAO.getTExpNssTradeInfoLst(subSstrId);
            reportModel.setTradeModelList(tradeModelList);
            String reportId = baseModel.getReportId();
            List fileModelList = this.nssReportDAO.getTExpNssAttachmentInfoLst(reportId);
            reportModel.setFileModelList(fileModelList);
        }
        return reportModel;
    }
}

