/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.manger.xml.data;

import com.rw.aml.dao.DshReportDAO;
import com.rw.aml.model.report.DshReportModel;
import com.rw.aml.model.table.TExpDshCustModel;
import com.rw.aml.model.table.TExpDshModel;
import com.rw.aml.model.table.TExpDshTradeTotalModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DshDataBuilder {
    private static DshDataBuilder builder;
    @Autowired
    private DshReportDAO dshReportDAO;

    public static DshDataBuilder getInstance() {
        if (builder == null) {
            builder = new DshDataBuilder();
        }
        return builder;
    }

    public List<DshReportModel> getNshReportInfo(List<String> dshIdList, int actionId) throws RuntimeException {
        ArrayList<DshReportModel> resultList = null;
        List baseModelList = this.dshReportDAO.getTExpDshInfo(dshIdList);
        if (baseModelList != null && baseModelList.size() != 0) {
            int reportNum = baseModelList.size();
            resultList = new ArrayList<DshReportModel>(reportNum);
            for (TExpDshModel model : baseModelList) {
                DshReportModel reportModel = this.getNshReportInfo(model, actionId);
                resultList.add(reportModel);
            }
        }
        return resultList;
    }

    public DshReportModel getNshReportInfo(String dshId, int actionId) throws Exception {
        TExpDshModel baseModel = this.dshReportDAO.getTExpDshInfo(dshId);
        DshReportModel reportModel = this.getNshReportInfo(baseModel, actionId);
        return reportModel;
    }

    private DshReportModel getNshReportInfo(TExpDshModel baseModel, int actionId) throws RuntimeException {
        DshReportModel reportModel = null;
        if (baseModel != null) {
            reportModel = new DshReportModel();
            reportModel.setBaseModel(baseModel);
            String dshId = baseModel.getDshId();
            int records = this.dshReportDAO.getAllTradeDetailNumber(dshId);
            if (records > 10000) {
                throw new RuntimeException("\u8be5\u62a5\u6587\u7684\u6240\u542b\u4ea4\u6613\u7b14\u6570\u5fc5\u987b\u5c0f\u4e8e10000\u6761!");
            }
            switch (actionId) {
                case 0: 
                case 1: 
                case 2: {
                    List clientModelList = this.dshReportDAO.getTExpDshCustInfoLst(dshId);
                    reportModel.setClientModelList(clientModelList);
                    if (clientModelList == null) break;
                    HashMap<String, List> totalTradeMap = new HashMap<String, List>();
                    HashMap<String, List> detailTradeMap = new HashMap<String, List>();
                    for (TExpDshCustModel clientModel : clientModelList) {
                        String catiId = clientModel.getCatiId();
                        List tradeTotalList = this.dshReportDAO.getTExpDshTradeTotalInfo(catiId);
                        totalTradeMap.put(catiId, tradeTotalList);
                        if (tradeTotalList == null) continue;
                        for (TExpDshTradeTotalModel tradeTotal : tradeTotalList) {
                            String htcrId = tradeTotal.getHtcrId();
                            List tradeDetailList = this.dshReportDAO.getTExpDshTradeDetailInfoList(htcrId);
                            detailTradeMap.put(htcrId, tradeDetailList);
                        }
                    }
                    reportModel.setTotalTradeMap(totalTradeMap);
                    reportModel.setDetailTradeMap(detailTradeMap);
                    break;
                }
                case 3: 
                case 4: {
                    List vwDshCihtrDetailList = this.dshReportDAO.getVDshCihtrDetailInfo(dshId);
                    reportModel.setVwDshCihtrDetailList(vwDshCihtrDetailList);
                    break;
                }
                case 5: {
                    List vwDshDhtrDetailList = this.dshReportDAO.getVDshDhtrDetailModel(dshId);
                    reportModel.setVwDshDhtrDetailList(vwDshDhtrDetailList);
                    break;
                }
            }
        }
        return reportModel;
    }
}

