/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.manger.xml.build;

import com.rw.aml.dao.AmlBaseDAO;
import com.rw.aml.dao.DshReportDAOImpl;
import com.rw.aml.manger.xml.build.name.AddFileNameType;
import com.rw.aml.manger.xml.build.name.CorrectFileNameType;
import com.rw.aml.manger.xml.build.name.DeleteFileNameType;
import com.rw.aml.manger.xml.build.name.FileNameType;
import com.rw.aml.manger.xml.build.name.NormalFileNameType;
import com.rw.aml.manger.xml.build.name.RectiFileNameType;
import com.rw.aml.manger.xml.build.name.ResendFileNameType;
import com.rw.aml.model.report.ZipFileModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportFilesModel;
import com.rw.aml.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ReportBuild {
    public static final String tblSchema = "amldata";
    @Autowired
    private DshReportDAOImpl dshReportDAO;
    @Autowired
    private AmlBaseDAO amlBaseDAO;

    protected abstract ZipFileModel build(List<String> var1, int var2, String var3) throws Exception;

    public void processDataBuild(List<String> sqlList, byte[] content, String fileUuid) {
        this.dshReportDAO.batchExcute(sqlList);
        this.dshReportDAO.insertFileContent(content, fileUuid);
    }

    protected FileNameType getFileNameTypeByAction(int actionId, String exchangeSign) throws RuntimeException {
        NormalFileNameType type = null;
        switch (actionId) {
            case 0: {
                type = new NormalFileNameType(exchangeSign);
                break;
            }
            case 1: {
                type = new ResendFileNameType(exchangeSign);
                break;
            }
            case 2: {
                type = new AddFileNameType(exchangeSign);
                break;
            }
            case 3: {
                type = new CorrectFileNameType(exchangeSign);
                break;
            }
            case 4: {
                type = new RectiFileNameType(exchangeSign);
                break;
            }
            case 5: {
                if ("SH".equals(exchangeSign)) {
                    type = new DeleteFileNameType(exchangeSign);
                    break;
                }
                throw new RuntimeException("\u53ef\u7591\u62a5\u6587\u4e0d\u80fd\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff01");
            }
        }
        if (type == null) {
            throw new RuntimeException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
        }
        return type;
    }

    protected String getInstReportFileSql(TReportFilesModel model) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into amldata.t_report_files(pk_id, object_id, report_type, message_type, report_date, build_date, zip_no)");
        sql.append(" values('");
        sql.append(model.getId());
        sql.append("','");
        sql.append(model.getObjectId());
        sql.append("','");
        int exchangeSign = StrUtil.cvtReportTypeToInt((String)model.getReportType());
        sql.append(exchangeSign);
        sql.append("','");
        sql.append(model.getMessageType());
        sql.append("','");
        sql.append(model.getReportDate());
        sql.append("',");
        sql.append("sysdate,");
        sql.append(model.getZipNo());
        sql.append(")");
        return sql.toString();
    }

    protected String getInstFileSql(TFileModel model) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into wolfdata.t_files(id, object_id, name, file_size, extension, create_by, create_time, file_flag)");
        sql.append(" values('");
        sql.append(model.getId());
        sql.append("','");
        sql.append(model.getObjectId());
        sql.append("','");
        sql.append(model.getName());
        sql.append("','");
        sql.append(model.getFileSize());
        sql.append("','");
        sql.append(model.getExtension());
        sql.append("','");
        sql.append(model.getCreateBy());
        sql.append("',");
        sql.append("sysdate,'");
        sql.append(model.getCreateBy());
        sql.append("')");
        return sql.toString();
    }

    protected boolean checkZipFileSize(String fileName, long cmpSize) throws Exception {
        boolean blResult = Boolean.FALSE;
        long size = 0L;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        FileInputStream fis = new FileInputStream(file);
        size = fis.available();
        fis.close();
        if (size > cmpSize) {
            blResult = Boolean.TRUE;
        }
        return blResult;
    }

    protected List<String> getUpdateOldCodeSql(Map<String, String> codeMap, int type) throws Exception {
        ArrayList<String> sqlList = null;
        if (codeMap != null && codeMap.size() != 0) {
            sqlList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : codeMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String sql = "";
                if (type == 1) {
                    sql = "update amldata.T_EXP_DSH t set t.old_code = '" + value + "' where t.dsh_id = '" + key + "'";
                } else if (type == 2) {
                    sql = "update amldata.T_EXP_NSS t set t.old_code = '" + value + "' where t.sstr_id = '" + key + "'";
                }
                sqlList.add(sql);
            }
        }
        return sqlList;
    }

    public TFileModel getFileContentByParameter(String objectIds, String reportType, String messageType) throws Exception {
        return this.amlBaseDAO.getFileContentByParameter(objectIds, reportType, messageType);
    }

    public TFileModel getFileContentByReportId(String reportId) throws Exception {
        return this.amlBaseDAO.getFileContentByReportId(reportId);
    }

    public ZipFileModel getFileContent(TFileModel model) throws Exception {
        ZipFileModel zipFileModel = new ZipFileModel();
        String id = model.getId();
        zipFileModel.setName(model.getName());
        zipFileModel.setExtension(model.getExtension());
        byte[] content = this.amlBaseDAO.getFileContent(id);
        zipFileModel.setContent(content);
        return zipFileModel;
    }
}

