/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.manger.xml.build;

import com.rw.aml.manger.xml.build.ReportBuild;
import com.rw.aml.manger.xml.build.name.FileNameType;
import com.rw.aml.manger.xml.data.NssDataBuilder;
import com.rw.aml.manger.xml.xml.NssXmlBuilder;
import com.rw.aml.model.report.NssReportModel;
import com.rw.aml.model.report.ZipFileModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportFilesModel;
import com.rw.aml.util.FileUtil;
import com.rw.aml.util.StrUtil;
import com.rw.aml.util.XmlUtil;
import com.rw.aml.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NssReportBuilder
extends ReportBuild {
    private static final Logger logger = Logger.getLogger(NssReportBuilder.class);
    @Autowired
    private NssDataBuilder nssDataBuilder;

    public ZipFileModel build(List<String> sstrIdList, int actionId, String userCode) throws Exception {
        logger.debug((Object)"build start...");
        String dirPath = StrUtil.getZipDirPath();
        if (sstrIdList == null || sstrIdList.size() == 0) {
            throw new RuntimeException("\u8be5\u9009\u62e9\u62a5\u544a!");
        }
        List reportModelList = this.nssDataBuilder.getNssReportInfo(sstrIdList);
        if (reportModelList == null || reportModelList.size() == 0) {
            throw new RuntimeException("\u8be5\u62a5\u544a\u65e0\u6570\u636e!");
        }
        FileNameType fileNameType = this.getFileNameTypeByAction(actionId, "SS");
        String zipFileName = fileNameType.generateZipName(userCode);
        String zipPath = String.valueOf(dirPath) + zipFileName;
        File file = new File(zipPath);
        if (!file.exists()) {
            file.mkdir();
        }
        int serNo = 1;
        HashMap<String, String> newCodeMap = new HashMap<String, String>();
        for (NssReportModel reportModel : reportModelList) {
            String strXml = NssXmlBuilder.getInstance().build(reportModel);
            String oldCode = reportModel.getBaseModel().getOldCode();
            String xmlFileName = fileNameType.generateXmlFileName(serNo, oldCode);
            String newCode = fileNameType.getNewCode();
            if (newCode != null && !"".equals(newCode)) {
                String sstrId = reportModel.getBaseModel().getSstrId();
                newCodeMap.put(sstrId, newCode);
            }
            String xmlAttachPath = String.valueOf(zipPath) + File.separator + xmlFileName;
            XmlUtil.string2XmlFile((String)strXml, (String)(String.valueOf(xmlAttachPath) + "." + "XML".toUpperCase()));
            List attachList = reportModel.getFileModelList();
            if (attachList != null && attachList.size() > 0) {
                File attachFile = new File(xmlAttachPath);
                if (!attachFile.exists()) {
                    attachFile.mkdir();
                }
                for (TFileModel attachModel : attachList) {
                    String attachFileName = String.valueOf(attachModel.getName()) + "." + attachModel.getExtension();
                    logger.debug((Object)("attachFileName:" + attachFileName));
                    FileUtil.byteToFile((byte[])attachModel.getContent(), (String)(String.valueOf(xmlAttachPath) + File.separator + attachFileName));
                }
                String attZipDestFile = String.valueOf(zipPath) + File.separator + xmlFileName + "." + "ZIP".toUpperCase();
                ZipUtil.zip((String)xmlAttachPath, (String)attZipDestFile);
                if (this.checkZipFileSize(attZipDestFile, 0x200000L)) {
                    FileUtil.delDir((File)attachFile);
                    throw new RuntimeException("\u9644\u4ef6\u5927\u5c0f\u8d85\u8fc72M!");
                }
                FileUtil.delDir((File)attachFile);
            }
            ++serNo;
        }
        String zipDestFile = String.valueOf(dirPath) + File.separator + zipFileName + "." + "ZIP".toUpperCase();
        ZipUtil.zip((String)zipPath, (String)zipDestFile);
        if (this.checkZipFileSize(zipDestFile, 0x500000L)) {
            FileUtil.delDir((File)file);
            throw new RuntimeException("\u6570\u636e\u5305\u5927\u5c0f\u8d85\u8fc75M!");
        }
        FileUtil.delDir((File)file);
        ArrayList<String> sqlList = new ArrayList<String>();
        TReportFilesModel rptFilesModel = new TReportFilesModel();
        UUID uuid = UUID.randomUUID();
        rptFilesModel.setId(uuid.toString());
        rptFilesModel.setMessageType(String.valueOf(actionId));
        rptFilesModel.setObjectId(StrUtil.listToString(sstrIdList, (char)','));
        rptFilesModel.setReportType("SS");
        rptFilesModel.setReportDate(fileNameType.getReportDate());
        rptFilesModel.setZipNo(fileNameType.getZipNo());
        String instReportFileSql = this.getInstReportFileSql(rptFilesModel);
        sqlList.add(instReportFileSql);
        List cdSqlList = this.getUpdateOldCodeSql(newCodeMap, 2);
        if (cdSqlList != null) {
            sqlList.addAll(cdSqlList);
        }
        byte[] content = FileUtil.fileToByte((String)zipDestFile);
        ZipFileModel result = new ZipFileModel();
        result.setContent(content);
        result.setName(zipFileName);
        result.setExtension("ZIP".toUpperCase());
        TFileModel fileModel = new TFileModel();
        fileModel.setCreateBy(userCode);
        fileModel.setFileFlag(userCode);
        fileModel.setObjectId(uuid.toString());
        UUID fileUuid = UUID.randomUUID();
        fileModel.setId(fileUuid.toString());
        fileModel.setName(zipFileName);
        fileModel.setFileSize(String.valueOf(content.length));
        fileModel.setExtension("ZIP".toUpperCase());
        String tbfileSql = this.getInstFileSql(fileModel);
        sqlList.add(tbfileSql);
        this.processDataBuild(sqlList, content, fileUuid.toString());
        logger.debug((Object)"build end...");
        return result;
    }
}

