/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.dao;

import com.rw.aml.dao.AmlBaseDAOImpl;
import com.rw.aml.dao.NssReportDAO;
import com.rw.aml.model.table.TExpClientCorpInfoModel;
import com.rw.aml.model.table.TExpNssClientModel;
import com.rw.aml.model.table.TExpNssModel;
import com.rw.aml.model.table.TExpNssTradeModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.util.CommonKit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="nssReportDAO")
public class NssReportDAOImpl
extends AmlBaseDAOImpl
implements NssReportDAO {
    private static final Logger logger = LoggerFactory.getLogger(NssReportDAOImpl.class);

    public List<TExpNssModel> getTExpNssInfo(List<String> sstrIdList) throws RuntimeException {
        logger.debug("getTExpNssInfo start...");
        String sql = "select * from amldata.T_EXP_NSS t ";
        if (sstrIdList != null && sstrIdList.size() > 0) {
            StringBuilder newSql = new StringBuilder();
            newSql.append(sql);
            newSql.append(" where t.sstr_id in");
            newSql.append("(");
            for (String dshId : sstrIdList) {
                newSql.append("'");
                newSql.append(dshId);
                newSql.append("'");
                newSql.append(",");
            }
            newSql.deleteCharAt(newSql.length() - 1);
            newSql.append(")");
            sql = newSql.toString();
        }
        List list = this.findList(sql);
        ArrayList<TExpNssModel> modelList = new ArrayList<TExpNssModel>(list.size());
        for (Map map : list) {
            TExpNssModel model = (TExpNssModel)CommonKit.mapToModel((Map)map, (Object)new TExpNssModel());
            modelList.add(model);
        }
        return modelList;
    }

    public TExpNssModel getTExpNssInfo(String sstrId) throws RuntimeException {
        logger.debug("getTExpNssInfo start...");
        String sql = "select * from amldata.T_EXP_NSS t where t.sstr_id= ?";
        List list = this.findList(sql, new Object[]{sstrId});
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            TExpNssModel model = (TExpNssModel)CommonKit.mapToModel((Map)map, (Object)new TExpNssModel());
            return model;
        }
        return null;
    }

    public List<TExpNssClientModel> getTExpNssClientInfoLst(String sstrId) throws RuntimeException {
        logger.debug("getTExpNssClientInfoLst start...");
        String sql = "select * from amldata.T_EXP_NSS_CLIENT t where t.sstr_id= ? order by chif_seqno";
        List list = this.findList(sql, new Object[]{sstrId});
        ArrayList<TExpNssClientModel> modelList = new ArrayList<TExpNssClientModel>(list.size());
        for (Map map : list) {
            TExpNssClientModel model = (TExpNssClientModel)CommonKit.mapToModel((Map)map, (Object)new TExpNssClientModel());
            modelList.add(model);
        }
        return modelList;
    }

    public List<TExpClientCorpInfoModel> getTExpClientCorpInfoLst(String fdac) throws RuntimeException {
        logger.debug("getTExpClientCorpInfoLst start...");
        String sql = "select * from amldata.T_EXP_CLIENT_CORP_INFO t where t.CLIENT_ID = ?";
        List list = this.findList(sql, new Object[]{fdac});
        ArrayList<TExpClientCorpInfoModel> modelList = new ArrayList<TExpClientCorpInfoModel>(list.size());
        for (Map map : list) {
            TExpClientCorpInfoModel model = (TExpClientCorpInfoModel)CommonKit.mapToModel((Map)map, (Object)new TExpClientCorpInfoModel());
            modelList.add(model);
        }
        return modelList;
    }

    public List<TExpNssTradeModel> getTExpNssTradeInfoLst(String sstrId) throws RuntimeException {
        logger.debug("getTExpNssTradeInfoLst start...");
        String sql = "select * from amldata.T_EXP_NSS_TRADE t where t.sstr_id= ? order by rpdi_seqno";
        List list = this.findList(sql, new Object[]{sstrId});
        ArrayList<TExpNssTradeModel> modelList = new ArrayList<TExpNssTradeModel>(list.size());
        for (Map map : list) {
            TExpNssTradeModel model = (TExpNssTradeModel)CommonKit.mapToModel((Map)map, (Object)new TExpNssTradeModel());
            modelList.add(model);
        }
        return modelList;
    }

    public List<TFileModel> getTExpNssAttachmentInfoLst(String reportId) throws RuntimeException {
        logger.debug("getTExpNssAttachmentInfoLst start...");
        String sql = "select * from WOLFDATA.t_files f, wolfdata.t_file_content c where f.id = c.id and f.object_id = ?";
        List list = this.findList(sql, new Object[]{reportId});
        ArrayList<TFileModel> modelList = new ArrayList<TFileModel>(list.size());
        for (Map map : list) {
            TFileModel model = (TFileModel)CommonKit.mapToModel((Map)map, (Object)new TFileModel());
            modelList.add(model);
        }
        return modelList;
    }
}

