/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.dao;

import com.rw.aml.dao.AmlBaseDAOImpl;
import com.rw.aml.dao.DshReportDAO;
import com.rw.aml.model.table.TExpDshCustModel;
import com.rw.aml.model.table.TExpDshModel;
import com.rw.aml.model.table.TExpDshTradeDetailModel;
import com.rw.aml.model.table.TExpDshTradeTotalModel;
import com.rw.aml.model.table.VDshCihtrDetailModel;
import com.rw.aml.model.table.VDshDhtrDetailModel;
import com.rw.annotation.SystemDaoLog;
import com.rw.util.CommonKit;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="dshReportDAO")
public class DshReportDAOImpl
extends AmlBaseDAOImpl
implements DshReportDAO {
    private static final Logger logger = LoggerFactory.getLogger(DshReportDAOImpl.class);

    @SystemDaoLog(description="\u83b7\u53d6\u5355\u4e2a\u5927\u989d\u4e0a\u62a5\u4fe1\u606f")
    public TExpDshModel getTExpDshInfo(String dshId) throws RuntimeException {
        logger.debug("getTExpDshInfo start...");
        String sql = "select * from amldata.T_EXP_DSH t where t.dsh_id= ?";
        List list = this.findList(sql, new Object[]{dshId});
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            TExpDshModel model = (TExpDshModel)CommonKit.mapToModel((Map)map, (Object)new TExpDshModel());
            return model;
        }
        return null;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u4e00\u7ec4\u5927\u989d\u4e0a\u62a5\u4fe1\u606f")
    public List<TExpDshModel> getTExpDshInfo(List<String> dshIdList) throws RuntimeException {
        logger.debug("getTExpDshInfo start...");
        String sql = "select * from amldata.T_EXP_DSH t ";
        if (dshIdList != null && dshIdList.size() > 0) {
            StringBuilder newSql = new StringBuilder();
            newSql.append(sql);
            newSql.append(" where t.dsh_id in");
            newSql.append("(");
            for (String dshId : dshIdList) {
                newSql.append("'");
                newSql.append(dshId);
                newSql.append("'");
                newSql.append(",");
            }
            newSql.deleteCharAt(newSql.length() - 1);
            newSql.append(")");
            sql = newSql.toString();
        }
        List list = this.findList(sql);
        ArrayList<TExpDshModel> modelList = new ArrayList<TExpDshModel>(list.size());
        for (Map map : list) {
            TExpDshModel model = (TExpDshModel)CommonKit.mapToModel((Map)map, (Object)new TExpDshModel());
            modelList.add(model);
        }
        return modelList;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u5927\u989d\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u603b\u6570")
    public int getAllTradeDetailNumber(String dshId) throws RuntimeException {
        logger.debug("getAllTradeDetailNumber start...");
        int size = 0;
        String sql = "select count(dsh_id) as records from amldata.T_EXP_DSH_TRADE_D t where t.dsh_id= ?";
        List list = this.findList(sql, new Object[]{dshId});
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            size = ((BigDecimal)map.get("RECORDS")).intValue();
        }
        logger.debug("getAllTradeDetailNumber end...");
        return size;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u5927\u989d\u4ea4\u6613\u5ba2\u6237")
    public List<TExpDshCustModel> getTExpDshCustInfoLst(String dshId) throws RuntimeException {
        logger.debug("getTExpDshCustInfoLst start...");
        String sql = "select * from amldata.T_EXP_DSH_CUST t where t.dsh_id= ? order by t.cati_seqno";
        List list = this.findList(sql, new Object[]{dshId});
        ArrayList<TExpDshCustModel> modelList = new ArrayList<TExpDshCustModel>(list.size());
        for (Map map : list) {
            TExpDshCustModel model = (TExpDshCustModel)CommonKit.mapToModel((Map)map, (Object)new TExpDshCustModel());
            modelList.add(model);
        }
        return modelList;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u5927\u989d\u4ea4\u6613\u603b\u6570\u4fe1\u606f")
    public List<TExpDshTradeTotalModel> getTExpDshTradeTotalInfo(String catiId) throws RuntimeException {
        logger.debug("getTExpDshTradeTotalInfo start...");
        String sql = "select * from amldata.T_EXP_DSH_TRADE_T t where t.cati_id= ?";
        List list = this.findList(sql, new Object[]{catiId});
        ArrayList<TExpDshTradeTotalModel> modelList = new ArrayList<TExpDshTradeTotalModel>(list.size());
        for (Map map : list) {
            TExpDshTradeTotalModel model = (TExpDshTradeTotalModel)CommonKit.mapToModel((Map)map, (Object)new TExpDshTradeTotalModel());
            modelList.add(model);
        }
        return modelList;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u5927\u989d\u4ea4\u6613\u660e\u7ec6\u6570\u636e")
    public List<TExpDshTradeDetailModel> getTExpDshTradeDetailInfoList(String htcrId) throws RuntimeException {
        logger.debug("getTExpDshTradeDetailInfo start...");
        String sql = "select * from amldata.T_EXP_DSH_TRADE_D t where t.htcr_id= ? order\u3000 by t.tsdt_seqno ";
        List list = this.findList(sql, new Object[]{htcrId});
        ArrayList<TExpDshTradeDetailModel> modelList = new ArrayList<TExpDshTradeDetailModel>(list.size());
        for (Map map : list) {
            TExpDshTradeDetailModel model = (TExpDshTradeDetailModel)CommonKit.mapToModel((Map)map, (Object)new TExpDshTradeDetailModel());
            String cratValue = model.getCrat();
            model.setCrat(this.formateCratValue(cratValue));
            modelList.add(model);
        }
        return modelList;
    }

    private String formateCratValue(String cratValue) {
        if (cratValue != null & !"".equals(cratValue)) {
            double cratDblValue = Double.parseDouble(cratValue);
            if (cratDblValue < 0.0) {
                cratDblValue *= -1.0;
            }
            String pattern = "0.###";
            DecimalFormat fmt = new DecimalFormat(pattern);
            cratValue = fmt.format((Object)cratDblValue).toString();
            return cratValue;
        }
        return null;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u5927\u989d\u4e0a\u62a5\u62a5\u6587\u5ba2\u6237\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f")
    public List<VDshCihtrDetailModel> getVDshCihtrDetailInfo(String dshId) throws RuntimeException {
        logger.debug("getVDshCihtrDetailInfo end...");
        String sql = "SELECT * FROM  AMLCONFIG.V_DSH_CIHTR_DETAIL v where v.dsh_id = ? by v.TSDT_SEQNO";
        List list = this.findList(sql, new Object[]{dshId});
        ArrayList<VDshCihtrDetailModel> modelList = new ArrayList<VDshCihtrDetailModel>(list.size());
        for (Map map : list) {
            VDshCihtrDetailModel model = (VDshCihtrDetailModel)CommonKit.mapToModel((Map)map, (Object)new VDshCihtrDetailModel());
            modelList.add(model);
        }
        return modelList;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u5927\u989d\u4e0a\u62a5\u62a5\u6587\u5ba2\u6237\u57fa\u672c\u4fe1\u606f")
    public List<VDshDhtrDetailModel> getVDshDhtrDetailModel(String dshId) throws RuntimeException {
        logger.debug("getVDshDhtrDetailModel end...");
        String sql = "SELECT * FROM  AMLCONFIG.V_DSH_DHTR_DETAIL  v where v.dsh_id = ? order by v.seqno";
        List list = this.findList(sql, new Object[]{dshId});
        ArrayList<VDshDhtrDetailModel> modelList = new ArrayList<VDshDhtrDetailModel>(list.size());
        for (Map map : list) {
            VDshDhtrDetailModel model = (VDshDhtrDetailModel)CommonKit.mapToModel((Map)map, (Object)new VDshDhtrDetailModel());
            modelList.add(model);
        }
        return modelList;
    }
}

