/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.dao;

import com.rw.aml.dao.AmlBaseDAO;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportModel;
import com.rw.aml.util.StrUtil;
import com.rw.annotation.SystemDaoLog;
import com.rw.dao.BaseDAOImpl;
import com.rw.util.CommonKit;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="amlBaseDAO")
public class AmlBaseDAOImpl
extends BaseDAOImpl
implements AmlBaseDAO {
    private static final Logger logger = LoggerFactory.getLogger(AmlBaseDAOImpl.class);
    public static final String tblSchema = "amldata";
    public static final String IS_SUB_COMPANY_CODE = "0";

    @SystemDaoLog(description="\u67e5\u8be2\u62a5\u8868")
    public TReportModel findReport(String uniqueId) throws RuntimeException {
        String sql = "select * from amldata.T_REPORT t where t.unique_rowid = ?";
        List list = this.findList(sql, new Object[]{uniqueId});
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            TReportModel model = (TReportModel)CommonKit.mapToModel((Map)map, (Object)new TReportModel());
            String reportInTime = model.getReportInTime();
            reportInTime = reportInTime.substring(0, reportInTime.length() - 2);
            model.setReportInTime(reportInTime);
            return model;
        }
        return null;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u4e0a\u62a5\u673a\u6784\u4ee3\u7801")
    public String getReportOrgNum(String userId) throws RuntimeException {
        logger.debug("getReportOrgNum start...");
        String result = "";
        String sql = "";
        sql = "1".equals(IS_SUB_COMPANY_CODE) ? "SELECT a.dept_id   FROM (SELECT DISTINCT tdg.dept_id, tdg.parent_dept, tdg.dept_name   FROM wolf.wb_dept tdg   START WITH (EXISTS (SELECT 1   FROM (select c.dept_id from wolf.wb_user a   inner join wolf.wb_user_role b    on a.user_id = b.user_id    inner join wolf.t_dept_privilege c     on b.role_id = c.role_id     union all select a.dept_id  from wolf.wb_user a  inner join wolf.wb_dept b   on a.dept_id = b.dept_id) tdc    WHERE tdc.dept_id = tdg.dept_id))   CONNECT BY PRIOR parent_dept = dept_id) a   LEFT JOIN (SELECT trdp.dept_id, MAX(1) enable_flag            FROM wolf.t_dept_privilege trdp   JOIN wolf.wb_user_role tur   ON trdp.role_id = tur.role_id  inner  join wolf.wb_user tu     on tur.user_id = tu.user_id   WHERE tu.user_name = '" + userId + "'" + "              GROUP BY trdp.dept_id) b  ON a.dept_id = b.dept_id   where a.parent_dept = '-1'" : "SELECT * FROM  amldata.T_EXP_COMPANY_CODE";
        List list = this.findList(sql);
        if (list.size() > 0) {
            String area_code;
            Map map = (Map)list.get(0);
            result = area_code = (String)map.get("COMPANY_CODE");
        }
        logger.debug("getReportOrgNum end...");
        return result;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u4e0a\u62a5\u673a\u6784\u4ee3\u7801")
    public Map<String, Object> getReportBaseData(String userId) throws RuntimeException {
        logger.debug("getReportBaseData start");
        String sql = "";
        sql = "1".equals(IS_SUB_COMPANY_CODE) ? "SELECT a.dept_id   FROM (SELECT DISTINCT tdg.dept_id, tdg.parent_dept, tdg.dept_name   FROM wolf.wb_dept tdg   START WITH (EXISTS (SELECT 1   FROM (select c.dept_id from wolf.wb_user a   inner join wolf.wb_user_role b    on a.user_id = b.user_id    inner join wolf.t_dept_privilege c     on b.role_id = c.role_id     union all select a.dept_id  from wolf.wb_user a  inner join wolf.wb_dept b   on a.dept_id = b.dept_id) tdc    WHERE tdc.dept_id = tdg.dept_id))   CONNECT BY PRIOR parent_dept = dept_id) a   LEFT JOIN (SELECT trdp.dept_id, MAX(1) enable_flag            FROM wolf.t_dept_privilege trdp   JOIN wolf.wb_user_role tur   ON trdp.role_id = tur.role_id  inner  join wolf.wb_user tu     on tur.user_id = tu.user_id   WHERE tu.user_name = '" + userId + "'" + "  GROUP BY trdp.dept_id) b  ON a.dept_id = b.dept_id   where a.parent_dept = '-1'" : "select distinct t.code as typecode from amldata.T_EXP_COMPANY_CODE t";
        List list = this.findList(sql);
        if (list.size() == 1) {
            logger.debug("list size is 1");
            Map map = (Map)list.get(0);
            return map;
        }
        if (list.size() > 1) {
            logger.debug("list size > 1");
            throw new RuntimeException("\u6570\u636e\u5e93\u6709\u810f\u6570\u636e\u5b58\u5728!");
        }
        return null;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u62a5\u8868\u521b\u5efa\u65f6\u95f4")
    public String getReportDate() throws RuntimeException {
        logger.debug("getReportDate start...");
        String result = "";
        String sql = "select to_char(sysdate, 'yyyyMMdd') as reportDate from dual";
        List list = this.findList(sql);
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            result = (String)map.get("REPORTDATE");
        }
        logger.debug("getReportDate end...");
        return result;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u4e0a\u62a5\u62a5\u8868zipNO")
    public int getZipNoInReportFile(String reportType) throws RuntimeException {
        logger.debug("getZipNoInReportFile start...");
        int exchangeSign = StrUtil.cvtReportTypeToInt((String)reportType);
        int zipNo = 0;
        String sql = "SELECT nvl(max(t.zip_no),0)+1 zip_no FROM amldata.T_REPORT_FILES t WHERE t.report_date=to_char(SYSDATE,'yyyymmdd') and t.report_type = ?";
        List list = this.findList(sql, new Object[]{exchangeSign});
        if (list.size() > 0) {
            Map map = (Map)list.get(0);
            zipNo = ((BigDecimal)map.get("ZIP_NO")).intValue();
        }
        logger.debug("getZipNoInReportFile end...");
        return zipNo;
    }

    @SystemDaoLog(description="\u63d2\u5165\u9644\u4ef6T_FILES")
    public void instFileSql(TFileModel model) throws RuntimeException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into wolfDATA.t_files(id, object_id, name, file_size, extension, create_by, create_time, file_flag)");
        sql.append(" values('");
        sql.append(model.getId());
        sql.append("','");
        sql.append(model.getObjectId());
        sql.append("','");
        sql.append(model.getName());
        sql.append("','");
        sql.append(model.getFileSize());
        sql.append("','");
        sql.append(model.getExtension());
        sql.append("','");
        sql.append(model.getCreateBy());
        sql.append("',");
        sql.append("sysdate,'");
        sql.append(model.getCreateBy());
        sql.append("')");
        this.insert(sql.toString());
    }

    @SystemDaoLog(description="\u6279\u91cf\u6267\u884cSQL")
    public int batchExcute(List<String> sqlList) throws RuntimeException {
        if (sqlList != null && sqlList.size() > 0) {
            return this.batchUpdateSql(sqlList);
        }
        return 0;
    }

    protected String isEmpty(String temp) {
        if (StringUtils.isEmpty((String)temp)) {
            return IS_SUB_COMPANY_CODE;
        }
        return temp;
    }

    @SystemDaoLog(description="\u63d2\u5165\u6587\u4ef6\u5185\u5bb9\u5230L_FILESTORE")
    public void insertFileContent(byte[] content, String id) throws RuntimeException {
        String tableName = this.getFileContentTableName(id);
        if (StringUtils.isNotBlank((String)tableName)) {
            String sql = "insert into " + tableName + "(id, content) values(?, ?)";
            this.insert(sql, new Object[]{id, content});
        }
    }

    @SystemDaoLog(description="\u901a\u8fc7objectId\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f")
    public TFileModel getFileContentId(String reportId) throws RuntimeException {
        String sql = "SELECT f.* FROM WOLFDATA.t_files f,WOLFDATA.T_FILE_CONTENT c where f.id=c.id and f.object_id = '" + reportId + "'";
        List list = this.findList(sql);
        if (list.size() == 1) {
            Map map = (Map)list.get(0);
            TFileModel model = (TFileModel)CommonKit.mapToModel((Map)map, (Object)new TFileModel());
            return model;
        }
        if (list.size() > 1) {
            throw new RuntimeException("\u6570\u636e\u5e93\u6709\u810f\u6570\u636e\u5b58\u5728!");
        }
        return null;
    }

    @SystemDaoLog(description="\u5220\u9664\u9644\u4ef6")
    public void deleteFileContentId(String reportId) throws RuntimeException {
        String sql = "delete from WOLFDATA.t_files f where f.object_id = '" + reportId + "'";
        this.del(sql);
        sql = "delete from  WOLFDATA.t_file_content c where c.id in (select f.id from wolfdata.t_files f where f.object_id = '" + reportId + "')";
        this.del(sql);
    }

    @SystemDaoLog(description="\u83b7\u53d6\u62a5\u8868\u9644\u4ef6\u4fe1\u606f")
    public TFileModel getFileContentByParameter(String ids, String reportType, String messageType) throws RuntimeException {
        String sql = "SELECT f.* FROM wolfdata.t_files f,WOLFDATA.T_FILE_CONTENT c,amldata.T_REPORT_FILES t where  f.id = c.id and f.object_id = t.id and  t.object_id = '" + ids + "' and  t.report_type = '" + reportType + "' and t.message_type = '" + messageType + "'";
        List list = this.findList(sql);
        if (list.size() == 1) {
            Map map = (Map)list.get(0);
            TFileModel model = (TFileModel)CommonKit.mapToModel((Map)map, (Object)new TFileModel());
            return model;
        }
        if (list.size() > 1) {
            throw new RuntimeException("\u6570\u636e\u5e93\u6709\u810f\u6570\u636e\u5b58\u5728!");
        }
        return null;
    }

    @SystemDaoLog(description="\u6839\u636e\u62a5\u8868ID\u83b7\u53d6\u62a5\u8868\u9644\u4ef6\u4fe1\u606f")
    public TFileModel getFileContentByReportId(String reportId) throws RuntimeException {
        String sql = "SELECT f.* FROM wolfdata.t_files f, WOLFDATA.T_FILE_CONTENT c,amldata.T_REPORT_FILES t where  f.id = c.id and  f.object_id = t.id and  t.id = '" + reportId + "'";
        List list = this.findList(sql);
        if (list.size() == 1) {
            Map map = (Map)list.get(0);
            TFileModel model = (TFileModel)CommonKit.mapToModel((Map)map, (Object)new TFileModel());
            return model;
        }
        if (list.size() > 1) {
            throw new RuntimeException("\u6570\u636e\u5e93\u6709\u810f\u6570\u636e\u5b58\u5728!");
        }
        return null;
    }

    @SystemDaoLog(description="\u83b7\u53d6\u9644\u4ef6\u5185\u5bb9")
    public byte[] getFileContent(String id) throws RuntimeException {
        String sql;
        List list;
        byte[] result = null;
        String tableName = this.getFileContentTableName(id);
        if (StringUtils.isNotBlank((String)tableName) && (list = this.findList(sql = "select content from " + tableName + " where id='" + id + "'")).size() > 0) {
            Map map = (Map)list.get(0);
            result = (byte[])map.get("CONTENT");
        }
        return result;
    }

    private String getFileContentTableName(String id) {
        return "WOLFDATA.T_FILE_CONTENT";
    }
}

