/*
 * Decompiled with CFR 0.152.
 */
package com.rw.aml.controller;

import com.rw.aml.model.report.ZipFileModel;
import com.rw.aml.service.AmlsXmlExportService;
import com.rw.aml.util.FileUtil;
import com.rw.annotation.SystemControllerLog;
import com.wb.util.WebUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/ck/aml"})
public class AmlPackController {
    private static final Logger logger = LoggerFactory.getLogger(AmlPackController.class);
    @Autowired
    private AmlsXmlExportService xmlExportService;

    @RequestMapping(value={"/getPackage.jhtml"})
    @SystemControllerLog(description="\u5927\u989d\u53ef\u7591\u4e0a\u62a5\u6253\u5305\u4e0b\u8f7d")
    public void getPackage(HttpServletRequest request, HttpServletResponse response) throws RuntimeException {
        logger.debug("getPackage start...");
        String classPath = request.getSession().getServletContext().getRealPath("/WEB-INF/classes");
        String userId = WebUtil.fetch((HttpServletRequest)request, (String)"sys.username");
        String reportType = request.getParameter("reportType".toUpperCase());
        String actionType = request.getParameter("actionType".toUpperCase());
        logger.debug("userId:" + userId);
        logger.debug("reportType:" + reportType);
        logger.debug("actionType:" + actionType);
        int actionId = 0;
        if (actionType != null && !"".equals(actionType)) {
            logger.debug("actiontype is not null");
            Integer intActionType = Integer.parseInt(actionType);
            actionId = intActionType;
        }
        String ids = request.getParameter("ids".toUpperCase());
        logger.debug("ids:" + ids);
        try {
            ZipFileModel zipFile = null;
            if ("1".equals(reportType)) {
                logger.debug("\u5927\u989d\u62a5\u6587\u5904\u7406...");
                zipFile = this.xmlExportService.exportDshZipReport(ids, actionId, userId, classPath);
            } else if ("2".equals(reportType)) {
                logger.debug("\u53ef\u7591\u62a5\u6587\u5904\u7406...");
                zipFile = this.xmlExportService.exportNssZipReport(ids, actionId, userId, classPath);
            }
            String downloadFlag = request.getParameter("downloadFlag".toUpperCase());
            if ("1".equals(downloadFlag)) {
                String reportId = request.getParameter("reportId".toUpperCase());
                logger.debug("reportId:" + reportId);
                zipFile = this.xmlExportService.downloadZipReport(reportId, classPath);
                logger.debug("\u9644\u4ef6\u62a5\u6587\u4e0b\u8f7d...");
            }
            if (zipFile == null) {
                throw new RuntimeException("zipFile null exception!!!");
            }
            logger.debug("zipFile is not null...");
            FileUtil.exportOutputStream((HttpServletResponse)response, (byte[])zipFile.getContent(), (String)zipFile.getName(), (String)zipFile.getExtension());
        }
        catch (Exception e) {
            logger.error("getPackage is error:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }
}

