package com.wb.tool;

import com.wb.tool.Query;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class Updater {

   public HttpServletRequest request;
   public String jndi;
   public String type;
   public String transaction;
   public boolean batchUpdate;
   public boolean uniqueUpdate = true;
   public String isolation;
   public String tableName;
   public String sqlInsert;
   public String sqlUpdate;
   public String sqlDelete;
   public String paramInsert;
   public String paramUpdate;
   public String paramDelete;
   public String mode;
   public boolean ignoreBlob = false;
   public boolean useExistFields = true;
   public String whereFields;
   public JSONObject fieldsMap;


   public void run() throws Exception {
      JSONArray destroyData = null;
      JSONArray createData = null;
      JSONArray updateData = null;
      JSONObject fields = null;
      if(StringUtil.isEmpty(this.mode)) {
         String query = WebUtil.fetch(this.request, StringUtil.select(new String[]{this.paramDelete, "destroy"}));
         if(!StringUtil.isEmpty(query)) {
            destroyData = new JSONArray(query);
            if(this.useExistFields && fields == null && destroyData.length() > 0) {
               fields = destroyData.getJSONObject(0);
            }
         }

         query = WebUtil.fetch(this.request, StringUtil.select(new String[]{this.paramInsert, "create"}));
         if(!StringUtil.isEmpty(query)) {
            createData = new JSONArray(query);
            if(this.useExistFields && fields == null && createData.length() > 0) {
               fields = createData.getJSONObject(0);
            }
         }

         query = WebUtil.fetch(this.request, StringUtil.select(new String[]{this.paramUpdate, "update"}));
         if(!StringUtil.isEmpty(query)) {
            updateData = new JSONArray(query);
            if(this.useExistFields && fields == null && updateData.length() > 0) {
               fields = updateData.getJSONObject(0);
            }
         }
      } else {
         JSONArray query1;
         if(this.useExistFields) {
            fields = WebUtil.fetch(this.request);
            query1 = (new JSONArray()).put(fields);
         } else {
            query1 = (new JSONArray()).put(WebUtil.fetch(this.request));
         }

         if(this.mode.equals("delete")) {
            destroyData = query1;
         } else if(this.mode.equals("update")) {
            updateData = query1;
         } else {
            createData = query1;
         }
      }

      if((destroyData == null?0:destroyData.length()) + (createData == null?0:createData.length()) + (updateData == null?0:updateData.length()) != 0) {
         Query query2 = new Query();
         Connection connection = DbUtil.getConnection(this.request, this.jndi);
         boolean isCommit = "commit".equals(this.transaction);
         if((isCommit || StringUtil.isEmpty(this.transaction)) && connection.getAutoCommit()) {
            this.transaction = "start";
         }

         if("start".equals(this.transaction)) {
            DbUtil.startTransaction(connection, this.isolation);
         }

         query2.request = this.request;
         query2.jndi = this.jndi;
         query2.type = this.type;
         query2.batchUpdate = this.batchUpdate;
         query2.transaction = "none";
         query2.uniqueUpdate = this.uniqueUpdate;
         if(!StringUtil.isEmpty(this.tableName)) {
            JSONObject whereFieldsObj;
            if(StringUtil.isEmpty(this.whereFields)) {
               whereFieldsObj = fields;
            } else {
               whereFieldsObj = JsonUtil.fromCSV(this.whereFields);
            }

            String[] sqls = DbUtil.buildSQLsWb(this.jndi, this.tableName, this.ignoreBlob, 1, this.request, fields, whereFieldsObj, this.fieldsMap);
            if(StringUtil.isEmpty(this.sqlInsert)) {
               this.sqlInsert = sqls[0];
            }

            if(StringUtil.isEmpty(this.sqlUpdate)) {
               this.sqlUpdate = sqls[1];
            }

            if(StringUtil.isEmpty(this.sqlDelete)) {
               this.sqlDelete = sqls[2];
            }
         }

         String sql;
         if(!StringUtil.isEmpty(this.sqlDelete) && !"-".equals(this.sqlDelete) && destroyData != null && destroyData.length() > 0) {
            sql = this.sqlDelete;
            if(!sql.isEmpty()) {
               query2.sql = sql;
               query2.arrayData = destroyData;
               query2.run();
            }
         }

         if(!StringUtil.isEmpty(this.sqlUpdate) && !"-".equals(this.sqlUpdate) && updateData != null && updateData.length() > 0) {
            sql = this.sqlUpdate;
            if(!sql.isEmpty()) {
               query2.sql = sql;
               query2.arrayData = updateData;
               query2.run();
            }
         }

         if(!StringUtil.isEmpty(this.sqlInsert) && !"-".equals(this.sqlInsert) && createData != null && createData.length() > 0) {
            sql = this.sqlInsert;
            if(!sql.isEmpty()) {
               query2.sql = sql;
               query2.arrayData = createData;
               query2.run();
            }
         }

         if(isCommit) {
            connection.commit();
            connection.setAutoCommit(true);
         }

      }
   }
}
