package com.wb.tool;

import com.wb.common.Resource;
import com.wb.common.ScriptBuffer;
import com.wb.tool.Flow;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Route {

   public JSONObject flow;
   private JSONArray allNodes;
   private JSONArray connections;
   private JSONObject data;


   public Route(JSONObject jo, JSONObject tpl) {
      this.flow = tpl;
      this.allNodes = this.getNodes(tpl);
      this.connections = tpl.getJSONArray("conn");
      jo.put("FLOW_XTPL", tpl.toString());
      this.data = jo;
   }

   public JSONArray getCurrentNodes() {
      return (JSONArray)this.data.opt("CURRENT_NODES");
   }

   public void move(String src, String dst) throws Exception {
      JSONArray currentNodes = this.getCurrentNodes();
      int fromIndex = JsonUtil.indexOf(currentNodes, src);
      if(fromIndex == -1) {
         throw new Exception("Node \"" + src + "\" is not active.");
      } else {
         JSONObject dstObj = JsonUtil.findObject(this.allNodes, "label", dst);
         if(dstObj == null) {
            throw new Exception("Node \"" + dst + "\" does not exist.");
         } else {
            currentNodes.put(fromIndex, dst);
         }
      }
   }

   public void to(String name) throws Exception {
      String[] names = new String[]{name};
      this.deactivateAll();
      this.activate(names);
   }

   public void activate(String[] names) throws Exception {
      JSONArray currentNodes = this.getCurrentNodes();
      String[] var7 = names;
      int var6 = names.length;

      for(int var5 = 0; var5 < var6; ++var5) {
         String n = var7[var5];
         JSONObject obj = JsonUtil.findObject(this.allNodes, "label", n);
         if(obj == null) {
            throw new Exception("Node \"" + n + "\" does not exist.");
         }

         if(JsonUtil.indexOf(currentNodes, n) == -1) {
            currentNodes.put(n);
         }
      }

   }

   public void deactivate(String[] names) {
      JSONArray currentNodes = this.getCurrentNodes();
      String[] var7 = names;
      int var6 = names.length;

      for(int var5 = 0; var5 < var6; ++var5) {
         String n = var7[var5];
         int i = JsonUtil.indexOf(currentNodes, n);
         if(i != -1) {
            currentNodes.remove(i);
         }
      }

   }

   public void deactivateAll() {
      JSONArray currentNodes = this.getCurrentNodes();
      int j = currentNodes.length();

      for(int i = j - 1; i >= 0; --i) {
         currentNodes.remove(i);
      }

   }

   public void pause() {
      this.data.put("paused", true);
   }

   public void resume() {
      this.data.put("paused", false);
   }

   public void remove() throws Exception {
      Flow.remove((String)this.get("ROUTE_ID"));
   }

   public boolean isPaused() {
      return this.data.optBoolean("paused", false);
   }

   public void commit() throws Exception {
      Connection conn = null;
      PreparedStatement st = null;
      Date date = new Date();
      String routeId = this.data.optString("ROUTE_ID");
      String userId = this.data.optString("sys.user", "-");
      String activeNode = this.getCurrentNodes().optString(0);

      try {
         conn = DbUtil.getConnection();
         conn.setAutoCommit(false);
         st = conn.prepareStatement("delete from WB_ROUTE where ROUTE_ID=?");
         st.setString(1, routeId);
         st.executeUpdate();
         DbUtil.close(st);
         st = conn.prepareStatement("insert into WB_ROUTE values(?,?,?,?,?,?,?,?)");
         st.setString(1, routeId);
         st.setString(2, this.data.optString("FLOW_ID"));
         st.setTimestamp(3, new Timestamp(date.getTime()));
         st.setString(4, userId);
         st.setString(5, activeNode);
         st.setString(6, this.data.optString("TITLE", "-"));
         st.setString(7, this.data.optString("STATUS", "-"));
         DbUtil.setText(st, 8, this.data.toString());
         st.executeUpdate();
         conn.commit();
         this.set("MODIFY_DATE", date);
         this.set("USER_ID", userId);
         this.set("ACTIVE_NODE", activeNode);
      } finally {
         DbUtil.close(st);
         DbUtil.close(conn);
      }

   }

   public void set(String name, Object value) throws Exception {
      if(value instanceof Date) {
         value = DateUtil.dateToStr((Date)value);
      } else {
         String id;
         if(value instanceof InputStream) {
            id = SysUtil.getId();
            Resource.set(id, this.getBytes((InputStream)value));
            value = "@@blob." + id;
         } else if(value instanceof byte[]) {
            id = SysUtil.getId();
            Resource.set(id, (byte[])value);
            value = "@@byte." + id;
         } else if(value instanceof Object[]) {
            value = (new JSONArray((Object[])value)).toString();
         }
      }

      this.data.put(name, value);
   }

   public void set(HttpServletRequest request) throws Exception {
      JSONObject items = WebUtil.fetch(request);
      Set es = items.entrySet();
      Iterator var5 = es.iterator();

      while(var5.hasNext()) {
         Entry e = (Entry)var5.next();
         this.set((String)e.getKey(), e.getValue());
      }

   }

   public Object get(String name) {
      Object value = this.data.opt(name);
      if(value instanceof String) {
         String prefix = (String)value;
         if(prefix.startsWith("@@blob.")) {
            value = new ByteArrayInputStream(Resource.getBytes(prefix.substring(7), (byte[])null));
         } else if(prefix.startsWith("@@byte.")) {
            value = Resource.getBytes(prefix.substring(7), (byte[])null);
         }
      }

      return value;
   }

   public JSONObject get() {
      return this.data;
   }

   private byte[] getBytes(InputStream is) throws Exception {
      ByteArrayOutputStream bos;
      try {
         bos = new ByteArrayOutputStream();
         IOUtils.copy(is, bos);
      } finally {
         is.close();
      }

      return bos.toByteArray();
   }

   public boolean forward(HttpServletRequest request) throws Exception {
      int j = this.connections.length();
      String activeNode = this.getCurrentNodes().optString(0);
      String[] nodes = new String[]{""};
      this.set("xLastNode", activeNode);

      for(int i = 0; i < j; ++i) {
         JSONObject jo = this.connections.getJSONObject(i);
         if(jo.optString("src").equals(activeNode)) {
            JSONObject xprop = jo.optJSONObject("xprop");
            String condi = xprop.optString("条件");
            if(StringUtil.isEmpty(condi) || Boolean.parseBoolean(ScriptBuffer.run(WebUtil.replaceParams(request, "return " + condi)).toString())) {
               nodes[0] = jo.optString("dst");
               this.deactivateAll();
               this.activate(nodes);
               return true;
            }
         }
      }

      return false;
   }

   public boolean backward(HttpServletRequest request) throws Exception {
      return false;
   }

   private JSONArray getNodes(JSONObject template) {
      JSONArray nodes = new JSONArray();
      JSONArray list = template.getJSONArray("list");
      int j = list.length();

      for(int i = 0; i < j; ++i) {
         JSONObject obj = list.getJSONObject(i);
         if(obj.getBoolean("isObj")) {
            obj.remove("box");
            nodes.put(obj);
         }
      }

      return nodes;
   }
}
