package com.wb.tool;

import com.wb.util.StringUtil;
import java.io.Serializable;

public class QueueWriter implements Serializable {

   private static final long serialVersionUID = 2100540580239114561L;
   private StringBuffer buf = new StringBuffer();
   private int bufferSize;


   public QueueWriter(int bufferSize) {
      this.bufferSize = bufferSize;
   }

   public synchronized void print(Object object, String type, boolean encoded) {
      String string;
      if(object == null) {
         string = "null";
      } else {
         string = object.toString();
      }

      if(this.buf.length() > 0) {
         this.buf.append(',');
      }

      this.buf.append("{type:\"");
      this.buf.append(type);
      this.buf.append("\",msg:");
      this.buf.append(StringUtil.quote(string));
      if(encoded) {
         this.buf.append(",encode:true");
      }

      this.buf.append('}');
      if(this.buf.length() > this.bufferSize) {
         this.clear();
      }

   }

   public String toString() {
      return this.buf.toString();
   }

   public void clear() {
      this.buf.delete(0, this.buf.length());
   }
}
