package com.wb.tool;

import com.wb.common.DataPermissionBuffer;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.tool.Console;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {

   private static final Logger logger = LoggerFactory.getLogger(Query.class);
   public HttpServletRequest request;
   public String sql;
   public String jndi;
   public String arrayName;
   public JSONArray arrayData;
   public boolean batchUpdate;
   public String type;
   public String transaction;
   public String isolation;
   public boolean uniqueUpdate;
   public String errorText;
   private String debugSql;
   private String formattedSql;
   private ArrayList paramList;
   private ArrayList paramValList;
   private int paramCount;
   private PreparedStatement statement;
   private Map paramValMap;


   public Object run() throws Exception {
      String functionId = "";
      String xwl = this.request.getParameter("xwl");
      String title = "";
      Object result = null;

      try {
         String e = SysUtil.getId();
         if(StringUtils.isNotEmpty(xwl)) {
            title = XwlBuffer.get(xwl + ".xwl", true).optString("title");
            if(StringUtils.indexOf(xwl, "/") > -1 && StringUtils.countMatches(xwl, "/") >= 2) {
               String[] isCall = StringUtils.split(xwl, "/");
               functionId = isCall[isCall.length - 2];
               xwl = StringUtils.substringBeforeLast(xwl, "/");
            } else {
               functionId = xwl;
            }
         }

         this.checkProperties();
         boolean hasArray = this.arrayData != null || !StringUtil.isEmpty(this.arrayName);
         this.sql = this.sql.trim();
         this.replaceMacros();
         Connection connection = DbUtil.getConnection(this.request, this.jndi);
         boolean isCommit = "commit".equals(this.transaction);
         if(isCommit) {
            if(connection.getAutoCommit()) {
               this.transaction = "start";
            }
         } else if(StringUtil.isEmpty(this.transaction) && (this.uniqueUpdate || hasArray) && connection.getAutoCommit()) {
            this.transaction = "start";
         }

         if("start".equals(this.transaction)) {
            DbUtil.startTransaction(connection, this.isolation);
         }

         if(StringUtil.isEmpty(this.type)) {
            if(this.sql.startsWith("{")) {
               this.type = "call";
            } else {
               this.type = "execute";
            }
         }

         boolean isCall1 = "call".equals(this.type);
         if(isCall1) {
            this.statement = connection.prepareCall(this.formattedSql);
         } else {
            this.statement = connection.prepareStatement(this.formattedSql);
         }

         if(Var.fetchSize != -1) {
            this.statement.setFetchSize(Var.fetchSize);
         }

         WebUtil.setObject(this.request, SysUtil.getId(), this.statement);
         this.regParameters();
         long beginTime = System.currentTimeMillis();
         if(hasArray) {
            this.executeBatch();
         } else {
            if(Var.debug) {
               this.printSql();
            }

            if("query".equals(this.type)) {
               result = this.statement.executeQuery();
               WebUtil.setObject(this.request, SysUtil.getId(), result);
            } else {
               int affectedRows;
               if("update".equals(this.type)) {
                  affectedRows = this.statement.executeUpdate();
                  result = Integer.valueOf(affectedRows);
                  if(this.uniqueUpdate && affectedRows != 1) {
                     this.notUnique();
                  }
               } else {
                  if(this.statement.execute()) {
                     result = this.statement.getResultSet();
                     WebUtil.setObject(this.request, SysUtil.getId(), result);
                  } else {
                     affectedRows = this.statement.getUpdateCount();
                     result = Integer.valueOf(affectedRows);
                     if(this.uniqueUpdate && affectedRows != 1) {
                        this.notUnique();
                     }
                  }

                  if(isCall1 && this.paramCount > 0) {
                     HashMap endTime = this.getOutParameter();
                     if(endTime.size() > 0) {
                        if(endTime.containsKey("return")) {
                           throw new IllegalArgumentException("Invalid output parameter name \"return\"");
                        }

                        endTime.put("return", result);
                        result = endTime;
                     }
                  }
               }
            }
         }

         if(isCommit) {
            connection.commit();
            connection.setAutoCommit(true);
         }

         long endTime1 = System.currentTimeMillis();
         if(StringUtils.isNotEmpty(functionId)) {
            LogUtil.recordForSp(this.type, functionId, e, WebUtil.fetch(this.request, "sys.username"), this.sql, title, xwl, this.paramValMap, "0", "执行成功！", endTime1 - beginTime);
         }

         this.checkError(result);
         return result;
      } catch (SQLException var15) {
         logger.error("SQL【" + StringUtil.toLine(this.formattedSql) + "】<br>" + var15.getMessage());
         throw new Exception(var15.getMessage());
      } catch (Exception var16) {
         logger.error("SQL【" + StringUtil.toLine(this.formattedSql) + "】<br>" + var16.getMessage());
         throw var16;
      }
   }

   private void checkProperties() {
      String[] isolations;
      if(!StringUtil.isEmpty(this.transaction)) {
         isolations = new String[]{"start", "commit", "none"};
         if(StringUtil.indexOf(isolations, this.transaction) == -1) {
            throw new IllegalArgumentException("Invalid transaction \"" + this.transaction + "\".");
         }
      }

      if(!StringUtil.isEmpty(this.type)) {
         isolations = new String[]{"query", "update", "execute", "call"};
         if(StringUtil.indexOf(isolations, this.type) == -1) {
            throw new IllegalArgumentException("Invalid type \"" + this.type + "\".");
         }
      }

      if(!StringUtil.isEmpty(this.isolation)) {
         isolations = new String[]{"readCommitted", "readUncommitted", "repeatableRead", "serializable"};
         if(StringUtil.indexOf(isolations, this.isolation) == -1) {
            throw new IllegalArgumentException("Invalid isolation \"" + this.isolation + "\".");
         }
      }

   }

   private void executeBatch() throws Exception {
      JSONArray ja;
      if(this.arrayData == null) {
         Object obj = WebUtil.fetchObject(this.request, this.arrayName);
         if(obj instanceof JSONArray) {
            ja = (JSONArray)obj;
         } else {
            if(obj == null) {
               return;
            }

            String val = obj.toString();
            if(val.isEmpty()) {
               return;
            }

            ja = new JSONArray(val);
         }
      } else {
         ja = this.arrayData;
      }

      int j = ja.length();
      if(j != 0) {
         for(int i = 0; i < j; ++i) {
            JSONObject jo = ja.getJSONObject(i);

            for(int k = 0; k < this.paramCount; ++k) {
               Object[] param = (Object[])this.paramList.get(k);
               String name = (String)param[0];
               if(!((Boolean)param[2]).booleanValue() && jo.has(name)) {
                  Object valObj = JsonUtil.opt(jo, name);
                  DbUtil.setObject(this.statement, k + 1, ((Integer)param[1]).intValue(), valObj);
                  if(Var.debug) {
                     this.paramValList.set(k, StringUtil.toString(valObj));
                  }
               }
            }

            if(Var.debug) {
               this.printSql();
            }

            if(this.batchUpdate) {
               this.statement.addBatch();
            } else {
               int affectedRows = this.statement.executeUpdate();
               if(this.uniqueUpdate && affectedRows != 1) {
                  this.notUnique();
               }
            }
         }

         if(this.batchUpdate) {
            this.statement.executeBatch();
         }

      }
   }

   private void notUnique() {
      throw new RuntimeException(Str.format(this.request, "updateNotUnique", new Object[0]));
   }

   private void replaceMacros() {
      StringBuilder buf = new StringBuilder();
      int startPos = 0;
      int endPos = 0;

      int lastPos;
      for(lastPos = 0; (startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1; lastPos = endPos) {
         buf.append(this.sql.substring(lastPos, startPos));
         startPos += 2;
         endPos += 2;
         buf.append("\'{?");
         buf.append(this.sql.substring(endPos - 1, endPos));
         buf.append('\'');
      }

      buf.append(this.sql.substring(lastPos));
      this.debugSql = buf.toString();
      this.formattedSql = StringUtil.replaceAll(this.debugSql, "\'{?}\'", "?");
   }

   private void regParameters() throws Exception {
      int index = 1;
      int startPos = 0;
      int endPos = 0;
      this.paramList = new ArrayList();
      this.paramValMap = new LinkedHashMap();
      if(Var.debug) {
         this.paramValList = new ArrayList();
      }

      CallableStatement callStatement;
      if(this.statement instanceof CallableStatement) {
         callStatement = (CallableStatement)this.statement;
      } else {
         callStatement = null;
      }

      for(boolean isCall = callStatement != null; (startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1; ++index) {
         startPos += 2;
         String param = this.sql.substring(startPos, endPos);
         endPos += 2;
         String orgParam = param;
         boolean isOutParam = isCall && param.startsWith("@");
         String paraName;
         int dotPos;
         int type;
         Integer typeObj;
         if(isOutParam) {
            param = param.substring(1);
            dotPos = param.indexOf(46);
            String typeText;
            if(dotPos == -1) {
               typeText = "varchar";
               paraName = param;
            } else {
               typeText = param.substring(0, dotPos);
               paraName = param.substring(dotPos + 1);
            }

            boolean hasSub = typeText.indexOf(61) != -1;
            if(hasSub) {
               typeObj = DbUtil.getFieldType(StringUtil.getNamePart(typeText));
               if(typeObj == null) {
                  throw new Exception("Invalid type " + typeText);
               }

               type = typeObj.intValue();
               int subType = Integer.parseInt(StringUtil.getValuePart(typeText));
               callStatement.registerOutParameter(index, type, subType);
            } else {
               typeObj = DbUtil.getFieldType(typeText);
               if(typeObj == null) {
                  throw new Exception("Invalid type " + typeText);
               }

               type = typeObj.intValue();
               callStatement.registerOutParameter(index, type);
            }

            if(Var.debug) {
               this.paramValList.add(orgParam);
            }
         } else {
            dotPos = param.indexOf(46);
            if(dotPos == -1) {
               type = 12;
               paraName = param;
            } else {
               typeObj = DbUtil.getFieldType(param.substring(0, dotPos));
               if(typeObj == null) {
                  type = 12;
                  paraName = param;
               } else {
                  type = typeObj.intValue();
                  paraName = param.substring(dotPos + 1);
               }
            }

            Object obj = WebUtil.fetchObject(this.request, paraName);
            DbUtil.setObject(this.statement, index, type, obj);
            if(Var.debug) {
               this.paramValList.add(StringUtil.toString(obj));
            }

            this.paramValMap.put(paraName, obj);
         }

         Object[] paramObjects = new Object[]{paraName, Integer.valueOf(type), Boolean.valueOf(isOutParam)};
         this.paramList.add(paramObjects);
      }

      this.paramCount = this.paramList.size();
   }

   private void filterDataPermission(Object paramValue, String paraName, String userId) {
      if(DataPermissionBuffer.exitType(paraName)) {
         ArrayList permissionList = DataPermissionBuffer.getPermissionData(userId, paraName);
         String paramValue1;
         if(paramValue != null) {
            List paramValueList = Arrays.asList(ObjectUtils.toString(paramValue).split(","));
            if(permissionList != null) {
               ArrayList newValue = new ArrayList();
               Iterator var8 = paramValueList.iterator();

               while(var8.hasNext()) {
                  String pv = (String)var8.next();
                  if(permissionList.contains(pv)) {
                     newValue.add(pv);
                  }
               }

               paramValue1 = CollectionUtil.join(newValue, ",");
            } else {
               paramValue = null;
            }
         } else if(permissionList != null) {
            paramValue1 = CollectionUtil.join(permissionList, ",");
         }
      }

   }

   private HashMap getOutParameter() throws Exception {
      CallableStatement st = (CallableStatement)this.statement;
      HashMap map = new HashMap();

      for(int i = 0; i < this.paramCount; ++i) {
         Object[] param = (Object[])this.paramList.get(i);
         if(((Boolean)param[2]).booleanValue()) {
            Object object = DbUtil.getObject(st, i + 1, ((Integer)param[1]).intValue());
            if(object instanceof ResultSet) {
               WebUtil.setObject(this.request, SysUtil.getId(), object);
            }

            map.put((String)param[0], object);
         }
      }

      return map;
   }

   private void checkError(Object object) throws Exception {
      if(!StringUtil.isEmpty(this.errorText) && object instanceof ResultSet) {
         ResultSet rs = (ResultSet)object;
         if(rs.next()) {
            throw new RuntimeException(this.errorText);
         }
      }

   }

   private void printSql() {
      String sql = this.debugSql;

      String s;
      for(Iterator var3 = this.paramValList.iterator(); var3.hasNext(); sql = StringUtil.replaceFirst(sql, "{?}", s)) {
         s = (String)var3.next();
      }

      logger.debug("模块【" + this.request.getParameter("xwl") + "】执行的SQL语句:" + StringUtil.toLine(sql));
      Console.log(this.request, sql);
   }
}
