package com.wb.tool;

import com.rw.util.PropKit;
import com.wb.tool.MailSender;
import com.wb.util.LogUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class MgMailSend {

   public static void mgMailSend(String attachementFileList, String to, String subject, String content) throws Exception {
      MailSender mailSender = null;

      try {
         String e = PropKit.getProperty("mail.smtp.host");
         boolean stmp_auth = Boolean.parseBoolean(PropKit.getProperty("mail.smtp.auth"));
         String username = PropKit.getProperty("mail.username");
         String password = PropKit.getProperty("mail.password");
         String fromUser = PropKit.getProperty("mail.fromUser");
         mailSender = new MailSender(e, username, password, stmp_auth);

         try {
            mailSender.send(fromUser, to, "", "", subject, content, attachementFileList, (HttpServletRequest)null, (String)null, (String)null);
         } catch (Exception var22) {
            LogUtil.error("send mail error for (subject=\'" + subject + "\', to=\'" + to + "\')  is " + var22.getMessage());
         }
      } catch (IOException var23) {
         var23.printStackTrace();
      } catch (Exception var24) {
         var24.printStackTrace();
      } finally {
         try {
            mailSender.close();
         } catch (Exception var21) {
            LogUtil.error("发送邮件关闭失败:" + var21.getMessage());
            var21.printStackTrace();
         }

      }

   }
}
